/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.status;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.status.Status;
import fr.jayasoft.ivy.util.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StatusManager {
    private List _status = new ArrayList();
    private String _defaultStatus;
    private Map _statusPriorityMap;
    private Map _statusIntegrationMap;
    private String _deliveryStatusListString;

    public static StatusManager newDefaultInstance() {
        return new StatusManager(new Status[]{new Status("release", false), new Status("milestone", false), new Status("integration", true)}, "integration");
    }

    public static StatusManager getCurrent() {
        return Ivy.getCurrent().getStatusManager();
    }

    public StatusManager(Status[] status, String defaultStatus) {
        this._status.addAll(Arrays.asList(status));
        this._defaultStatus = defaultStatus;
        this.computeMaps();
    }

    public StatusManager() {
    }

    public void addStatus(Status status) {
        this._status.add(status);
    }

    public void setDefaultStatus(String defaultStatus) {
        this._defaultStatus = defaultStatus;
    }

    public List getStatuses() {
        return this._status;
    }

    private void computeMaps() {
        Status status;
        if (this._status.isEmpty()) {
            throw new IllegalStateException("badly configured statuses: no status found");
        }
        this._statusPriorityMap = new HashMap();
        Iterator iter = this._status.listIterator();
        while (iter.hasNext()) {
            status = (Status)iter.next();
            this._statusPriorityMap.put(status.getName(), new Integer(iter.previousIndex()));
        }
        this._statusIntegrationMap = new HashMap();
        iter = this._status.iterator();
        while (iter.hasNext()) {
            status = (Status)iter.next();
            this._statusIntegrationMap.put(status.getName(), status.isIntegration());
        }
    }

    public boolean isStatus(String status) {
        if (this._statusPriorityMap == null) {
            this.computeMaps();
        }
        return this._statusPriorityMap.containsKey(status);
    }

    public int getPriority(String status) {
        Integer priority;
        if (this._statusPriorityMap == null) {
            this.computeMaps();
        }
        if ((priority = (Integer)this._statusPriorityMap.get(status)) == null) {
            Message.debug("unknown status " + status + ": assuming lowest priority");
            return Integer.MAX_VALUE;
        }
        return priority;
    }

    public boolean isIntegration(String status) {
        Boolean isIntegration;
        if (this._statusIntegrationMap == null) {
            this.computeMaps();
        }
        if ((isIntegration = (Boolean)this._statusIntegrationMap.get(status)) == null) {
            Message.debug("unknown status " + status + ": assuming integration");
            return true;
        }
        return isIntegration;
    }

    public String getDeliveryStatusListString() {
        if (this._deliveryStatusListString == null) {
            StringBuffer ret = new StringBuffer();
            Iterator iter = this._status.iterator();
            while (iter.hasNext()) {
                Status status = (Status)iter.next();
                if (status.isIntegration()) continue;
                ret.append(status.getName()).append(",");
            }
            if (ret.length() > 0) {
                ret.deleteCharAt(ret.length() - 1);
            }
            this._deliveryStatusListString = ret.toString();
        }
        return this._deliveryStatusListString;
    }

    public String getDefaultStatus() {
        if (this._defaultStatus == null) {
            if (this._status.isEmpty()) {
                throw new IllegalStateException("badly configured statuses: no status found");
            }
            this._defaultStatus = ((Status)this._status.get(this._status.size() - 1)).getName();
        }
        return this._defaultStatus;
    }
}

