/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.repository.ssh.AbstractSshBasedRepository;
import fr.jayasoft.ivy.resolver.RepositoryResolver;
import java.io.File;

public abstract class AbstractSshBasedResolver
extends RepositoryResolver {
    private boolean passfileSet = false;

    private AbstractSshBasedRepository getSshBasedRepository() {
        return (AbstractSshBasedRepository)this.getRepository();
    }

    public void setKeyFile(String filePath) {
        this.getSshBasedRepository().setKeyFile(new File(filePath));
    }

    public void setPassfile(String passfile) {
        this.getSshBasedRepository().setPassFile(passfile == null ? null : new File(passfile));
        this.passfileSet = true;
    }

    public void setIvy(Ivy ivy) {
        super.setIvy(ivy);
        if (!this.passfileSet) {
            this.getSshBasedRepository().setPassFile(new File(ivy.getDefaultIvyUserDir(), this.getSshBasedRepository().getHost() + ".ssh.passwd"));
        }
    }

    public void setUserPassword(String password) {
        this.getSshBasedRepository().setUserPassword(password);
    }

    public void setKeyFilePassword(String password) {
        this.getSshBasedRepository().setKeyFilePassword(password);
    }

    public void setUser(String user) {
        this.getSshBasedRepository().setUser(user);
    }

    public void setHost(String host) {
        this.getSshBasedRepository().setHost(host);
    }

    public void setPort(int port) {
        this.getSshBasedRepository().setPort(port);
    }

    public abstract String getTypeName();
}

