/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;

public class PaletteAnimator
extends LayoutAnimator {
    private List drawers = new ArrayList();
    private PaletteViewerPreferences prefs;

    public PaletteAnimator(PaletteViewerPreferences prefs) {
        this.prefs = prefs;
    }

    public void addDrawer(DrawerEditPart drawer) {
        this.drawers.add(drawer.getFigure());
    }

    protected void autoCollapse(DrawerFigure openDrawer) {
        DrawerFigure drawer;
        int autoCollapseMode = this.prefs.getAutoCollapseSetting();
        if (autoCollapseMode == 1) {
            return;
        }
        if (autoCollapseMode == 2) {
            Iterator iter = this.drawers.iterator();
            while (iter.hasNext()) {
                DrawerFigure drawer2 = (DrawerFigure)((Object)iter.next());
                if (drawer2 == openDrawer) continue;
                drawer2.setExpanded(false);
            }
            return;
        }
        int wHint = openDrawer.getParent().getClientArea().width;
        int availableHeight = openDrawer.getParent().getSize().height;
        int requiredHeight = 0;
        ArrayList<DrawerFigure> closable = new ArrayList<DrawerFigure>();
        Iterator iter = openDrawer.getParent().getChildren().iterator();
        while (iter.hasNext()) {
            IFigure sibling = (IFigure)iter.next();
            int height = sibling.getPreferredSize((int)wHint, (int)-1).height;
            requiredHeight += height;
            if (!(sibling instanceof DrawerFigure) || sibling == openDrawer || !(drawer = (DrawerFigure)sibling).isExpanded() || drawer.isPinnedOpen()) continue;
            closable.add(drawer);
        }
        int i = closable.size() - 1;
        while (i >= 0 && requiredHeight > availableHeight) {
            drawer = (DrawerFigure)((Object)closable.get(i));
            int expandedHeight = drawer.getPreferredSize((int)wHint, (int)-1).height;
            drawer.setExpanded(false);
            int collapsedHeight = drawer.getPreferredSize((int)wHint, (int)-1).height;
            requiredHeight -= expandedHeight - collapsedHeight;
            --i;
        }
    }

    public void playbackStarting(IFigure figure) {
        if (figure instanceof DrawerFigure) {
            ((DrawerFigure)figure).setAnimating(true);
        }
    }

    public void removeDrawer(DrawerEditPart drawer) {
        this.drawers.remove(drawer.getFigure());
    }

    public void init(IFigure figure) {
        if (figure instanceof DrawerFigure) {
            DrawerFigure drawer = (DrawerFigure)figure;
            if (drawer.isExpanded()) {
                this.autoCollapse(drawer);
            }
            return;
        }
        super.init(figure);
    }

    public void tearDown(IFigure figure) {
        if (figure instanceof DrawerFigure) {
            ((DrawerFigure)figure).setAnimating(false);
        }
    }
}

