/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.CheckinOptions;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.checkin.ArtifactColumnInfo;
import com.almworks.tracklink.checkin.CheckBoxColumnInfo;
import com.almworks.tracklink.checkin.LinkCheckMap;
import com.almworks.tracklink.checkin.MessageOptionsForm;
import com.almworks.tracklink.util.BooleanWrapper;
import com.almworks.tracklink.util.SelectionMarkupProvider;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.tracklink.vcslinks.comments.CommentMaker;
import com.almworks.util.threads.AWTBottleneck;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.almworks.util.detach.DetachComposite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeforeCheckinDialog
extends DialogWrapper
implements DataProvider {
    private final DetachComposite myLifespan = new DetachComposite();
    private final SelectionMarkupProvider myMarkupProvider;
    private final LinkCheckMap myMap;
    private final BooleanWrapper myBooleanWrapper;
    private final List<ArtifactInfo> myFilteredInfos;
    private final String myInitialComment;
    private final IssueLinkModel myModel;
    private final VirtualFile[] myVirtualFiles;
    private ListTableModel<ArtifactInfo> myTableModel;
    private TableView myView;
    private JTextArea myPreview;
    private JScrollPane myScrollPane;
    private final AWTBottleneck myCommentUpdater = new AWTBottleneck(100L, new Runnable(){

        public void run() {
            BeforeCheckinDialog.this.updateComment();
        }
    });
    @NonNls
    public static final String LOGO_SMALL = "/com/almworks/tracklink/icons/linked.png";
    private final MessageOptionsForm myMessageOptions = new MessageOptionsForm();

    public BeforeCheckinDialog(Component parent, boolean canBeParent, final List<ArtifactInfo> artifactInfos, final List<ArtifactInfo> filteredInfos, final BooleanWrapper filteringWrapper, String initialComment, IssueLinkModel model, VirtualFile[] virtualFiles, CheckinOptions checkinOptions) {
        super(parent, canBeParent);
        this.myModel = model;
        this.myVirtualFiles = virtualFiles;
        this.myFilteredInfos = filteredInfos;
        this.myInitialComment = initialComment;
        this.myMap = new LinkCheckMap();
        this.setTitle(StringBundle.get("checkin.dialog.title", new Object[0]));
        this.setModal(true);
        this.init();
        this.pack();
        this.myBooleanWrapper = new BooleanWrapper(){

            public boolean getValue() {
                return filteringWrapper.getValue();
            }

            public void setValue(boolean isSelected) {
                filteringWrapper.setValue(isSelected);
                if (BeforeCheckinDialog.this.myTableModel != null) {
                    BeforeCheckinDialog.this.myTableModel.setItems(this.getValue() ? filteredInfos : artifactInfos);
                }
            }
        };
        this.myBooleanWrapper.setValue(filteringWrapper.getValue());
        this.myMarkupProvider = new SelectionMarkupProvider(){

            public boolean isEmpty(boolean selectionOnly) {
                if (selectionOnly) {
                    return BeforeCheckinDialog.this.myView.getSelection().isEmpty();
                }
                return BeforeCheckinDialog.this.myView.getItems().isEmpty();
            }

            public void doMarkup(boolean mark, boolean selectionOnly) {
                if (selectionOnly) {
                    Collection selection = BeforeCheckinDialog.this.myView.getSelection();
                    if (!selection.isEmpty()) {
                        BeforeCheckinDialog.this.myMap.setSelected(selection, mark);
                    }
                } else {
                    List list = BeforeCheckinDialog.this.myTableModel.getItems();
                    if (!list.isEmpty()) {
                        BeforeCheckinDialog.this.myMap.setSelected(list, mark);
                    }
                }
                BeforeCheckinDialog.this.myView.getTableViewModel().fireTableRowsUpdated(0, BeforeCheckinDialog.this.myTableModel.getItems().size());
            }
        };
        Runnable updater = new Runnable(){

            public void run() {
                BeforeCheckinDialog.this.myCommentUpdater.request();
            }
        };
        this.myMap.addListener(updater);
        this.myMap.setSelected(filteredInfos, true);
        this.myMessageOptions.setCheckinOptions(checkinOptions);
        checkinOptions.addChangeListener(this.myLifespan, updater);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myTableModel = new ListTableModel(new ColumnInfo[]{new CheckBoxColumnInfo(StringBundle.get("Column.Checkbox", new Object[0]), this.myMap){

            @NonNls
            public String getMaxStringValue() {
                return StringBundle.get("Column.Checkbox", new Object[0]) + "mmmm";
            }
        }, new ArtifactColumnInfo<String>(GenericKeys.ID){

            @NonNls
            public String getMaxStringValue() {
                return "PRJ-123456   ";
            }
        }, new ArtifactColumnInfo(GenericKeys.SUMMARY)});
        this.myView = new TableView(this.myTableModel);
        this.myTableModel.sortByColumn(2, 1);
        this.myView.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (BeforeCheckinDialog.this.myView.columnAtPoint(e.getPoint()) == 0) {
                    BeforeCheckinDialog.this.myView.getTableHeader().setToolTipText(StringBundle.get("Column.WorkedOn.Tooltip", new Object[0]));
                } else {
                    BeforeCheckinDialog.this.myView.getTableHeader().setToolTipText(null);
                }
            }
        });
        JPanel southPanel = new JPanel(GuiUtils.createBorderLayout());
        southPanel.add((Component)new JLabel(StringBundle.get("checkin.previewlabel", new Object[0])), "North");
        this.myPreview = new JTextArea(this.myInitialComment, 5, 80);
        this.myPreview.setEditable(false);
        this.myPreview.setLineWrap(true);
        this.myPreview.setWrapStyleWord(false);
        this.myScrollPane = new JScrollPane(this.myPreview);
        southPanel.add((Component)this.myScrollPane, "Center");
        southPanel.add((Component)this.myMessageOptions.getComponent(), "North");
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent((JComponent)new JScrollPane((Component)this.myView));
        splitter.setSecondComponent((JComponent)southPanel);
        return splitter;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        ActionToolbar toolbar = Utils.createActionToolbar("CheckinDialog.Toolbar");
        return toolbar != null ? toolbar.getComponent() : null;
    }

    public String getComment() {
        return this.myPreview.getText();
    }

    @Nullable
    public Object getData(String dataId) {
        if (Comparing.strEqual((String)dataId, (String)"LinkCheckMap")) {
            return this.myMap;
        }
        if (Comparing.strEqual((String)dataId, (String)"BooleanWrapper")) {
            return this.myBooleanWrapper;
        }
        if (Comparing.strEqual((String)dataId, (String)"SelectionMarkupProvider")) {
            return this.myMarkupProvider;
        }
        return null;
    }

    private void updateComment() {
        final int v = this.myScrollPane.getVerticalScrollBar().getValue();
        List<ArtifactInfo> infos = this.myMap.getSelectedInfos();
        CheckinOptions checkinOptions = this.myMessageOptions.getCheckinOptions();
        CommentMaker commentMaker = new CommentMaker(this.myInitialComment, infos, this.myModel, checkinOptions);
        this.myPreview.setText(commentMaker.getMessage());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar bar = BeforeCheckinDialog.this.myScrollPane.getVerticalScrollBar();
                int value = Math.max(bar.getMinimum(), Math.min(bar.getMaximum(), v));
                bar.setValue(value);
            }
        });
    }

    protected void dispose() {
        this.myLifespan.detach();
        super.dispose();
    }
}

