/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.store.amq.AMQMessageStore;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.store.amq.AMQTopicMessageStore;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class AMQTxOperation {
    public static final byte ADD_OPERATION_TYPE = 0;
    public static final byte REMOVE_OPERATION_TYPE = 1;
    public static final byte ACK_OPERATION_TYPE = 3;
    private byte operationType;
    private ActiveMQDestination destination;
    private Object data;
    private Location location;

    public AMQTxOperation() {
    }

    public AMQTxOperation(byte operationType, ActiveMQDestination destination, Object data, Location location) {
        this.operationType = operationType;
        this.destination = destination;
        this.data = data;
        this.location = location;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public byte getOperationType() {
        return this.operationType;
    }

    public void setOperationType(byte operationType) {
        this.operationType = operationType;
    }

    public boolean replay(AMQPersistenceAdapter adapter, ConnectionContext context) throws IOException {
        boolean result = false;
        AMQMessageStore store2 = (AMQMessageStore)adapter.createMessageStore(this.destination);
        if (this.operationType == 0) {
            result = store2.replayAddMessage(context, (Message)this.data, this.location);
        } else if (this.operationType == 1) {
            result = store2.replayRemoveMessage(context, (MessageAck)this.data);
        } else {
            JournalTopicAck ack = (JournalTopicAck)this.data;
            result = ((AMQTopicMessageStore)store2).replayAcknowledge(context, ack.getClientId(), ack.getSubscritionName(), ack.getMessageId());
        }
        return result;
    }

    public void writeExternal(WireFormat wireFormat, DataOutput dos) throws IOException {
        this.location.writeExternal(dos);
        ByteSequence packet = wireFormat.marshal(this.getData());
        dos.writeInt(packet.length);
        dos.write(packet.data, packet.offset, packet.length);
        packet = wireFormat.marshal(this.destination);
        dos.writeInt(packet.length);
        dos.write(packet.data, packet.offset, packet.length);
    }

    public void readExternal(WireFormat wireFormat, DataInput dis) throws IOException {
        this.location = new Location();
        this.location.readExternal(dis);
        int size2 = dis.readInt();
        byte[] data = new byte[size2];
        dis.readFully(data);
        this.setData(wireFormat.unmarshal(new ByteSequence(data)));
        size2 = dis.readInt();
        data = new byte[size2];
        dis.readFully(data);
        this.destination = (ActiveMQDestination)wireFormat.unmarshal(new ByteSequence(data));
    }
}

