/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v9;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v9.BaseCommandMarshaller;

public class BrokerInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 2;
    }

    @Override
    public DataStructure createObject() {
        return new BrokerInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        BrokerInfo info2 = (BrokerInfo)o;
        info2.setBrokerId((BrokerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setBrokerURL(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerInfo[] value = new BrokerInfo[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerInfo)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setPeerBrokerInfos(value);
        } else {
            info2.setPeerBrokerInfos(null);
        }
        info2.setBrokerName(this.tightUnmarshalString(dataIn, bs));
        info2.setSlaveBroker(bs.readBoolean());
        info2.setMasterBroker(bs.readBoolean());
        info2.setFaultTolerantConfiguration(bs.readBoolean());
        info2.setDuplexConnection(bs.readBoolean());
        info2.setNetworkConnection(bs.readBoolean());
        info2.setConnectionId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setBrokerUploadUrl(this.tightUnmarshalString(dataIn, bs));
        info2.setNetworkProperties(this.tightUnmarshalString(dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BrokerInfo info2 = (BrokerInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getBrokerId(), bs);
        rc += this.tightMarshalString1(info2.getBrokerURL(), bs);
        rc += this.tightMarshalObjectArray1(wireFormat, info2.getPeerBrokerInfos(), bs);
        rc += this.tightMarshalString1(info2.getBrokerName(), bs);
        bs.writeBoolean(info2.isSlaveBroker());
        bs.writeBoolean(info2.isMasterBroker());
        bs.writeBoolean(info2.isFaultTolerantConfiguration());
        bs.writeBoolean(info2.isDuplexConnection());
        bs.writeBoolean(info2.isNetworkConnection());
        rc += this.tightMarshalLong1(wireFormat, info2.getConnectionId(), bs);
        rc += this.tightMarshalString1(info2.getBrokerUploadUrl(), bs);
        return (rc += this.tightMarshalString1(info2.getNetworkProperties(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        BrokerInfo info2 = (BrokerInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getBrokerId(), dataOut, bs);
        this.tightMarshalString2(info2.getBrokerURL(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info2.getPeerBrokerInfos(), dataOut, bs);
        this.tightMarshalString2(info2.getBrokerName(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalLong2(wireFormat, info2.getConnectionId(), dataOut, bs);
        this.tightMarshalString2(info2.getBrokerUploadUrl(), dataOut, bs);
        this.tightMarshalString2(info2.getNetworkProperties(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        BrokerInfo info2 = (BrokerInfo)o;
        info2.setBrokerId((BrokerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setBrokerURL(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerInfo[] value = new BrokerInfo[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerInfo)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setPeerBrokerInfos(value);
        } else {
            info2.setPeerBrokerInfos(null);
        }
        info2.setBrokerName(this.looseUnmarshalString(dataIn));
        info2.setSlaveBroker(dataIn.readBoolean());
        info2.setMasterBroker(dataIn.readBoolean());
        info2.setFaultTolerantConfiguration(dataIn.readBoolean());
        info2.setDuplexConnection(dataIn.readBoolean());
        info2.setNetworkConnection(dataIn.readBoolean());
        info2.setConnectionId(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setBrokerUploadUrl(this.looseUnmarshalString(dataIn));
        info2.setNetworkProperties(this.looseUnmarshalString(dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        BrokerInfo info2 = (BrokerInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getBrokerId(), dataOut);
        this.looseMarshalString(info2.getBrokerURL(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info2.getPeerBrokerInfos(), dataOut);
        this.looseMarshalString(info2.getBrokerName(), dataOut);
        dataOut.writeBoolean(info2.isSlaveBroker());
        dataOut.writeBoolean(info2.isMasterBroker());
        dataOut.writeBoolean(info2.isFaultTolerantConfiguration());
        dataOut.writeBoolean(info2.isDuplexConnection());
        dataOut.writeBoolean(info2.isNetworkConnection());
        this.looseMarshalLong(wireFormat, info2.getConnectionId(), dataOut);
        this.looseMarshalString(info2.getBrokerUploadUrl(), dataOut);
        this.looseMarshalString(info2.getNetworkProperties(), dataOut);
    }
}

