/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.BufferOverflowException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Driver;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.DriverImpl;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.apache.qpid.proton.messenger.Messenger;
import org.apache.qpid.proton.messenger.MessengerException;
import org.apache.qpid.proton.messenger.Status;
import org.apache.qpid.proton.messenger.Tracker;
import org.apache.qpid.proton.messenger.impl.TrackerImpl;
import org.apache.qpid.proton.messenger.impl.TrackerQueue;

public class MessengerImpl
implements Messenger {
    private static final EnumSet<EndpointState> UNINIT = EnumSet.of(EndpointState.UNINITIALIZED);
    private static final EnumSet<EndpointState> ACTIVE = EnumSet.of(EndpointState.ACTIVE);
    private static final EnumSet<EndpointState> CLOSED = EnumSet.of(EndpointState.CLOSED);
    private static final EnumSet<EndpointState> ANY = EnumSet.allOf(EndpointState.class);
    private static final Accepted ACCEPTED = new Accepted();
    private final Logger _logger = Logger.getLogger("proton.messenger");
    private final String _name;
    private long _timeout = -1L;
    private long _nextTag = 1L;
    private byte[] _buffer = new byte[5120];
    private Driver _driver;
    private int _credit;
    private int _distributed;
    private TrackerQueue _incoming = new TrackerQueue();
    private TrackerQueue _outgoing = new TrackerQueue();
    private final SentSettled _sentSettled = new SentSettled();
    private final MessageAvailable _messageAvailable = new MessageAvailable();

    public MessengerImpl() {
        this(UUID.randomUUID().toString());
    }

    public MessengerImpl(String name) {
        this._name = name;
    }

    public void setTimeout(long timeInMillis) {
        this._timeout = timeInMillis;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void start() throws IOException {
        this._driver = new DriverImpl();
    }

    public void stop() {
        for (Connector c : this._driver.connectors()) {
            Connection connection = c.getConnection();
            connection.close();
            try {
                c.process();
                c.close();
            }
            catch (IOException e) {
                this._logger.log(Level.WARNING, "Error while sending close", e);
            }
        }
        for (Listener l : this._driver.listeners()) {
            try {
                l.close();
            }
            catch (IOException e) {
                this._logger.log(Level.WARNING, "Error while closing listener", e);
            }
        }
        this._driver.destroy();
    }

    public void put(Message m) throws MessengerException {
        try {
            int encoded;
            URI address = new URI(m.getAddress());
            if (address.getHost() == null) {
                throw new MessengerException("unable to send to address: " + m.getAddress());
            }
            int port = address.getPort() < 0 ? MessengerImpl.defaultPort(address.getScheme()) : address.getPort();
            Sender sender = this.getLink(address.getHost(), port, new SenderFinder(address.getPath()));
            this.adjustReplyTo(m);
            byte[] tag = String.valueOf(this._nextTag++).getBytes();
            Delivery delivery = sender.delivery(tag);
            while (true) {
                try {
                    encoded = m.encode(this._buffer, 0, this._buffer.length);
                }
                catch (BufferOverflowException e) {
                    this._buffer = new byte[this._buffer.length * 2];
                    continue;
                }
                break;
            }
            sender.send(this._buffer, 0, encoded);
            this._outgoing.add(delivery);
            sender.advance();
        }
        catch (URISyntaxException e) {
            throw new MessengerException("Invalid address: " + m.getAddress(), (Throwable)e);
        }
    }

    public void send() throws TimeoutException {
        this.waitUntil(this._sentSettled);
    }

    public void recv(int n) throws TimeoutException {
        this._credit += n;
        this.distributeCredit();
        this.waitUntil(this._messageAvailable);
    }

    public Message get() {
        for (Connector c : this._driver.connectors()) {
            Connection connection = c.getConnection();
            this._logger.log(Level.FINE, "Attempting to get message from " + connection);
            for (Delivery delivery = connection.getWorkHead(); delivery != null; delivery = delivery.getWorkNext()) {
                if (delivery.isReadable()) {
                    this._logger.log(Level.FINE, "Readable delivery found: " + delivery);
                    int size = this.read((Receiver)delivery.getLink());
                    MessageImpl message = new MessageImpl();
                    message.decode(this._buffer, 0, size);
                    this._incoming.add(delivery);
                    --this._distributed;
                    delivery.getLink().advance();
                    return message;
                }
                this._logger.log(Level.FINE, "Delivery not readable: " + delivery);
            }
        }
        return null;
    }

    public void subscribe(String source) throws MessengerException {
        boolean listen = source.contains("~");
        try {
            int port;
            URI address = new URI(listen ? source.replace("~", "") : source);
            if (address.getHost() == null) {
                throw new MessengerException("Invalid source address (hostname cannot be null): " + source);
            }
            int n = port = address.getPort() < 0 ? MessengerImpl.defaultPort(address.getScheme()) : address.getPort();
            if (listen) {
                this._driver.createListener(address.getHost(), port, null);
            } else {
                this.getLink(address.getHost(), port, new ReceiverFinder(address.getPath()));
            }
        }
        catch (URISyntaxException e) {
            throw new MessengerException("Invalid source: " + source, (Throwable)e);
        }
    }

    public int outgoing() {
        return this.queued(true);
    }

    public int incoming() {
        return this.queued(false);
    }

    public int getIncomingWindow() {
        return this._incoming.getWindow();
    }

    public void setIncomingWindow(int window) {
        this._incoming.setWindow(window);
    }

    public int getOutgoingWindow() {
        return this._outgoing.getWindow();
    }

    public void setOutgoingWindow(int window) {
        this._outgoing.setWindow(window);
    }

    public Tracker incomingTracker() {
        return new TrackerImpl(false, this._incoming.getHighWaterMark() - 1);
    }

    public Tracker outgoingTracker() {
        return new TrackerImpl(true, this._outgoing.getHighWaterMark() - 1);
    }

    private TrackerQueue getTrackerQueue(Tracker tracker) {
        return TrackerQueue.isOutgoing(tracker) ? this._outgoing : this._incoming;
    }

    public void reject(Tracker tracker, int flags) {
        this.getTrackerQueue(tracker).reject(tracker, flags);
    }

    public void accept(Tracker tracker, int flags) {
        this.getTrackerQueue(tracker).accept(tracker, flags);
    }

    public void settle(Tracker tracker, int flags) {
        this.getTrackerQueue(tracker).settle(tracker, flags);
    }

    public Status getStatus(Tracker tracker) {
        return this.getTrackerQueue(tracker).getStatus(tracker);
    }

    private int queued(boolean outgoing) {
        int count = 0;
        for (Connector c : this._driver.connectors()) {
            Connection connection = c.getConnection();
            for (Link link : new Links(connection, ACTIVE, ANY)) {
                if (outgoing) {
                    if (!(link instanceof Sender)) continue;
                    count += link.getQueued();
                    continue;
                }
                if (!(link instanceof Receiver)) continue;
                count += link.getQueued();
            }
        }
        return count;
    }

    private int read(Receiver receiver) {
        int total = 0;
        int start = 0;
        while (true) {
            int read = receiver.recv(this._buffer, start, this._buffer.length - start);
            total += read;
            if (read != this._buffer.length - start) break;
            byte[] old = this._buffer;
            this._buffer = new byte[this._buffer.length * 2];
            System.arraycopy(old, 0, this._buffer, 0, old.length);
            start += read;
        }
        return total;
    }

    private void process() {
        this.processAllConnectors();
        this.processActive();
    }

    private void processAllConnectors() {
        for (Connector c : this._driver.connectors()) {
            try {
                c.process();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Error processing connection", e);
            }
        }
    }

    private void processActive() {
        Listener l = this._driver.listener();
        while (l != null) {
            Connector c = l.accept();
            ConnectionImpl connection = new ConnectionImpl();
            connection.setContainer(this._name);
            c.setConnection((Connection)connection);
            Sasl sasl = c.sasl();
            if (sasl != null) {
                sasl.server();
                sasl.setMechanisms(new String[]{"ANONYMOUS"});
                sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
            }
            connection.open();
            l = this._driver.listener();
        }
        Connector c = this._driver.connector();
        while (c != null) {
            this._logger.log(Level.FINE, "Processing active connector " + c);
            try {
                c.process();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Error processing connection", e);
            }
            Connection connection = c.getConnection();
            if (connection.getLocalState() == EndpointState.UNINITIALIZED) {
                connection.open();
            }
            for (Delivery delivery = connection.getWorkHead(); delivery != null; delivery = delivery.getWorkNext()) {
                if (!(delivery.getLink() instanceof Sender) || !delivery.isUpdated()) continue;
                delivery.disposition(delivery.getRemoteState());
            }
            this._outgoing.slide();
            for (Session session : new Sessions(connection, UNINIT, ANY)) {
                session.open();
                this._logger.log(Level.FINE, "Opened session " + session);
            }
            for (Link link : new Links(connection, UNINIT, ANY)) {
                link.setSource(link.getRemoteSource());
                link.setTarget(link.getRemoteTarget());
                link.open();
                this._logger.log(Level.FINE, "Opened link " + link);
            }
            this.distributeCredit();
            for (Link link : new Links(connection, ACTIVE, CLOSED)) {
                link.close();
            }
            for (Session session : new Sessions(connection, ACTIVE, CLOSED)) {
                session.close();
            }
            if (connection.getLocalState() == EndpointState.ACTIVE && connection.getRemoteState() == EndpointState.CLOSED) {
                connection.close();
            }
            if (c.isClosed()) {
                this.reclaimCredit(connection);
                c.destroy();
            } else {
                try {
                    c.process();
                }
                catch (IOException e) {
                    this._logger.log(Level.SEVERE, "Error processing connection", e);
                }
            }
            c = this._driver.connector();
        }
    }

    private void waitUntil(Predicate condition) throws TimeoutException {
        this.waitUntil(condition, this._timeout);
    }

    private void waitUntil(Predicate condition, long timeout) throws TimeoutException {
        this.processAllConnectors();
        long deadline = timeout < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        boolean wait = deadline > System.currentTimeMillis();
        boolean first = true;
        boolean done = condition.test();
        while (first || !done && wait) {
            if (wait && !done && !first) {
                this._driver.doWait(timeout < 0L ? 0L : deadline - System.currentTimeMillis());
            }
            this.processActive();
            wait = deadline > System.currentTimeMillis();
            done = done || condition.test();
            first = false;
        }
    }

    private Connection lookup(String host, String service) {
        for (Connector c : this._driver.connectors()) {
            Connection connection = c.getConnection();
            if (!host.equals(connection.getRemoteContainer()) && !service.equals(connection.getContext())) continue;
            return connection;
        }
        return null;
    }

    private void reclaimCredit(Connection connection) {
        for (Link link : new Links(connection, ANY, ANY)) {
            if (!(link instanceof Receiver) || link.getCredit() <= 0) continue;
            this.reclaimCredit(link.getCredit());
        }
    }

    private void reclaimCredit(int credit) {
        this._credit += credit;
        this._distributed -= credit;
    }

    private void distributeCredit() {
        int previous = 0;
        while (this._credit > 0 && this._credit != previous) {
            previous = this._credit;
            for (Connector c : this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Link link : new Links(connection, ACTIVE, ANY)) {
                    if (!(link instanceof Receiver)) continue;
                    ((Receiver)link).flow(1);
                    --this._credit;
                    ++this._distributed;
                    if (this._credit != 0) continue;
                    return;
                }
            }
        }
    }

    private <C extends Link> C getLink(String host, int port, LinkFinder<C> finder) {
        Object link2;
        String service = host + ":" + port;
        Connection connection = this.lookup(host, service);
        if (connection == null) {
            Connector connector = this._driver.createConnector(host, port, null);
            this._logger.log(Level.FINE, "Connecting to " + host + ":" + port);
            connection = new ConnectionImpl();
            connection.setContainer(this._name);
            connection.setHostname(host);
            connection.setContext((Object)service);
            connector.setConnection(connection);
            Sasl sasl = connector.sasl();
            if (sasl != null) {
                sasl.client();
                sasl.setMechanisms(new String[]{"ANONYMOUS"});
            }
            connection.open();
        }
        for (Object link2 : new Links(connection, ACTIVE, ANY)) {
            C result = finder.test((Link)link2);
            if (result == null) continue;
            return result;
        }
        Session session = connection.session();
        session.open();
        link2 = finder.create(session);
        link2.open();
        return (C)link2;
    }

    private void adjustReplyTo(Message m) {
        String original = m.getReplyTo();
        if (original == null || original.length() == 0) {
            m.setReplyTo("amqp://" + this._name);
        } else if (original.startsWith("~/")) {
            m.setReplyTo("amqp://" + this._name + "/" + original.substring(2));
        }
    }

    private static boolean matchTarget(Target target, String path) {
        if (target == null) {
            return path.isEmpty();
        }
        return path.equals(target.getAddress());
    }

    private static boolean matchSource(Source source, String path) {
        if (source == null) {
            return path.isEmpty();
        }
        return path.equals(source.getAddress());
    }

    private static int defaultPort(String scheme) {
        if ("amqps".equals(scheme)) {
            return 5671;
        }
        return 5672;
    }

    private static class SessionIterator
    implements Iterator<Session> {
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;
        private Session _next;

        SessionIterator(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._local = local;
            this._remote = remote;
            this._next = connection.sessionHead(this._local, this._remote);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Session next() {
            try {
                Session session = this._next;
                return session;
            }
            finally {
                this._next = this._next.next(this._local, this._remote);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Sessions
    implements Iterable<Session> {
        private final Connection _connection;
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;

        Sessions(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._connection = connection;
            this._local = local;
            this._remote = remote;
        }

        @Override
        public Iterator<Session> iterator() {
            return new SessionIterator(this._connection, this._local, this._remote);
        }
    }

    private static class LinkIterator
    implements Iterator<Link> {
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;
        private Link _next;

        LinkIterator(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._local = local;
            this._remote = remote;
            this._next = connection.linkHead(this._local, this._remote);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Link next() {
            try {
                Link link = this._next;
                return link;
            }
            finally {
                this._next = this._next.next(this._local, this._remote);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Links
    implements Iterable<Link> {
        private final Connection _connection;
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;

        Links(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._connection = connection;
            this._local = local;
            this._remote = remote;
        }

        @Override
        public Iterator<Link> iterator() {
            return new LinkIterator(this._connection, this._local, this._remote);
        }
    }

    private class ReceiverFinder
    implements LinkFinder<Receiver> {
        private final String _path;

        ReceiverFinder(String path) {
            this._path = path;
        }

        @Override
        public Receiver test(Link link) {
            if (link instanceof Receiver && MessengerImpl.matchSource((Source)link.getSource(), this._path)) {
                return (Receiver)link;
            }
            return null;
        }

        @Override
        public Receiver create(Session session) {
            return session.receiver(this._path);
        }
    }

    private class SenderFinder
    implements LinkFinder<Sender> {
        private final String _path;

        SenderFinder(String path) {
            this._path = path;
        }

        @Override
        public Sender test(Link link) {
            if (link instanceof Sender && MessengerImpl.matchTarget((Target)link.getTarget(), this._path)) {
                return (Sender)link;
            }
            return null;
        }

        @Override
        public Sender create(Session session) {
            return session.sender(this._path);
        }
    }

    private static interface LinkFinder<C extends Link> {
        public C test(Link var1);

        public C create(Session var1);
    }

    private class MessageAvailable
    implements Predicate {
        private MessageAvailable() {
        }

        @Override
        public boolean test() {
            for (Connector c : MessengerImpl.this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Delivery delivery = connection.getWorkHead(); delivery != null; delivery = delivery.getWorkNext()) {
                    if (!delivery.isReadable()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class SentSettled
    implements Predicate {
        private SentSettled() {
        }

        @Override
        public boolean test() {
            for (Connector c : MessengerImpl.this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Link link : new Links(connection, ACTIVE, ACTIVE)) {
                    if (!(link instanceof Sender) || link.getQueued() <= 0) continue;
                    return false;
                }
            }
            return this.checkSettled(MessengerImpl.this._outgoing.deliveries());
        }

        boolean checkSettled(Iterator<Delivery> unsettled) {
            if (unsettled != null) {
                Delivery d;
                while (unsettled.hasNext() && (d = unsettled.next()) != null) {
                    if (d.getRemoteState() != null || d.remotelySettled()) {
                        d.settle();
                        continue;
                    }
                    if (d.getLink().getSession().getConnection().getRemoteState() == EndpointState.CLOSED) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static interface Predicate {
        public boolean test();
    }
}

