/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxSearchRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHandler
extends JsonRequestHandler<JmxSearchRequest> {
    public SearchHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public RequestType getType() {
        return RequestType.SEARCH;
    }

    @Override
    protected void checkForRestriction(JmxSearchRequest pRequest) {
        this.checkType();
    }

    @Override
    public Object doHandleRequest(Set<MBeanServerConnection> servers, JmxSearchRequest request) throws MBeanException, IOException {
        HashSet<String> ret = new HashSet<String>();
        for (MBeanServerConnection server : servers) {
            Set<ObjectName> names = server.queryNames(request.getObjectName(), null);
            for (ObjectName name : names) {
                ret.add(request.getOrderedObjectName(name));
            }
        }
        return new ArrayList(ret);
    }

    @Override
    public boolean handleAllServersAtOnce(JmxSearchRequest pRequest) {
        return true;
    }

    @Override
    protected Object doHandleRequest(MBeanServerConnection server, JmxSearchRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }
}

