##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
Plugin.define "AxCMS.net" do
author "Brendan Coles <bcoles@gmail.com>" # 2011-03-04
version "0.1"
description "AxCMS.net - the free ASP.NET CMS by Axinom - Homepage: http://en.axcms.net/"

# Google results as at 2011-03-04 #
# 59 for "powered by axcms"

# ShodanHQ results as at 2011-03-04 #
# 8 for X-Powered-By: AxCMS.net

# Examples #
examples %w|
88.217.156.146
88.217.156.178
88.217.156.179
88.217.156.180
88.217.156.182
88.217.156.183
88.217.156.185
88.217.156.186
92.42.226.213
92.42.226.243
213.189.86.20
axcms.net
help.axcms.net
de.axcms.net
ch.axinom.com
axinom.com
www.axinom.de
help.axinom.de
en.help.axinom.de
www.axdms.net
www.axinom.co.uk
www.axinom.ch
www.freeenterprisecms.de
www.axday.de
www.stolenmoments.co.uk
www.consonavita.com
www.axasp.de
josephburton.co.uk
axcmsexpress.cloudapp.net
www.henksplek.com
www.abosoftware.co.za
|

# Matches #
matches [

# Powered by logo HTML
{ :text=>'<div style="text-align:center;width:100%;"><a href="http://axcms.net" target="_blank"><img src="http://axcms.net/upload/poweredby_150x25_13871.png" height="25" width="150" alt="Powered by AxCMS.net" style="height:25px;width:150px;border-width:0px;" /></a></div></form>' },

# Version Detection # Meta Generator
{ :version=>/<meta name="GENERATOR" content="AxCMS.net ver([\d\.]{1,15})">/ },
{ :version=>/<meta name="GENERATOR" content="AxCMS.net ([\d\.]{1,15})" \/>/ },

# Version Detection # HTML Comment
{ :version=>/<!-- Generated by AxCMS.net ([\d\.]{1,15}) -->/ },

# HTML Comment
{ :text=>'<!-- Build and published by AxCMS.net | powered by Axinom-->' },

]

# Passive #
def passive
	m=[]

	# X-Powered-By: AxCMS.net
	m << { :version=>@meta['x-powered-by'].scan(/AxCMS.net ([\d\.]+)/)[0] } if @meta['x-powered-by'] =~ /AxCMS.net ([\d\.]+)/

	# Return passive matches
	m
end

end


