# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{pg}
  s.version = "0.15.1"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Michael Granger"]
  s.cert_chain = ["-----BEGIN CERTIFICATE-----\nMIIDbDCCAlSgAwIBAgIBATANBgkqhkiG9w0BAQUFADA+MQwwCgYDVQQDDANnZWQx\nGTAXBgoJkiaJk/IsZAEZFglGYWVyaWVNVUQxEzARBgoJkiaJk/IsZAEZFgNvcmcw\nHhcNMTMwMjI3MTY0ODU4WhcNMTQwMjI3MTY0ODU4WjA+MQwwCgYDVQQDDANnZWQx\nGTAXBgoJkiaJk/IsZAEZFglGYWVyaWVNVUQxEzARBgoJkiaJk/IsZAEZFgNvcmcw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDb92mkyYwuGBg1oRxt2tkH\n+Uo3LAsaL/APBfSLzy8o3+B3AUHKCjMUaVeBoZdWtMHB75X3VQlvXfZMyBxj59Vo\ncDthr3zdao4HnyrzAIQf7BO5Y8KBwVD+yyXCD/N65TTwqsQnO3ie7U5/9ut1rnNr\nOkOzAscMwkfQxBkXDzjvAWa6UF4c5c9kR/T79iA21kDx9+bUMentU59aCJtUcbxa\n7kcKJhPEYsk4OdxR9q2dphNMFDQsIdRO8rywX5FRHvcb+qnXC17RvxLHtOjysPtp\nEWsYoZMxyCDJpUqbwoeiM+tAHoz2ABMv3Ahie3Qeb6+MZNAtMmaWfBx3dg2u+/WN\nAgMBAAGjdTBzMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgSwMB0GA1UdDgQWBBSZ0hCV\nqoHr122fGKelqffzEQBhszAcBgNVHREEFTATgRFnZWRARmFlcmllTVVELm9yZzAc\nBgNVHRIEFTATgRFnZWRARmFlcmllTVVELm9yZzANBgkqhkiG9w0BAQUFAAOCAQEA\nVlcfyq6GwyE8i0QuFPCeVOwJaneSvcwx316DApjy9/tt2YD2HomLbtpXtji5QXor\nON6oln4tWBIB3Klbr3szq5oR3Rc1D02SaBTalxSndp4M6UkW9hRFu5jn98pDB4fq\n5l8wMMU0Xdmqx1VYvysVAjVFVC/W4NNvlmg+2mEgSVZP5K6Tc9qDh3eMQInoYw6h\nt1YA6RsUJHp5vGQyhP1x34YpLAaly8icbns/8PqOf7Osn9ztmg8bOMJCeb32eQLj\n6mKCwjpegytE0oifXfF8k75A9105cBnNiMZOe1tXiqYc/exCgWvbggurzDOcRkZu\n/YSusaiDXHKU2O3Akc3htA==\n-----END CERTIFICATE-----\n"]
  s.date = %q{2013-04-08}
  s.description = %q{Pg is the Ruby interface to the {PostgreSQL RDBMS}[http://www.postgresql.org/].

It works with {PostgreSQL 8.4 and later}[http://www.postgresql.org/support/versioning/].

A small example usage:

  #!/usr/bin/env ruby

  require 'pg'

  # Output a table of current connections to the DB
  conn = PG.connect( dbname: 'sales' )
  conn.exec( "SELECT * FROM pg_stat_activity" ) do |result|
    puts "     PID | User             | Query"
  result.each do |row|
      puts " %7d | %-16s | %s " %
        row.values_at('procpid', 'usename', 'current_query')
    end
  end}
  s.email = ["ged@FaerieMUD.org"]
  s.extensions = ["ext/extconf.rb"]
  s.extra_rdoc_files = ["Contributors.rdoc", "History.rdoc", "Manifest.txt", "README-OS_X.rdoc", "README-Windows.rdoc", "README.ja.rdoc", "README.rdoc", "POSTGRES", "LICENSE", "ext/gvl_wrappers.c", "ext/pg.c", "ext/pg_connection.c", "ext/pg_result.c"]
  s.files = [".gemtest", "BSDL", "ChangeLog", "Contributors.rdoc", "History.rdoc", "LICENSE", "Manifest.txt", "POSTGRES", "README-OS_X.rdoc", "README-Windows.rdoc", "README.ja.rdoc", "README.rdoc", "Rakefile", "Rakefile.cross", "ext/extconf.rb", "ext/gvl_wrappers.c", "ext/gvl_wrappers.h", "ext/pg.c", "ext/pg.h", "ext/pg_connection.c", "ext/pg_result.c", "ext/vc/pg.sln", "ext/vc/pg_18/pg.vcproj", "ext/vc/pg_19/pg_19.vcproj", "lib/pg.rb", "lib/pg/connection.rb", "lib/pg/constants.rb", "lib/pg/exceptions.rb", "lib/pg/result.rb", "sample/array_insert.rb", "sample/async_api.rb", "sample/async_copyto.rb", "sample/async_mixed.rb", "sample/check_conn.rb", "sample/copyfrom.rb", "sample/copyto.rb", "sample/cursor.rb", "sample/disk_usage_report.rb", "sample/issue-119.rb", "sample/losample.rb", "sample/minimal-testcase.rb", "sample/notify_wait.rb", "sample/pg_statistics.rb", "sample/replication_monitor.rb", "sample/test_binary_values.rb", "sample/wal_shipper.rb", "sample/warehouse_partitions.rb", "spec/data/expected_trace.out", "spec/data/random_binary_data", "spec/lib/helpers.rb", "spec/pg/connection_spec.rb", "spec/pg/result_spec.rb", "spec/pg_spec.rb"]
  s.homepage = %q{https://bitbucket.org/ged/ruby-pg}
  s.licenses = ["BSD", "Ruby", "GPL"]
  s.rdoc_options = ["-f", "fivefish", "-t", "pg: The Ruby Interface to PostgreSQL", "-m", "README.rdoc"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new(">= 1.8.7")
  s.rubyforge_project = %q{pg}
  s.rubygems_version = %q{1.5.2}
  s.summary = %q{Pg is the Ruby interface to the {PostgreSQL RDBMS}[http://www.postgresql.org/]}

  if s.respond_to? :specification_version then
    s.specification_version = 4

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<hoe-mercurial>, ["~> 1.4.0"])
      s.add_development_dependency(%q<hoe-highline>, ["~> 0.1.0"])
      s.add_development_dependency(%q<rdoc>, ["~> 3.10"])
      s.add_development_dependency(%q<rake-compiler>, ["~> 0.8"])
      s.add_development_dependency(%q<hoe-deveiate>, ["~> 0.2"])
      s.add_development_dependency(%q<hoe>, ["~> 3.5"])
    else
      s.add_dependency(%q<hoe-mercurial>, ["~> 1.4.0"])
      s.add_dependency(%q<hoe-highline>, ["~> 0.1.0"])
      s.add_dependency(%q<rdoc>, ["~> 3.10"])
      s.add_dependency(%q<rake-compiler>, ["~> 0.8"])
      s.add_dependency(%q<hoe-deveiate>, ["~> 0.2"])
      s.add_dependency(%q<hoe>, ["~> 3.5"])
    end
  else
    s.add_dependency(%q<hoe-mercurial>, ["~> 1.4.0"])
    s.add_dependency(%q<hoe-highline>, ["~> 0.1.0"])
    s.add_dependency(%q<rdoc>, ["~> 3.10"])
    s.add_dependency(%q<rake-compiler>, ["~> 0.8"])
    s.add_dependency(%q<hoe-deveiate>, ["~> 0.2"])
    s.add_dependency(%q<hoe>, ["~> 3.5"])
  end
end
