'''OpenGL extension SGIS.texture_edge_clamp

Overview (from the spec)
	
	The base OpenGL provides clamping such that the texture coordinates are
	limited to exactly the range [0,1].  When a texture coordinate is
	clamped using this algorithm, the texture sampling filter straddles the
	edge of the texture image, taking 1/2 its sample values from within the
	texture image, and the other 1/2 from the texture border.  It is
	sometimes desirable to clamp a texture without requiring a border, and
	without using the constant border color.
	
	This extension defines a new texture clamping algorithm.
	CLAMP_TO_EDGE_SGIS clamps texture coordinates at all mipmap levels such
	that the texture filter never samples a border texel.  When used with a
	NEAREST or a LINEAR filter, the color returned when clamping is derived
	only from texels at the edge of the texture image.  When used with
	FILTER4 filters, the filter operations of CLAMP_TO_EDGE_SGIS are defined
	but don't result in a nice clamp-to-edge color.
	
	CLAMP_TO_EDGE_SGIS is supported by 1, 2, and 3-dimensional textures
	only.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIS/texture_edge_clamp.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIS_texture_edge_clamp'
GL_CLAMP_TO_EDGE_SGIS = constant.Constant( 'GL_CLAMP_TO_EDGE_SGIS', 0x812F )


def glInitTextureEdgeClampSGIS():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
