require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SBIC_NTARG)) {
    sub SBIC_NTARG () {	8;}
}
unless(defined(&SBIC_NLUN)) {
    sub SBIC_NLUN () {	8;}
}
unless(defined(&SBIC_NTAGS)) {
    sub SBIC_NTAGS () {	256;}
}
unless(defined(&SBIC_MAX_MSGLEN)) {
    sub SBIC_MAX_MSGLEN () {	8;}
}
unless(defined(&SBIC_ABORT_TIMEOUT)) {
    sub SBIC_ABORT_TIMEOUT () {	2000;}
}
unless(defined(&SBIC_SENSE_TIMEOUT)) {
    sub SBIC_SENSE_TIMEOUT () {	1000;}
}
unless(defined(&ACB_FREE)) {
    sub ACB_FREE () {	0x;}
}
unless(defined(&ACB_ACTIVE)) {
    sub ACB_ACTIVE () {	0x1;}
}
unless(defined(&ACB_READY)) {
    sub ACB_READY () {	0x2;}
}
unless(defined(&ACB_DONE)) {
    sub ACB_DONE () {	0x4;}
}
unless(defined(&ACB_SENSE)) {
    sub ACB_SENSE () {	0x8;}
}
unless(defined(&ACB_COMPLETE)) {
    sub ACB_COMPLETE () {	0x10;}
}
unless(defined(&ACB_RESET)) {
    sub ACB_RESET () {	0x20;}
}
unless(defined(&ACB_ABORT)) {
    sub ACB_ABORT () {	0x40;}
}
unless(defined(&L_STATE_IDLE)) {
    sub L_STATE_IDLE () {	0;}
}
unless(defined(&L_STATE_BUSY)) {
    sub L_STATE_BUSY () {	1;}
}
unless(defined(&L_STATE_ESTAT)) {
    sub L_STATE_ESTAT () {	2;}
}
unless(defined(&T_NEED_RESET)) {
    sub T_NEED_RESET () {	0x1;}
}
unless(defined(&T_NEGOTIATE)) {
    sub T_NEGOTIATE () {	0x2;}
}
unless(defined(&T_BUSY)) {
    sub T_BUSY () {	0x4;}
}
unless(defined(&T_SYNCMODE)) {
    sub T_SYNCMODE () {	0x8;}
}
unless(defined(&T_NOSYNC)) {
    sub T_NOSYNC () {	0x10;}
}
unless(defined(&T_NODISC)) {
    sub T_NODISC () {	0x20;}
}
unless(defined(&T_TAG)) {
    sub T_TAG () {	0x40;}
}
unless(defined(&T_WANTSYNC)) {
    sub T_WANTSYNC () {	0x80;}
}
unless(defined(&TINFO_LUN)) {
    sub TINFO_LUN {
	my($t, $l) = @_;
	eval q((($t)-> $lun[($l)]));
    }
}
unless(defined(&SBICF_SELECTED)) {
    sub SBICF_SELECTED () {	0x1;}
}
unless(defined(&SBICF_NODMA)) {
    sub SBICF_NODMA () {	0x2;}
}
unless(defined(&SBICF_INDMA)) {
    sub SBICF_INDMA () {	0x4;}
}
unless(defined(&SBICF_SYNCNEGO)) {
    sub SBICF_SYNCNEGO () {	0x8;}
}
unless(defined(&SBICF_ABORTING)) {
    sub SBICF_ABORTING () {	0x10;}
}
unless(defined(&SBIC_UNINITIALIZED)) {
    sub SBIC_UNINITIALIZED () {	0;}
}
unless(defined(&SBIC_IDLE)) {
    sub SBIC_IDLE () {	1;}
}
unless(defined(&SBIC_SELECTING)) {
    sub SBIC_SELECTING () {	2;}
}
unless(defined(&SBIC_RESELECTED)) {
    sub SBIC_RESELECTED () {	3;}
}
unless(defined(&SBIC_IDENTIFIED)) {
    sub SBIC_IDENTIFIED () {	4;}
}
unless(defined(&SBIC_CONNECTED)) {
    sub SBIC_CONNECTED () {	5;}
}
unless(defined(&SBIC_DISCONNECT)) {
    sub SBIC_DISCONNECT () {	6;}
}
unless(defined(&SBIC_CMDCOMPLETE)) {
    sub SBIC_CMDCOMPLETE () {	7;}
}
unless(defined(&SBIC_ERROR)) {
    sub SBIC_ERROR () {	8;}
}
unless(defined(&SBIC_SELTIMEOUT)) {
    sub SBIC_SELTIMEOUT () {	9;}
}
unless(defined(&SBIC_CLEANING)) {
    sub SBIC_CLEANING () {	10;}
}
unless(defined(&SBIC_BUSRESET)) {
    sub SBIC_BUSRESET () {	11;}
}
unless(defined(&SEND_DEV_RESET)) {
    sub SEND_DEV_RESET () {	0x1;}
}
unless(defined(&SEND_PARITY_ERROR)) {
    sub SEND_PARITY_ERROR () {	0x2;}
}
unless(defined(&SEND_INIT_DET_ERR)) {
    sub SEND_INIT_DET_ERR () {	0x4;}
}
unless(defined(&SEND_REJECT)) {
    sub SEND_REJECT () {	0x8;}
}
unless(defined(&SEND_IDENTIFY)) {
    sub SEND_IDENTIFY () {	0x10;}
}
unless(defined(&SEND_ABORT)) {
    sub SEND_ABORT () {	0x20;}
}
unless(defined(&SEND_WDTR)) {
    sub SEND_WDTR () {	0x40;}
}
unless(defined(&SEND_SDTR)) {
    sub SEND_SDTR () {	0x80;}
}
unless(defined(&SEND_TAG)) {
    sub SEND_TAG () {	0x100;}
}
unless(defined(&SBIC_CHIP_UNKNOWN)) {
    sub SBIC_CHIP_UNKNOWN () {	0;}
}
unless(defined(&SBIC_CHIP_WD33C93)) {
    sub SBIC_CHIP_WD33C93 () {	1;}
}
unless(defined(&SBIC_CHIP_WD33C93A)) {
    sub SBIC_CHIP_WD33C93A () {	2;}
}
unless(defined(&SBIC_CHIP_WD33C93B)) {
    sub SBIC_CHIP_WD33C93B () {	3;}
}
unless(defined(&SBIC_CHIP_LIST)) {
    sub SBIC_CHIP_LIST () {	{"UNKNOWN", "WD33C93", "WD33C93A", "WD33C93B"};}
}
unless(defined(&CFFLAGS_NODISC)) {
    sub CFFLAGS_NODISC {
	my($_cf, $_t) = @_;
	eval q((($_cf) & (1<< ( 0+ ($_t)))));
    }
}
unless(defined(&CFFLAGS_NOSYNC)) {
    sub CFFLAGS_NOSYNC {
	my($_cf, $_t) = @_;
	eval q((($_cf) & (1<< ( 8+ ($_t)))));
    }
}
unless(defined(&CFFLAGS_NOTAGS)) {
    sub CFFLAGS_NOTAGS {
	my($_cf, $_t) = @_;
	eval q((($_cf) & (1<< (16+ ($_t)))));
    }
}
unless(defined(&SBIC_STATE_ERROR)) {
    sub SBIC_STATE_ERROR () {	-1;}
}
unless(defined(&SBIC_STATE_DONE)) {
    sub SBIC_STATE_DONE () {	0;}
}
unless(defined(&SBIC_STATE_RUNNING)) {
    sub SBIC_STATE_RUNNING () {	1;}
}
unless(defined(&SBIC_STATE_DISCONNECT)) {
    sub SBIC_STATE_DISCONNECT () {	2;}
}
unless(defined(&DEBUG_ACBS)) {
    sub DEBUG_ACBS () {	0x1;}
}
unless(defined(&DEBUG_INTS)) {
    sub DEBUG_INTS () {	0x2;}
}
unless(defined(&DEBUG_CMDS)) {
    sub DEBUG_CMDS () {	0x4;}
}
unless(defined(&DEBUG_MISC)) {
    sub DEBUG_MISC () {	0x8;}
}
unless(defined(&DEBUG_TRAC)) {
    sub DEBUG_TRAC () {	0x10;}
}
unless(defined(&DEBUG_RSEL)) {
    sub DEBUG_RSEL () {	0x20;}
}
unless(defined(&DEBUG_PHASE)) {
    sub DEBUG_PHASE () {	0x40;}
}
unless(defined(&DEBUG_DMA)) {
    sub DEBUG_DMA () {	0x80;}
}
unless(defined(&DEBUG_CCMDS)) {
    sub DEBUG_CCMDS () {	0x100;}
}
unless(defined(&DEBUG_MSGS)) {
    sub DEBUG_MSGS () {	0x200;}
}
unless(defined(&DEBUG_TAGS)) {
    sub DEBUG_TAGS () {	0x400;}
}
unless(defined(&DEBUG_SYNC)) {
    sub DEBUG_SYNC () {	0x800;}
}
if(defined(&SBICDEBUG)) {
    eval 'sub SBIC_DEBUG {
        my($level, $str) = @_;
	    eval q( &do {  &if ( &wd33c93_debug &  &__CONCAT( &DEBUG_,$level))  &printf $str; }  &while (0));
    }' unless defined(&SBIC_DEBUG);
} else {
    eval 'sub SBIC_DEBUG {
        my($level, $str) = @_;
	    eval q();
    }' unless defined(&SBIC_DEBUG);
}
1;
