/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.Attribute;

public class X509Attribute
extends ASN1Encodable {
    Attribute attr;

    X509Attribute(ASN1Encodable aSN1Encodable) {
        this.attr = Attribute.getInstance(aSN1Encodable);
    }

    public X509Attribute(String string, ASN1Encodable aSN1Encodable) {
        this.attr = new Attribute(new DERObjectIdentifier(string), new DERSet(aSN1Encodable));
    }

    public X509Attribute(String string, ASN1EncodableVector aSN1EncodableVector) {
        this.attr = new Attribute(new DERObjectIdentifier(string), new DERSet(aSN1EncodableVector));
    }

    public String getOID() {
        return this.attr.getAttrType().getId();
    }

    public ASN1Encodable[] getValues() {
        ASN1Set aSN1Set = this.attr.getAttrValues();
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[aSN1Set.size()];
        for (int i = 0; i != aSN1Set.size(); ++i) {
            aSN1EncodableArray[i] = (ASN1Encodable)aSN1Set.getObjectAt(i);
        }
        return aSN1EncodableArray;
    }

    public DERObject toASN1Object() {
        return this.attr.toASN1Object();
    }
}

