/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.actions.ActionFactory;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.SwingDownIconListener;
import org.jpedal.objects.acroforms.actions.SwingFormButtonListener;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class DefaultActionHandler
implements ActionHandler {
    private static final boolean showMethods = false;
    private PdfObjectReader currentPdfFile;
    private Javascript javascript;
    private AcroRenderer acrorend;
    private ActionFactory actionFactory;
    private PdfDecoder decode_pdf;
    private int pageHeight;
    private int insetH;

    public void init(PdfDecoder pdfDecoder, Javascript javascript, AcroRenderer acroRenderer) {
        this.currentPdfFile = pdfDecoder.getIO();
        this.javascript = javascript;
        this.acrorend = acroRenderer;
        this.decode_pdf = pdfDecoder;
    }

    public void init(PdfObjectReader pdfObjectReader, Javascript javascript, AcroRenderer acroRenderer) {
        this.currentPdfFile = this.decode_pdf.getIO();
        this.javascript = javascript;
        this.acrorend = acroRenderer;
    }

    public void setPageAccess(int n, int n2) {
        this.pageHeight = n;
        this.insetH = n2;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        actionFactory.setPDF(this.decode_pdf, this.acrorend);
        this.actionFactory = actionFactory;
    }

    public Object setupChangingDownIcon(Object object, Object object2) {
        return new SwingDownIconListener(object, object2);
    }

    public Object setupChangingCaption(String string, String string2, String string3) {
        return new SwingFormButtonListener(string, string2, string3);
    }

    public Object setComboClickOnEntry(String string) {
        return new SwingFormButtonListener(string, "comboEntry", (AcroRenderer)null);
    }

    public Object setHoverCursor() {
        return this.actionFactory.getHoverCursor();
    }

    public Object setupXFAAction(int n, String string, String string2) {
        switch (n) {
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return new SwingFormButtonListener(n, string, string2, this.acrorend);
            }
        }
        return null;
    }

    public void A(Object object, FormObject formObject, int n) {
        int n2 = formObject.getActionFlag();
        Object object2 = formObject.getAobj();
        int n3 = formObject.getType();
        if (n3 == 3) {
            this.additionalAction_Signature(formObject, n);
        } else if (n2 > 0 || object2 instanceof Map) {
            Map map = new HashMap();
            if (object2 != null) {
                map = (Map)object2;
            }
            if (map.containsKey("S")) {
                String string = (String)map.get("S");
                if ((string = Strip.checkRemoveLeadingSlach(string)).equals("Named")) {
                    if (map.containsKey("N")) {
                        String string2 = (String)map.get("N");
                        if ((string2 = Strip.checkRemoveLeadingSlach(string2)).equals("Print")) {
                            this.additionalAction_Print(n);
                        } else if (string2.equals("SaveAs")) {
                            LogWriter.writeFormLog("Named Action=SaveAs pagenumber=" + map.get("PageNumber"), false);
                        } else if (!string2.startsWith("AcroForm:")) {
                            if (string2.startsWith("NextPage")) {
                                LogWriter.writeFormLog("Named action NextPage NOT implemented" + string2, false);
                            } else if (!string2.startsWith("ZoomTo")) {
                                if (string2.startsWith("FullScreen")) {
                                    LogWriter.writeFormLog("Named action FullScreen NOT implemented" + string2, false);
                                } else {
                                    LogWriter.writeFormLog("{stream} Named Action NOT IMPLEMENTED command=" + string2 + " field=" + ConvertToString.convertMapToString(map, null), false);
                                }
                            }
                        }
                    }
                } else if (string.equals("GoTo") && map.containsKey("D")) {
                    this.addtionalAction_Goto(formObject, n);
                } else if (string.equals("ResetForm")) {
                    this.additionalAction_ResetForm(n);
                } else if (string.equals("SubmitForm")) {
                    this.additionalAction_SubmitForm(n, map);
                } else if (string.equals("JavaScript")) {
                    LogWriter.writeFormLog("{stream} JavaScript field=" + ConvertToString.convertMapToString(map, null), false);
                } else if (string.equals("Hide")) {
                    this.additionalAction_Hide(n, map);
                } else if (string.equals("URI")) {
                    this.additionalAction_URI(n, map);
                } else if (string.equals("Launch")) {
                    LogWriter.writeFormLog("{stream} launch activate action NOT IMPLEMENTED", false);
                } else if (string.equals("GoTo")) {
                    LogWriter.writeFormLog("{FormStream.resolveAdditionalAction} /GoTo action NOT IMPLEMENTED", false);
                } else if (string.equals("GoToR")) {
                    this.addAdditionalAction_GotoR(n, map);
                } else {
                    LogWriter.writeFormLog("{stream} UNKNOWN command for Activate Action command=" + string + " field=" + ConvertToString.convertMapToString(map, null), false);
                }
            } else if (map.containsKey("Dest")) {
                if (n == 3) {
                    Map map2 = (Map)((Map)formObject.getAobj()).get("Dest");
                    int n4 = this.decode_pdf.getPageFromObjectRef((String)map2.get("Page"));
                    this.changeTo(null, n4, map2.get("Position"));
                } else {
                    this.actionFactory.setCursor(n);
                }
            } else if (formObject.getActionFlag() == 1) {
                this.actionFactory.popup(object, formObject, this.currentPdfFile, this.pageHeight, this.insetH);
            } else {
                LogWriter.writeFormLog("{stream} Activate Action UNKNOWN command NOT IMPLEMENTED field=" + ConvertToString.convertMapToString(map, null), false);
            }
        } else if (object2 != null) {
            LogWriter.writeFormLog("{stream} A additionalAction NON Map UNIMPLEMENTED", false);
        }
    }

    private void addAdditionalAction_GotoR(int n, Map map) {
        if (n == 3) {
            int n2;
            int n3;
            String string = (String)map.get("D");
            Map map2 = (Map)map.get("F");
            String string2 = (String)map2.get("Type");
            String string3 = (String)map2.get("F");
            if (string3.startsWith("(")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (string.startsWith("(")) {
                string = string.substring(1, string.length() - 1);
            }
            if ((n3 = string.indexOf("P.")) != -1) {
                string = string.substring(n3 + 2, string.length());
                n2 = Integer.parseInt(string);
            } else {
                n2 = string.equals("F") ? 1 : 1;
            }
            if (string2.equals("/Filespec")) {
                if (string3.startsWith("./")) {
                    string3 = new File(string3.substring(2, string3.length())).getAbsolutePath();
                }
                if (string3.startsWith("../")) {
                    String string4 = new File("").getAbsolutePath();
                    string3 = string4.substring(0, string4.lastIndexOf(92) + 1) + string3.substring(3, string3.length());
                }
                if (new File(string3).exists()) {
                    this.changeTo(string3, n2, null);
                    LogWriter.writeFormLog("{DefaultActionHamdler.A} Form has GoToR command, needs methods for opening new file on page specified", false);
                } else {
                    this.actionFactory.showMessageDialog("The file specified " + string3 + " Does Not Exist!");
                }
            } else {
                LogWriter.writeFormLog("{CustomMouseListener.mouseClicked} GoToRemote NON Filespec NOT IMPLEMENTED", false);
            }
        } else {
            this.actionFactory.setCursor(n);
        }
    }

    private void additionalAction_URI(int n, Map map) {
        String string = this.removeBrackets((String)map.get("URI"));
        if (n == 3) {
            try {
                BrowserLauncher.openURL(string);
            }
            catch (IOException iOException) {
                this.actionFactory.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
            }
        } else {
            this.actionFactory.setCursor(n);
        }
    }

    private void additionalAction_Hide(int n, Map map) {
        if (n == 1) {
            HashMap hashMap = new HashMap();
            this.getHideMap(map, hashMap);
            this.actionFactory.setFieldVisibility(hashMap);
        }
    }

    private void additionalAction_SubmitForm(int n, Map map) {
        if (n == 3) {
            Object object;
            Object object2;
            if (map.containsKey("Fields")) {
                object2 = new StringTokenizer((String)map.get("Fields"), "[]()");
                String string = null;
                StringBuffer stringBuffer = new StringBuffer();
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (((String)object).indexOf(".x") != -1) {
                        string = ((String)object).substring(((String)object).indexOf(46) + 1, ((String)object).indexOf(".x") + 1);
                    }
                    if (((String)object).indexOf(" R") == -1) continue;
                    String string2 = ((String)object).trim();
                    object = (String)this.currentPdfFile.readObject(new PdfObject(string2), string2, false, null).get("T");
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(((String)object).substring(1, ((String)object).length() - 1));
                    stringBuffer.append(',');
                }
                map.put("Fields", stringBuffer.toString());
            }
            if ((object = map.get("F")) instanceof Map) {
                object2 = (String)((Map)object).get("F");
                if (((String)object2).startsWith("(")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
            } else {
                object2 = (String)object;
                if (((String)object2).startsWith("(")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
            }
            this.actionFactory.submitURL(map, (String)object2);
        }
    }

    private void additionalAction_ResetForm(int n) {
        if (n == 1) {
            this.actionFactory.reset();
        }
    }

    private void addtionalAction_Goto(FormObject formObject, int n) {
        if (n == 3) {
            String string = (String)((Map)formObject.getAobj()).get("D");
            String string2 = string.substring(1, string.indexOf(47) - 1);
            int n2 = this.decode_pdf.getPageFromObjectRef(string2);
            this.changeTo(null, n2, null);
        } else {
            this.actionFactory.setCursor(n);
        }
    }

    private void additionalAction_Print(int n) {
        if (n == 2) {
            this.actionFactory.print();
        }
    }

    private void additionalAction_Signature(FormObject formObject, int n) {
        if (n == 3) {
            Map map = this.decode_pdf.getFormRenderer().getSignatureObject(formObject.getPDFRef());
            if (map == null) {
                return;
            }
            this.actionFactory.showSig(map);
        } else {
            this.actionFactory.setCursor(n);
        }
    }

    public void changeTo(String string, int n, Object object) {
        if (string != null) {
            try {
                this.decode_pdf.openPdfFile(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n != -1 && n > 0 && n < this.decode_pdf.getPageCount()) {
            try {
                this.decode_pdf.decodePage(n);
                this.decode_pdf.updatePageNumberDisplayed(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.decode_pdf.setPageParameters(-1.0f, n);
        }
        this.actionFactory.setPageandPossition(object);
    }

    public void E(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 1, 6, ' ');
    }

    public void X(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 2, 6, ' ');
    }

    public void D(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 3, 6, ' ');
    }

    public void U(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 4, 6, ' ');
    }

    public void Fo(Object object, FormObject formObject) {
    }

    public void Bl(Object object, FormObject formObject) {
    }

    public void O(int n) {
        Object var2_2 = null;
        if (var2_2 != null) {
            this.javascript.executeAction(n, 11);
        }
    }

    public void PO(int n) {
        Object var2_2 = null;
        if (var2_2 != null) {
            this.javascript.executeAction(n, 7);
        }
    }

    public void PC(int n) {
        this.javascript.executeAction(n, 8);
    }

    public void PV(int n) {
        this.javascript.executeAction(n, 9);
    }

    public void PI(int n) {
        this.javascript.executeAction(n, 10);
    }

    public int K(Object object, FormObject formObject, int n) {
        int n2 = 0;
        n2 = this.javascript.execute(formObject.getFieldName(), 13, n, this.actionFactory.getKeyPressed(object));
        return n2;
    }

    public void F(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 15, 6, ' ');
    }

    public void V(Object object, FormObject formObject, int n) {
        this.javascript.execute(formObject.getFieldName(), 16, n, this.actionFactory.getKeyPressed(object));
    }

    public void C(Object object, FormObject formObject) {
        this.javascript.execute(formObject.getFieldName(), 17, 6, ' ');
    }

    private String removeBrackets(String string) {
        if (string.startsWith("(") || string.startsWith("[") || string.startsWith("{")) {
            if (string.endsWith(")")) {
                return string.substring(1, string.length() - 1);
            }
            return string.substring(1, string.length() - 2);
        }
        return string;
    }

    private void getHideMap(Map map, Map map2) {
        Boolean[] booleanArray;
        String[] stringArray;
        Object object;
        if (!Strip.checkRemoveLeadingSlach((String)map.get("S")).equals("Hide")) {
            LogWriter.writeFormLog("{stream} getHideMap has a NON Hide value field=" + map, false);
        }
        if (map2.containsKey("fields")) {
            object = (String[])map2.get("fields");
            stringArray = new String[((String[])object).length + 1];
            System.arraycopy(object, 0, stringArray, 0, ((String[])object).length);
            stringArray[stringArray.length - 1] = (String)map.get("T");
        } else {
            stringArray = new String[]{(String)map.get("T")};
        }
        map2.put("fields", stringArray);
        object = Boolean.TRUE;
        if (map.containsKey("H")) {
            object = Boolean.valueOf((String)map.get("H"));
        }
        if (map2.containsKey("hide")) {
            Boolean[] booleanArray2 = (Boolean[])map2.get("hide");
            booleanArray = new Boolean[booleanArray2.length + 1];
            System.arraycopy(booleanArray2, 0, booleanArray, 0, booleanArray2.length);
            booleanArray[booleanArray.length - 1] = object;
        } else {
            booleanArray = new Boolean[]{object};
        }
        map2.put("hide", booleanArray);
        if (map.containsKey("Next")) {
            this.getHideMap((Map)map.get("Next"), map2);
        }
    }
}

