/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.openamf.AMFBody;
import org.openamf.AMFMessage;
import org.openamf.io.AMFDeserializer;
import org.openamf.io.AMFSerializer;

public class RemotingTester {
    public static AMFMessage sendMessage(String gateway, String target, String response, List parameters) throws IOException, HttpException {
        AMFMessage requestMessage = new AMFMessage();
        AMFBody requestBody = new AMFBody(target, response, parameters);
        requestMessage.addBody(requestBody);
        return RemotingTester.sendMessage(gateway, requestMessage);
    }

    public static AMFMessage sendMessage(String gateway, AMFMessage requestMessage) throws IOException, HttpException {
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baOutputStream);
        AMFSerializer serializer = new AMFSerializer(outputStream);
        serializer.serializeMessage(requestMessage);
        PostMethod post = new PostMethod(gateway);
        post.setRequestBody((InputStream)new ByteArrayInputStream(baOutputStream.toByteArray()));
        post.setRequestContentLength(baOutputStream.size());
        post.setRequestHeader("Content-type", "application/x-amf");
        HttpClient httpclient = new HttpClient();
        int result = httpclient.executeMethod((HttpMethod)post);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(post.getResponseBody()));
        AMFDeserializer deserializer = new AMFDeserializer(inputStream);
        AMFMessage resposeMessage = deserializer.getAMFMessage();
        post.releaseConnection();
        return resposeMessage;
    }

    public static void main(String[] args) throws IOException {
        AMFMessage msg1 = RemotingTester.createMessage1();
        System.out.println("msg1 = " + msg1);
        AMFMessage msg2 = RemotingTester.sendMessage("http://localhost:8080/openamf/gateway", msg1);
        System.out.println("msg2 = " + msg2);
    }

    private static AMFMessage createMessage1() {
        AMFMessage message = new AMFMessage();
        HashMap<String, Boolean> keys1 = new HashMap<String, Boolean>();
        keys1.put("amf", Boolean.FALSE);
        keys1.put("error", Boolean.TRUE);
        keys1.put("trace", Boolean.TRUE);
        keys1.put("coldfusion", Boolean.TRUE);
        keys1.put("m_debug", Boolean.TRUE);
        keys1.put("httpheaders", Boolean.FALSE);
        keys1.put("amfheaders", Boolean.FALSE);
        keys1.put("recordset", Boolean.TRUE);
        message.addHeader("amf_server_debug", true, keys1);
        message.addBody("org.openamf.test.Test3.getNumber", "/1", new Double(3.14), (byte)0);
        return message;
    }
}

