/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.cfx;

import com.allaire.cfx.Query;
import com.allaire.cfx.Response;
import java.util.Enumeration;
import java.util.Hashtable;
import railo.loader.engine.CFMLEngineFactory;
import railo.runtime.cfx.QueryWrap;

public final class DebugResponse
implements Response {
    private StringBuffer write = new StringBuffer();
    private StringBuffer writeDebug = new StringBuffer();
    private Hashtable variables = new Hashtable();
    private Hashtable queries = new Hashtable();

    @Override
    public Query addQuery(String string, String[] stringArray) {
        QueryWrap queryWrap = new QueryWrap(CFMLEngineFactory.getInstance().getCreationUtil().createQuery(stringArray, 0, string), string.toLowerCase());
        this.queries.put(string.toLowerCase(), queryWrap);
        return queryWrap;
    }

    @Override
    public void setVariable(String string, String string2) {
        this.variables.put(string.toLowerCase(), string2);
    }

    @Override
    public void write(String string) {
        this.write.append(string);
    }

    @Override
    public void writeDebug(String string) {
        this.writeDebug.append(string);
    }

    public void printResults() {
        Object object;
        System.out.println("[ --- Railo Debug Response --- ]");
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|          Output          |");
        System.out.println("----------------------------");
        System.out.println(this.write);
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|       Debug Output       |");
        System.out.println("----------------------------");
        System.out.println(this.writeDebug);
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|        Variables         |");
        System.out.println("----------------------------");
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            System.out.println("[Variable:" + object + "]");
            System.out.println(this.escapeString(this.variables.get(object).toString()));
        }
        System.out.println();
        enumeration = this.queries.keys();
        while (enumeration.hasMoreElements()) {
            object = (Query)this.queries.get(enumeration.nextElement());
            this.printQuery((Query)object);
            System.out.println();
        }
    }

    public void printQuery(Query query) {
        if (query != null) {
            String[] stringArray = query.getColumns();
            int n = query.getRowCount();
            System.out.println("[Query:" + query.getName() + "]");
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (n2 > 0) {
                    System.out.print(", ");
                }
                System.out.print(stringArray[n2]);
                ++n2;
            }
            System.out.println();
            n2 = 1;
            while (n2 <= n) {
                int n3 = 1;
                while (n3 <= stringArray.length) {
                    if (n3 > 1) {
                        System.out.print(", ");
                    }
                    System.out.print(this.escapeString(query.getData(n2, n3)));
                    ++n3;
                }
                System.out.println();
                ++n2;
            }
        }
    }

    private String escapeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                stringBuffer.append("\\n");
            } else if (c == '\t') {
                stringBuffer.append("\\t");
            } else if (c == '\\') {
                stringBuffer.append("\\\\");
            } else if (c == '\b') {
                stringBuffer.append("\\b");
            } else if (c == '\r') {
                stringBuffer.append("\\r");
            } else if (c == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return "\"" + stringBuffer.toString() + "\"";
    }
}

