open GtkSignal
open Gobject
open Data
let set = set
let get = get
let param = param

open GtkBaseProps

open GtkBaseProps

class virtual container_props = object
  val virtual obj : _ obj
  method set_border_width = set Container.P.border_width obj
  method set_resize_mode = set Container.P.resize_mode obj
  method border_width = get Container.P.border_width obj
  method resize_mode = get Container.P.resize_mode obj
end

class virtual container_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method border_width = self#notify Container.P.border_width
  method resize_mode = self#notify Container.P.resize_mode
end

class virtual container_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method add = self#connect
    {Container.S.add with marshaller = fun f ->
     marshal1 GObj.conv_widget "GtkContainer::add" f}
  method remove = self#connect
    {Container.S.remove with marshaller = fun f ->
     marshal1 GObj.conv_widget "GtkContainer::remove" f}
  method notify_border_width ~callback =
    self#notify Container.P.border_width ~callback
  method notify_resize_mode ~callback =
    self#notify Container.P.resize_mode ~callback
end

class virtual item_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method select = self#connect Item.S.select
  method deselect = self#connect Item.S.deselect
  method toggle = self#connect Item.S.toggle
end

class virtual window_props = object
  val virtual obj : _ obj
  method set_title = set Window.P.title obj
  method set_accept_focus = set Window.P.accept_focus obj
  method set_allow_grow = set Window.P.allow_grow obj
  method set_allow_shrink = set Window.P.allow_shrink obj
  method set_decorated = set Window.P.decorated obj
  method set_default_height = set Window.P.default_height obj
  method set_default_width = set Window.P.default_width obj
  method set_deletable = set Window.P.deletable obj
  method set_destroy_with_parent = set Window.P.destroy_with_parent obj
  method set_focus_on_map = set Window.P.focus_on_map obj
  method set_gravity = set Window.P.gravity obj
  method set_icon = set Window.P.icon obj
  method set_icon_name = set Window.P.icon_name obj
  method set_modal = set Window.P.modal obj
  method set_position = set Window.P.window_position obj
  method set_opacity = set Window.P.opacity obj
  method set_resizable = set Window.P.resizable obj
  method set_role = set Window.P.role obj
  method set_screen = set Window.P.screen obj
  method set_skip_pager_hint = set Window.P.skip_pager_hint obj
  method set_skip_taskbar_hint = set Window.P.skip_taskbar_hint obj
  method set_type_hint = set Window.P.type_hint obj
  method set_urgency_hint = set Window.P.urgency_hint obj
  method title = get Window.P.title obj
  method accept_focus = get Window.P.accept_focus obj
  method allow_grow = get Window.P.allow_grow obj
  method allow_shrink = get Window.P.allow_shrink obj
  method decorated = get Window.P.decorated obj
  method default_height = get Window.P.default_height obj
  method default_width = get Window.P.default_width obj
  method deletable = get Window.P.deletable obj
  method destroy_with_parent = get Window.P.destroy_with_parent obj
  method focus_on_map = get Window.P.focus_on_map obj
  method gravity = get Window.P.gravity obj
  method has_toplevel_focus = get Window.P.has_toplevel_focus obj
  method icon = get Window.P.icon obj
  method icon_name = get Window.P.icon_name obj
  method is_active = get Window.P.is_active obj
  method modal = get Window.P.modal obj
  method position = get Window.P.window_position obj
  method opacity = get Window.P.opacity obj
  method resizable = get Window.P.resizable obj
  method role = get Window.P.role obj
  method screen = get Window.P.screen obj
  method skip_pager_hint = get Window.P.skip_pager_hint obj
  method skip_taskbar_hint = get Window.P.skip_taskbar_hint obj
  method kind = get Window.P.kind obj
  method type_hint = get Window.P.type_hint obj
  method urgency_hint = get Window.P.urgency_hint obj
end

class virtual window_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method title = self#notify Window.P.title
  method accept_focus = self#notify Window.P.accept_focus
  method allow_grow = self#notify Window.P.allow_grow
  method allow_shrink = self#notify Window.P.allow_shrink
  method decorated = self#notify Window.P.decorated
  method default_height = self#notify Window.P.default_height
  method default_width = self#notify Window.P.default_width
  method deletable = self#notify Window.P.deletable
  method destroy_with_parent = self#notify Window.P.destroy_with_parent
  method focus_on_map = self#notify Window.P.focus_on_map
  method gravity = self#notify Window.P.gravity
  method has_toplevel_focus = self#notify Window.P.has_toplevel_focus
  method icon = self#notify Window.P.icon
  method icon_name = self#notify Window.P.icon_name
  method is_active = self#notify Window.P.is_active
  method modal = self#notify Window.P.modal
  method position = self#notify Window.P.window_position
  method opacity = self#notify Window.P.opacity
  method resizable = self#notify Window.P.resizable
  method role = self#notify Window.P.role
  method screen = self#notify Window.P.screen
  method skip_pager_hint = self#notify Window.P.skip_pager_hint
  method skip_taskbar_hint = self#notify Window.P.skip_taskbar_hint
  method kind = self#notify Window.P.kind
  method type_hint = self#notify Window.P.type_hint
  method urgency_hint = self#notify Window.P.urgency_hint
end

class virtual dialog_props = object
  val virtual obj : _ obj
  method set_has_separator = set Dialog.P.has_separator obj
  method has_separator = get Dialog.P.has_separator obj
end

class virtual dialog_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method has_separator = self#notify Dialog.P.has_separator
end

class virtual file_selection_props = object
  val virtual obj : _ obj
  method set_filename = set FileSelection.P.filename obj
  method set_select_multiple = set FileSelection.P.select_multiple obj
  method set_show_fileops = set FileSelection.P.show_fileops obj
  method filename = get FileSelection.P.filename obj
  method select_multiple = get FileSelection.P.select_multiple obj
  method show_fileops = get FileSelection.P.show_fileops obj
end

class virtual file_selection_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method filename = self#notify FileSelection.P.filename
  method select_multiple = self#notify FileSelection.P.select_multiple
  method show_fileops = self#notify FileSelection.P.show_fileops
end

class virtual message_dialog_props = object
  val virtual obj : _ obj
  method set_message_type = set MessageDialog.P.message_type obj
  method message_type = get MessageDialog.P.message_type obj
end

class virtual message_dialog_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method message_type = self#notify MessageDialog.P.message_type
end

class virtual about_dialog_props = object
  val virtual obj : _ obj
  method set_comments = set AboutDialog.P.comments obj
  method set_copyright = set AboutDialog.P.copyright obj
  method set_license = set AboutDialog.P.license obj
  method set_logo = set AboutDialog.P.logo obj
  method set_logo_icon_name = set AboutDialog.P.logo_icon_name obj
  method set_translator_credits = set AboutDialog.P.translator_credits obj
  method set_version = set AboutDialog.P.version obj
  method set_website = set AboutDialog.P.website obj
  method set_website_label = set AboutDialog.P.website_label obj
  method set_wrap_license = set AboutDialog.P.wrap_license obj
  method comments = get AboutDialog.P.comments obj
  method copyright = get AboutDialog.P.copyright obj
  method license = get AboutDialog.P.license obj
  method logo = get AboutDialog.P.logo obj
  method logo_icon_name = get AboutDialog.P.logo_icon_name obj
  method translator_credits = get AboutDialog.P.translator_credits obj
  method version = get AboutDialog.P.version obj
  method website = get AboutDialog.P.website obj
  method website_label = get AboutDialog.P.website_label obj
  method wrap_license = get AboutDialog.P.wrap_license obj
end

class virtual about_dialog_notify obj = object (self)
  val obj : 'a obj = obj
  method private notify : 'b. ('a, 'b) property ->
    callback:('b -> unit) -> _ =
  fun prop ~callback -> GtkSignal.connect_property obj
    ~prop ~callback
  method comments = self#notify AboutDialog.P.comments
  method copyright = self#notify AboutDialog.P.copyright
  method license = self#notify AboutDialog.P.license
  method logo = self#notify AboutDialog.P.logo
  method logo_icon_name = self#notify AboutDialog.P.logo_icon_name
  method translator_credits = self#notify AboutDialog.P.translator_credits
  method version = self#notify AboutDialog.P.version
  method website = self#notify AboutDialog.P.website
  method website_label = self#notify AboutDialog.P.website_label
  method wrap_license = self#notify AboutDialog.P.wrap_license
end

class virtual plug_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method embedded = self#connect Plug.S.embedded
end

class virtual socket_sigs = object (self)
  method private virtual connect :
    'b. ('a,'b) GtkSignal.t -> callback:'b -> GtkSignal.id
  method private virtual notify :
    'b. ('a,'b) property -> callback:('b -> unit) -> GtkSignal.id
  method plug_added = self#connect Socket.S.plug_added
  method plug_removed = self#connect Socket.S.plug_removed
end

