/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.mpg;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import net.sourceforge.jffmpeg.demux.mpg.MpegDemux;

public class MpegTrack
implements Track {
    protected MpegDemux demux;
    protected int trackId;
    protected int streamId;
    protected Format format;
    protected long pos;

    public MpegTrack(MpegDemux mpegDemux, int n) {
        this.demux = mpegDemux;
        this.trackId = n;
        this.pos = 0L;
    }

    public Time getDuration() {
        return new Time(0L);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isEnabled() {
        return true;
    }

    public Time mapFrameToTime(int n) {
        return new Time(0L);
    }

    public int mapTimeToFrame(Time time) {
        return 0;
    }

    public Time getStartTime() {
        return new Time(0L);
    }

    public void setTrackListener(TrackListener trackListener) {
    }

    public void readFrame(Buffer buffer) {
        try {
            buffer.setLength(0);
            buffer.setOffset(0);
            buffer.setFlags(64);
            boolean bl = false;
            while (!bl) {
                int n = this.demux.peekPacket(this.pos);
                if (n >= 448 && n <= 479 || n >= 480 && n <= 495 || n == 445) {
                    if (n != this.trackId) {
                        this.pos = this.demux.skipDTSPacket(this.pos);
                        continue;
                    }
                    this.pos = this.demux.readDTSPacket(buffer, this.streamId, this.pos);
                    bl = true;
                    break;
                }
                this.pos = this.demux.skipPacket(this.pos);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

