/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.http.HTTPProxyDestinationControl;
import flex.messaging.Destination;
import flex.messaging.config.ConfigMap;
import flex.messaging.services.HTTPProxyService;
import flex.messaging.services.Service;
import flex.messaging.services.http.ProtocolFactory;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.SettingsReplaceUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPProxyDestination
extends Destination {
    static final long serialVersionUID = -5749492520894791206L;
    public static final String LOG_CATEGORY = "Service.HTTP";
    private static final String URL = "url";
    private static final String WSDL = "wsdl";
    private static final String DYNAMIC_URL = "dynamic-url";
    private static final String SOAP = "soap";
    private static final String REMOTE_USERNAME = "remote-username";
    private static final String REMOTE_PASSWORD = "remote-password";
    private static final String USE_CUSTOM_AUTH = "use-custom-auth";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String PROPERTIES = "properties";
    protected String defaultUrl;
    protected final List dynamicUrls = new ArrayList();
    protected String remoteUsername;
    protected String remotePassword;
    protected boolean useCustomAuthentication;
    protected ProtocolFactory protocolFactory;
    protected boolean allowsDynamicAuthentication;
    protected boolean dynamicParsed;
    protected String parsedDefaultUrl;
    protected List parsedDynamicUrls;
    private HTTPProxyDestinationControl controller;

    public HTTPProxyDestination() {
        this(false);
    }

    public HTTPProxyDestination(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id, ConfigMap properties) {
        List soapUrls;
        String className;
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap factoryMap = properties.getPropertyAsMap("protocol-factory", null);
        if (factoryMap != null && (className = factoryMap.getPropertyAsString(CLASS, null)) != null) {
            Class factoryClass = ClassUtil.createClass((String)className);
            this.protocolFactory = (ProtocolFactory)ClassUtil.createDefaultInstance((Class)factoryClass, (Class)ProtocolFactory.class);
            String factoryId = factoryMap.getPropertyAsString(ID, this.getId() + "_protocol_factory");
            ConfigMap protocolProperties = factoryMap.getPropertyAsMap(PROPERTIES, null);
            this.protocolFactory.initialize(factoryId, protocolProperties);
        }
        this.defaultUrl = properties.getPropertyAsString(URL, null);
        if (this.defaultUrl == null) {
            this.defaultUrl = properties.getPropertyAsString(WSDL, null);
        } else {
            properties.allowProperty(WSDL);
        }
        List dynUrls = properties.getPropertyAsList(DYNAMIC_URL, null);
        if (dynUrls != null) {
            this.dynamicUrls.addAll(dynUrls);
        }
        if ((soapUrls = properties.getPropertyAsList(SOAP, new ArrayList())) != null) {
            this.dynamicUrls.addAll(soapUrls);
        }
        this.remoteUsername = properties.getPropertyAsString(REMOTE_USERNAME, null);
        this.remotePassword = properties.getPropertyAsString(REMOTE_PASSWORD, null);
        this.useCustomAuthentication = properties.getPropertyAsBoolean(USE_CUSTOM_AUTH, true);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public List getDynamicUrls() {
        return this.dynamicUrls;
    }

    public void addDynamicUrl(String dynamicUrl) {
        if (dynamicUrl != null) {
            this.dynamicUrls.add(dynamicUrl);
            this.dynamicParsed = false;
        }
    }

    public void addDynamicUrls(List dynamicUrls) {
        this.dynamicUrls.addAll(dynamicUrls);
        this.dynamicParsed = false;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setProtocolFactory(ProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUsername() {
        return this.remoteUsername;
    }

    public void setRemoteUsername(String remoteUsername) {
        this.remoteUsername = remoteUsername;
    }

    public void setService(Service service) {
        HTTPProxyService proxyService = (HTTPProxyService)service;
        super.setService((Service)proxyService);
    }

    public boolean isUseCustomAuthentication() {
        return this.useCustomAuthentication;
    }

    public void setUseCustomAuthentication(boolean useCustomAuthentication) {
        this.useCustomAuthentication = useCustomAuthentication;
    }

    public String getParsedDefaultUrl(String contextPath, String serverName, String serverPort, String serverProtocol) {
        if (this.defaultUrl != null) {
            this.parsedDefaultUrl = SettingsReplaceUtil.replaceAllTokensGivenServerName((String)this.defaultUrl, (String)contextPath, (String)serverName, (String)serverPort, (String)serverProtocol);
        }
        return this.parsedDefaultUrl;
    }

    public List getParsedDynamicUrls(String contextPath) {
        if (!this.dynamicParsed || this.parsedDynamicUrls == null) {
            HTTPProxyDestination.parseDynamicUrls(this, contextPath);
        }
        return this.parsedDynamicUrls;
    }

    private static void parseDynamicUrls(HTTPProxyDestination dest, String contextPath) {
        List dynamicUrls = dest.getDynamicUrls();
        dest.parsedDynamicUrls = new ArrayList();
        dest.allowsDynamicAuthentication = true;
        String lastDomainAndPort = null;
        boolean computeAuth = true;
        Set parsedUrls = SettingsReplaceUtil.replaceAllTokensCalculateServerName((List)dynamicUrls, (String)contextPath);
        Iterator iter = parsedUrls.iterator();
        while (iter.hasNext()) {
            String url = (String)iter.next();
            dest.parsedDynamicUrls.add(url.toCharArray());
            if (!computeAuth) continue;
            boolean fail = false;
            try {
                URL urlObj = new URL(url);
                String host = urlObj.getHost();
                if (host.indexOf("*") > -1) {
                    fail = true;
                } else {
                    String domainAndPort = host + ":" + urlObj.getPort();
                    if (lastDomainAndPort != null && !lastDomainAndPort.equalsIgnoreCase(domainAndPort)) {
                        fail = true;
                    }
                    lastDomainAndPort = domainAndPort;
                }
            }
            catch (MalformedURLException e) {
                fail = true;
            }
            if (!fail) continue;
            computeAuth = false;
            dest.allowsDynamicAuthentication = false;
        }
        dest.dynamicParsed = true;
    }

    public boolean allowsDynamicAuthentication() {
        if (!this.dynamicParsed) {
            throw new RuntimeException("Cannot compute authentication if dynamic urls aren't parsed");
        }
        return this.allowsDynamicAuthentication;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupDestinationControl(Service service) {
        this.controller = new HTTPProxyDestinationControl(this, service.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }
}

