/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.Server;
import flex.messaging.client.FlexClientManager;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.AdapterSettings;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FactorySettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.PropertiesSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import flex.messaging.config.SharedServerSettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.config.TargetSettings;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.log.Log;
import flex.messaging.log.Target;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import flex.messaging.services.AuthenticationService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.RedeployManager;
import flex.messaging.util.StringUtils;
import flex.messaging.util.ToStringPrettyPrinter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MessagingConfiguration
implements ServicesConfiguration {
    private final Map channelSettings = new HashMap();
    private final List defaultChannels = new ArrayList(4);
    private final SecuritySettings securitySettings;
    private final List serviceSettings;
    private final List sharedServerSettings;
    private LoggingSettings loggingSettings;
    private SystemSettings systemSettings;
    private FlexClientSettings flexClientSettings;
    private final Map clusterSettings = new HashMap();
    private final Map factorySettings = new HashMap();
    static /* synthetic */ Class class$flex$messaging$Server;

    public MessagingConfiguration() {
        this.serviceSettings = new ArrayList();
        this.sharedServerSettings = new ArrayList();
        this.securitySettings = new SecuritySettings();
    }

    public void configureBroker(MessageBroker broker) {
        broker.setChannelSettings(this.channelSettings);
        broker.setSecuritySettings(this.securitySettings);
        broker.setSystemSettings(this.systemSettings);
        broker.setFlexClientSettings(this.flexClientSettings);
        this.createAuthorizationManager(broker);
        this.createFlexClientManager(broker);
        this.createRedeployManager(broker);
        this.createFactories(broker);
        this.createSharedServers(broker);
        this.createEndpoints(broker);
        broker.setDefaultChannels(this.defaultChannels);
        this.prepareClusters(broker);
        this.createServices(broker);
    }

    public MessageBroker createBroker(String id, ClassLoader loader) {
        return new MessageBroker(this.systemSettings.isManageable(), id, loader);
    }

    private void createFactories(MessageBroker broker) {
        Iterator iter = this.factorySettings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            FactorySettings factorySetting = (FactorySettings)((Object)entry.getValue());
            broker.addFactory(id, factorySetting.createFactory());
        }
    }

    private void createFlexClientManager(MessageBroker broker) {
        FlexClientManager flexClientManager = new FlexClientManager(broker.isManaged(), broker);
        broker.setFlexClientManager(flexClientManager);
    }

    private void createRedeployManager(MessageBroker broker) {
        RedeployManager redeployManager = new RedeployManager();
        redeployManager.setEnabled(this.systemSettings.getRedeployEnabled());
        redeployManager.setWatchInterval(this.systemSettings.getWatchInterval());
        redeployManager.setTouchFiles(this.systemSettings.getTouchFiles());
        redeployManager.setWatchFiles(this.systemSettings.getWatchFiles());
        broker.setRedeployManager(redeployManager);
    }

    private void createAuthorizationManager(MessageBroker broker) {
        LoginManager loginManager = new LoginManager();
        LoginCommand loginCommand = null;
        Map loginCommands = this.securitySettings.getLoginCommands();
        LoginCommandSettings loginCommandSettings = (LoginCommandSettings)loginCommands.get("all");
        if (loginCommandSettings != null) {
            loginCommand = this.initLoginCommand(loginCommandSettings);
        } else {
            String serverInfo = this.securitySettings.getServerInfo();
            loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverInfo);
            if (loginCommandSettings != null) {
                loginCommand = this.initLoginCommand(loginCommandSettings);
            } else {
                serverInfo = serverInfo.toLowerCase();
                Iterator iterator = loginCommands.keySet().iterator();
                while (iterator.hasNext()) {
                    String serverMatch = (String)iterator.next();
                    loginCommandSettings = (LoginCommandSettings)loginCommands.get(serverMatch);
                    if (serverInfo.indexOf(serverMatch.toLowerCase()) == -1) continue;
                    loginCommands.put(serverInfo, loginCommandSettings);
                    loginCommand = this.initLoginCommand(loginCommandSettings);
                    break;
                }
            }
        }
        loginManager.setLoginCommand(loginCommand);
        if (loginCommandSettings != null) {
            loginManager.setPerClientAuthentication(loginCommandSettings.isPerClientAuthentication());
        }
        broker.setLoginManager(loginManager);
    }

    private LoginCommand initLoginCommand(LoginCommandSettings loginCommandSettings) {
        String loginClass = loginCommandSettings.getClassName();
        Class c = ClassUtil.createClass(loginClass, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        LoginCommand loginCommand = (LoginCommand)ClassUtil.createDefaultInstance(c, LoginCommand.class);
        return loginCommand;
    }

    private void createSharedServers(MessageBroker broker) {
        int n = this.sharedServerSettings.size();
        for (int i = 0; i < n; ++i) {
            SharedServerSettings settings = (SharedServerSettings)this.sharedServerSettings.get(i);
            String id = settings.getId();
            String className = settings.getClassName();
            Class serverClass = ClassUtil.createClass(className, broker.getClassLoader());
            Server server = (Server)ClassUtil.createDefaultInstance(serverClass, class$flex$messaging$Server == null ? MessagingConfiguration.class$("flex.messaging.Server") : class$flex$messaging$Server);
            server.initialize(id, settings.getProperties());
            if (broker.isManaged() && server instanceof ManageableComponent) {
                ManageableComponent manageableServer = (ManageableComponent)((Object)server);
                manageableServer.setManaged(true);
                manageableServer.setParent(broker);
            }
            broker.addServer(server);
            if (!Log.isInfo()) continue;
            Log.getLogger((String)"Configuration").info("Server " + id + " of type " + className + " created.");
        }
    }

    private void createEndpoints(MessageBroker broker) {
        Iterator iter = this.channelSettings.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            ChannelSettings chanSettings = (ChannelSettings)this.channelSettings.get(id);
            String url = chanSettings.getUri();
            String endpointClassName = chanSettings.getEndpointType();
            if (chanSettings.isRemote()) continue;
            Endpoint endpoint = broker.createEndpoint(id, url, endpointClassName);
            endpoint.setSecurityConstraint(chanSettings.getConstraint());
            endpoint.setClientType(chanSettings.getClientType());
            String referencedServerId = chanSettings.getServerId();
            if (referencedServerId != null && endpoint instanceof Endpoint2) {
                Server server = broker.getServer(referencedServerId);
                if (server == null) {
                    ConfigurationException ce = new ConfigurationException();
                    ce.setMessage(11128, new Object[]{chanSettings.getId(), referencedServerId});
                    throw ce;
                }
                ((Endpoint2)endpoint).setServer(broker.getServer(referencedServerId));
            }
            endpoint.initialize(id, chanSettings.getProperties());
            if (!Log.isInfo()) continue;
            String endpointURL = endpoint.getUrl();
            String endpointSecurity = EndpointControl.getSecurityConstraintOf(endpoint);
            if (StringUtils.isEmpty((String)endpointSecurity)) {
                endpointSecurity = "None";
            }
            Log.getLogger((String)"Configuration").info("Endpoint " + id + " created with security: " + endpointSecurity + StringUtils.NEWLINE + "at URL: " + endpointURL);
        }
    }

    private void createServices(MessageBroker broker) {
        AuthenticationService authService = new AuthenticationService();
        authService.setMessageBroker(broker);
        Iterator iter = this.serviceSettings.iterator();
        while (iter.hasNext()) {
            ServiceSettings svcSettings = (ServiceSettings)iter.next();
            String svcId = svcSettings.getId();
            String svcClassName = svcSettings.getClassName();
            Service service = broker.createService(svcId, svcClassName);
            service.initialize(svcId, svcSettings.getProperties());
            Iterator chanIter = svcSettings.getDefaultChannels().iterator();
            while (chanIter.hasNext()) {
                ChannelSettings chanSettings = (ChannelSettings)chanIter.next();
                service.addDefaultChannel(chanSettings.getId());
            }
            Map svcAdapterSettings = svcSettings.getAllAdapterSettings();
            Iterator asIter = svcAdapterSettings.values().iterator();
            while (asIter.hasNext()) {
                AdapterSettings as = (AdapterSettings)asIter.next();
                service.registerAdapter(as.getId(), as.getClassName());
                if (!as.isDefault()) continue;
                service.setDefaultAdapter(as.getId());
            }
            Map destinationSettings = svcSettings.getDestinationSettings();
            Iterator destSettingsIter = destinationSettings.keySet().iterator();
            while (destSettingsIter.hasNext()) {
                String destName = (String)destSettingsIter.next();
                DestinationSettings destSettings = (DestinationSettings)destinationSettings.get(destName);
                this.createDestination(destSettings, service, svcSettings);
            }
        }
    }

    private void createDestination(DestinationSettings destSettings, Service service, ServiceSettings svcSettings) {
        String destId = destSettings.getId();
        Destination destination = service.createDestination(destId);
        List chanSettings = destSettings.getChannelSettings();
        if (chanSettings.size() > 0) {
            ArrayList<String> channelIds = new ArrayList<String>(2);
            Iterator iter = chanSettings.iterator();
            while (iter.hasNext()) {
                ChannelSettings cs = (ChannelSettings)iter.next();
                channelIds.add(cs.getId());
            }
            destination.setChannels(channelIds);
        }
        SecurityConstraint constraint = destSettings.getConstraint();
        destination.setSecurityConstraint(constraint);
        destination.initialize(destId, svcSettings.getProperties());
        destination.initialize(destId, destSettings.getAdapterSettings().getProperties());
        destination.initialize(destId, destSettings.getProperties());
        this.createAdapter(destination, destSettings, svcSettings);
    }

    private void createAdapter(Destination destination, DestinationSettings destSettings, ServiceSettings svcSettings) {
        AdapterSettings adapterSettings = destSettings.getAdapterSettings();
        String adapterId = adapterSettings.getId();
        ServiceAdapter adapter = destination.createAdapter(adapterId);
        adapter.initialize(adapterId, svcSettings.getProperties());
        adapter.initialize(adapterId, adapterSettings.getProperties());
        adapter.initialize(adapterId, destSettings.getProperties());
    }

    public void createLogAndTargets() {
        if (this.loggingSettings == null) {
            Log.setPrettyPrinterClass((String)ToStringPrettyPrinter.class.getName());
            return;
        }
        Log.createLog();
        ConfigMap properties = this.loggingSettings.getProperties();
        if (properties.getPropertyAsString("pretty-printer", null) == null) {
            Log.setPrettyPrinterClass((String)ToStringPrettyPrinter.class.getName());
        }
        Log.initialize(null, (ConfigMap)properties);
        List targets = this.loggingSettings.getTargets();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            TargetSettings targetSettings = (TargetSettings)it.next();
            String className = targetSettings.getClassName();
            Class c = ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
            try {
                Target target = (Target)c.newInstance();
                target.setLevel(Log.readLevel((String)targetSettings.getLevel()));
                target.setFilters(targetSettings.getFilters());
                target.initialize(null, targetSettings.getProperties());
                Log.addTarget((Target)target);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getCause();
                }
                System.err.println("*** Error setting up logging system");
                t.printStackTrace();
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10126, new Object[]{className});
                cx.setRootCause(t);
                throw cx;
            }
        }
    }

    private void prepareClusters(MessageBroker broker) {
        ClusterManager clusterManager = broker.getClusterManager();
        Iterator iter = this.clusterSettings.keySet().iterator();
        while (iter.hasNext()) {
            String clusterId = (String)iter.next();
            ClusterSettings cs = (ClusterSettings)this.clusterSettings.get(clusterId);
            clusterManager.prepareCluster(cs);
        }
    }

    public void addSharedServerSettings(SharedServerSettings settings) {
        this.sharedServerSettings.add(settings);
    }

    public void addChannelSettings(String id, ChannelSettings settings) {
        this.channelSettings.put(id, settings);
    }

    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void addDefaultChannel(String id) {
        this.defaultChannels.add(id);
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    public ServiceSettings getServiceSettings(String id) {
        Iterator iter = this.serviceSettings.iterator();
        while (iter.hasNext()) {
            ServiceSettings serviceSettings = (ServiceSettings)iter.next();
            if (!serviceSettings.getId().equals(id)) continue;
            return serviceSettings;
        }
        return null;
    }

    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void setLoggingSettings(LoggingSettings loggingSettings) {
        this.loggingSettings = loggingSettings;
    }

    public void setSystemSettings(SystemSettings ss) {
        this.systemSettings = ss;
    }

    public SystemSettings getSystemSettings() {
        return this.systemSettings;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            Iterator it = this.clusterSettings.values().iterator();
            while (it.hasNext()) {
                ClusterSettings cs = (ClusterSettings)it.next();
                if (!cs.isDefault()) continue;
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10214, new Object[]{settings.getClusterName(), cs.getClusterName()});
                throw cx;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx = new ConfigurationException();
            cx.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    public ClusterSettings getClusterSettings(String clusterId) {
        Iterator it = this.clusterSettings.values().iterator();
        while (it.hasNext()) {
            ClusterSettings cs = (ClusterSettings)it.next();
            if (cs.getClusterName() == clusterId) {
                return cs;
            }
            if (cs.getClusterName() == null || !cs.getClusterName().equals(clusterId)) continue;
            return cs;
        }
        return null;
    }

    public ClusterSettings getDefaultCluster() {
        Iterator it = this.clusterSettings.values().iterator();
        while (it.hasNext()) {
            ClusterSettings cs = (ClusterSettings)it.next();
            if (!cs.isDefault()) continue;
            return cs;
        }
        return null;
    }

    public void addFactorySettings(String id, FactorySettings settings) {
        this.factorySettings.put(id, settings);
    }

    public void reportUnusedProperties() {
        ArrayList findings = new ArrayList();
        Iterator serviceItr = this.serviceSettings.iterator();
        while (serviceItr.hasNext()) {
            ServiceSettings serviceSettings = (ServiceSettings)serviceItr.next();
            this.gatherUnusedProperties(serviceSettings.getId(), serviceSettings.getSourceFile(), "service", (PropertiesSettings)serviceSettings, findings);
            Iterator destinationItr = serviceSettings.getDestinationSettings().values().iterator();
            while (destinationItr.hasNext()) {
                DestinationSettings destinationSettings = (DestinationSettings)destinationItr.next();
                this.gatherUnusedProperties(destinationSettings.getId(), destinationSettings.getSourceFile(), "destination", (PropertiesSettings)destinationSettings, findings);
                AdapterSettings adapterSettings = destinationSettings.getAdapterSettings();
                if (adapterSettings == null) continue;
                this.gatherUnusedProperties(adapterSettings.getId(), adapterSettings.getSourceFile(), "adapter", (PropertiesSettings)adapterSettings, findings);
            }
        }
        Iterator channelItr = this.channelSettings.values().iterator();
        while (channelItr.hasNext()) {
            ChannelSettings channelSettings = (ChannelSettings)channelItr.next();
            if (channelSettings.isRemote()) continue;
            this.gatherUnusedProperties(channelSettings.getId(), channelSettings.getSourceFile(), "channel", (PropertiesSettings)channelSettings, findings);
        }
        if (!findings.isEmpty()) {
            int errorNumber = 10149;
            ConfigurationException exception = new ConfigurationException();
            StringBuffer allDetails = new StringBuffer();
            for (int i = 0; i < findings.size(); ++i) {
                allDetails.append(StringUtils.NEWLINE);
                allDetails.append("  ");
                exception.setDetails(errorNumber, "pattern", (Object[])findings.get(i));
                allDetails.append(exception.getDetails());
                exception.setDetails(null);
            }
            exception.setMessage(errorNumber, new Object[]{allDetails});
            throw exception;
        }
    }

    private void gatherUnusedProperties(String settingsId, String settingsSource, String settingsType, PropertiesSettings settings, Collection result) {
        List unusedProperties = settings.getProperties().findAllUnusedProperties();
        int size = unusedProperties.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String path = (String)unusedProperties.get(i);
                result.add(new Object[]{path, settingsType, settingsId, settingsSource});
            }
        }
    }
}

