/*
 * Decompiled with CFR 0.152.
 */
package railo.cli;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.servlet.ServletException;
import railo.cli.CLIInvoker;
import railo.cli.CLIInvokerImpl;
import railo.cli.Closer;

public class CLIFactory
extends Thread {
    private static final int PORT = 8893;
    private File root;
    private String servletName;
    private Map<String, String> config;
    private long idleTime;

    public CLIFactory(File file, String string, Map<String, String> map) {
        this.root = file;
        this.servletName = string;
        this.config = map;
        this.idleTime = 60000L;
        String string2 = map.get("idle");
        if (string2 != null) {
            try {
                this.idleTime = Long.parseLong(string2);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void run() {
        String string = this.root.getAbsolutePath();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return;
        }
        try {
            try {
                this.invoke(inetAddress, string);
            }
            catch (ConnectException connectException) {
                this.startInvoker(string);
                this.invoke(inetAddress, string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void invoke(InetAddress inetAddress, String string) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(inetAddress.getHostAddress(), 8893);
        CLIInvoker cLIInvoker = (CLIInvoker)registry.lookup(string);
        cLIInvoker.invoke(this.config);
    }

    private void startInvoker(String string) throws ServletException, RemoteException {
        Registry registry = CLIFactory.getRegistry(8893);
        CLIInvokerImpl cLIInvokerImpl = new CLIInvokerImpl(this.root, this.servletName);
        CLIInvoker cLIInvoker = (CLIInvoker)UnicastRemoteObject.exportObject((Remote)cLIInvokerImpl, 0);
        registry.rebind(string, cLIInvoker);
        if (this.idleTime > 0L) {
            Closer closer = new Closer(registry, cLIInvokerImpl, string, this.idleTime);
            closer.setDaemon(false);
            closer.start();
        }
    }

    public static Registry getRegistry(int n) {
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(n);
        }
        catch (RemoteException remoteException) {}
        try {
            if (registry == null) {
                registry = LocateRegistry.getRegistry(n);
            }
        }
        catch (RemoteException remoteException) {}
        RemoteServer.setLog(System.out);
        return registry;
    }
}

