/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.preview;

import com.sun.security.sasl.preview.MergedEnumeration;
import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslClientFactory;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.preview.SaslServer;
import com.sun.security.sasl.preview.SaslServerFactory;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class Sasl {
    private static SaslClientFactory clientFactory = null;
    private static SaslServerFactory serverFactory = null;
    public static final String CLIENT_PKGS = "javax.security.sasl.client.pkgs";
    public static final String SERVER_PKGS = "javax.security.sasl.server.pkgs";
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    static /* synthetic */ Class class$com$sun$security$sasl$preview$SaslClientFactory;
    static /* synthetic */ Class class$com$sun$security$sasl$preview$SaslServerFactory;

    private Sasl() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        SaslClient saslClient = null;
        Enumeration enumeration = Sasl.getSaslClientFactories(map);
        while (saslClient == null && enumeration.hasMoreElements()) {
            SaslClientFactory saslClientFactory = (SaslClientFactory)enumeration.nextElement();
            saslClient = saslClientFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler);
        }
        return saslClient;
    }

    public static SaslServer createSaslServer(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        SaslServer saslServer = null;
        Enumeration enumeration = Sasl.getSaslServerFactories(map);
        while (saslServer == null && enumeration.hasMoreElements()) {
            SaslServerFactory saslServerFactory = (SaslServerFactory)enumeration.nextElement();
            saslServer = saslServerFactory.createSaslServer(string, string2, string3, map, callbackHandler);
        }
        return saslServer;
    }

    public static Enumeration getSaslClientFactories(Map map) {
        return new MergedEnumeration(clientFactory, CLIENT_PKGS, 0, "ClientFactory", class$com$sun$security$sasl$preview$SaslClientFactory != null ? class$com$sun$security$sasl$preview$SaslClientFactory : (class$com$sun$security$sasl$preview$SaslClientFactory = Sasl.class$("com.sun.security.sasl.preview.SaslClientFactory")), map);
    }

    public static Enumeration getSaslServerFactories(Map map) {
        return new MergedEnumeration(serverFactory, SERVER_PKGS, 1, "ServerFactory", class$com$sun$security$sasl$preview$SaslServerFactory != null ? class$com$sun$security$sasl$preview$SaslServerFactory : (class$com$sun$security$sasl$preview$SaslServerFactory = Sasl.class$("com.sun.security.sasl.preview.SaslServerFactory")), map);
    }

    public static void setSaslClientFactory(SaslClientFactory saslClientFactory) {
        if (clientFactory != null) {
            throw new IllegalStateException("SaslClientFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        clientFactory = saslClientFactory;
    }

    public static void setSaslServerFactory(SaslServerFactory saslServerFactory) {
        if (serverFactory != null) {
            throw new IllegalStateException("SaslServerFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        serverFactory = saslServerFactory;
    }
}

