/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.functions;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class JSFunction {
    private static boolean debugJavaScript = false;
    String ref;
    AcroRenderer acro;
    int functionID = 0;
    public static final int AFDate = 1;
    public static final int AFNumber = 2;
    public static final int AFPercent = 3;
    public static final int AFRange = 4;
    public static final int AFSimple = 5;
    public static final int AFSpecial = 6;
    public static final int AFTime = 7;
    static final int AVG = 1;
    static final int SUM = 2;
    static final int PRD = 3;
    static final int MIN = 4;
    static final int MAX = 5;
    public static final int UNKNOWN = -1;
    public static final int KEYSTROKE = 1;
    public static final int VALIDATE = 2;
    public static final int FORMAT = 3;
    public static final int CALCULATE = 4;
    public static boolean DECIMAL_IS_COMMA = false;

    public JSFunction(AcroRenderer acroRenderer, String string) {
        this.acro = acroRenderer;
        this.ref = string;
    }

    public static void debug(String string) {
        if (debugJavaScript) {
            System.out.println("[javascript] " + string);
        }
    }

    protected static String applyRegexp(String string, String[] stringArray) {
        String string2 = "";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Pattern pattern = Pattern.compile(stringArray[i]);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            i = n;
            int n2 = matcher.start();
            int n3 = matcher.end();
            string2 = string.substring(n2, n3);
        }
        return string2;
    }

    String processArray(String string, int n) {
        float f = 0.0f;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        String[] stringArray = JSFunction.convertToArray(string);
        float f2 = stringArray.length;
        int n2 = 1;
        while ((float)n2 < f2) {
            string = JSFunction.stripQuotes(stringArray[n2]);
            String string2 = (String)this.acro.getCompData().getValue(string);
            if (string2.length() == 0) {
                string2 = "0";
            }
            if (string2.indexOf(46) != -1) {
                bl2 = true;
            }
            bl3 = true;
            boolean bl4 = string2.startsWith("-");
            float f3 = 0.0f;
            int n3 = string2.indexOf(44);
            if (n3 != -1) {
                string2 = string2.replace(',', '.');
            }
            f3 = bl4 ? -Float.parseFloat(string2.substring(1)) : Float.parseFloat(string2);
            switch (n) {
                case 1: {
                    f += f3;
                    break;
                }
                case 2: {
                    f += f3;
                    break;
                }
                case 3: {
                    if (bl) {
                        f = 1.0f;
                        bl = false;
                    }
                    f *= f3;
                    break;
                }
                case 4: {
                    if (n2 == 1) {
                        f = f3;
                        break;
                    }
                    if (!(f3 < f)) break;
                    f = f3;
                    break;
                }
                case 5: {
                    if (n2 == 1) {
                        f = f3;
                        break;
                    }
                    if (!(f3 > f)) break;
                    f = f3;
                    break;
                }
                default: {
                    JSFunction.debug("Unsupported op " + n + " in processArray");
                }
            }
            ++n2;
        }
        if (n == 1) {
            f /= f2 - 1.0f;
        }
        if (bl2) {
            return String.valueOf(f);
        }
        if (!bl3) {
            return "";
        }
        return String.valueOf((int)f);
    }

    public static String[] convertToArray(String string) {
        int n;
        Object object;
        String string2 = string;
        int n2 = string.indexOf(40);
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = null;
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 != -1) {
            object = string.substring(0, n2);
            arrayList.add((String)object);
            ++n3;
            string = string.substring(n2, string.length()).trim();
            n = 1;
            if (string.endsWith(";")) {
                ++n;
            }
            if (string.startsWith("(")) {
                string = string.substring(1, string.length() - n);
            } else {
                JSFunction.debug("Unknown args in " + string2);
            }
        }
        object = new StringTokenizer(string, "(,);", true);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string4 = ((StringTokenizer)object).nextToken();
            while (((StringTokenizer)object).hasMoreTokens() && string4.startsWith("\"") && !string4.endsWith("\"")) {
                string4 = string4 + ((StringTokenizer)object).nextToken();
            }
            if (n4 == 0 && string4.equals(",")) {
                arrayList.add(string3);
                string3 = "";
                ++n3;
                continue;
            }
            if (string4.equals("(")) {
                ++n4;
            } else if (string4.equals(")")) {
                --n4;
            }
            string3 = string3 + string4;
        }
        arrayList.add(string3);
        stringArray = new String[++n3];
        for (n = 0; n < n3; ++n) {
            stringArray[n] = ((String)arrayList.get(n)).trim();
        }
        return stringArray;
    }

    private static String padString(String string, int n) {
        int n2 = string.length();
        if (n == n2) {
            return string;
        }
        if (n < n2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void maskAlert(int n, Object[] objectArray) {
        String string = (String)this.acro.getCompData().getLastValidValue(this.ref);
        if (string == null) {
            string = "";
        }
        this.acro.getCompData().setValue(this.ref, string, true, true, false);
        this.acro.reportError(n, objectArray);
    }

    String validateMask(String[] stringArray, String string, boolean bl) {
        String[] stringArray2 = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        int n4 = stringArray.length;
        if (n4 != 2) {
            String string3 = "";
            for (int i = 0; i < n4; ++i) {
                string3 = i == 0 ? stringArray[i] : string3 + ',' + stringArray[i];
            }
            JSFunction.debug("Unexpected values items=" + n4 + '{' + string3 + '}');
        } else {
            int n5;
            String string4;
            boolean bl2 = true;
            String string5 = (String)this.acro.getCompData().getValue(this.ref);
            if (string5 == null || string5.length() == 0) {
                return "";
            }
            String string6 = null;
            int n6 = string5.lastIndexOf(32);
            if (n6 != -1 && (string6 = string5.substring(n6 + 1).toLowerCase().trim()) != null && (string6.equals("am") || string6.equals("pm"))) {
                string5 = string5.substring(0, n6);
            }
            if ((string4 = JSFunction.stripQuotes(stringArray[1])).charAt((n5 = string4.indexOf(100)) + 1) != 'd') {
                string4 = string4.replaceFirst("d", "dd");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, string, true);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, string, true);
            StringBuffer stringBuffer = new StringBuffer();
            String string7 = "";
            String string8 = "";
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            while (stringTokenizer.hasMoreTokens()) {
                int n7;
                String string9;
                String string10;
                string8 = "";
                while (string.indexOf(string10 = stringTokenizer.nextToken()) != -1 && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(string10);
                }
                while ((string9 = !stringTokenizer2.hasMoreTokens() ? null : stringTokenizer2.nextToken()) != null && string.indexOf(string9) != -1 && stringTokenizer2.hasMoreTokens()) {
                }
                string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                if (string9 != null) {
                    string8 = JSFunction.padString(string9, string10.length());
                }
                if (string10.equals("h")) {
                    string8 = bl && string9 == null ? String.valueOf(gregorianCalendar.get(10)) : JSFunction.padString(string9, 2);
                    bl2 = JSFunction.verifyNumberInRange(string8, 0, 11);
                } else if (string10.equals("HH")) {
                    if (bl && string9 == null) {
                        string8 = String.valueOf(gregorianCalendar.get(11));
                        string8 = JSFunction.padString(string8, 2);
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 23);
                    } else {
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 23);
                    }
                } else if (string10.equals("MM")) {
                    if (bl && string9 == null) {
                        string8 = String.valueOf(gregorianCalendar.get(12));
                        string8 = JSFunction.padString(string8, 2);
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 59);
                    } else {
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 59);
                    }
                } else if (string10.equals("mm") || string10.equals("m")) {
                    bl2 = JSFunction.verifyNumberInRange(string8, 0, 12);
                    if (bl2 && (n7 = Integer.parseInt(string8) - 1) == 1 && n > 0) {
                        --n;
                    }
                } else if (string10.equals("tt")) {
                    if (bl && string9 == null) {
                        string8 = "am";
                    }
                    bl2 = string8.toLowerCase().equals("am") || string8.toLowerCase().equals("pm");
                } else if (string10.equals("ss")) {
                    if (bl && string9 == null) {
                        string8 = String.valueOf(gregorianCalendar.get(13));
                        string8 = JSFunction.padString(string8, 2);
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 59);
                    } else {
                        bl2 = JSFunction.verifyNumberInRange(string8, 0, 59);
                    }
                } else if (string10.equals("dd") || string10.equals("d")) {
                    bl2 = JSFunction.verifyNumberInRange(string8, 0, 31);
                    if (bl2) {
                        n3 = Integer.parseInt(string8);
                    }
                } else if (string10.equals("yyyy") || string10.equals("yy")) {
                    if (bl && string9 == null) {
                        string9 = String.valueOf(gregorianCalendar.get(1));
                        bl2 = JSFunction.verifyNumberInRange(string9, 0, 9999);
                    } else if (string10.length() != string9.length()) {
                        bl2 = false;
                    } else {
                        if (string9.length() == 2) {
                            n7 = Integer.parseInt(string9);
                            string9 = n7 < 50 ? "20" + string9 : "19" + string9;
                        }
                        bl2 = JSFunction.verifyNumberInRange(string9, 0, 9999);
                    }
                    if (bl2 && Integer.parseInt(string9) % 4 != 0 && n > 0) {
                        --n;
                    }
                    string8 = string9;
                } else if (string10.equals("mmm") || string10.equals("mmmm")) {
                    n7 = -1;
                    if (string9.length() >= 3) {
                        for (int i = 0; i != stringArray2.length; ++i) {
                            String string11;
                            string9 = string9.toLowerCase();
                            int n8 = 3;
                            if (!(string9 = string9.substring(0, n8).toLowerCase()).equals(string11 = stringArray2[i].substring(0, n8).toLowerCase())) continue;
                            n7 = i;
                        }
                    }
                    if (n7 == -1) {
                        try {
                            n7 = Integer.parseInt(string9) - 1;
                            if (n7 < 12) {
                                string8 = stringArray2[n7];
                            }
                        }
                        catch (Exception exception) {
                            string8 = null;
                            bl2 = false;
                        }
                    } else {
                        string8 = stringArray2[n7];
                    }
                    if (n7 != 1 && n > 0) {
                        --n;
                    }
                    if (n7 > 11) {
                        bl2 = false;
                    } else {
                        n2 = n7;
                    }
                } else {
                    JSFunction.debug("Mask value >" + string10 + "< not implemented");
                    bl2 = false;
                }
                if (!bl2) break;
                stringBuffer.append(string8);
                if (string7 == null) continue;
                stringBuffer.append(string7);
            }
            if (n2 < 0 || n2 > nArray.length || n3 > nArray[n2] + n) {
                bl2 = false;
            }
            if (bl2) {
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    private static boolean verifyNumberInRange(String string, int n, int n2) {
        boolean bl = true;
        if (string == null || JSFunction.isNotNumber(string)) {
            bl = false;
        } else {
            int n3 = Integer.parseInt(string);
            if (n3 < n || n3 > n2) {
                bl = false;
            }
        }
        return bl;
    }

    protected static String stripQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.startsWith("\\u")) {
            String string2 = string.substring(2);
            string = String.valueOf((char)Integer.parseInt(string2, 16));
        } else if (string.startsWith("\\")) {
            String string3 = string.substring(1);
            string = String.valueOf((char)Integer.parseInt(string3, 8));
        }
        return string;
    }

    protected static boolean isNotNumber(String string) {
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '.' || cArray[i] == '-' || cArray[i] == ',' || cArray[i] >= '0' && cArray[i] <= '9') continue;
            i = n;
            bl = true;
        }
        return bl;
    }
}

