#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.09';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::mwg_coll',
	'Image::ExifTool::XMP::mwg_kw',
	'Image::ExifTool::XMP::mwg_rs',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'3dpanoramasize' => { 289 => 0x38 },
	'aberrationcorrectiondistance' => { 83 => 0x69 },
	'about' => { 331 => 'about' },
	'abspeakaudiofilepath' => { 337 => 'absPeakAudioFilePath' },
	'accessorytype' => { 232 => 0x53 },
	'actionadvised' => { 97 => 0x2a },
	'activearea' => { 90 => 0xc68d },
	'actived-lighting' => { 169 => 0x22, 197 => 0x24 },
	'actived-lightingmode' => { 197 => 0x25 },
	'addaspectratioinfo' => { 64 => 0x80e },
	'additionalmodelinformation' => { 321 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 64 => 0x80f, 65 => 0x11, 66 => 0x13, 69 => 0x14 },
	'address' => { 123 => 'Address' },
	'adjustmentmode' => { 284 => 0x15 },
	'adobe' => { 91 => 'Adobe' },
	'adultcontentwarning' => { 327 => 'AdultContentWarning', 330 => 'adultContentWarning' },
	'advancedraw' => { 199 => 0x76a43203 },
	'advancedscenetype' => { 232 => 0x3d },
	'advisory' => { 335 => 'Advisory' },
	'ae_iso' => { 237 => 0x2 },
	'aeaperture' => { 237 => 0x1 },
	'aebautocancel' => { 64 => 0x104 },
	'aebbracketvalue' => { 58 => 0x11 },
	'aebsequence' => { 64 => 0x105 },
	'aebsequenceautocancel' => { 62 => 0x9, 63 => 0x9, 65 => 0x8, 66 => 0x9, 69 => 0x9, 70 => 0x7 },
	'aebshotcount' => { 64 => 0x106 },
	'aebxv' => { 237 => 0x4 },
	'aeexposuretime' => { 237 => 0x0 },
	'aelbutton' => { 140 => 0x45 },
	'aelexposureindicator' => { 140 => 0x51 },
	'aelock' => { 140 => 0x5b, 207 => '4.2', 211 => '4.2', 213 => 0x201, 260 => 0x48, 289 => 0x86 },
	'aelockbutton' => { 206 => '16.1', 207 => '4.1', 208 => '15.1', 209 => '30.1', 210 => '16.1', 211 => '4.1', 212 => '17.1' },
	'aelockbuttonplusdials' => { 206 => '16.2', 209 => '32.1' },
	'aelockformb-d80' => { 212 => '3.1' },
	'aemaxaperture' => { 237 => 0x9 },
	'aemaxaperture2' => { 237 => 0xa },
	'aemeteringmode' => { 237 => 0xc },
	'aemeteringsegments' => { 143 => 0x628, 260 => 0x209 },
	'aemicroadjustment' => { 64 => 0x111 },
	'aeminaperture' => { 237 => 0xb },
	'aeminexposuretime' => { 237 => 0x5 },
	'aeprogrammode' => { 237 => 0x6 },
	'aesetting' => { 25 => 0x21 },
	'aexv' => { 237 => 0x3 },
	'af-cpriorityselection' => { 206 => '1.1', 209 => '1.1', 210 => '0.1' },
	'af-onformb-d10' => { 206 => '3.3', 209 => '3.2' },
	'af-onformb-d11' => { 210 => '2.2' },
	'af-spriorityselection' => { 206 => '1.2', 209 => '1.2', 210 => '0.2' },
	'afactivation' => { 206 => '2.1', 209 => '2.1' },
	'afadjustment' => { 260 => 0x72 },
	'afandmeteringbuttons' => { 64 => 0x701 },
	'afaperture' => { 165 => 0x5, 166 => 0x5 },
	'afareaheight' => { 148 => 0x1a },
	'afareaillumination' => { 140 => 0x4b, 211 => '15.3' },
	'afareamode' => { 136 => 0x33, 140 => 0xe, 147 => 0x0, 148 => 0x5, 232 => 0xf, 287 => 0x11, 288 => 0x10, 289 => 0x24 },
	'afareamodesetting' => { 207 => '11.1', 208 => '0.1', 211 => '16.1', 212 => '2.1' },
	'afareas' => { 213 => 0x304 },
	'afareawidth' => { 148 => 0x18 },
	'afareaxposition' => { 148 => 0x14 },
	'afareayposition' => { 148 => 0x16 },
	'afassist' => { 62 => 0x5, 70 => 0x5, 140 => 0x48, 206 => '2.5', 207 => '0.2', 208 => '0.2', 209 => '2.4', 210 => '1.4', 211 => '0.2', 212 => '2.3' },
	'afassistbeam' => { 64 => 0x50e, 65 => 0x4, 66 => 0x5, 67 => 0x4, 68 => 0x4, 69 => 0x5 },
	'afassistlamp' => { 232 => 0x31 },
	'afbuttonpressed' => { 289 => 0x83 },
	'afdefocus' => { 238 => 0x6 },
	'afduringliveview' => { 64 => 0x511 },
	'affinetune' => { 149 => 0x0, 213 => 0x306 },
	'affinetuneadj' => { 149 => 0x2, 177 => 0x2d1, 178 => 0x2dc, 213 => 0x307 },
	'affinetuneindex' => { 149 => 0x1 },
	'afilluminator' => { 287 => 0x29, 298 => 0xb044 },
	'afimageheight' => { 148 => 0x12 },
	'afimagewidth' => { 148 => 0x10 },
	'afintegrationtime' => { 238 => 0x7 },
	'afmicroadjmode' => { 1 => 0x1, 286 => 0x131 },
	'afmicroadjustment' => { 64 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2, 286 => 0x130 },
	'afmode' => { 87 => 0x3009, 136 => 0x16, 284 => 0x5, 298 => 0xb043 },
	'afonaelockbuttonswitch' => { 64 => 0x702 },
	'afonbutton' => { 206 => '3.1' },
	'afpoint' => { 25 => 0x13, 86 => 0x18, 136 => 0x15, 147 => 0x1, 216 => 0x308, 284 => 0x1f, 285 => 0x20 },
	'afpointactivationarea' => { 63 => 0x11, 69 => 0x11 },
	'afpointareaexpansion' => { 64 => 0x508 },
	'afpointautoselection' => { 64 => 0x50b },
	'afpointbrightness' => { 64 => 0x50d, 206 => '2.4' },
	'afpointdisplayduringfocus' => { 64 => 0x50c },
	'afpointillumination' => { 63 => 0xa, 206 => '2.3', 209 => '2.3', 210 => '1.3', 212 => '2.4' },
	'afpointmode' => { 242 => 0x3 },
	'afpointposition' => { 87 => 0x2021, 232 => 0x4d },
	'afpointregistration' => { 62 => 0x7 },
	'afpoints' => { 139 => 0x10 },
	'afpointselected' => { 140 => 0xd, 213 => 0x305, 260 => 0xe, 285 => 0x1c, 287 => 0x12, 288 => 0x11 },
	'afpointselected2' => { 242 => 0x4 },
	'afpointselection' => { 63 => 0xb, 206 => '1.3', 209 => '1.3' },
	'afpointselectionmethod' => { 64 => 0x50f, 65 => 0xc, 66 => 0xd, 69 => 0xd },
	'afpointsinfocus' => { 58 => 0xe, 147 => 0x2, 238 => 0xb, 260 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 16 => 0x38 },
	'afpointspotmetering' => { 63 => 0xd },
	'afpointsunknown1' => { 238 => 0x0 },
	'afpointsunknown2' => { 238 => 0x2 },
	'afpointsused' => { 148 => 0x8 },
	'afpredictor' => { 238 => 0x4 },
	'afresponse' => { 169 => 0xad },
	'afresult' => { 218 => 0x1038 },
	'afsearch' => { 213 => 0x303 },
	'afsensoractive' => { 136 => 0x1 },
	'afstatusactivesensor' => { 136 => 0x2 },
	'afstatusbottom' => { 136 => 0x8 },
	'afstatusbottom-left' => { 136 => 0x12 },
	'afstatusbottom-right' => { 136 => 0x6 },
	'afstatuscenterhorizontal' => { 136 => 0x2f },
	'afstatuscentervertical' => { 136 => 0xc },
	'afstatusleft' => { 136 => 0x2d },
	'afstatusmiddlehorizontal' => { 136 => 0xa },
	'afstatusright' => { 136 => 0x31 },
	'afstatustop' => { 136 => 0xe },
	'afstatustop-left' => { 136 => 0x10 },
	'afstatustop-right' => { 136 => 0x4 },
	'afwithshutter' => { 287 => 0x2a },
	'aggregationtype' => { 328 => 'aggregationType' },
	'agreement' => { 330 => 'agreement' },
	'aiservocontinuousshooting' => { 63 => 0x15 },
	'aiservoimagepriority' => { 64 => 0x503 },
	'aiservotrackingmethod' => { 64 => 0x504 },
	'aiservotrackingsensitivity' => { 63 => 0x14, 64 => 0x502 },
	'album' => { 337 => 'album' },
	'alreadyapplied' => { 312 => 'AlreadyApplied' },
	'alternatetitle' => { 328 => 'alternateTitle' },
	'alttapename' => { 337 => 'altTapeName' },
	'alttimecode' => { 337 => 'altTimecode' },
	'alttimecodetimeformat' => { 337 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 337 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 337 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 272 => 0x14 },
	'ambienttemperaturefahrenheit' => { 272 => 0x13 },
	'analogbalance' => { 90 => 0xc627 },
	'angleadj' => { 83 => 0x8b },
	'anti-blur' => { 298 => 0xb04b },
	'antialiasstrength' => { 90 => 0xc632 },
	'aperturerange' => { 64 => 0x10d },
	'apertureringuse' => { 242 => '1.4' },
	'aperturesetting' => { 140 => 0x7, 287 => 0x30, 288 => 0x29, 289 => 0x1 },
	'aperturevalue' => { 73 => 0x2, 90 => 0x9202, 218 => 0x1002, 316 => 'ApertureValue' },
	'applekeywords' => { 222 => 'AAPL:Keywords' },
	'applicationnotes' => { 90 => 0x2bc, 236 => 0x2bc },
	'applicationrecordversion' => { 97 => 0x0 },
	'applyshootingmeteringmode' => { 64 => 0x10e },
	'approved' => { 317 => 'Approved' },
	'approvedby' => { 317 => 'ApprovedBy' },
	'approximatefnumber' => { 228 => 0x313, 234 => 0x3406 },
	'approximatefocusdistance' => { 309 => 'ApproximateFocusDistance' },
	'armidentifier' => { 98 => 0x78 },
	'armversion' => { 98 => 0x7a },
	'artfilter' => { 213 => 0x529 },
	'artfiltereffect' => { 213 => 0x52f },
	'artist' => { 90 => 0x13b, 224 => 'Artist', 260 => 0x22e, 333 => 'Artist', 337 => 'artist' },
	'artmode' => { 87 => 0x301b },
	'artmodeparameters' => { 87 => 0x310b },
	'artworkcopyrightnotice' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 321 => 'ArtworkOrObject' },
	'artworksource' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 321 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 217 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 217 => 0x1112, 260 => 0x80, 287 => 0x55, 288 => 0x55, 289 => 0xa },
	'asshoticcprofile' => { 90 => 0xc68f },
	'asshotneutral' => { 90 => 0xc628 },
	'asshotpreprofilematrix' => { 90 => 0xc690 },
	'asshotprofilename' => { 90 => 0xc6f6 },
	'asshotwhitexy' => { 90 => 0xc629 },
	'assignbktbutton' => { 206 => '4.2' },
	'assignfuncbutton' => { 64 => 0x70b },
	'assistbuttonfunction' => { 62 => 0xd },
	'attributionname' => { 310 => 'attributionName' },
	'attributionurl' => { 310 => 'attributionURL' },
	'audio' => { 232 => 0x20 },
	'audiobitrate' => { 50 => 0x6c },
	'audiochannels' => { 50 => 0x70 },
	'audiochanneltype' => { 337 => 'audioChannelType' },
	'audiocompression' => { 117 => 'Compression' },
	'audiocompressor' => { 337 => 'audioCompressor' },
	'audioduration' => { 97 => 0x99 },
	'audiomoddate' => { 337 => 'audioModDate' },
	'audiooutcue' => { 97 => 0x9a },
	'audiosamplerate' => { 50 => 0x6e, 337 => 'audioSampleRate' },
	'audiosampletype' => { 337 => 'audioSampleType' },
	'audiosamplingrate' => { 97 => 0x97 },
	'audiosamplingresolution' => { 97 => 0x98 },
	'audiotype' => { 97 => 0x96 },
	'author' => { 119 => 'Author', 222 => 'Author', 224 => 'Author', 271 => 'Author', 308 => 'author', 325 => 'Author', 335 => 'Author' },
	'authorsposition' => { 326 => 'AuthorsPosition' },
	'autoaperture' => { 251 => '0.1' },
	'autobracket' => { 284 => 0x19 },
	'autobracketing' => { 94 => 0x1100, 260 => 0x18 },
	'autobracketmodem' => { 206 => '21.2', 209 => '26.2' },
	'autobracketorder' => { 140 => 0x43, 206 => '21.3', 209 => '26.3', 210 => '12.2', 211 => '2.2', 212 => '13.2' },
	'autobracketset' => { 206 => '21.1', 208 => '11.1', 209 => '26.1', 210 => '12.1', 211 => '2.1', 212 => '13.1' },
	'autobrightness' => { 312 => 'AutoBrightness' },
	'autocontrast' => { 312 => 'AutoContrast' },
	'autodistortioncontrol' => { 156 => 0x4 },
	'autodynamicrange' => { 94 => 0x140b },
	'autoexposure' => { 312 => 'AutoExposure' },
	'autoexposurebracketing' => { 58 => 0x10 },
	'autofocus' => { 216 => 0x209 },
	'autofp' => { 211 => '7.3', 212 => '31.4' },
	'autoiso' => { 58 => 0x1, 87 => 0x3008, 207 => '1.1', 211 => '1.1' },
	'autoisomax' => { 207 => '1.2', 211 => '1.2' },
	'autoisominshutterspeed' => { 207 => '1.3', 211 => '1.3' },
	'autolateralca' => { 312 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 13 => 0xbe, 14 => 0xbf, 17 => 0xbf, 46 => 0x2, 64 => 0x204, 83 => 0x6f },
	'autolightingoptimizeron' => { 83 => 0x6e },
	'autoredeye' => { 199 => 0xfe28a44f },
	'autorotate' => { 58 => 0x1b },
	'autoshadows' => { 312 => 'AutoShadows' },
	'auxiliarylens' => { 169 => 0x82 },
	'avaperturesetting' => { 242 => 0x13 },
	'averagelv' => { 143 => 0x38 },
	'avsettingwithoutlens' => { 64 => 0x707 },
	'azimuth' => { 127 => 'Azimuth' },
	'babyage' => { 232 => [0x8010,0x33] },
	'babyname' => { 232 => 0x66 },
	'backgroundalpha' => { 332 => 'bgalpha' },
	'baseexposurecompensation' => { 242 => 0x15 },
	'baseiso' => { 58 => 0x2, 77 => 0x101c, 234 => 0x312a },
	'baselineexposure' => { 90 => 0xc62a },
	'baselinenoise' => { 90 => 0xc62b },
	'baselinesharpness' => { 90 => 0xc62c },
	'baseurl' => { 335 => 'BaseURL' },
	'batterylevel' => { 287 => 0x51, 291 => 0xc, 292 => 0x4, 293 => 0x4 },
	'batteryorder' => { 206 => '12.5', 209 => '13.2', 210 => '2.1' },
	'batterystate' => { 140 => 0x60, 293 => 0x14 },
	'batterytemperature' => { 291 => 0x1, 293 => 0x2 },
	'batteryunknown' => { 291 => 0x2, 293 => 0x0 },
	'batteryvoltage' => { 272 => 0x2a, 291 => 0x8 },
	'batteryvoltage1' => { 293 => 0x6 },
	'batteryvoltage2' => { 293 => 0x8 },
	'bayergreensplit' => { 90 => 0xc62d },
	'bayerpattern' => { 101 => 0xf902, 144 => 0x17 },
	'beatspliceparams' => { 337 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 337 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 337 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 337 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 337 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 337 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 206 => '13.1', 207 => '0.1', 208 => '2.1', 209 => '10.1', 211 => '0.1', 212 => '4.1' },
	'beeppitch' => { 210 => '3.1' },
	'beepvolume' => { 210 => '4.5' },
	'bestqualityscale' => { 90 => 0xc65c },
	'bestshotmode' => { 87 => 0x3007 },
	'bitdepth' => { 124 => 'BitDepth', 144 => 0x11, 174 => 0x41 },
	'bitspercomponent' => { 99 => 0x87 },
	'bitspersample' => { 90 => 0x102, 333 => 'BitsPerSample' },
	'blacklevel' => { 90 => 0xc61a, 218 => 0x1012 },
	'blacklevel2' => { 217 => 0x600, 221 => 0x600 },
	'blacklevelrepeatdim' => { 90 => 0xc619 },
	'blackpoint' => { 260 => 0x200 },
	'blacks2012' => { 312 => 'Blacks2012' },
	'bleachbypasstoning' => { 260 => 0x7f },
	'bluebalance' => { 155 => 0x271, 218 => 0x1018, 236 => 0x12, 260 => 0x1b },
	'bluecurvelimits' => { 82 => 0x1fe },
	'bluecurvepoints' => { 82 => 0x1d4 },
	'bluehue' => { 312 => 'BlueHue' },
	'bluesaturation' => { 312 => 'BlueSaturation' },
	'blurcontrol' => { 260 => 0x82 },
	'blurwarning' => { 94 => 0x1300 },
	'bodybatteryadload' => { 240 => 0x3 },
	'bodybatteryadnoload' => { 240 => 0x2 },
	'bodybatterystate' => { 240 => '1.1' },
	'bodybatteryvoltage1' => { 240 => 0x2 },
	'bodybatteryvoltage2' => { 240 => 0x4 },
	'bodybatteryvoltage3' => { 240 => 0x6 },
	'bodybatteryvoltage4' => { 240 => 0x8 },
	'bodyfirmware' => { 277 => 0x0 },
	'bodyfirmwareversion' => { 214 => 0x104, 215 => 0x100, 218 => 0x104 },
	'bodyserialnumber' => { 277 => 0x10 },
	'bracketmode' => { 42 => 0x3 },
	'bracketsequence' => { 87 => 0x301d },
	'bracketshotnumber' => { 42 => 0x5, 242 => 0x9, 297 => 0x2b },
	'bracketshotnumber2' => { 297 => 0x2d },
	'bracketstep' => { 137 => 0xe },
	'bracketvalue' => { 42 => 0x4 },
	'brightness' => { 90 => 0xfe53, 118 => 'Brightness', 137 => 0x2c, 171 => 0x34, 272 => 0x25, 287 => 0x22, 298 => 0x2007, 312 => 'Brightness' },
	'brightnessadj' => { 82 => 0x114, 192 => 0x0, 202 => 0x2d, 302 => 0x8018 },
	'brightnessvalue' => { 90 => 0x9203, 143 => [0x691,0x49c3], 218 => 0x1003, 316 => 'BrightnessValue' },
	'bulbduration' => { 58 => 0x18 },
	'burstmode' => { 104 => 0xa, 232 => 0x2a },
	'burstmode2' => { 104 => 0x18 },
	'burstshot' => { 284 => 0x34 },
	'buttonfunctioncontroloff' => { 64 => 0x70a },
	'bwfilter' => { 137 => 0x2a, 145 => 0x39 },
	'bwmode' => { 218 => 0x203 },
	'by-line' => { 97 => 0x50 },
	'by-linetitle' => { 97 => 0x55 },
	'bytecount' => { 328 => 'byteCount' },
	'calibration' => { 284 => [0x24,0x30] },
	'calibrationilluminant1' => { 90 => 0xc65a },
	'calibrationilluminant2' => { 90 => 0xc65b },
	'cameraangle' => { 337 => 'cameraAngle' },
	'cameracalibration1' => { 90 => 0xc623 },
	'cameracalibration2' => { 90 => 0xc624 },
	'cameracalibrationsig' => { 90 => 0xc6f3 },
	'cameracolorcalibration01' => { 27 => 0x0, 33 => 0xba },
	'cameracolorcalibration02' => { 27 => 0x4, 33 => 0xbf },
	'cameracolorcalibration03' => { 27 => 0x8, 33 => 0xc4 },
	'cameracolorcalibration04' => { 27 => 0xc, 33 => 0xc9 },
	'cameracolorcalibration05' => { 27 => 0x10, 33 => 0xce },
	'cameracolorcalibration06' => { 27 => 0x14, 33 => 0xd3 },
	'cameracolorcalibration07' => { 27 => 0x18, 33 => 0xd8 },
	'cameracolorcalibration08' => { 27 => 0x1c, 33 => 0xdd },
	'cameracolorcalibration09' => { 27 => 0x20, 33 => 0xe2 },
	'cameracolorcalibration10' => { 27 => 0x24, 33 => 0xe7 },
	'cameracolorcalibration11' => { 27 => 0x28, 33 => 0xec },
	'cameracolorcalibration12' => { 27 => 0x2c, 33 => 0xf1 },
	'cameracolorcalibration13' => { 27 => 0x30, 33 => 0xf6 },
	'cameracolorcalibration14' => { 27 => 0x34, 33 => 0xfb },
	'cameracolorcalibration15' => { 27 => 0x38, 33 => 0x100 },
	'cameraid' => { 218 => 0x209, 283 => 0x209 },
	'cameraiso' => { 25 => 0x10 },
	'cameralabel' => { 337 => 'cameraLabel' },
	'cameramodel' => { 337 => 'cameraModel' },
	'cameramove' => { 337 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 6 => 0x7a, 8 => 0x30, 10 => 0x35, 11 => 0x30, 12 => 0x30, 13 => 0x31, 14 => 0x31, 15 => 0x35, 16 => 0x27, 17 => 0x31, 18 => 0x7d, 19 => 0x38, 20 => 0x36, 21 => 0x35, 262 => 0x1, 293 => 0x18 },
	'cameraowner' => { 105 => 0xc353 },
	'cameraparameters' => { 218 => 0x2050 },
	'cameraprofile' => { 312 => 'CameraProfile' },
	'cameraprofiledigest' => { 312 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 90 => 0xc62f, 135 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 213 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 6 => 0x1b, 8 => 0x18, 10 => 0x19, 11 => 0x18, 12 => 0x18, 13 => 0x19, 14 => 0x19, 15 => 0x19, 16 => 0x17, 17 => 0x19, 18 => 0x1b, 19 => 0x19, 20 => 0x19, 21 => 0x19, 22 => [0x87,0x91], 23 => [0x99,0x9f,0xa4,0xa8,0x105], 24 => [0x64,0x1d2,0x1f7,0x1fa,0x208,0x20c,0x47,0x53,0x5b,0x5c], 58 => 0xc, 228 => 0x320, 234 => 0x3402, 260 => 0x47, 281 => 0x43 },
	'cameratemperature2' => { 263 => 0xc },
	'cameratemperature3' => { 263 => 0xe },
	'cameratemperature4' => { 263 => 0x14 },
	'cameratemperature5' => { 263 => 0x16 },
	'cameratype' => { 58 => 0x1a, 218 => 0x207 },
	'cameratype2' => { 214 => 0x100 },
	'canonexposuremode' => { 25 => 0x14 },
	'canonfiledescription' => { 77 => 0x805 },
	'canonfilelength' => { 47 => 0xe },
	'canonfirmwareversion' => { 47 => 0x7, 77 => 0x80b },
	'canonflashinfo' => { 77 => 0x1028 },
	'canonflashmode' => { 25 => 0x4 },
	'canonimagesize' => { 7 => 0x39, 25 => 0xa },
	'canonimagetype' => { 47 => 0x6, 77 => 0x815 },
	'canonmodelid' => { 47 => 0x10, 77 => 0x1834 },
	'canonvrd' => { 91 => 'CanonVRD' },
	'caption' => { 308 => 'caption' },
	'caption-abstract' => { 97 => 0x78 },
	'captionsauthornames' => { 315 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 315 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 326 => 'CaptionWriter' },
	'captureframerate' => { 87 => 0x4001 },
	'cardshutterlock' => { 140 => 0x49 },
	'casioimagesize' => { 87 => 0x9 },
	'catalogsets' => { 97 => 0xff, 305 => 'CatalogSets', 307 => 'CatalogSets' },
	'categories' => { 47 => 0x23, 308 => 'categories' },
	'category' => { 97 => 0xf, 326 => 'Category' },
	'ccdboardversion' => { 228 => 0x331 },
	'ccdscanmode' => { 218 => 0x1039 },
	'ccdsensitivity' => { 189 => 0x6 },
	'ccdversion' => { 228 => 0x330 },
	'cellglobalid' => { 311 => 'cgi' },
	'celllength' => { 90 => 0x109 },
	'cellr' => { 311 => 'r' },
	'celltowerid' => { 311 => 'cellid' },
	'cellwidth' => { 90 => 0x108 },
	'centerafarea' => { 211 => '15.1' },
	'centerfocuspoint' => { 212 => '2.2' },
	'centerweightedareasize' => { 206 => '7.1', 209 => '5.1', 210 => '7.1', 211 => '6.3', 212 => '8.1' },
	'certificate' => { 341 => 'Certificate' },
	'cfapattern' => { 90 => 0xa302, 316 => 'CFAPattern' },
	'cfapattern2' => { 90 => 0x828e },
	'cfapatterncolumns' => { 316 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 316 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 316 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 90 => 0x828d },
	'channel' => { 328 => 'channel' },
	'channels' => { 117 => 'Channels' },
	'checkmark' => { 82 => 0x26a },
	'checkmark2' => { 83 => 0x8e },
	'childfontfiles' => { 342 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 206 => '10.3' },
	'chromablurradius' => { 90 => 0xc631 },
	'chromaticaberration' => { 83 => 0x66 },
	'chromaticaberrationb' => { 312 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 83 => 0x6b },
	'chromaticaberrationcorrection' => { 250 => 0x1 },
	'chromaticaberrationon' => { 83 => 0x62 },
	'chromaticaberrationr' => { 312 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 83 => 0x6a },
	'chrominancenoisereduction' => { 83 => 0x5e, 284 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 83 => 0x60 },
	'city' => { 97 => 0x5a, 123 => 'City', 232 => 0x6d, 326 => 'City' },
	'clarity' => { 312 => 'Clarity' },
	'clarity2012' => { 312 => 'Clarity2012' },
	'classifystate' => { 97 => 0xe1 },
	'client' => { 337 => 'client' },
	'clientname' => { 317 => 'ClientName' },
	'clmodeshootingspeed' => { 206 => '10.2', 209 => '11.2', 210 => '10.2', 212 => '11.1' },
	'cmcontrast' => { 221 => 0x2022 },
	'cmexposurecompensation' => { 221 => 0x2000 },
	'cmhue' => { 221 => 0x2021 },
	'cmsaturation' => { 221 => 0x2020 },
	'cmsharpness' => { 221 => 0x2023 },
	'cmwhitebalance' => { 221 => 0x2001 },
	'cmwhitebalancecomp' => { 221 => 0x2002 },
	'cmwhitebalancegraypoint' => { 221 => 0x2010 },
	'codec' => { 131 => 'Codec' },
	'codedcharacterset' => { 98 => 0x5a },
	'collectionname' => { 322 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 322 => 'Collections' },
	'collectionuri' => { 322 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 199 => 0xc89224b },
	'coloradjustment' => { 284 => 0x14 },
	'coloradjustmentmode' => { 283 => 0x210 },
	'coloranta' => { 342 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 342 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 342 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 342 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 342 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 342 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 342 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 342 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 342 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 342 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 342 => 'Colorants' },
	'colorantswatchname' => { 342 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 342 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 342 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 342 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 118 => 'ColorBalance' },
	'colorbalanceadj' => { 199 => 0x76a43202 },
	'colorbalanceblue' => { 137 => 0x1e },
	'colorbalancegreen' => { 137 => 0x1d },
	'colorbalancered' => { 137 => 0x1c },
	'colorblur' => { 83 => 0x65 },
	'colorbooster' => { 199 => 0x5f0e7d23 },
	'colorboostlevel' => { 193 => 0x1 },
	'colorboosttype' => { 193 => 0x0 },
	'colorclass' => { 266 => 0xde },
	'colorcompensationfilter' => { 140 => [0x3a,0x5f], 142 => 0x111, 298 => 0xb022 },
	'colorcompensationfilterset' => { 287 => 0xd, 288 => 0xc, 289 => 0x18, 299 => 0xf },
	'colorcontrol' => { 218 => 0x102b },
	'colorcorrection' => { 302 => 0x8015 },
	'colordataversion' => { 31 => 0x0, 32 => 0x0, 34 => 0x0, 35 => 0x0 },
	'coloreffect' => { 232 => 0x28 },
	'colorfilter' => { 86 => 0x17, 87 => 0x3017, 137 => 0x29, 145 => [0x38,0x4d,0x4f], 265 => 0x17 },
	'colorgain' => { 174 => 0x51 },
	'colorhue' => { 169 => 0x8d },
	'colorimetricreference' => { 90 => 0xc6bf },
	'colorlabel' => { 315 => 'ColorLabel' },
	'colormatrix' => { 217 => 0x200, 218 => 0x1011, 281 => 0xa030 },
	'colormatrix1' => { 90 => 0xc621 },
	'colormatrix2' => { 90 => 0xc622, 221 => 0x200 },
	'colormatrixa' => { 260 => 0x203 },
	'colormatrixadobergb' => { 281 => 0xa032 },
	'colormatrixb' => { 260 => 0x204 },
	'colormatrixnumber' => { 218 => 0x1019 },
	'colormatrixsrgb' => { 281 => 0xa031 },
	'colormode' => { 87 => 0x3015, 94 => 0x1210, 104 => 0x66, 137 => 0x28, 140 => 0x16, 142 => 0x101, 143 => 0x36, 145 => 0x7, 169 => 0x3, 189 => 0x4, 232 => 0x32, 284 => 0x2c, 298 => 0xb029, 326 => 'ColorMode' },
	'colormoirereduction' => { 200 => 0x15 },
	'colormoirereductionmode' => { 200 => 0x5 },
	'colornoisereduction' => { 302 => 0x8029, 312 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 312 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 200 => 0x18 },
	'colornoisereductionsharpness' => { 200 => 0x1c },
	'colorplanes' => { 93 => 0x2 },
	'colorprofile' => { 137 => 0x33 },
	'colorrepresentation' => { 99 => 0x3c },
	'colorreproduction' => { 298 => 0xb020 },
	'colorsequence' => { 99 => 0x41 },
	'colorspace' => { 36 => 0x3, 47 => 0xb4, 77 => 0x10b4, 90 => 0xa001, 124 => 'ColorSpace', 138 => 0x2f, 139 => 0x25, 140 => 0x17, 169 => 0x1e, 213 => 0x507, 260 => 0x37, 281 => 0xa011, 284 => 0xb, 287 => 0x1b, 288 => 0x83, 289 => 0xe, 299 => 0x6, 316 => 'ColorSpace' },
	'colortempasshot' => { 28 => 0x4, 29 => 0x1d, 30 => 0x26, 31 => 0x43, 34 => 0x43, 35 => 0x43 },
	'colortempauto' => { 28 => 0x9, 29 => 0x22, 30 => 0x1c, 31 => 0x48, 34 => 0x48, 35 => 0x48 },
	'colortempcloudy' => { 28 => 0x22, 29 => 0x31, 30 => 0x35, 31 => 0x5c, 34 => 0x75, 35 => 0x75 },
	'colortempcustom' => { 31 => 0x84 },
	'colortempcustom1' => { 29 => 0x45 },
	'colortempcustom2' => { 29 => 0x4a },
	'colortempdaylight' => { 28 => 0x18, 29 => 0x27, 30 => 0x2b, 31 => 0x52, 34 => 0x6b, 35 => 0x6b },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0xb9, 7 => 0x37, 8 => 0x62, 9 => 0x37, 10 => 0x7c, 11 => 0x73, 12 => 0x73, 13 => 0x77, 14 => 0x73, 15 => 0x7c, 16 => 0x58, 17 => 0x73, 18 => 0xc0, 19 => 0x7f, 20 => 0x7d, 21 => 0x7b, 47 => 0xae, 56 => 0x9, 77 => 0x10ae, 94 => 0x1005, 102 => 0x846, 118 => 'ColorTemperature', 138 => [0x6e,0x49], 139 => 0x3f, 140 => [0x39,0x5e], 142 => 0x10b, 145 => [0x3c,0x4c,0x4e], 228 => 0x321, 260 => 0x50, 298 => 0xb021, 312 => 'Temperature' },
	'colortemperatureadj' => { 302 => 0x8013 },
	'colortemperaturebg' => { 218 => 0x1013 },
	'colortemperaturerg' => { 218 => 0x1014 },
	'colortemperaturesetting' => { 140 => 0x25, 287 => 0xc, 288 => 0xb, 289 => 0x17, 299 => 0xe },
	'colortempflash' => { 28 => 0x36, 29 => 0x40, 30 => 0x49, 31 => 0x70, 34 => 0x89, 35 => 0x89 },
	'colortempflashdata' => { 31 => 0x24a },
	'colortempfluorescent' => { 28 => 0x2c, 29 => 0x3b, 30 => 0x3f, 31 => 0x66, 34 => 0x7f, 35 => 0x7f },
	'colortempkelvin' => { 28 => 0x31, 30 => 0x44, 31 => 0x6b, 34 => 0x84, 35 => 0x84, 232 => 0x44 },
	'colortempmeasured' => { 28 => 0xe, 31 => 0x4d, 34 => 0x4d, 35 => 0x4d },
	'colortemppc1' => { 30 => 0x94, 31 => 0x75 },
	'colortemppc2' => { 30 => 0x99, 31 => 0x7a },
	'colortemppc3' => { 30 => 0x9e, 31 => 0x7f },
	'colortempshade' => { 28 => 0x1d, 29 => 0x2c, 30 => 0x30, 31 => 0x57, 34 => 0x70, 35 => 0x70 },
	'colortemptungsten' => { 28 => 0x27, 29 => 0x36, 30 => 0x3a, 31 => 0x61, 34 => 0x7a, 35 => 0x7a },
	'colortempunknown' => { 28 => 0x13, 30 => 0x21, 34 => 0x52, 35 => 0x52 },
	'colortempunknown10' => { 28 => 0x63, 30 => 0x76, 34 => 0xa2, 35 => 0xa2 },
	'colortempunknown11' => { 28 => 0x68, 30 => 0x7b, 34 => 0xa7, 35 => 0xa7 },
	'colortempunknown12' => { 28 => 0x6d, 30 => 0x80, 34 => 0xac, 35 => 0xac },
	'colortempunknown13' => { 28 => 0x72, 30 => 0x85, 34 => 0xb1, 35 => 0xb1 },
	'colortempunknown14' => { 30 => 0x8a, 34 => 0xb6, 35 => 0xb6 },
	'colortempunknown15' => { 30 => 0x8f, 34 => 0xbb, 35 => 0xbb },
	'colortempunknown16' => { 30 => 0xa3, 35 => 0xc0 },
	'colortempunknown17' => { 35 => 0xc5 },
	'colortempunknown18' => { 35 => 0xca },
	'colortempunknown19' => { 35 => 0xcf },
	'colortempunknown2' => { 28 => 0x3b, 30 => 0x4e, 34 => 0x57, 35 => 0x57 },
	'colortempunknown20' => { 35 => 0xd4 },
	'colortempunknown3' => { 28 => 0x40, 30 => 0x53, 34 => 0x5c, 35 => 0x5c },
	'colortempunknown4' => { 28 => 0x45, 30 => 0x58, 34 => 0x61, 35 => 0x61 },
	'colortempunknown5' => { 28 => 0x4a, 30 => 0x5d, 34 => 0x66, 35 => 0x66 },
	'colortempunknown6' => { 28 => 0x4f, 30 => 0x62, 34 => 0x8e, 35 => 0x8e },
	'colortempunknown7' => { 28 => 0x54, 30 => 0x67, 34 => 0x93, 35 => 0x93 },
	'colortempunknown8' => { 28 => 0x59, 30 => 0x6c, 34 => 0x98, 35 => 0x98 },
	'colortempunknown9' => { 28 => 0x5e, 30 => 0x71, 34 => 0x9d, 35 => 0x9d },
	'colortone' => { 7 => 0x6f, 9 => 0x77, 25 => 0x2a, 36 => 0x2 },
	'colortoneadj' => { 82 => 0x11e },
	'colortonefaithful' => { 16 => 0x107, 52 => 0x6c, 53 => 0x6c },
	'colortonelandscape' => { 16 => 0x105, 52 => 0x3c, 53 => 0x3c },
	'colortonemonochrome' => { 52 => 0x84, 53 => 0x84 },
	'colortoneneutral' => { 16 => 0x106, 52 => 0x54, 53 => 0x54 },
	'colortoneportrait' => { 16 => 0x104, 52 => 0x24, 53 => 0x24 },
	'colortonestandard' => { 16 => 0x103, 52 => 0xc, 53 => 0xc },
	'colortoneunknown' => { 53 => 0x9c },
	'colortoneuserdef1' => { 16 => 0x109, 52 => 0x9c, 53 => 0xb4 },
	'colortoneuserdef2' => { 16 => 0x10a, 52 => 0xb4, 53 => 0xcc },
	'colortoneuserdef3' => { 16 => 0x10b, 52 => 0xcc, 53 => 0xe4 },
	'commanddials' => { 211 => '5.1' },
	'commanddialsaperturesetting' => { 206 => '17.3', 209 => '33.3', 210 => '17.3' },
	'commanddialschangemainsub' => { 206 => '17.2', 209 => '33.2', 210 => '17.2' },
	'commanddialsmenuandplayback' => { 206 => '17.4', 209 => '33.4', 210 => '17.4' },
	'commanddialsreverserotation' => { 206 => '17.1', 208 => '16.2', 209 => '33.1', 210 => '17.1', 212 => '18.1' },
	'commanderchannel' => { 211 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 211 => '13.1' },
	'commandergroupa_ttlcomp' => { 212 => '32.1' },
	'commandergroupamanualoutput' => { 211 => '13.2' },
	'commandergroupamode' => { 211 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 211 => '14.1' },
	'commandergroupb_ttlcomp' => { 212 => '33.1' },
	'commandergroupbmanualoutput' => { 211 => '14.2' },
	'commandergroupbmode' => { 211 => '11.3' },
	'commanderinternalflash' => { 211 => '11.1' },
	'commanderinternalmanualoutput' => { 211 => '12.2' },
	'commanderinternalttlchannel' => { 209 => '18.2' },
	'commanderinternalttlcomp' => { 211 => '12.1', 212 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 209 => '20.1', 210 => '26.1' },
	'commanderinternalttlcompgroupa' => { 209 => '21.1', 210 => '27.1' },
	'commanderinternalttlcompgroupb' => { 209 => '22.1', 210 => '28.1' },
	'comment' => { 0 => 0x2, 91 => 'Comment', 119 => 'Comment', 224 => 'Comment' },
	'complianceprofile' => { 328 => 'complianceProfile' },
	'componentsconfiguration' => { 90 => 0x9101, 124 => 'Components', 316 => 'ComponentsConfiguration' },
	'componentversion' => { 77 => 0x80c },
	'composer' => { 337 => 'composer' },
	'compositionadjust' => { 259 => '0.1' },
	'compositionadjustrotation' => { 259 => 0x7 },
	'compositionadjustx' => { 259 => 0x5 },
	'compositionadjusty' => { 259 => 0x6 },
	'compressedbitsperpixel' => { 90 => 0x9102, 316 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 142 => 0x40, 218 => 0x40 },
	'compression' => { 90 => 0x103, 333 => 'Compression' },
	'compressionfactor' => { 213 => 0x50d },
	'compressionratio' => { 124 => 'Compression', 218 => 0x1034 },
	'constrainedcropheight' => { 82 => 0x266, 266 => 0xd6 },
	'constrainedcropwidth' => { 82 => 0x262, 266 => 0xd5 },
	'contact' => { 97 => 0x76 },
	'contentlocationcode' => { 97 => 0x1a },
	'contentlocationname' => { 97 => 0x1b },
	'continuousbracketing' => { 140 => 0x20 },
	'continuousdrive' => { 25 => 0x5 },
	'continuousshootingspeed' => { 64 => 0x610 },
	'continuousshotlimit' => { 64 => 0x611 },
	'contrast' => { 7 => 0x73, 9 => 0x75, 25 => 0xd, 86 => 0xc, 87 => [0x3012,0x20], 90 => [0xa408,0xfe54], 94 => [0x1004,0x1006], 118 => 'Contrast', 137 => 0x20, 138 => 0x31, 139 => 0x27, 140 => 0x19, 145 => 0x2, 171 => 0x33, 218 => 0x1029, 232 => 0x39, 234 => 0x300a, 260 => 0x20, 265 => 0xc, 272 => 0x24, 284 => 0xd, 287 => 0x1d, 288 => 0x1a, 298 => 0x2004, 312 => 'Contrast', 316 => 'Contrast' },
	'contrast2012' => { 312 => 'Contrast2012' },
	'contrastadj' => { 82 => 0x115, 202 => 0x2c, 302 => 0x8017 },
	'contrastcurve' => { 169 => 0x8c },
	'contrastdetectaf' => { 148 => 0x4 },
	'contrastdetectafarea' => { 260 => 0x231 },
	'contrastdetectafinfocus' => { 148 => 0x1c },
	'contrastfaithful' => { 16 => 0xec, 52 => 0x60, 53 => 0x60 },
	'contrasthighlight' => { 260 => 0x6d },
	'contrasthighlightshadowadj' => { 260 => 0x6f },
	'contrastlandscape' => { 16 => 0xea, 52 => 0x30, 53 => 0x30 },
	'contrastmode' => { 232 => 0x2c },
	'contrastmonochrome' => { 16 => 0xed, 52 => 0x78, 53 => 0x78 },
	'contrastneutral' => { 16 => 0xeb, 52 => 0x48, 53 => 0x48 },
	'contrastportrait' => { 16 => 0xe9, 52 => 0x18, 53 => 0x18 },
	'contrastsetting' => { 213 => 0x505, 221 => 0x1012, 289 => 0x10, 299 => 0x8 },
	'contrastshadow' => { 260 => 0x6e },
	'contraststandard' => { 16 => 0xe8, 52 => 0x0, 53 => 0x0 },
	'contrastunknown' => { 53 => 0x90 },
	'contrastuserdef1' => { 16 => 0xee, 52 => 0x90, 53 => 0xa8 },
	'contrastuserdef2' => { 16 => 0xef, 52 => 0xa8, 53 => 0xc0 },
	'contrastuserdef3' => { 16 => 0xf0, 52 => 0xc0, 53 => 0xd8 },
	'contributedmedia' => { 337 => 'contributedMedia' },
	'contributedmediaduration' => { 337 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 337 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 337 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 337 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 337 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 337 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 337 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 337 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 337 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 337 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 313 => 'contributor' },
	'contributors' => { 119 => 'Contributors' },
	'controldialset' => { 140 => 0x46 },
	'controlledvocabularyterm' => { 321 => 'CVterm' },
	'controllerboardversion' => { 228 => 0x332 },
	'controlmode' => { 58 => 0x12 },
	'conversionlens' => { 232 => 0x35 },
	'converter' => { 90 => 0xfe4d, 189 => 0xb, 312 => 'Converter' },
	'converttograyscale' => { 312 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 90 => 0x8298, 119 => 'Copyright', 224 => 'Copyright', 260 => 0x22f, 271 => 'Copyright', 325 => 'Copyright', 328 => 'copyright', 330 => 'copyright', 333 => 'Copyright', 337 => 'copyright' },
	'copyrightflag' => { 269 => 0x40a },
	'copyrightnotice' => { 97 => 0x74 },
	'copyrightowner' => { 327 => 'CopyrightOwner' },
	'copyrightownerid' => { 327 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 327 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 327 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 327 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 327 => 'CopyrightStatus' },
	'coringfilter' => { 217 => 0x310, 218 => 0x102d, 221 => 0x310 },
	'coringvalues' => { 217 => 0x311, 221 => 0x311 },
	'corporateentity' => { 328 => 'corporateEntity' },
	'country' => { 123 => 'Country', 232 => 0x69, 326 => 'Country' },
	'country-primarylocationcode' => { 97 => 0x64 },
	'country-primarylocationname' => { 97 => 0x65 },
	'countrycode' => { 168 => 0x5, 267 => 'CountryCode', 320 => 'CountryCode' },
	'coverage' => { 313 => 'coverage' },
	'coverdate' => { 328 => 'coverDate' },
	'coverdisplaydate' => { 328 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 260 => 0x28 },
	'crc32' => { 314 => 'crc32' },
	'createdate' => { 90 => 0x9004, 119 => 'CreateDate', 222 => 'CreationDate', 224 => 'create-date', 271 => 'CreationDate', 335 => 'CreateDate' },
	'creationdate' => { 325 => 'CreationDate', 328 => 'creationDate' },
	'creationtime' => { 224 => 'Creation Time' },
	'creativestyle' => { 287 => 0x1a, 288 => 0x18, 297 => 0x41 },
	'creativestylesetting' => { 289 => 0xf, 299 => 0x7 },
	'creativestylewaschanged' => { 302 => 0x8001 },
	'creator' => { 222 => 'Creator', 271 => 'Creator', 313 => 'creator', 325 => 'Creator' },
	'creatoraddress' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 320 => 'CreatorContactInfo' },
	'creatorcountry' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 335 => 'CreatorTool' },
	'creatorworkemail' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 320 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 97 => 0x6e, 326 => 'Credit' },
	'creditline' => { 330 => 'creditLine' },
	'creditlinereq' => { 340 => 'CreditLineReq' },
	'creditlinerequired' => { 327 => 'CreditLineRequired' },
	'cropactive' => { 82 => 0x244 },
	'cropangle' => { 312 => 'CropAngle' },
	'cropaspectratio' => { 82 => 0x260 },
	'cropbottom' => { 93 => 0x9, 194 => 0x36, 266 => 0xdc, 312 => 'CropBottom' },
	'cropbottommargin' => { 38 => 0x3 },
	'cropcircleactive' => { 83 => 0xd6 },
	'cropcircleradius' => { 83 => 0xd9 },
	'cropcirclex' => { 83 => 0xd7 },
	'cropcircley' => { 83 => 0xd8 },
	'cropconstraintowarp' => { 312 => 'CropConstrainToWarp' },
	'cropheight' => { 82 => 0x24c, 217 => 0x615, 221 => 0x615, 312 => 'CropHeight' },
	'crophispeed' => { 169 => 0x1b },
	'cropleft' => { 82 => 0x246, 93 => 0x6, 194 => 0x1e, 217 => 0x612, 221 => 0x612, 266 => 0xd9, 312 => 'CropLeft' },
	'cropleftmargin' => { 38 => 0x0 },
	'cropoutputheight' => { 194 => 0xce },
	'cropoutputheightinches' => { 194 => 0x96 },
	'cropoutputpixels' => { 194 => 0xd6 },
	'cropoutputresolution' => { 194 => 0xb6 },
	'cropoutputscale' => { 194 => 0xbe },
	'cropoutputwidth' => { 194 => 0xc6 },
	'cropoutputwidthinches' => { 194 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimageleft' => { 3 => 0x3 },
	'croppedimagetop' => { 3 => 0x4 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 93 => 0x8, 194 => 0x2e, 266 => 0xdb, 312 => 'CropRight' },
	'croprightmargin' => { 38 => 0x1 },
	'croprotation' => { 93 => 0xb },
	'cropscaledresolution' => { 194 => 0x9e },
	'cropsourceresolution' => { 194 => 0xae },
	'croptop' => { 82 => 0x248, 93 => 0x7, 194 => 0x26, 217 => 0x613, 221 => 0x613, 266 => 0xda, 312 => 'CropTop' },
	'croptopmargin' => { 38 => 0x2 },
	'cropunit' => { 312 => 'CropUnit' },
	'cropunits' => { 312 => 'CropUnits' },
	'cropwidth' => { 82 => 0x24a, 217 => 0x614, 221 => 0x614, 312 => 'CropWidth' },
	'crossprocess' => { 260 => 0x7b },
	'crossprocessparams' => { 260 => 0x235 },
	'currenticcprofile' => { 90 => 0xc691 },
	'currentpreprofilematrix' => { 90 => 0xc692 },
	'currentversion' => { 302 => 0xd000 },
	'curves' => { 199 => 0x76a43201 },
	'custom1' => { 327 => 'Custom1' },
	'custom10' => { 327 => 'Custom10' },
	'custom2' => { 327 => 'Custom2' },
	'custom3' => { 327 => 'Custom3' },
	'custom4' => { 327 => 'Custom4' },
	'custom5' => { 327 => 'Custom5' },
	'custom6' => { 327 => 'Custom6' },
	'custom7' => { 327 => 'Custom7' },
	'custom8' => { 327 => 'Custom8' },
	'custom9' => { 327 => 'Custom9' },
	'customcontrast' => { 83 => 0x4e },
	'customcontrols' => { 64 => 0x70c },
	'customdefaultunsharpfineness' => { 83 => 0xbe },
	'customdefaultunsharpstrength' => { 83 => 0xbc },
	'customdefaultunsharpthreshold' => { 83 => 0xc0 },
	'customlinear' => { 83 => 0x4f },
	'customoutputhighlightpoint' => { 83 => 0x53 },
	'customoutputshadowpoint' => { 83 => 0x54 },
	'custompicturestylefilename' => { 47 => 0x4010 },
	'customrawhighlight' => { 83 => 0x7c },
	'customrawhighlightpoint' => { 83 => 0x51 },
	'customrawshadow' => { 83 => 0x85 },
	'customrawshadowpoint' => { 83 => 0x52 },
	'customrendered' => { 90 => 0xa401, 316 => 'CustomRendered' },
	'customsaturation' => { 213 => 0x503 },
	'customsettingsalldefault' => { 206 => '0.2', 209 => '0.2' },
	'customsettingsbank' => { 206 => '0.1', 209 => '0.1' },
	'customsharpness' => { 83 => 0x50 },
	'customunsharpmaskfineness' => { 83 => 0xb8 },
	'customunsharpmaskstrength' => { 83 => 0xb6 },
	'customunsharpmaskthreshold' => { 83 => 0xba },
	'customwb_rblevels' => { 299 => 0x1a },
	'customwb_rgblevels' => { 289 => 0x19 },
	'customwbbluelevel' => { 140 => 0x36 },
	'customwberror' => { 140 => 0x37 },
	'customwbgreenlevel' => { 140 => 0x35 },
	'customwbredlevel' => { 140 => 0x34 },
	'customwbsetting' => { 140 => 0x26 },
	'd-lightinghq' => { 199 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 195 => 0x2 },
	'd-lightinghqhighlight' => { 195 => 0x1 },
	'd-lightinghqselected' => { 199 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 195 => 0x0 },
	'd-lightinghs' => { 199 => 0xce5554aa },
	'd-lightinghsadjustment' => { 196 => 0x0 },
	'd-lightinghscolorboost' => { 196 => 0x1 },
	'd-rangeoptimizerhighlight' => { 302 => 0x8024 },
	'd-rangeoptimizermode' => { 302 => 0x8022 },
	'd-rangeoptimizershadow' => { 302 => 0x802d },
	'd-rangeoptimizervalue' => { 302 => 0x8023 },
	'datacompressionmethod' => { 99 => 0x6e },
	'dataimprint' => { 137 => 0x34 },
	'date' => { 260 => 0x6, 313 => 'date' },
	'dateacquired' => { 135 => 'DateAcquired' },
	'datecreated' => { 97 => 0x37, 326 => 'DateCreated' },
	'datedisplayformat' => { 191 => 0x3 },
	'dateimprint' => { 208 => '4.2' },
	'daterecieved' => { 328 => 'dateRecieved' },
	'datesent' => { 98 => 0x46 },
	'datestampmode' => { 47 => 0x1c },
	'datetime' => { 308 => 'datetime', 333 => 'DateTime' },
	'datetimedigitized' => { 316 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 80 => 0x0, 90 => 0x9003, 116 => 0x14, 119 => 'OriginalDate', 272 => 0xb, 316 => 'DateTimeOriginal' },
	'datetimestamp' => { 104 => 0x64 },
	'daylightsavings' => { 59 => 0x3, 191 => 0x2 },
	'declination' => { 127 => 'Declination' },
	'decposition' => { 137 => 0x32 },
	'defaultcroporigin' => { 90 => 0xc61f },
	'defaultcropsize' => { 90 => 0xc620 },
	'defaulteraseoption' => { 64 => 0x813 },
	'defaultscale' => { 90 => 0xc61e },
	'defringe' => { 312 => 'Defringe' },
	'deletedimagecount' => { 169 => 0xa6, 175 => 0x6e },
	'deprecatedon' => { 310 => 'deprecatedOn' },
	'derivedfrom' => { 338 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 338 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 338 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 338 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 338 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 338 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 338 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 338 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 338 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 338 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 338 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 338 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 338 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 338 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 338 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 338 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 338 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 338 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 224 => 'Description', 313 => 'description', 335 => 'Description' },
	'destination' => { 98 => 0x5 },
	'destinationcity' => { 260 => 0x24, 264 => 0x3 },
	'destinationcitycode' => { 265 => 0x1001 },
	'destinationdst' => { 260 => 0x26, 264 => '0.3' },
	'developmentdynamicrange' => { 94 => 0x1403 },
	'devicesettingdescription' => { 316 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 316 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 316 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 316 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 64 => 0x706 },
	'digitalcreationdate' => { 97 => 0x3e },
	'digitalcreationtime' => { 97 => 0x3f },
	'digitaldeehighlightadj' => { 174 => 0x202 },
	'digitaldeeshadowadj' => { 174 => 0x200 },
	'digitaldeethreshold' => { 174 => 0x201 },
	'digitalfilter01' => { 248 => 0x5 },
	'digitalfilter02' => { 248 => 0x16 },
	'digitalfilter03' => { 248 => 0x27 },
	'digitalfilter04' => { 248 => 0x38 },
	'digitalfilter05' => { 248 => 0x49 },
	'digitalfilter06' => { 248 => 0x5a },
	'digitalfilter07' => { 248 => 0x6b },
	'digitalfilter08' => { 248 => 0x7c },
	'digitalfilter09' => { 248 => 0x8d },
	'digitalfilter10' => { 248 => 0x9e },
	'digitalfilter11' => { 248 => 0xaf },
	'digitalfilter12' => { 248 => 0xc0 },
	'digitalfilter13' => { 248 => 0xd1 },
	'digitalfilter14' => { 248 => 0xe2 },
	'digitalfilter15' => { 248 => 0xf3 },
	'digitalfilter16' => { 248 => 0x104 },
	'digitalfilter17' => { 248 => 0x115 },
	'digitalfilter18' => { 248 => 0x126 },
	'digitalfilter19' => { 248 => 0x137 },
	'digitalfilter20' => { 248 => 0x148 },
	'digitalgain' => { 56 => 0xb },
	'digitalgem' => { 162 => 0x0 },
	'digitalice' => { 174 => 0x100 },
	'digitalimageguid' => { 321 => 'DigImageGUID' },
	'digitalroc' => { 173 => 0x0 },
	'digitalsourcefiletype' => { 321 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 321 => 'DigitalSourceType' },
	'digitalzoom' => { 25 => 0xc, 86 => 0xa, 104 => 0x68, 118 => 'DigitalZoom', 137 => 0xc, 169 => 0x86, 189 => 0xa, 218 => 0x204, 260 => 0x1e, 265 => 0xa, 283 => 0x204 },
	'digitalzoomon' => { 283 => 0x21b },
	'digitalzoomratio' => { 90 => 0xa404, 316 => 'DigitalZoomRatio' },
	'director' => { 337 => 'director' },
	'directorphotography' => { 337 => 'directorPhotography' },
	'directory' => { 91 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 6 => 0x2d5, 8 => 0x17e, 10 => 0x238, 11 => 0x13f, 12 => 0x133, 13 => 0x1df, 14 => 0x1a7, 15 => 0x1f0, 16 => 0xcc, 17 => 0x1c7, 18 => 0x298, 19 => 0x1e7, 20 => 0x1e5, 21 => 0x1f7 },
	'directoryindex2' => { 18 => 0x29c },
	'directorynumber' => { 158 => 0x6 },
	'disclaimer' => { 224 => 'Disclaimer' },
	'displayallafpoints' => { 64 => 0x514 },
	'displayaperture' => { 25 => 0x23 },
	'displayedunitsx' => { 270 => 0x2 },
	'displayedunitsy' => { 270 => 0x6 },
	'distance1' => { 104 => 0x28 },
	'distance2' => { 104 => 0x2c },
	'distance3' => { 104 => 0x30 },
	'distance4' => { 104 => 0x34 },
	'distortioncontrol' => { 175 => 0x10 },
	'distortioncorrection' => { 83 => 0x67, 213 => 0x50b, 235 => '7.1', 250 => 0x0, 298 => 0x2013 },
	'distortioncorrection2' => { 217 => 0x1011 },
	'distortioncorrectionon' => { 83 => 0x63 },
	'distortionn' => { 235 => 0xc },
	'distortionparama' => { 235 => 0x8 },
	'distortionparamb' => { 235 => 0x4 },
	'distortionparamc' => { 235 => 0xb },
	'distortionscale' => { 235 => 0x5 },
	'distributor' => { 328 => 'distributor' },
	'dloon' => { 83 => 0xdc },
	'dlosetting' => { 83 => 0xdd },
	'dlosettingapplied' => { 83 => 0xe4 },
	'dloshootingdistance' => { 83 => 0xde },
	'dloversion' => { 83 => 0xe5 },
	'dmcomment' => { 337 => 'comment' },
	'dngbackwardversion' => { 90 => 0xc613 },
	'dnglensinfo' => { 90 => 0xc630 },
	'dngversion' => { 90 => 0xc612 },
	'document' => { 224 => 'Document' },
	'documentancestorid' => { 326 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 326 => 'DocumentAncestors' },
	'documenthistory' => { 97 => 0xe7 },
	'documentid' => { 338 => 'DocumentID' },
	'documentname' => { 90 => 0x10d },
	'documentnotes' => { 97 => 0xe6 },
	'doi' => { 328 => 'doi' },
	'dotrange' => { 90 => 0x150 },
	'dpp' => { 308 => 'dpp' },
	'drivemode' => { 87 => 0x3103, 137 => 0x6, 140 => 0x1e, 143 => 0xe, 213 => 0x600, 260 => 0x34, 284 => 0x3, 287 => 0x4, 288 => 0x7e, 289 => 0x34 },
	'drivemode2' => { 140 => 0xa, 242 => 0x7, 297 => 0xe, 299 => 0x1 },
	'drivemodesetting' => { 289 => 0x4 },
	'dspfirmwareversion' => { 260 => 0x27 },
	'duration' => { 50 => 0x6a, 117 => 'Duration', 131 => 'Duration', 337 => 'duration' },
	'durationscale' => { 337 => [\'duration','durationScale'] },
	'durationvalue' => { 337 => [\'duration','durationValue'] },
	'dustremovaldata' => { 47 => 0x97 },
	'dynamicafarea' => { 206 => '1.4', 209 => '1.4' },
	'dynamicrange' => { 94 => 0x1400 },
	'dynamicrangeexpansion' => { 260 => 0x69 },
	'dynamicrangemax' => { 82 => 0x7c },
	'dynamicrangemin' => { 82 => 0x7a },
	'dynamicrangeoptimizer' => { 140 => 0x15, 298 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerbracket' => { 297 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 287 => 0x19, 288 => 0x17, 289 => 0xd, 299 => 0x5 },
	'dynamicrangeoptimizermode' => { 143 => 0x15, 287 => 0x18, 288 => 0x16, 297 => 0x15 },
	'dynamicrangeoptimizersetting' => { 140 => 0x27, 289 => 0xc, 299 => 0x4 },
	'dynamicrangesetting' => { 94 => 0x1402 },
	'e-dialinprogram' => { 242 => '1.3' },
	'easyexposurecomp' => { 212 => '6.1' },
	'easyexposurecompensation' => { 206 => '6.4', 209 => '4.4', 210 => '5.2' },
	'easymode' => { 25 => 0xb },
	'edgenoisereduction' => { 200 => 0x4, 302 => 0x8028 },
	'edition' => { 328 => 'edition' },
	'editorialupdate' => { 97 => 0x8 },
	'editstatus' => { 97 => 0x7, 267 => 'EditStatus' },
	'editversionname' => { 199 => 0x3d136244 },
	'effectivelv' => { 260 => 0x2d },
	'effectivemaxaperture' => { 165 => 0x12, 166 => 0x13 },
	'eissn' => { 328 => 'eIssn' },
	'elevation' => { 127 => 'Elevation' },
	'email' => { 119 => 'EMail' },
	'embargodate' => { 328 => 'embargoDate', 330 => 'embargoDate' },
	'encryptionkey' => { 281 => 0xa020 },
	'endingpage' => { 328 => 'endingPage' },
	'enduser' => { 327 => 'EndUser' },
	'enduserid' => { 327 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 327 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 337 => 'engineer' },
	'enhancedarktones' => { 192 => 0x8 },
	'enhancement' => { 86 => 0x16, 87 => 0x3016 },
	'enhancer' => { 217 => 0x300 },
	'enhancervalues' => { 217 => 0x301 },
	'envelopenumber' => { 98 => 0x28 },
	'envelopepriority' => { 98 => 0x3c },
	'enveloperecordversion' => { 98 => 0x0 },
	'epsonimageheight' => { 218 => 0x20c },
	'epsonimagewidth' => { 218 => 0x20b },
	'epsonsoftware' => { 218 => 0x20d },
	'equipmentinstitution' => { 304 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 304 => 'EquipmentManufacturer' },
	'equipmentversion' => { 214 => 0x0 },
	'ettlii' => { 64 => 0x304, 65 => 0xd, 66 => 0xe, 67 => 0x7, 68 => 0x7, 69 => 0xe },
	'event' => { 307 => 'Event', 321 => 'Event', 328 => 'event' },
	'eventnumber' => { 272 => 0x9 },
	'evsteps' => { 242 => '1.2', 244 => 0x0 },
	'evstepsize' => { 208 => '5.1', 211 => '0.7' },
	'exclusivityenddate' => { 330 => 'exclusivityEndDate' },
	'excursiontolerance' => { 99 => 0x82 },
	'exif' => { 91 => 'EXIF' },
	'exifbyteorder' => { 91 => 'ExifByteOrder' },
	'exifcamerainfo' => { 97 => 0xe8 },
	'exifimageheight' => { 90 => 0xa003, 316 => 'PixelYDimension' },
	'exifimagewidth' => { 90 => 0xa002, 316 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 91 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 90 => 0x9000, 316 => 'ExifVersion' },
	'exitpupilposition' => { 165 => 0x4, 166 => 0x4 },
	'expirationdate' => { 97 => 0x25, 328 => 'expirationDate', 330 => 'expirationDate' },
	'expirationtime' => { 97 => 0x26 },
	'exposure' => { 90 => 0xfe51, 312 => 'Exposure' },
	'exposure2012' => { 312 => 'Exposure2012' },
	'exposureadj' => { 197 => 0x0 },
	'exposureadj2' => { 197 => 0x12 },
	'exposureadjust' => { 284 => 0xc },
	'exposurebracketingindicatorlast' => { 140 => 0x52 },
	'exposurebracketshotnumber' => { 143 => 0x2d, 297 => 0x2f },
	'exposurebracketstepsize' => { 242 => 0x8 },
	'exposurebracketvalue' => { 169 => 0x19 },
	'exposurecompensation' => { 58 => 0x6, 73 => 0x0, 90 => 0x9204, 104 => 0x24, 118 => 'ExposureComp', 137 => 0xd, 138 => 0x53, 139 => 0x1e, 143 => 0x49c0, 218 => 0x1006, 260 => 0x16, 281 => 0xa013, 284 => [0xc,0x35,0x4d], 316 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 140 => 0x47, 143 => 0x2a },
	'exposurecompensationset' => { 289 => 0x3, 299 => 0x1e },
	'exposurecompensationsetting' => { 140 => 0x1 },
	'exposurecompstepsize' => { 206 => '6.3', 209 => '4.3' },
	'exposurecontrolstep' => { 210 => '6.1' },
	'exposurecontrolstepsize' => { 206 => '6.2', 209 => '4.2', 212 => '7.1' },
	'exposuredelaymode' => { 206 => '10.1', 208 => '9.1', 209 => '10.4', 210 => '10.1', 211 => '6.4', 212 => '11.2' },
	'exposuredifference' => { 169 => 0xe },
	'exposureindex' => { 90 => 0xa215, 316 => 'ExposureIndex' },
	'exposureindicator' => { 140 => 0x50 },
	'exposurelevelincrements' => { 62 => 0x6, 63 => 0x6, 64 => 0x101, 65 => 0x5, 66 => 0x6, 67 => 0x5, 68 => 0x5, 69 => 0x6, 70 => 0x4, 287 => 0x58, 288 => 0x58 },
	'exposuremode' => { 90 => 0xa402, 118 => 'ExposureMode', 137 => 0x1, 138 => 0xa, 139 => 0x0, 140 => 0x0, 143 => 0x34, 213 => 0x200, 230 => 0x40d, 284 => 0x8, 298 => 0xb041, 316 => 'ExposureMode' },
	'exposuremodeinmanual' => { 64 => 0x10b },
	'exposureprogram' => { 90 => 0x8822, 287 => 0x3c, 288 => 0x3c, 289 => 0x5, 293 => 0x14, 297 => 0x3f, 299 => 0x2, 316 => 'ExposureProgram' },
	'exposureshift' => { 213 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x6, 23 => 0x7, 58 => 0x16, 90 => 0x829a, 101 => 0xfd05, 104 => 0x20, 106 => 0xfa24, 108 => 0xf104, 111 => 0x12, 113 => 0x38, 116 => 0x10, 118 => 'ExposureTime', 137 => 0x9, 138 => 0x35, 139 => 0x48, 140 => 0x8, 143 => 0x49b8, 260 => 0x12, 281 => 0xa018, 284 => [0x32,0x4a], 287 => 0x0, 288 => 0x0, 299 => 0x27, 316 => 'ExposureTime' },
	'exposuretime2' => { 284 => [0x33,0x4b] },
	'exposuretuning' => { 169 => 0x1c },
	'exposurevalue' => { 102 => 0x3 },
	'exposurewarning' => { 94 => 0x1302 },
	'exrauto' => { 94 => 0x1033 },
	'exrmode' => { 94 => 0x1034 },
	'extendedwbdetect' => { 213 => 0x902 },
	'extender' => { 214 => 0x301 },
	'extenderfirmwareversion' => { 214 => 0x304 },
	'extendermagnification' => { 120 => 'Magnification' },
	'extendermake' => { 120 => 'Make' },
	'extendermodel' => { 120 => 'Model', 214 => 0x303 },
	'extenderserialnumber' => { 120 => 'SerialNumber', 214 => 0x302 },
	'externalflash' => { 216 => 0x1201 },
	'externalflashae1' => { 218 => 0x101f },
	'externalflashae1_0' => { 218 => 0x101b },
	'externalflashae2' => { 218 => 0x1020 },
	'externalflashae2_0' => { 218 => 0x101c },
	'externalflashbounce' => { 216 => 0x1204, 218 => 0x1026, 249 => 0x1a },
	'externalflashexposurecomp' => { 169 => 0x17, 249 => 0x19 },
	'externalflashfirmware' => { 159 => 0x6, 160 => 0x6, 161 => 0x6 },
	'externalflashflags' => { 159 => 0x8, 160 => 0x8, 161 => 0x8 },
	'externalflashguidenumber' => { 216 => 0x1203, 249 => '24.1' },
	'externalflashgvalue' => { 218 => 0x1025 },
	'externalflashmode' => { 218 => 0x1028, 249 => 0x2 },
	'externalflashzoom' => { 216 => 0x1205, 218 => 0x1027 },
	'externalsensorbrightnessvalue' => { 228 => 0x311, 234 => 0x3408 },
	'extrainfoversion' => { 291 => 0x1a },
	'eyestartaf' => { 140 => 0x40 },
	'face10position' => { 84 => 0x3f4, 85 => 0x1ec, 157 => 0x28, 246 => 0x12 },
	'face10size' => { 247 => 0x12 },
	'face11position' => { 157 => 0x2c, 246 => 0x14 },
	'face11size' => { 247 => 0x14 },
	'face12position' => { 157 => 0x30, 246 => 0x16 },
	'face12size' => { 247 => 0x16 },
	'face13position' => { 246 => 0x18 },
	'face13size' => { 247 => 0x18 },
	'face14position' => { 246 => 0x1a },
	'face14size' => { 247 => 0x1a },
	'face15position' => { 246 => 0x1c },
	'face15size' => { 247 => 0x1c },
	'face16position' => { 246 => 0x1e },
	'face16size' => { 247 => 0x1e },
	'face17position' => { 246 => 0x20 },
	'face17size' => { 247 => 0x20 },
	'face18position' => { 246 => 0x22 },
	'face18size' => { 247 => 0x22 },
	'face19position' => { 246 => 0x24 },
	'face19size' => { 247 => 0x24 },
	'face1position' => { 39 => 0x8, 84 => 0xd, 85 => 0x18, 157 => 0x4, 226 => 0x1, 246 => 0x0, 273 => 0xbc, 294 => 0x1, 295 => 0x0, 296 => 0x0 },
	'face1size' => { 247 => 0x0 },
	'face20position' => { 246 => 0x26 },
	'face20size' => { 247 => 0x26 },
	'face21position' => { 246 => 0x28 },
	'face21size' => { 247 => 0x28 },
	'face22position' => { 246 => 0x2a },
	'face22size' => { 247 => 0x2a },
	'face23position' => { 246 => 0x2c },
	'face23size' => { 247 => 0x2c },
	'face24position' => { 246 => 0x2e },
	'face24size' => { 247 => 0x2e },
	'face25position' => { 246 => 0x30 },
	'face25size' => { 247 => 0x30 },
	'face26position' => { 246 => 0x32 },
	'face26size' => { 247 => 0x32 },
	'face27position' => { 246 => 0x34 },
	'face27size' => { 247 => 0x34 },
	'face28position' => { 246 => 0x36 },
	'face28size' => { 247 => 0x36 },
	'face29position' => { 246 => 0x38 },
	'face29size' => { 247 => 0x38 },
	'face2position' => { 39 => 0xa, 84 => 0x7c, 85 => 0x4c, 157 => 0x8, 226 => 0x5, 246 => 0x2, 273 => 0xc8, 294 => 0x6, 295 => 0x20, 296 => 0x25 },
	'face2size' => { 247 => 0x2 },
	'face30position' => { 246 => 0x3a },
	'face30size' => { 247 => 0x3a },
	'face31position' => { 246 => 0x3c },
	'face31size' => { 247 => 0x3c },
	'face32position' => { 246 => 0x3e },
	'face32size' => { 247 => 0x3e },
	'face3position' => { 39 => 0xc, 84 => 0xeb, 85 => 0x80, 157 => 0xc, 226 => 0x9, 246 => 0x4, 273 => 0xd4, 294 => 0xb, 295 => 0x40, 296 => 0x4a },
	'face3size' => { 247 => 0x4 },
	'face4position' => { 39 => 0xe, 84 => 0x15a, 85 => 0xb4, 157 => 0x10, 226 => 0xd, 246 => 0x6, 273 => 0xe0, 294 => 0x10, 295 => 0x60, 296 => 0x6f },
	'face4size' => { 247 => 0x6 },
	'face5position' => { 39 => 0x10, 84 => 0x1c9, 85 => 0xe8, 157 => 0x14, 226 => 0x11, 246 => 0x8, 273 => 0xec, 294 => 0x15, 295 => 0x80, 296 => 0x94 },
	'face5size' => { 247 => 0x8 },
	'face6position' => { 39 => 0x12, 84 => 0x238, 85 => 0x11c, 157 => 0x18, 246 => 0xa, 273 => 0xf8, 294 => 0x1a, 295 => 0xa0, 296 => 0xb9 },
	'face6size' => { 247 => 0xa },
	'face7position' => { 39 => 0x14, 84 => 0x2a7, 85 => 0x150, 157 => 0x1c, 246 => 0xc, 273 => 0x104, 294 => 0x1f, 295 => 0xc0, 296 => 0xde },
	'face7size' => { 247 => 0xc },
	'face8position' => { 39 => 0x16, 84 => 0x316, 85 => 0x184, 157 => 0x20, 246 => 0xe, 273 => 0x110, 294 => 0x24, 295 => 0xe0, 296 => 0x103 },
	'face8size' => { 247 => 0xe },
	'face9position' => { 39 => 0x18, 84 => 0x385, 85 => 0x1b8, 157 => 0x24, 246 => 0x10 },
	'face9size' => { 247 => 0x10 },
	'facedetect' => { 260 => 0x76 },
	'facedetectarea' => { 217 => 0x1201 },
	'facedetectframecrop' => { 217 => 0x1207 },
	'facedetectframesize' => { 39 => 0x3, 84 => 0x1, 85 => 0x4, 157 => 0x1, 217 => 0x1203, 260 => 0x77, 273 => 0xb6 },
	'facedetection' => { 289 => 0x30, 299 => 0x19 },
	'faceinfounknown' => { 87 => 0x2089 },
	'faceorientation' => { 85 => 0x8 },
	'faceposition' => { 245 => 0x2, 282 => 0x4 },
	'facepositions' => { 94 => 0x4103 },
	'facesdetected' => { 39 => 0x2, 40 => 0x2, 41 => 0x3, 84 => 0x0, 85 => 0x2, 87 => 0x211c, 94 => 0x4100, 157 => 0x3, 217 => 0x1200, 232 => 0x3f, 245 => 0x0, 273 => 0xb5, 282 => 0x0, 294 => 0x0, 301 => 0x30 },
	'facesrecognized' => { 227 => 0x0 },
	'facewidth' => { 40 => 0x1 },
	'faithfuloutputhighlightpoint' => { 83 => 0x38 },
	'faithfuloutputshadowpoint' => { 83 => 0x39 },
	'faithfulrawcolortone' => { 83 => 0x31 },
	'faithfulrawcontrast' => { 83 => 0x33 },
	'faithfulrawhighlight' => { 83 => 0x79 },
	'faithfulrawhighlightpoint' => { 83 => 0x36 },
	'faithfulrawlinear' => { 83 => 0x34 },
	'faithfulrawsaturation' => { 83 => 0x32 },
	'faithfulrawshadow' => { 83 => 0x82 },
	'faithfulrawshadowpoint' => { 83 => 0x37 },
	'faithfulrawsharpness' => { 83 => 0x35 },
	'faithfulunsharpmaskfineness' => { 83 => 0xac },
	'faithfulunsharpmaskstrength' => { 83 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 83 => 0xae },
	'femicroadjustment' => { 64 => 0x110 },
	'ffid' => { 314 => 'ffid' },
	'fieldcount' => { 218 => 0x103f },
	'filedatarate' => { 337 => 'fileDataRate' },
	'fileformat' => { 75 => 0x0, 98 => 0x14, 284 => [0x22,0x26], 298 => 0xb000 },
	'fileindex' => { 4 => 0x143, 6 => 0x2c9, 8 => 0x172, 10 => 0x22c, 11 => 0x133, 12 => 0x13f, 13 => 0x1d3, 14 => 0x19b, 15 => 0x1e4, 16 => 0xd0, 17 => 0x1bb, 18 => 0x28c, 19 => 0x1db, 20 => 0x1d9, 21 => 0x1eb, 233 => 0x0 },
	'fileindex2' => { 18 => 0x290 },
	'filemodifydate' => { 91 => 'FileModifyDate' },
	'filename' => { 91 => 'FileName' },
	'filenameasdelivered' => { 327 => 'FileNameAsDelivered' },
	'filenumber' => { 42 => 0x1, 47 => 0x8, 77 => 0x1817, 88 => 'FileNumber', 158 => 0x8 },
	'filenumbermemory' => { 137 => 0x1a },
	'filenumbersequence' => { 206 => '12.2', 208 => '3.1', 209 => '11.1', 210 => '4.3', 212 => '5.2' },
	'filesource' => { 90 => 0xa300, 94 => 0x8000, 316 => 'FileSource' },
	'fileversion' => { 98 => 0x16 },
	'fillflashautoreduction' => { 62 => 0xe, 63 => 0xe, 70 => 0xa },
	'filllight' => { 312 => 'FillLight' },
	'fillorder' => { 90 => 0x10a },
	'filmmode' => { 94 => 0x1401, 230 => 0x412, 232 => 0x42 },
	'filmtype' => { 174 => 0x2 },
	'filtereffect' => { 42 => 0xe, 171 => 0x37 },
	'filtereffectfaithful' => { 52 => 0x70, 53 => 0x70 },
	'filtereffectlandscape' => { 52 => 0x40, 53 => 0x40 },
	'filtereffectmonochrome' => { 16 => 0xff, 52 => 0x88, 53 => 0x88 },
	'filtereffectneutral' => { 52 => 0x58, 53 => 0x58 },
	'filtereffectportrait' => { 52 => 0x28, 53 => 0x28 },
	'filtereffectstandard' => { 52 => 0x10, 53 => 0x10 },
	'filtereffectunknown' => { 53 => 0xa0 },
	'filtereffectuserdef1' => { 52 => 0xa0, 53 => 0xb8 },
	'filtereffectuserdef2' => { 52 => 0xb8, 53 => 0xd0 },
	'filtereffectuserdef3' => { 52 => 0xd0, 53 => 0xe8 },
	'finderdisplayduringexposure' => { 63 => 0x1 },
	'finesharpness' => { 260 => 0x70 },
	'finetuneoptcenterweighted' => { 206 => '7.2', 212 => '9.1' },
	'finetuneoptmatrixmetering' => { 206 => '8.1', 209 => '6.1', 212 => '8.2' },
	'finetuneoptspotmetering' => { 206 => '8.2', 209 => '6.2', 212 => '9.2' },
	'firmware' => { 218 => 0x405, 284 => [0x17,0x3b,0x57], 309 => 'Firmware' },
	'firmwaredate' => { 86 => 0x15, 87 => 0x2001, 272 => 0x4 },
	'firmwareid' => { 144 => 0x0 },
	'firmwarename' => { 281 => 0xa001 },
	'firmwarerevision' => { 16 => 0xa4, 47 => 0x1e, 274 => 0x0 },
	'firmwarerevision2' => { 274 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 8 => 0x136, 11 => 0xff, 12 => 0x107, 102 => 0xce5, 116 => 0x57, 118 => 'FirmwareVersion', 232 => 0x2, 234 => 0x3109, 260 => 0x230, 276 => 0x2 },
	'firstpublicationdate' => { 327 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 97 => 0x16 },
	'flash' => { 88 => 'Flash', 90 => 0x9209, 138 => 0x1f, 139 => 0x15, 316 => 'Flash' },
	'flashaction' => { 289 => [0x87,0x287] },
	'flashactivity' => { 25 => 0x1c },
	'flashbatterylevel' => { 31 => 0x249 },
	'flashbias' => { 232 => 0x24 },
	'flashbits' => { 25 => 0x1d },
	'flashbuttonfunction' => { 64 => 0x70e },
	'flashchargelevel' => { 218 => 0x1010 },
	'flashcolorfilter' => { 161 => 0x10 },
	'flashcommandermode' => { 159 => '9.1', 160 => '9.1', 161 => '9.1' },
	'flashcompensation' => { 159 => 0xa, 160 => 0xa, 161 => 0xa, 309 => 'FlashCompensation' },
	'flashcontrol' => { 289 => 0x21 },
	'flashcontrolbuilt-in' => { 209 => '16.1', 210 => '23.1' },
	'flashcontrolmode' => { 159 => '9.2', 160 => '9.2', 161 => '9.2', 213 => 0x404 },
	'flashdefault' => { 140 => 0x42 },
	'flashdevice' => { 218 => 0x1005 },
	'flashdistance' => { 87 => 0x2034 },
	'flashenergy' => { 90 => 0xa20b, 316 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 169 => 0x18 },
	'flashexposurecomp' => { 58 => 0xf, 94 => 0x1011, 121 => 'ExposureComp', 137 => 0x23, 142 => 0x104, 143 => 0x49c1, 169 => 0x12, 213 => 0x401, 218 => 0x1023, 260 => 0x4d, 284 => [0x3a,0x56], 298 => 0x104 },
	'flashexposurecompset' => { 140 => 0x10, 237 => 0xe, 289 => 0x23, 299 => 0x1f },
	'flashexposureindicator' => { 140 => 0x54 },
	'flashexposureindicatorlast' => { 140 => 0x56 },
	'flashexposureindicatornext' => { 140 => 0x55 },
	'flashexposurelock' => { 42 => 0x19 },
	'flashfired' => { 104 => 0x5d, 121 => 'Fired', 137 => 0x14, 187 => '590.3', 232 => 0x8007, 316 => [\'Flash','FlashFired'] },
	'flashfiring' => { 64 => 0x306, 65 => 0x6, 66 => 0x7, 69 => 0x7 },
	'flashfirmwareversion' => { 214 => 0x1002 },
	'flashfocallength' => { 159 => 0xb, 160 => 0xc, 161 => 0xc },
	'flashfunction' => { 143 => 0x31, 316 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 159 => 0xe, 160 => 0xf, 161 => 0xf },
	'flashgroupacompensation' => { 159 => 0x11, 160 => 0x12, 161 => 0x13 },
	'flashgroupacontrolmode' => { 159 => 0xf, 160 => '16.1', 161 => '17.1' },
	'flashgroupaoutput' => { 159 => 0x11, 160 => 0x12, 161 => 0x13 },
	'flashgroupbcompensation' => { 159 => 0x12, 160 => 0x13, 161 => 0x14 },
	'flashgroupbcontrolmode' => { 159 => 0x10, 160 => '17.1', 161 => '18.1' },
	'flashgroupboutput' => { 159 => 0x12, 160 => 0x13, 161 => 0x14 },
	'flashgroupccompensation' => { 160 => 0x14, 161 => 0x15 },
	'flashgroupccontrolmode' => { 160 => '17.2', 161 => '18.2' },
	'flashgroupcoutput' => { 160 => 0x14, 161 => 0x15 },
	'flashguidenumber' => { 58 => 0xd, 74 => 0x0, 121 => 'GuideNumber' },
	'flashintensity' => { 86 => [0x19,0x5], 213 => 0x405 },
	'flashlevel' => { 207 => 0x9, 298 => 0xb048 },
	'flashmake' => { 121 => 'Make' },
	'flashmanufacturer' => { 135 => 'FlashManufacturer' },
	'flashmetering' => { 137 => 0x3f, 140 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15 },
	'flashmeteringsegments' => { 260 => 0x20a },
	'flashmode' => { 86 => 0x4, 104 => 0x5c, 121 => 'Mode', 137 => 0x2, 138 => 0x20, 139 => 0x16, 140 => 0xf, 169 => 0x87, 213 => 0x400, 218 => 0x1004, 260 => 0xc, 265 => 0x4, 275 => 0x20, 283 => 0x225, 287 => 0x23, 288 => 0x1f, 289 => 0x20, 299 => 0x10, 316 => [\'Flash','FlashMode'] },
	'flashmodel' => { 121 => 'Model', 135 => 'FlashModel', 214 => 0x1001 },
	'flashoptions' => { 242 => 0x2 },
	'flashoptions2' => { 242 => 0x10 },
	'flashoutput' => { 31 => 0x248, 58 => 0x21, 159 => 0xa, 160 => 0xa, 161 => 0xa },
	'flashpixversion' => { 90 => 0xa000, 316 => 'FlashpixVersion' },
	'flashredeyemode' => { 316 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 213 => 0x403 },
	'flashreturn' => { 316 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 121 => 'SerialNumber', 214 => 0x1003 },
	'flashsetting' => { 169 => 0x8 },
	'flashshutterspeed' => { 206 => '20.2', 209 => '15.2', 210 => '22.2', 211 => '7.2', 212 => '23.1' },
	'flashsource' => { 159 => 0x4, 160 => 0x4, 161 => 0x4 },
	'flashstatus' => { 249 => 0x0 },
	'flashsyncspeed' => { 206 => '20.1', 209 => '15.1', 210 => '22.1' },
	'flashsyncspeedav' => { 62 => 0x3, 64 => 0x10f, 65 => 0x2, 66 => 0x3, 67 => 0x2, 68 => 0x2, 69 => 0x3, 70 => 0x6 },
	'flashthreshold' => { 74 => 0x1 },
	'flashtype' => { 121 => 'Type', 140 => 0x59, 169 => 0x9, 214 => 0x1000 },
	'flashwarning' => { 210 => '30.1', 211 => '7.1', 212 => '31.1', 232 => 0x62 },
	'flickerreduce' => { 283 => 0x218 },
	'fliphorizontal' => { 199 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 6 => 0x3, 8 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x5, 23 => 0x6, 58 => 0x15, 90 => 0x829d, 101 => 0xfd04, 104 => 0x1e, 106 => 0xfa23, 108 => 0xf103, 111 => 0x13, 113 => 0x3c, 116 => 0xc, 125 => 'FNumber', 137 => 0xa, 138 => 0x36, 139 => 0x47, 140 => 0x9, 143 => 0x49c7, 260 => 0x13, 281 => 0xa019, 284 => [0x31,0x49], 287 => 0x1, 288 => 0x1, 299 => 0x26, 316 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x20, 7 => 0x9, 8 => 0x1d, 9 => 0x9, 10 => 0x1e, 11 => 0x1d, 12 => 0x1d, 13 => 0x1e, 14 => 0x1e, 15 => 0x1e, 16 => 0x28, 17 => 0x1e, 18 => 0x23, 19 => 0x1e, 20 => 0x1e, 21 => 0x1e, 44 => 0x1, 87 => 0x1d, 90 => 0x920a, 111 => 0x1d, 125 => 'FocalLength', 137 => 0x12, 165 => 0xa, 166 => 0xb, 251 => 0x9, 260 => 0x1d, 285 => 0xe, 316 => 'FocalLength' },
	'focallengthin35mmformat' => { 90 => 0xa405, 281 => 0xa01a, 316 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 285 => 0x10 },
	'focalplanediagonal' => { 214 => 0x103, 218 => 0x205 },
	'focalplaneresolutionunit' => { 90 => 0xa210, 316 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 90 => 0xa20e, 316 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 44 => 0x2 },
	'focalplanexunknown' => { 44 => 0x2 },
	'focalplaneyresolution' => { 90 => 0xa20f, 316 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 44 => 0x3 },
	'focalplaneyunknown' => { 44 => 0x3 },
	'focaltype' => { 7 => 0x2d, 44 => 0x0 },
	'focalunits' => { 25 => 0x19 },
	'focus' => { 189 => 0x8 },
	'focusarea' => { 137 => 0x31 },
	'focusareaselection' => { 211 => '15.2' },
	'focuscontinuous' => { 25 => 0x20 },
	'focusdisplayaiservoandmf' => { 64 => 0x515 },
	'focusdistance' => { 125 => 'FocusDistance', 137 => 0x13, 143 => 0x49bb, 165 => 0x9, 166 => 0xa, 216 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 6 => 0x8b, 8 => 0x45, 10 => 0x56, 11 => 0x45, 12 => 0x45, 13 => 0x52, 14 => 0x52, 15 => 0x56, 17 => 0x52, 18 => 0x8e, 19 => 0x59, 20 => 0x57, 21 => 0x56, 58 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 6 => 0x89, 8 => 0x43, 10 => 0x54, 11 => 0x43, 12 => 0x43, 13 => 0x50, 14 => 0x50, 15 => 0x54, 17 => 0x50, 18 => 0x8c, 19 => 0x57, 20 => 0x55, 21 => 0x54, 58 => 0x13 },
	'focusholdbutton' => { 140 => 0x44 },
	'focusinfoversion' => { 216 => 0x0 },
	'focusingscreen' => { 63 => 0x0, 64 => 0x80b, 69 => 0x0 },
	'focuslocked' => { 136 => 0x14 },
	'focusmode' => { 25 => 0x7, 86 => 0x3, 87 => [0x3003,0xd], 94 => 0x1021, 104 => 0x38, 118 => 'FocusMode', 137 => 0x30, 139 => 0xe, 140 => 0xc, 169 => 0x7, 213 => 0x301, 218 => 0x100b, 232 => 0x7, 260 => 0xd, 265 => 0x3, 285 => 0x1d, 287 => 0x4d, 288 => 0x4d, 298 => [0xb042,0xb04e], 299 => 0x13 },
	'focusmode2' => { 242 => '3.1' },
	'focusmodesetting' => { 207 => '10.1', 287 => 0x10, 288 => 0xf, 289 => 0x6 },
	'focusmodeswitch' => { 140 => 0x58, 287 => 0x2e },
	'focuspixel' => { 94 => 0x1023 },
	'focuspointwrap' => { 206 => '2.2', 209 => '2.2', 210 => '1.2', 212 => '2.5' },
	'focusposition' => { 165 => 0x8, 166 => 0x8, 260 => 0x10, 297 => 0x9bb },
	'focusprocess' => { 213 => 0x302 },
	'focusrange' => { 25 => 0x12, 218 => 0x100a },
	'focussetting' => { 284 => 0x6 },
	'focusstatus' => { 285 => 0x19, 287 => 0x53, 288 => 0x53 },
	'focusstepcount' => { 216 => 0x301, 218 => 0x100e },
	'focusstepinfinity' => { 216 => 0x303, 218 => 0x103b },
	'focusstepnear' => { 216 => 0x304, 218 => 0x103c },
	'focustrackinglockon' => { 206 => ['1.5','4.1'], 209 => '3.1', 210 => '0.4' },
	'focuswarning' => { 94 => 0x1301 },
	'foldername' => { 137 => 0x27 },
	'fontcomposite' => { 342 => [\'Fonts','FontsComposite'] },
	'fontface' => { 342 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 342 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 342 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 342 => [\'Fonts','FontsFontName'] },
	'fonts' => { 342 => 'Fonts' },
	'fonttype' => { 342 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 342 => [\'Fonts','FontsVersionString'] },
	'for' => { 271 => 'For' },
	'format' => { 313 => 'format', 335 => 'Format' },
	'forwardlock' => { 332 => 'forwardlock' },
	'forwardmatrix1' => { 90 => 0xc714 },
	'forwardmatrix2' => { 90 => 0xc715 },
	'framecount' => { 50 => [0x2,0x4] },
	'framenum' => { 266 => 0xd7 },
	'framenumber' => { 94 => 0x8003, 143 => 0x3c, 260 => 0x29 },
	'framerate' => { 50 => [0x1,0x6] },
	'freebytes' => { 77 => 0x1 },
	'freememorycardimages' => { 138 => [0x37,0x54], 139 => [0x2d,0x4a], 140 => 0x32 },
	'fujiflashmode' => { 94 => 0x1010 },
	'fullimagesize' => { 298 => 0xb02b },
	'fullsizeimage' => { 124 => 'data' },
	'fullsizeimagename' => { 124 => '1Name' },
	'fullsizeimagetype' => { 124 => '0Type' },
	'funcbutton' => { 206 => ['14.1','15.1'], 209 => '28.1', 210 => '13.1', 212 => '14.1' },
	'funcbuttonplusdials' => { 206 => ['14.2','15.2'], 209 => '31.1' },
	'functionbutton' => { 211 => '5.2' },
	'gainbase' => { 217 => 0x610 },
	'gaincontrol' => { 90 => 0xa407, 316 => 'GainControl' },
	'gamma' => { 90 => 0xa500 },
	'gammacompensatedvalue' => { 99 => 0x91 },
	'geimagesize' => { 94 => 0x1304 },
	'gemake' => { 95 => 0x300 },
	'gemodel' => { 95 => 0x207 },
	'genre' => { 328 => 'genre', 337 => 'genre' },
	'geography' => { 329 => 'geography' },
	'geosync' => { 91 => 'Geosync' },
	'geotag' => { 91 => 'Geotag' },
	'geotime' => { 91 => 'Geotime' },
	'globalaltitude' => { 269 => 0x419 },
	'globalangle' => { 269 => 0x40d },
	'good' => { 337 => 'good' },
	'gpsaltitude' => { 96 => 0x6, 122 => 'Altitude', 316 => 'GPSAltitude' },
	'gpsaltituderef' => { 96 => 0x5, 316 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 96 => 0x1c, 316 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 96 => 0x1d },
	'gpsdatetime' => { 122 => 'DateTime', 316 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 96 => 0x18, 122 => 'Bearing', 316 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 96 => 0x17, 316 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 96 => 0x1a, 122 => 'Distance', 316 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 96 => 0x19, 316 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 96 => 0x14, 316 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 96 => 0x13 },
	'gpsdestlongitude' => { 96 => 0x16, 316 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 96 => 0x15 },
	'gpsdifferential' => { 96 => 0x1e, 122 => 'Differential', 316 => 'GPSDifferential' },
	'gpsdop' => { 96 => 0xb, 316 => 'GPSDOP' },
	'gpshpositioningerror' => { 96 => 0x1f },
	'gpsimgdirection' => { 96 => 0x11, 316 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 96 => 0x10, 316 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 96 => 0x2, 122 => 'Latitude', 316 => 'GPSLatitude' },
	'gpslatituderef' => { 96 => 0x1 },
	'gpslongitude' => { 96 => 0x4, 122 => 'Longitude', 316 => 'GPSLongitude' },
	'gpslongituderef' => { 96 => 0x3 },
	'gpsmapdatum' => { 96 => 0x12, 122 => 'Datum', 316 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 96 => 0xa, 122 => 'MeasureMode', 316 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 96 => 0x1b, 316 => 'GPSProcessingMethod' },
	'gpssatellites' => { 96 => 0x8, 122 => 'Satellites', 316 => 'GPSSatellites' },
	'gpsspeed' => { 96 => 0xd, 122 => 'Speed', 316 => 'GPSSpeed' },
	'gpsspeedref' => { 96 => 0xc, 316 => 'GPSSpeedRef' },
	'gpsstatus' => { 96 => 0x9, 316 => 'GPSStatus' },
	'gpstimestamp' => { 96 => 0x7 },
	'gpstrack' => { 96 => 0xf, 122 => 'Heading', 316 => 'GPSTrack' },
	'gpstrackref' => { 96 => 0xe, 316 => 'GPSTrackRef' },
	'gpsversionid' => { 96 => 0x0, 316 => 'GPSVersionID' },
	'gradation' => { 213 => 0x50f },
	'gradientbasedcorractive' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrcontrast' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrections' => { 312 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrhue' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrmaskcenterweight' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrsaturation' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrsharpness' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrwhat' => { 312 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 312 => 'GrainAmount' },
	'grainfrequency' => { 312 => 'GrainFrequency' },
	'grainsize' => { 312 => 'GrainSize' },
	'graymixeraqua' => { 312 => 'GrayMixerAqua' },
	'graymixerblue' => { 312 => 'GrayMixerBlue' },
	'graymixergreen' => { 312 => 'GrayMixerGreen' },
	'graymixermagenta' => { 312 => 'GrayMixerMagenta' },
	'graymixerorange' => { 312 => 'GrayMixerOrange' },
	'graymixerpurple' => { 312 => 'GrayMixerPurple' },
	'graymixerred' => { 312 => 'GrayMixerRed' },
	'graymixeryellow' => { 312 => 'GrayMixerYellow' },
	'graypoint' => { 302 => 0x8021 },
	'grayresponseunit' => { 90 => 0x122 },
	'greencurvelimits' => { 82 => 0x1c4 },
	'greencurvepoints' => { 82 => 0x19a },
	'greenhue' => { 312 => 'GreenHue' },
	'greensaturation' => { 312 => 'GreenSaturation' },
	'griddisplay' => { 206 => '13.3', 208 => '2.2', 209 => '10.5', 210 => '3.4', 211 => '6.1', 212 => '4.2' },
	'gripbatteryadload' => { 240 => 0x5 },
	'gripbatteryadnoload' => { 240 => 0x4 },
	'gripbatterystate' => { 240 => '1.2' },
	'halftonehints' => { 90 => 0x141 },
	'hasalternative' => { 328 => 'hasAlternative' },
	'hascorrection' => { 328 => 'hasCorrection' },
	'hascrop' => { 312 => 'HasCrop' },
	'hasextendedxmp' => { 339 => 'HasExtendedXMP' },
	'haspreviousversion' => { 328 => 'hasPreviousVersion' },
	'hassettings' => { 312 => 'HasSettings' },
	'hastranslation' => { 328 => 'hasTranslation' },
	'hdr' => { 298 => 0x200a },
	'hdrlevel' => { 289 => 0x2e, 299 => 0x17 },
	'hdrsetting' => { 289 => 0x2d, 299 => 0x16 },
	'headline' => { 97 => 0x69, 326 => 'Headline' },
	'hierarchicalkeywords' => { 323 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 323 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 323 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 323 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 323 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 323 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 323 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 306 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 13 => 0xbc, 14 => 0xbd, 17 => 0xbd, 21 => 0xc9, 64 => 0x202, 94 => 0x100e, 169 => 0xb1, 260 => 0x71, 287 => 0x2c, 288 => 0x26, 289 => 0x26, 298 => 0x2009, 299 => 0x12 },
	'highlight' => { 284 => 0xf },
	'highlightcolordistortreduct' => { 302 => 0x8026 },
	'highlightprotection' => { 198 => 0x6 },
	'highlightrecovery' => { 312 => 'HighlightRecovery' },
	'highlights2012' => { 312 => 'Highlights2012' },
	'highlighttonepriority' => { 10 => 0x7, 13 => 0x7, 14 => 0x7, 15 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 64 => 0x203 },
	'highlowkeyadj' => { 260 => 0x6c },
	'highspeedsync' => { 140 => 0x5 },
	'histogramxml' => { 199 => 0x83a1a25 },
	'history' => { 326 => 'History', 338 => 'History' },
	'historyaction' => { 338 => [\'History','HistoryAction'] },
	'historychanged' => { 338 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 338 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 338 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 338 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 338 => [\'History','HistoryWhen'] },
	'hometowncity' => { 87 => 0x3006, 260 => 0x23, 264 => 0x2 },
	'hometowncitycode' => { 265 => 0x1000 },
	'hometowndst' => { 260 => 0x25, 264 => '0.2' },
	'hostcomputer' => { 90 => 0x13c },
	'hue' => { 145 => 0x3b, 260 => 0x67 },
	'hueadj' => { 202 => 0x2f, 302 => 0x8019 },
	'hueadjustment' => { 138 => 0x4a, 139 => 0x40, 169 => 0x92, 171 => 0x36 },
	'hueadjustmentaqua' => { 312 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 312 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 312 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 312 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 312 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 312 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 312 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 312 => 'HueAdjustmentYellow' },
	'huesetting' => { 221 => 0x1011 },
	'icc_profile' => { 91 => 'ICC_Profile' },
	'iccprofilename' => { 326 => 'ICCProfile' },
	'idccreativestyle' => { 302 => 0x8000 },
	'idcpreviewlength' => { 302 => 0x202 },
	'idcpreviewstart' => { 302 => 0x201 },
	'identifier' => { 313 => 'identifier', 335 => 'Identifier' },
	'illumination' => { 211 => '0.5' },
	'imageadjustment' => { 169 => 0x80, 189 => 0x5 },
	'imagealterationconstraints' => { 327 => 'ImageAlterationConstraints' },
	'imagearea' => { 179 => 0x10, 182 => 0x10 },
	'imageareaoffset' => { 260 => 0x38 },
	'imageauthentication' => { 169 => 0x20 },
	'imageboundary' => { 169 => 0x16 },
	'imagecount' => { 169 => 0xa5 },
	'imagecreator' => { 327 => 'ImageCreator' },
	'imagecreatorid' => { 327 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 327 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 327 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 169 => 0xa2 },
	'imagedescription' => { 90 => 0x10e, 333 => 'ImageDescription' },
	'imageduplicationconstraints' => { 327 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 199 => 0xfe443a45 },
	'imageeditcount' => { 260 => 0x41 },
	'imageediting' => { 260 => 0x32 },
	'imagefileconstraints' => { 327 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 327 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 327 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 90 => 0x101, 144 => 0xc, 333 => 'ImageLength' },
	'imagehistory' => { 90 => 0x9213 },
	'imageidnumber' => { 228 => 0x340 },
	'imagenumber' => { 90 => 0x9211, 118 => 'ImageNumber', 138 => 0xae, 139 => 0x5e, 287 => 0x9b, 289 => [0x400,0x114,0x314], 309 => 'ImageNumber' },
	'imagenumber2' => { 139 => 0x62 },
	'imageoptimization' => { 169 => 0xa9 },
	'imageorientation' => { 97 => 0x83 },
	'imageprocessing' => { 169 => 0x1a },
	'imageprocessingversion' => { 217 => 0x0 },
	'imagequality' => { 118 => 'ImageQuality', 181 => '723.2', 182 => '732.2', 187 => '708.1', 232 => 0x1 },
	'imagequality2' => { 213 => 0x603 },
	'imageref' => { 319 => 'ImageRef' },
	'imagereview' => { 207 => '0.4', 211 => '0.4' },
	'imagereviewtime' => { 207 => '2.1', 208 => '19.1', 209 => '9.2', 210 => '20.1', 212 => '21.2' },
	'imagesize' => { 124 => 'ImageSize' },
	'imagesizerestriction' => { 330 => 'imageSizeRestriction' },
	'imagesourcedata' => { 90 => 0x935c },
	'imagestabilization' => { 25 => 0x22, 87 => 0x3020, 118 => 'ImageStabilization', 138 => 0xbd, 139 => 0x71, 140 => 0x57, 141 => 0x0, 142 => [0x18,0x107,0x113], 143 => 0x49c2, 169 => 0xac, 213 => 0x604, 216 => 0x1600, 232 => 0x1a, 292 => 0x12, 293 => 0x11, 298 => 0xb026 },
	'imagestabilization2' => { 291 => 0xa },
	'imagestabilizationsetting' => { 143 => 0x14, 287 => 0x3d, 288 => 0x3d, 297 => 0x14 },
	'imagestyle' => { 287 => 0x2d, 288 => 0x27 },
	'imagesupplier' => { 327 => 'ImageSupplier' },
	'imagesupplierid' => { 327 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 327 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 327 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 260 => 0x4f },
	'imagetype' => { 97 => 0x82, 327 => 'ImageType' },
	'imageuniqueid' => { 47 => 0x28, 90 => 0xa420, 316 => 'ImageUniqueID' },
	'imagewidth' => { 90 => 0x100, 144 => 0xe, 333 => 'ImageWidth' },
	'incrementaltemperature' => { 312 => 'IncrementalTemperature' },
	'incrementaltint' => { 312 => 'IncrementalTint' },
	'industry' => { 328 => 'industry', 329 => 'industry' },
	'infobuttonwhenshooting' => { 64 => 0x409 },
	'infraredilluminator' => { 272 => 0x28 },
	'ingredients' => { 338 => 'Ingredients' },
	'ingredientsalternatepaths' => { 338 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 338 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 338 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 338 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 338 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 338 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 338 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 338 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 338 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 338 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 338 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 338 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 338 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 338 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 338 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 338 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 338 => [\'Ingredients','IngredientsVersionID'] },
	'initialzoomliveview' => { 206 => '4.4' },
	'initialzoomsetting' => { 206 => '9.3', 209 => '27.3' },
	'inkset' => { 90 => 0x14c },
	'instanceid' => { 338 => 'InstanceID' },
	'instantplaybacksetup' => { 140 => 0x3e },
	'instantplaybacktime' => { 140 => 0x3d },
	'instructions' => { 326 => 'Instructions' },
	'instrument' => { 337 => 'instrument' },
	'intellectualgenre' => { 320 => 'IntellectualGenre' },
	'intelligentauto' => { 298 => 0xb052 },
	'intelligentcontrast' => { 37 => 0x4 },
	'intelligentd-range' => { 232 => 0x79 },
	'intelligentexposure' => { 232 => 0x5d },
	'intelligentresolution' => { 232 => 0x70 },
	'interchangecolorspace' => { 99 => 0x40 },
	'internalflash' => { 137 => 0x2b, 206 => '23.1', 207 => '8.1', 208 => '22.1', 211 => '8.1', 212 => '24.1', 216 => 0x1208 },
	'internalflashae1' => { 218 => 0x1021 },
	'internalflashae1_0' => { 218 => 0x101d },
	'internalflashae2' => { 218 => 0x1022 },
	'internalflashae2_0' => { 218 => 0x101e },
	'internalflashmode' => { 249 => 0x1 },
	'internalflashstrength' => { 249 => 0x3 },
	'internalflashtable' => { 218 => 0x1024 },
	'internalserialnumber' => { 47 => 0x96, 57 => 0x9, 94 => 0x10, 143 => 0x49dc, 214 => 0x102, 232 => 0x25, 241 => 0x4, 276 => 0x5 },
	'interopindex' => { 90 => 0x1 },
	'interopversion' => { 90 => 0x2 },
	'intervallength' => { 137 => 0x10 },
	'intervalmode' => { 137 => 0x26 },
	'intervalnumber' => { 137 => 0x11 },
	'introtime' => { 337 => 'introTime' },
	'introtimescale' => { 337 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 337 => [\'introTime','introTimeValue'] },
	'iptc' => { 91 => 'IPTC' },
	'iptc-naa' => { 90 => 0x83bb, 236 => 0x83bb },
	'iptcbitspersample' => { 99 => 0x56 },
	'iptcdigest' => { 269 => 0x425 },
	'iptcimageheight' => { 99 => 0x1e },
	'iptcimagerotation' => { 99 => 0x66 },
	'iptcimagewidth' => { 99 => 0x14 },
	'iptclastedited' => { 321 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 99 => 0xa },
	'iptcpixelheight' => { 99 => 0x32 },
	'iptcpixelwidth' => { 99 => 0x28 },
	'isbn' => { 328 => 'isbn' },
	'iscorrectionof' => { 328 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 83 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x6, 7 => 0x75, 8 => 0x6, 9 => 0x79, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x0, 23 => 0x1, 86 => 0x14, 87 => [0x3014,0x14], 90 => 0x8827, 101 => 0xfd06, 102 => 0x1784, 104 => 0x60, 106 => [0xfa2e,0xfa46], 107 => [0x27,0x28], 108 => 0xf105, 111 => 0x14, 113 => 0x4e, 116 => 0x34, 118 => 'ISO', 137 => 0x8, 143 => 0x49ba, 163 => 0x0, 169 => 0x2, 236 => 0x17, 260 => [0x8b,0x14], 265 => 0x14, 281 => 0xa014, 316 => 'ISOSpeedRatings' },
	'iso2' => { 163 => 0x6, 176 => 0x265, 177 => 0x25c, 178 => 0x265, 179 => 0x221, 180 => 0x25d, 181 => 0x256, 182 => 0x25d, 184 => 0x2b5, 185 => 0x265, 188 => 0x2b5 },
	'isoauto' => { 242 => '14.4' },
	'isoautoparameters' => { 260 => 0x7a },
	'isodisplay' => { 208 => '2.3', 210 => '3.3', 212 => '4.3' },
	'isoexpansion' => { 64 => 0x103, 65 => 0x7, 66 => 0x8, 69 => 0x8, 163 => 0x4 },
	'isoexpansion2' => { 163 => 0xa },
	'isofloor' => { 242 => 0x6 },
	'isoselection' => { 169 => 0xf },
	'isosensitivitystep' => { 210 => '6.2' },
	'isosetting' => { 104 => 0x5e, 118 => 'ISOSetting', 137 => 0x24, 138 => 0x26, 139 => 0x1c, 140 => 0x13, 145 => 0x6, 169 => 0x13, 242 => '17.3', 275 => 0x27, 287 => 0x16, 288 => 0x14, 289 => 0x2 },
	'isospeed' => { 90 => 0x8833 },
	'isospeedexpansion' => { 63 => 0x3 },
	'isospeedincrements' => { 64 => 0x102 },
	'isospeedlatitudeyyy' => { 90 => 0x8834 },
	'isospeedlatitudezzz' => { 90 => 0x8835 },
	'isospeedrange' => { 64 => 0x103 },
	'isostepsize' => { 206 => '6.1', 209 => '4.1' },
	'isovalue' => { 218 => 0x1001 },
	'issn' => { 328 => 'issn' },
	'issueidentifier' => { 328 => 'issueIdentifier' },
	'issuename' => { 328 => 'issueName' },
	'istranslationof' => { 328 => 'isTranslationOf' },
	'jobid' => { 97 => 0xb8 },
	'jobname' => { 317 => 'JobName' },
	'jobref' => { 336 => 'JobRef' },
	'jobrefid' => { 336 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 336 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 336 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 317 => 'JobStatus' },
	'jpegquality' => { 7 => 0x66, 234 => 0x3034 },
	'jpegsize' => { 234 => 0x303a },
	'jpgfromraw' => { 77 => 0x2007, 88 => 'JpgFromRaw', 236 => 0x2e },
	'jpgfromrawlength' => { 90 => [0x117,0x202] },
	'jpgfromrawstart' => { 90 => [0x111,0x201] },
	'jpgrecordedpixels' => { 242 => '14.1' },
	'jurisdiction' => { 310 => 'jurisdiction' },
	'key' => { 337 => 'key' },
	'keyword' => { 328 => 'keyword' },
	'keywordinfo' => { 323 => 'Keywords' },
	'keywords' => { 97 => 0x19, 119 => 'Keywords', 222 => 'Keywords', 271 => 'Keywords', 308 => 'keywords', 325 => 'Keywords', 335 => 'Keywords' },
	'killdate' => { 328 => 'killDate' },
	'kodakimageheight' => { 101 => 0xf908, 104 => 0xe, 106 => [0xfa1e,0xfa52], 112 => 0x70 },
	'kodakimagewidth' => { 101 => 0xf907, 104 => 0xc, 106 => [0xfa1d,0xfa51], 112 => 0x6c },
	'kodakinfotype' => { 101 => 0xfa00 },
	'kodakmaker' => { 112 => 0x8 },
	'kodakmodel' => { 104 => 0x0, 112 => 0x28 },
	'label' => { 224 => 'Label', 335 => 'Label' },
	'labelname1' => { 319 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 319 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 232 => 0x6f },
	'landscapeoutputhighlightpoint' => { 83 => 0x26 },
	'landscapeoutputshadowpoint' => { 83 => 0x27 },
	'landscaperawcolortone' => { 83 => 0x1f },
	'landscaperawcontrast' => { 83 => 0x21 },
	'landscaperawhighlight' => { 83 => 0x77 },
	'landscaperawhighlightpoint' => { 83 => 0x24 },
	'landscaperawlinear' => { 83 => 0x22 },
	'landscaperawsaturation' => { 83 => 0x20 },
	'landscaperawshadow' => { 83 => 0x80 },
	'landscaperawshadowpoint' => { 83 => 0x25 },
	'landscaperawsharpness' => { 83 => 0x23 },
	'landscapeunsharpmaskfineness' => { 83 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 83 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 83 => 0xa2 },
	'language' => { 313 => 'language' },
	'languageidentifier' => { 97 => 0x87 },
	'lastfilenumber' => { 137 => 0x1b },
	'lastkeywordiptc' => { 135 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 135 => 'LastKeywordXMP' },
	'lasturl' => { 338 => 'LastURL' },
	'lateralchromaticaberration' => { 298 => 0x2012 },
	'lc1' => { 251 => 0x2 },
	'lc10' => { 251 => 0xb },
	'lc11' => { 251 => 0xc },
	'lc12' => { 251 => 0xd },
	'lc14' => { 251 => 0xf },
	'lc15' => { 251 => 0x10 },
	'lc2' => { 251 => 0x3 },
	'lc3' => { 251 => 0x4 },
	'lc4' => { 251 => 0x5 },
	'lc5' => { 251 => 0x6 },
	'lc6' => { 251 => 0x7 },
	'lc7' => { 251 => 0x8 },
	'lcddisplayatpoweron' => { 64 => 0x811, 68 => 0xa },
	'lcddisplayreturntoshoot' => { 69 => 0x12 },
	'lcdillumination' => { 206 => '17.5', 209 => '10.3', 210 => '4.2', 212 => '5.4' },
	'lcdilluminationduringbulb' => { 64 => 0x408 },
	'lcdpanels' => { 63 => 0x8 },
	'lcheditor' => { 199 => 0x8ae85e },
	'legacyiptcdigest' => { 326 => 'LegacyIPTCDigest' },
	'legalcode' => { 310 => 'legalcode' },
	'lens' => { 90 => 0xfdea, 169 => 0x84, 309 => 'Lens' },
	'lensafstopbutton' => { 62 => 0x11, 63 => 0x13, 64 => 0x506, 65 => 0x10, 66 => 0x12, 69 => 0x13, 70 => 0x9 },
	'lensaperturerange' => { 284 => [0x30,0x48] },
	'lensdistortionparams' => { 218 => 0x206 },
	'lensdrivenoaf' => { 64 => 0x505 },
	'lensfirmware' => { 277 => 0x20, 281 => 0xa004 },
	'lensfirmwareversion' => { 214 => 0x204 },
	'lensfocalrange' => { 284 => 0xa },
	'lensfstops' => { 164 => 0x7, 165 => 0xc, 166 => 0xd, 169 => 0x8b, 251 => '0.3' },
	'lensid' => { 309 => 'LensID' },
	'lensidnumber' => { 164 => 0x6, 165 => 0xb, 166 => 0xc },
	'lensinfo' => { 90 => 0xa432, 257 => 0x2a, 309 => 'LensInfo' },
	'lenskind' => { 251 => 0x1 },
	'lensmake' => { 90 => 0xa433, 125 => 'Make' },
	'lensmanualdistortionamount' => { 312 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 135 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 11 => 0x92b, 12 => 0x933, 47 => 0x95, 90 => 0xa434, 125 => 'Model', 135 => 'LensModel', 167 => 0x18a, 214 => 0x203, 257 => 0xc },
	'lensprofilechromaticaberrationscale' => { 312 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 312 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 312 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 312 => 'LensProfileEnable' },
	'lensprofilefilename' => { 312 => 'LensProfileFilename' },
	'lensprofilename' => { 312 => 'LensProfileName' },
	'lensprofilesetup' => { 312 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 312 => 'LensProfileVignettingScale' },
	'lensproperties' => { 214 => 0x20b },
	'lensserialnumber' => { 45 => 0x0, 90 => 0xa435, 125 => 'SerialNumber', 214 => 0x202, 232 => 0x52, 277 => 0x30 },
	'lensshutterlock' => { 140 => 0x4a },
	'lensspec' => { 285 => 0x0, 286 => 0x0, 298 => 0xb02a },
	'lenstemperature' => { 218 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0x1a0, 7 => 0xc, 8 => 0x111, 9 => 0xc, 10 => 0x14f, 11 => 0xd6, 12 => 0xde, 13 => 0xf6, 14 => 0xea, 15 => 0xff, 16 => [0xc,0x97], 17 => 0xe6, 18 => 0x153, 19 => 0xea, 20 => 0xe8, 21 => 0x112, 25 => 0x16, 142 => 0x10c, 143 => 0x49bd, 169 => 0x83, 214 => 0x201, 225 => 0x16, 228 => 0x310, 231 => 0x303, 232 => 0x51, 234 => 0x3405, 252 => 0x0, 253 => 0x0, 254 => 0x1, 255 => 0x1, 256 => 0x1, 258 => 0x0, 281 => 0xa003, 298 => 0xb027 },
	'levelgaugepitch' => { 213 => 0x904 },
	'levelgaugeroll' => { 213 => 0x903 },
	'levelorientation' => { 259 => 0x0 },
	'license' => { 310 => 'license' },
	'licensee' => { 327 => 'Licensee' },
	'licenseeid' => { 327 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 327 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 327 => 'LicenseeImageNotes' },
	'licenseename' => { 327 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 327 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 327 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 327 => 'LicenseeTransactionID' },
	'licenseid' => { 327 => 'LicenseID' },
	'licensestartdate' => { 327 => 'LicenseStartDate' },
	'licensetransactiondate' => { 327 => 'LicenseTransactionDate' },
	'licensetype' => { 314 => 'licensetype' },
	'licensor' => { 327 => 'Licensor' },
	'licensorcity' => { 327 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 327 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 327 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 327 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 327 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 327 => 'LicensorImageID' },
	'licensorname' => { 327 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 327 => 'LicensorNotes' },
	'licensorpostalcode' => { 327 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 327 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 327 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 327 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 327 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 327 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 327 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 327 => 'LicensorTransactionID' },
	'licensorurl' => { 327 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 218 => 0x1009 },
	'lightingmode' => { 87 => 0x302a },
	'lightreading' => { 260 => 0x15 },
	'lightsource' => { 90 => 0x9208, 169 => 0x90, 221 => 0x1000, 316 => 'LightSource' },
	'lightsourcespecial' => { 283 => 0x21d },
	'lightswitch' => { 212 => '0.1' },
	'lightvaluecenter' => { 218 => 0x103d },
	'lightvalueperiphery' => { 218 => 0x103e },
	'linearizationtable' => { 90 => 0xc618 },
	'linearresponselimit' => { 90 => 0xc62e },
	'linkaetoafpoint' => { 242 => '14.2' },
	'liveviewaf' => { 208 => '32.1', 212 => '34.1' },
	'liveviewafareamode' => { 210 => '34.1' },
	'liveviewafmethod' => { 299 => 0x20 },
	'liveviewafmode' => { 210 => '34.2' },
	'liveviewafsetting' => { 289 => 0x36 },
	'liveviewexposuresimulation' => { 64 => 0x810 },
	'liveviewfocusmode' => { 289 => 0x8b },
	'liveviewmetering' => { 289 => 0x84 },
	'liveviewmonitorofftime' => { 210 => '20.2' },
	'liveviewshooting' => { 42 => 0x13 },
	'localcaption' => { 97 => 0x79 },
	'localizedcameramodel' => { 90 => 0xc615 },
	'locallocationname' => { 281 => 0x30 },
	'location' => { 168 => 0x9, 232 => 0x67, 307 => 'Location', 320 => 'Location', 328 => 'location' },
	'locationareacode' => { 311 => 'lac' },
	'locationcreated' => { 321 => 'LocationCreated' },
	'locationcreatedcity' => { 321 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 321 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 321 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 321 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 321 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 321 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 168 => 0x0 },
	'locationname' => { 281 => 0x31 },
	'locationshown' => { 321 => 'LocationShown' },
	'locationshowncity' => { 321 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 321 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 321 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 321 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 321 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 321 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 64 => 0x709 },
	'logcomment' => { 337 => 'logComment' },
	'longexposurenoisereduction' => { 64 => 0x201, 65 => 0x1, 66 => 0x2, 67 => 0x1, 68 => 0x1, 69 => 0x2, 70 => 0x1, 287 => 0x2b, 288 => 0x25, 289 => 0x25, 298 => [0xb04e,0x2008], 299 => 0x11 },
	'longexposurenoisereduction2' => { 42 => 0x8 },
	'loop' => { 337 => 'loop' },
	'luminanceadjustmentaqua' => { 312 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 312 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 312 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 312 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 312 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 312 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 312 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 312 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 82 => 0x150 },
	'luminancecurvepoints' => { 82 => 0x126 },
	'luminancenoisereduction' => { 83 => 0x5f, 284 => 0x1b },
	'luminancenoisereductioncontrast' => { 312 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 312 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 83 => 0x6d },
	'luminancesmoothing' => { 312 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 64 => 0x40b },
	'm16cversion' => { 228 => 0x333 },
	'macro' => { 94 => 0x1020, 95 => 0x202, 218 => 0x202, 275 => 0x21, 283 => 0x202, 298 => 0xb040 },
	'macroled' => { 216 => 0x120a },
	'macromagnification' => { 4 => 0x1b, 8 => 0x1b, 11 => 0x1b, 12 => 0x1b, 16 => 0x1b, 17 => 0x1b, 42 => 0x10 },
	'macromode' => { 25 => 0x1, 137 => 0xb, 213 => 0x300, 232 => 0x1c },
	'magicfilter' => { 213 => 0x52c },
	'magnifiedview' => { 66 => 0x11, 68 => 0x9 },
	'maindialexposurecomp' => { 211 => '0.6' },
	'make' => { 78 => 0x0, 90 => 0x10f, 118 => 'Make', 224 => 'Make', 236 => 0x10f, 333 => 'Make' },
	'makernote' => { 316 => 'MakerNote' },
	'makernotecanon' => { 89 => 'MakN', 90 => 0x927c },
	'makernotecasio' => { 89 => 'MakN', 90 => 0x927c },
	'makernotecasio2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotefujifilm' => { 89 => 'MakN', 90 => 0x927c },
	'makernotege' => { 89 => 'MakN', 90 => 0x927c },
	'makernotege2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotehasselblad' => { 89 => 'MakN', 90 => 0x927c },
	'makernotehp' => { 89 => 'MakN', 90 => 0x927c },
	'makernotehp2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotehp4' => { 89 => 'MakN', 90 => 0x927c },
	'makernotehp6' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteisl' => { 89 => 'MakN', 90 => 0x927c },
	'makernotejvc' => { 89 => 'MakN', 90 => 0x927c },
	'makernotejvctext' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak10' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak1a' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak1b' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak3' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak4' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak5' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak6a' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak6b' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak7' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak8a' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak8b' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodak9' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekodakunknown' => { 89 => 'MakN', 90 => 0x927c },
	'makernotekyocera' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica2' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica3' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica4' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica5' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteleica6' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteminolta' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteminolta2' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteminolta3' => { 89 => 'MakN', 90 => 0x927c },
	'makernotenikon' => { 89 => 'MakN', 90 => 0x927c },
	'makernotenikon2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotenikon3' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteoffset' => { 283 => 0xff },
	'makernoteolympus' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteolympus2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepanasonic' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepanasonic2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax3' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax4' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax5' => { 89 => 'MakN', 90 => 0x927c },
	'makernotepentax6' => { 89 => 'MakN', 90 => 0x927c },
	'makernotephaseone' => { 89 => 'MakN', 90 => 0x927c },
	'makernotereconyx' => { 89 => 'MakN', 90 => 0x927c },
	'makernotericoh' => { 89 => 'MakN', 90 => 0x927c },
	'makernotericohtext' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesafety' => { 90 => 0xc635 },
	'makernotesamsung1a' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesamsung1b' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesamsung2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesanyo' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesanyoc4' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesanyopatch' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesigma' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesony' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesony2' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesony3' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesony4' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesonyericsson' => { 89 => 'MakN', 90 => 0x927c },
	'makernotesonysrf' => { 89 => 'MakN', 90 => 0x927c },
	'makernotetype' => { 276 => 0x1 },
	'makernoteunknown' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteunknowntext' => { 89 => 'MakN', 90 => 0x927c },
	'makernoteversion' => { 142 => 0x0, 169 => 0x1, 218 => 0x0, 232 => 0x8000, 280 => 0x0, 281 => 0x1, 284 => [0x1d,0x1f], 290 => 0x2000 },
	'managedfrom' => { 338 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 338 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 338 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 338 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 338 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 338 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 338 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 338 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 338 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 338 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 338 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 338 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 338 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 338 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 338 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 338 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 338 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 338 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 338 => 'Manager' },
	'managervariant' => { 338 => 'ManagerVariant' },
	'manageto' => { 338 => 'ManageTo' },
	'manageui' => { 338 => 'ManageUI' },
	'manifest' => { 338 => 'Manifest' },
	'manifestlinkform' => { 338 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 338 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 338 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 338 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 338 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 338 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 338 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 338 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 338 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 338 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 338 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 338 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 338 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 338 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 338 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 338 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 338 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 338 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 338 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 338 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 338 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 338 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 213 => 0x900, 232 => 0x86 },
	'manometerreading' => { 213 => 0x901 },
	'manualafpointselectpattern' => { 64 => 0x513 },
	'manualflash' => { 216 => 0x1209 },
	'manualflashoutput' => { 25 => 0x29, 207 => '8.2', 208 => '22.2', 209 => '16.2', 210 => '23.2', 211 => '8.2', 212 => '24.2' },
	'manualflashstrength' => { 213 => 0x406 },
	'manualfocusdistance' => { 169 => 0x85, 218 => 0x100c, 283 => 0x223 },
	'manualtv' => { 63 => 0x5, 64 => 0x705 },
	'manufacturedate' => { 241 => 0x1 },
	'manufacturedate1' => { 278 => 0x4 },
	'manufacturedate2' => { 278 => 0x5 },
	'marked' => { 325 => 'Marked', 341 => 'Marked' },
	'markers' => { 337 => 'markers' },
	'markerscomment' => { 337 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 337 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 337 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 337 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 337 => [\'markers','markersCuePointType'] },
	'markersduration' => { 337 => [\'markers','markersDuration'] },
	'markerslocation' => { 337 => [\'markers','markersLocation'] },
	'markersname' => { 337 => [\'markers','markersName'] },
	'markersprobability' => { 337 => [\'markers','markersProbability'] },
	'markersspeaker' => { 337 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 337 => [\'markers','markersStartTime'] },
	'markerstarget' => { 337 => [\'markers','markersTarget'] },
	'markerstype' => { 337 => [\'markers','markersType'] },
	'maskedareas' => { 90 => 0xc68e },
	'masterdocumentid' => { 97 => 0xb9 },
	'mastergain' => { 174 => 0x50 },
	'maxaperture' => { 25 => 0x1a, 108 => 0x6103, 125 => 'MaxAperture', 137 => 0x17, 143 => 0x49c5, 214 => 0x20a, 251 => '14.1' },
	'maxapertureatmaxfocal' => { 94 => 0x1407, 125 => 'MaxApertureAtMaxFocal', 164 => 0xb, 165 => 0x10, 166 => 0x11, 214 => 0x206 },
	'maxapertureatminfocal' => { 94 => 0x1406, 164 => 0xa, 165 => 0xf, 166 => 0x10, 214 => 0x205 },
	'maxaperturevalue' => { 90 => 0x9205, 316 => 'MaxApertureValue' },
	'maxavailheight' => { 321 => 'MaxAvailHeight' },
	'maxavailwidth' => { 321 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 206 => 0xb, 209 => 0xc, 210 => 0xb },
	'maxfaces' => { 217 => 0x1202 },
	'maxfocallength' => { 4 => 0xe6, 5 => 0x10, 6 => 0x1a4, 7 => 0x13, 8 => 0x115, 9 => 0x13, 10 => 0x153, 11 => 0xda, 13 => 0xfa, 14 => 0xee, 15 => 0x103, 16 => 0x95, 17 => 0xea, 18 => 0x157, 19 => 0xee, 20 => 0xec, 21 => 0x116, 25 => 0x17, 94 => 0x1405, 125 => 'MaxFocalLength', 164 => 0x9, 165 => 0xe, 166 => 0xf, 214 => 0x208 },
	'maximumdensityrange' => { 99 => 0x8c },
	'maxpagesize' => { 342 => 'MaxPageSize' },
	'maxpagesizeh' => { 342 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 342 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 342 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 90 => 0x119 },
	'maxstorage' => { 332 => 'maxstorage' },
	'mb-d10batteries' => { 206 => '12.6' },
	'mb-d10batterytype' => { 209 => '13.3' },
	'mb-d11batterytype' => { 210 => '2.3' },
	'mb-d80batteries' => { 211 => '6.5' },
	'mb-d80batterytype' => { 212 => '3.2' },
	'mcuversion' => { 164 => 0xc, 165 => 0x11, 166 => 0x12 },
	'md5digest' => { 126 => 'zmd5' },
	'measuredev' => { 21 => 0x9, 58 => 0x3, 77 => 0x1814, 118 => 'MeasuredEV' },
	'measuredev2' => { 10 => 0x8, 21 => 0x8, 58 => 0x17 },
	'measuredev3' => { 10 => 0x9 },
	'measuredlv' => { 143 => 0x690, 228 => 0x312, 234 => 0x3407 },
	'measuredrggb' => { 48 => 0x1 },
	'measuredrggbdata' => { 31 => 0x287 },
	'mediaconstraints' => { 327 => 'MediaConstraints' },
	'mediasummarycode' => { 327 => 'MediaSummaryCode' },
	'memorycardconfiguration' => { 293 => 0x16 },
	'menubuttondisplayposition' => { 62 => 0xb, 65 => 0xa, 66 => 0xb, 69 => 0xb },
	'menubuttonreturn' => { 70 => 0xb },
	'menumonitorofftime' => { 209 => '8.2', 210 => '21.1', 212 => '22.1' },
	'metadatadate' => { 335 => 'MetadataDate' },
	'metadatamoddate' => { 337 => 'metadataModDate' },
	'metering' => { 207 => '6.1' },
	'meteringmode' => { 25 => 0x11, 90 => 0x9207, 104 => 0x1c, 137 => 0x7, 138 => 0x25, 140 => 0x12, 213 => 0x202, 260 => 0x17, 284 => 0x9, 287 => 0x15, 288 => 0x13, 289 => 0x7, 299 => 0x3, 316 => 'MeteringMode' },
	'meteringmode2' => { 242 => '2.1' },
	'meteringmode3' => { 242 => '16.1' },
	'meteringoffscaleindicator' => { 140 => 0x53 },
	'meteringtime' => { 206 => '22.2', 207 => '3.2', 208 => '17.1', 209 => '7.3', 210 => '18.1', 211 => '3.2', 212 => '19.1' },
	'mieversion' => { 126 => '0Vers' },
	'minaperture' => { 25 => 0x1b, 125 => 'MinAperture', 251 => '0.2' },
	'minfocallength' => { 4 => 0xe4, 5 => 0xe, 6 => 0x1a2, 7 => 0x11, 8 => 0x113, 9 => 0x11, 10 => 0x151, 11 => 0xd8, 13 => 0xf8, 14 => 0xec, 15 => 0x101, 16 => 0x93, 17 => 0xe8, 18 => 0x155, 19 => 0xec, 20 => 0xea, 21 => 0x114, 25 => 0x18, 94 => 0x1404, 125 => 'MinFocalLength', 164 => 0x8, 165 => 0xd, 166 => 0xe, 214 => 0x207 },
	'minoltadate' => { 137 => 0x15 },
	'minoltaimagesize' => { 137 => 0x4, 138 => 0xc, 139 => 0x2, 142 => 0x103 },
	'minoltamodelid' => { 137 => 0x25 },
	'minoltaquality' => { 137 => 0x5, 138 => 0xd, 139 => 0x3, 142 => [0x102,0x103] },
	'minoltatime' => { 137 => 0x16 },
	'minormodelagedisclosure' => { 327 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 90 => 0x118 },
	'mirrorlockup' => { 62 => 0xc, 63 => 0xc, 64 => 0x60f, 65 => 0xb, 66 => 0xc, 67 => 0x6, 68 => 0x6, 69 => 0xc, 70 => 0x3 },
	'mobilecountrycode' => { 311 => 'mcc' },
	'mobilenetworkcode' => { 311 => 'mnc' },
	'moddate' => { 224 => 'modify-date', 325 => 'ModDate' },
	'modedialposition' => { 293 => 0x14 },
	'model' => { 78 => 0x6, 90 => 0x110, 118 => 'Model', 224 => 'Model', 236 => 0x110, 333 => 'Model' },
	'modelage' => { 321 => 'ModelAge' },
	'modelingflash' => { 206 => '21.4', 209 => '26.4', 210 => '30.2', 211 => '7.4', 212 => '31.3' },
	'modelreleaseid' => { 327 => 'ModelReleaseID' },
	'modelreleasestatus' => { 327 => 'ModelReleaseStatus' },
	'modificationdate' => { 328 => 'modificationDate' },
	'modifiedcolortemp' => { 49 => 0x9 },
	'modifieddigitalgain' => { 49 => 0xb },
	'modifiedparamflag' => { 43 => 0x1 },
	'modifiedpicturestyle' => { 49 => 0xa },
	'modifiedsaturation' => { 213 => 0x504 },
	'modifiedsensorbluelevel' => { 49 => 0x5 },
	'modifiedsensorredlevel' => { 49 => 0x4 },
	'modifiedsharpness' => { 49 => 0x2 },
	'modifiedsharpnessfreq' => { 49 => 0x3 },
	'modifiedtonecurve' => { 49 => 0x1 },
	'modifiedwhitebalance' => { 49 => 0x8 },
	'modifiedwhitebalanceblue' => { 49 => 0x7 },
	'modifiedwhitebalancered' => { 49 => 0x6 },
	'modifydate' => { 90 => 0x132, 119 => 'ModifyDate', 222 => 'ModDate', 223 => 'tIME', 271 => 'ModDate', 335 => 'ModifyDate' },
	'moirefilter' => { 90 => 0xfe58, 312 => 'MoireFilter' },
	'monitordisplayoff' => { 140 => 0x4c },
	'monitorofftime' => { 206 => '18.2', 207 => '3.1', 211 => '3.1' },
	'monochromecontrast' => { 83 => 0x3c },
	'monochromefiltereffect' => { 83 => 0x3a, 260 => 0x73 },
	'monochromelinear' => { 83 => 0x3d },
	'monochromeoutputhighlightpoint' => { 83 => 0x41 },
	'monochromeoutputshadowpoint' => { 83 => 0x42 },
	'monochromerawhighlight' => { 83 => 0x7a },
	'monochromerawhighlightpoint' => { 83 => 0x3f },
	'monochromerawshadow' => { 83 => 0x83 },
	'monochromerawshadowpoint' => { 83 => 0x40 },
	'monochromesharpness' => { 83 => 0x3e },
	'monochrometoning' => { 260 => 0x74 },
	'monochrometoningeffect' => { 83 => 0x3b },
	'monochromeunsharpmaskfineness' => { 83 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 83 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 83 => 0xb4 },
	'monthdaycreated' => { 104 => 0x12, 113 => 0xe },
	'moonphase' => { 272 => 0x12 },
	'morepermissions' => { 310 => 'morePermissions' },
	'motionsensitivity' => { 272 => 0x29 },
	'multiburstimageheight' => { 298 => 0x1002 },
	'multiburstimagewidth' => { 298 => 0x1001 },
	'multiburstmode' => { 298 => 0x1000 },
	'multicontrollerwhilemetering' => { 64 => 0x517 },
	'multiexposureautogain' => { 170 => 0x3 },
	'multiexposuremode' => { 170 => 0x1 },
	'multiexposureshots' => { 170 => 0x2 },
	'multiframenoisereduction' => { 289 => 0x35, 298 => 0x200b, 299 => 0x15 },
	'multifunctionlock' => { 64 => 0x70f },
	'multipleexposuremode' => { 217 => 0x101c },
	'multipleexposureset' => { 242 => '10.1' },
	'multisample' => { 174 => 0x40 },
	'multiselector' => { 206 => '9.4', 209 => '27.4' },
	'multiselectorliveview' => { 206 => '4.3' },
	'multiselectorplaybackmode' => { 206 => ['13.5','9.2'], 209 => '27.2' },
	'multiselectorshootmode' => { 206 => '9.1', 209 => '27.1' },
	'mycolormode' => { 51 => 0x2 },
	'nativedigest' => { 316 => 'NativeDigest', 333 => 'NativeDigest' },
	'ncdfileinfo' => { 102 => 0x414 },
	'ndfilter' => { 58 => 0x1c },
	'nefbitdepth' => { 169 => 0xe22 },
	'nefcompression' => { 169 => 0x93 },
	'neflinearizationtable' => { 169 => 0x96 },
	'neutraldensityfilter' => { 260 => 0x88 },
	'neutraloutputhighlightpoint' => { 83 => 0x2f },
	'neutraloutputshadowpoint' => { 83 => 0x30 },
	'neutralrawcolortone' => { 83 => 0x28 },
	'neutralrawcontrast' => { 83 => 0x2a },
	'neutralrawhighlight' => { 83 => 0x78 },
	'neutralrawhighlightpoint' => { 83 => 0x2d },
	'neutralrawlinear' => { 83 => 0x2b },
	'neutralrawsaturation' => { 83 => 0x29 },
	'neutralrawshadow' => { 83 => 0x81 },
	'neutralrawshadowpoint' => { 83 => 0x2e },
	'neutralrawsharpness' => { 83 => 0x2c },
	'neutralunsharpmaskfineness' => { 83 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 83 => 0xa8 },
	'neutraunsharpmaskstrength' => { 83 => 0xa4 },
	'newsphotoversion' => { 99 => 0x0 },
	'nickname' => { 335 => 'Nickname' },
	'nikoncapturedata' => { 169 => 0xe01 },
	'nikoncaptureeditversions' => { 169 => 0xe13 },
	'nikoncaptureoutput' => { 169 => 0xe1e },
	'nikoncaptureversion' => { 169 => 0xe09 },
	'nikoniccprofile' => { 169 => 0xe1d },
	'nikonimagesize' => { 181 => '723.1', 182 => '732.1', 187 => 0x2c4 },
	'noisefilter' => { 213 => 0x527 },
	'noisereduction' => { 94 => 0x100b, 138 => 0xb0, 139 => 0x60, 140 => 0x3f, 169 => 0x95, 199 => 0x753dcbc0, 200 => 0x17, 213 => 0x50a, 218 => 0x103a, 232 => 0x2d, 260 => 0x49, 278 => 0x2a },
	'noisereduction2' => { 217 => 0x1010 },
	'noisereductionapplied' => { 90 => 0xc6f7 },
	'noisereductionintensity' => { 200 => 0x9 },
	'noisereductionmethod' => { 200 => 0x11 },
	'noisereductionmode' => { 302 => 0x801e },
	'noisereductionsharpness' => { 200 => 0xd },
	'noisereductionvalue' => { 302 => 0x8027 },
	'nomemorycard' => { 206 => '22.1', 207 => '0.3', 208 => '2.4', 209 => '33.7', 210 => '3.2', 211 => '0.3', 212 => '4.5' },
	'nominalmaxaperture' => { 251 => 0xa },
	'nominalminaperture' => { 251 => '10.1' },
	'notes' => { 303 => 'Notes', 308 => 'notes' },
	'npages' => { 342 => 'NPages' },
	'nrwdata' => { 169 => 0x14 },
	'nullrecord' => { 77 => 0x0 },
	'number' => { 328 => 'number' },
	'numberofbeats' => { 337 => 'numberOfBeats' },
	'numberoffocuspoints' => { 210 => '0.3' },
	'numfacepositions' => { 226 => 0x0 },
	'numindexentries' => { 99 => 0x54 },
	'object' => { 328 => 'object' },
	'objectattributereference' => { 97 => 0x4 },
	'objectcycle' => { 97 => 0x4b },
	'objectdistance' => { 86 => 0x6, 87 => 0x2022 },
	'objectname' => { 97 => 0x5 },
	'objectpreviewdata' => { 97 => 0xca },
	'objectpreviewfileformat' => { 97 => 0xc8 },
	'objectpreviewfileversion' => { 97 => 0xc9 },
	'objecttypereference' => { 97 => 0x3 },
	'oecfcolumns' => { 316 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 316 => [\'OECF','OECFNames'] },
	'oecfrows' => { 316 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 316 => [\'OECF','OECFValues'] },
	'offsetschema' => { 90 => 0xea1d },
	'okbutton' => { 210 => '15.1', 212 => '16.1' },
	'oldsubfiletype' => { 90 => 0xff },
	'olympusimageheight' => { 218 => 0x102f },
	'olympusimagewidth' => { 218 => 0x102e },
	'onetouchwb' => { 218 => 0x302 },
	'opticalzoom' => { 106 => 0xfa3d, 108 => [0x6006,0xf006], 109 => 0x1000, 110 => 0xf, 113 => 0x1e, 125 => 'OpticalZoom' },
	'opticalzoomcode' => { 58 => 0xa },
	'opticalzoommode' => { 232 => 0x34 },
	'opticalzoomon' => { 283 => 0x219 },
	'optionenddate' => { 330 => 'optionEndDate' },
	'opto-electricconvfactor' => { 316 => 'OECF' },
	'ordernumber' => { 94 => 0x8002 },
	'organisationinimagecode' => { 321 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 321 => 'OrganisationInImageName' },
	'organization' => { 328 => 'organization' },
	'orientation' => { 90 => 0x112, 236 => 0x112, 333 => 'Orientation' },
	'orientationlinkedafpoint' => { 64 => 0x516 },
	'originaldecisiondata' => { 88 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 47 => 0x83 },
	'originaldirectory' => { 230 => 0x408 },
	'originaldocumentid' => { 338 => 'OriginalDocumentID' },
	'originalfilename' => { 77 => 0x816, 102 => 0x3e9, 114 => 0x20, 230 => 0x407 },
	'originalimageheight' => { 60 => 0xc, 93 => 0x1 },
	'originalimagewidth' => { 60 => 0xb, 93 => 0x0 },
	'originalrawfiledata' => { 90 => 0xc68c },
	'originalrawfiledigest' => { 90 => 0xc71d },
	'originalrawfilename' => { 90 => 0xc68b },
	'originaltransmissionreference' => { 97 => 0x67 },
	'originatingprogram' => { 97 => 0x41 },
	'originplatform' => { 328 => 'originPlatform' },
	'os' => { 314 => 'os' },
	'otherconditions' => { 327 => 'OtherConditions' },
	'otherconstraints' => { 327 => 'OtherConstraints' },
	'otherimageinfo' => { 327 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 327 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 327 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 327 => 'OtherLicenseRequirements' },
	'outcue' => { 337 => 'outCue' },
	'outcuescale' => { 337 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 337 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 150 => 0x3 },
	'outputimagewidth' => { 150 => 0x2 },
	'outputresolution' => { 150 => 0x4 },
	'owner' => { 341 => 'Owner' },
	'ownerid' => { 97 => 0xbc },
	'ownername' => { 12 => 0x10f, 47 => 0x9, 77 => 0x810, 90 => [0xa430,0xfde8], 118 => 'OwnerName', 309 => 'OwnerName' },
	'padding' => { 90 => 0xea1c },
	'pageimage' => { 335 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 335 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 335 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 335 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 335 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 335 => 'PageInfo' },
	'pagename' => { 90 => 0x11d },
	'pagenumber' => { 90 => 0x129 },
	'pagerange' => { 328 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 312 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectioncontrast' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectionexposure' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionhue' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionmaskcenterweight' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionsaturation' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionsharpness' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectionwhat' => { 312 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 232 => 0x26 },
	'panasonicimageheight' => { 232 => 0x4c },
	'panasonicimagewidth' => { 232 => 0x4b },
	'panasonicrawversion' => { 236 => 0x1 },
	'panasonictitle' => { 90 => 0xc6d2 },
	'panasonictitle2' => { 90 => 0xc6d3 },
	'panoramacropbottom' => { 300 => 0x7 },
	'panoramacropleft' => { 300 => 0x4 },
	'panoramacropright' => { 300 => 0x6 },
	'panoramacroptop' => { 300 => 0x5 },
	'panoramadirection' => { 54 => 0x5, 300 => 0x3 },
	'panoramaframeheight' => { 300 => 0x9 },
	'panoramaframenumber' => { 54 => 0x2 },
	'panoramaframewidth' => { 300 => 0x8 },
	'panoramafullheight' => { 300 => 0x2 },
	'panoramafullwidth' => { 300 => 0x1 },
	'panoramamode' => { 104 => 0x3c, 213 => 0x601 },
	'panoramasourceheight' => { 300 => 0xb },
	'panoramasourcewidth' => { 300 => 0xa },
	'panoramicstitchcameramotion' => { 133 => 'PanoramicStitchCameraMotion', 134 => 0x1 },
	'panoramicstitchmaptype' => { 133 => 'PanoramicStitchMapType', 134 => 0x2 },
	'panoramicstitchphi0' => { 133 => 'PanoramicStitchPhi0', 134 => 0x5 },
	'panoramicstitchphi1' => { 133 => 'PanoramicStitchPhi1', 134 => 0x6 },
	'panoramicstitchtheta0' => { 133 => 'PanoramicStitchTheta0', 134 => 0x3 },
	'panoramicstitchtheta1' => { 133 => 'PanoramicStitchTheta1', 134 => 0x4 },
	'panoramicstitchversion' => { 134 => 0x0 },
	'pantry' => { 338 => 'Pantry' },
	'parallax' => { 94 => 0xb211 },
	'parametricdarks' => { 312 => 'ParametricDarks' },
	'parametrichighlights' => { 312 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 312 => 'ParametricHighlightSplit' },
	'parametriclights' => { 312 => 'ParametricLights' },
	'parametricmidtonesplit' => { 312 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 312 => 'ParametricShadows' },
	'parametricshadowsplit' => { 312 => 'ParametricShadowSplit' },
	'parentreference1' => { 319 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 319 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'patientbirthdate' => { 304 => 'PatientDOB' },
	'patientid' => { 304 => 'PatientID' },
	'patientname' => { 304 => 'PatientName' },
	'patientsex' => { 304 => 'PatientSex' },
	'pdfversion' => { 325 => 'PDFVersion' },
	'pentaximagesize' => { 260 => 0x9 },
	'pentaxmodelid' => { 241 => 0x0, 260 => 0x5 },
	'pentaxmodeltype' => { 260 => 0x1 },
	'pentaxversion' => { 260 => 0x0 },
	'people' => { 307 => 'People' },
	'peripheralillumcentralradius' => { 302 => 0x8030 },
	'peripheralillumcentralvalue' => { 302 => 0x8031 },
	'peripheralillumination' => { 83 => 0x68 },
	'peripheralilluminationon' => { 83 => 0x64 },
	'peripheralillumperiphvalue' => { 302 => 0x8032 },
	'peripherallighting' => { 60 => 0x2 },
	'peripherallightingsetting' => { 61 => 0x5 },
	'peripherallightingvalue' => { 60 => 0x6 },
	'permissions' => { 330 => 'permissions' },
	'permits' => { 310 => 'permits' },
	'person' => { 328 => 'person' },
	'personinimage' => { 321 => 'PersonInImage' },
	'perspectivehorizontal' => { 312 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 312 => 'PerspectiveRotate' },
	'perspectivescale' => { 312 => 'PerspectiveScale' },
	'perspectivevertical' => { 312 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 72 => 0x1 },
	'pf10retainprogramshift' => { 72 => 0xb },
	'pf13drivepriority' => { 72 => 0xe },
	'pf14disablefocussearch' => { 72 => 0xf },
	'pf15disableafassistbeam' => { 72 => 0x10 },
	'pf16autofocuspointshoot' => { 72 => 0x11 },
	'pf17disableafpointsel' => { 72 => 0x12 },
	'pf18enableautoafpointsel' => { 72 => 0x13 },
	'pf19continuousshootspeed' => { 72 => 0x14 },
	'pf19shootingspeedhigh' => { 71 => 0xa },
	'pf19shootingspeedlow' => { 71 => 0x9 },
	'pf1disableshootingmodes' => { 72 => 0x2 },
	'pf1value' => { 71 => 0x1 },
	'pf20limitcontinousshots' => { 72 => 0x15 },
	'pf20maxcontinousshots' => { 71 => 0xb },
	'pf21enablequietoperation' => { 72 => 0x16 },
	'pf23felocktime' => { 71 => 0xd },
	'pf23postreleasetime' => { 71 => 0xe },
	'pf23settimerlengths' => { 72 => 0x18 },
	'pf23shutterbuttontime' => { 71 => 0xc },
	'pf24lightlcdduringbulb' => { 72 => 0x19 },
	'pf25aemode' => { 71 => 0xf },
	'pf25afmode' => { 71 => 0x12 },
	'pf25afpointsel' => { 71 => 0x13 },
	'pf25colormatrix' => { 71 => 0x17 },
	'pf25defaultclearsettings' => { 72 => 0x1a },
	'pf25drivemode' => { 71 => 0x11 },
	'pf25imagesize' => { 71 => 0x14 },
	'pf25meteringmode' => { 71 => 0x10 },
	'pf25parameters' => { 71 => 0x16 },
	'pf25wbmode' => { 71 => 0x15 },
	'pf26shortenreleaselag' => { 72 => 0x1b },
	'pf27reversedialrotation' => { 72 => 0x1c },
	'pf27value' => { 71 => 0x18 },
	'pf28noquickdialexpcomp' => { 72 => 0x1d },
	'pf29quickdialswitchoff' => { 72 => 0x1e },
	'pf2disablemeteringmodes' => { 72 => 0x3 },
	'pf2value' => { 71 => 0x2 },
	'pf30enlargementmode' => { 72 => 0x1f },
	'pf31originaldecisiondata' => { 72 => 0x20 },
	'pf3manualexposuremetering' => { 72 => 0x4 },
	'pf3value' => { 71 => 0x3 },
	'pf4exposuretimelimits' => { 72 => 0x5 },
	'pf4exposuretimemax' => { 71 => 0x5 },
	'pf4exposuretimemin' => { 71 => 0x4 },
	'pf5aperturelimits' => { 72 => 0x6 },
	'pf5aperturemax' => { 71 => 0x7 },
	'pf5aperturemin' => { 71 => 0x6 },
	'pf6presetshootingmodes' => { 72 => 0x7 },
	'pf7bracketcontinuousshoot' => { 72 => 0x8 },
	'pf8bracketshots' => { 71 => 0x8 },
	'pf8setbracketshots' => { 72 => 0x9 },
	'pf9changebracketsequence' => { 72 => 0xa },
	'phasedetectaf' => { 148 => 0x6 },
	'phonenumber' => { 119 => 'Phone' },
	'photoeffect' => { 25 => 0x28 },
	'photoeffecthistoryxml' => { 199 => 0xe9651831 },
	'photoeffects' => { 199 => 0xab5eca5e },
	'photoeffectsblue' => { 201 => 0x8 },
	'photoeffectsgreen' => { 201 => 0x6 },
	'photoeffectsred' => { 201 => 0x4 },
	'photoeffectstype' => { 201 => 0x0 },
	'photoinfoplayback' => { 206 => '17.6', 209 => '33.6' },
	'photometricinterpretation' => { 90 => 0x106, 333 => 'PhotometricInterpretation' },
	'photoshopquality' => { 268 => 0x0 },
	'picklabel' => { 315 => 'PickLabel' },
	'pictinfo' => { 283 => 0x208 },
	'picturecontrol' => { 199 => 0xe2173c47 },
	'picturecontrolactive' => { 202 => 0x0 },
	'picturecontroladjust' => { 171 => 0x30 },
	'picturecontrolbase' => { 171 => 0x18 },
	'picturecontroldata' => { 169 => [0xbd,0x23] },
	'picturecontrolmode' => { 202 => 0x13 },
	'picturecontrolname' => { 171 => 0x4 },
	'picturecontrolquickadjust' => { 171 => 0x31 },
	'pictureeffect' => { 298 => 0x200e },
	'picturefinish' => { 138 => 0x71 },
	'picturemode' => { 94 => 0x1031, 213 => 0x520, 260 => [0xb,0x33], 284 => 0x3d },
	'picturemode2' => { 242 => 0x0 },
	'picturemodebwfilter' => { 213 => 0x525 },
	'picturemodecontrast' => { 213 => 0x523 },
	'picturemodeeffect' => { 213 => 0x52d },
	'picturemodehue' => { 213 => 0x522 },
	'picturemodesaturation' => { 213 => 0x521 },
	'picturemodesharpness' => { 213 => 0x524 },
	'picturemodetone' => { 213 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0xed, 7 => 0x6c, 8 => 0x86, 9 => 0x73, 13 => 0xab, 14 => 0xa7, 15 => 0xb0, 16 => 0x6c, 17 => 0xa7, 18 => 0xf4, 19 => 0xb3, 56 => 0xa, 83 => 0x2 },
	'picturewizard' => { 281 => 0x21 },
	'picturewizardcolor' => { 279 => 0x1 },
	'picturewizardcontrast' => { 279 => 0x4 },
	'picturewizardmode' => { 279 => 0x0 },
	'picturewizardsaturation' => { 279 => 0x2 },
	'picturewizardsharpness' => { 279 => 0x3 },
	'pitchangle' => { 259 => 0x2 },
	'planarconfiguration' => { 90 => 0x11c, 333 => 'PlanarConfiguration' },
	'platenames' => { 342 => 'PlateNames' },
	'playbackmenustime' => { 208 => '20.1' },
	'playbackmonitorofftime' => { 209 => '8.1', 210 => '35.1', 212 => '21.1' },
	'playdisplay' => { 140 => 0x4e },
	'plusversion' => { 327 => 'Version' },
	'pngwarning' => { 224 => 'Warning' },
	'portraitoutputhighlightpoint' => { 83 => 0x1d },
	'portraitoutputshadowpoint' => { 83 => 0x1e },
	'portraitrawcolortone' => { 83 => 0x16 },
	'portraitrawcontrast' => { 83 => 0x18 },
	'portraitrawhighlight' => { 83 => 0x76 },
	'portraitrawhighlightpoint' => { 83 => 0x1b },
	'portraitrawlinear' => { 83 => 0x19 },
	'portraitrawsaturation' => { 83 => 0x17 },
	'portraitrawshadow' => { 83 => 0x7f },
	'portraitrawshadowpoint' => { 83 => 0x1c },
	'portraitrawsharpness' => { 83 => 0x1a },
	'portraitrefiner' => { 87 => 0x302b },
	'portraitunsharpmaskfineness' => { 83 => 0x9a },
	'portraitunsharpmaskstrength' => { 83 => 0x98 },
	'portraitunsharpmaskthreshold' => { 83 => 0x9c },
	'postalcode' => { 123 => 'PostalCode' },
	'postcropvignetteamount' => { 312 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 312 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 312 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 312 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 312 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 312 => 'PostCropVignetteStyle' },
	'powersource' => { 240 => '0.1' },
	'poweruptime' => { 169 => 0xb6 },
	'precaptureframes' => { 218 => 0x300 },
	'predictor' => { 90 => 0x13d },
	'preflashreturnstrength' => { 182 => 0x28a },
	'prefs' => { 97 => 0xdd, 267 => 'Prefs' },
	'preservedfilename' => { 338 => 'PreservedFileName' },
	'presetwhitebalance' => { 140 => 0x24, 302 => 0x8002 },
	'presetwhitebalanceadj' => { 302 => 0x8014 },
	'previewapplicationname' => { 90 => 0xc716 },
	'previewapplicationversion' => { 90 => 0xc717 },
	'previewbutton' => { 206 => ['14.1','15.1'], 209 => '29.1', 210 => '14.1' },
	'previewbuttonplusdials' => { 206 => ['14.2','15.2'], 209 => '31.2' },
	'previewcolorspace' => { 90 => 0xc71a },
	'previewcropbottom' => { 266 => 0xef },
	'previewcropleft' => { 266 => 0xec },
	'previewcropright' => { 266 => 0xee },
	'previewcroptop' => { 266 => 0xed },
	'previewdatetime' => { 90 => 0xc71b },
	'previewimage' => { 87 => 0x2000, 88 => 'PreviewImage', 91 => 'PreviewImage', 92 => 0x4, 128 => 'data', 142 => 0x81, 218 => 0x280, 231 => 0x300, 298 => 0x2001 },
	'previewimageborders' => { 260 => 0x3e },
	'previewimageheight' => { 55 => 0x4, 106 => 0xfa58 },
	'previewimagelength' => { 55 => 0x2, 87 => 0x3, 90 => [0x117,0x202], 142 => 0x89, 172 => 0x202, 213 => 0x102, 218 => 0x1037, 260 => 0x3, 275 => 0x1e, 280 => 0x3, 284 => [0x1b,0x1d], 290 => 0x202 },
	'previewimagename' => { 128 => '1Name' },
	'previewimagesize' => { 87 => 0x2, 111 => 0x2, 128 => 'ImageSize', 260 => 0x2, 284 => 0x1c, 298 => 0xb02c },
	'previewimagestart' => { 55 => 0x5, 87 => 0x4, 90 => [0x111,0x201], 142 => 0x88, 172 => 0x201, 213 => 0x101, 218 => 0x1036, 260 => 0x4, 275 => 0x1c, 280 => 0x2, 284 => [0x1a,0x1c], 290 => 0x201 },
	'previewimagetype' => { 128 => '0Type' },
	'previewimagevalid' => { 213 => 0x100, 218 => 0x1035 },
	'previewimagewidth' => { 55 => 0x3, 106 => 0xfa57 },
	'previewquality' => { 55 => 0x1 },
	'previewsettingsdigest' => { 90 => 0xc719 },
	'previewsettingsname' => { 90 => 0xc718 },
	'primaryafpoint' => { 148 => 0x7 },
	'primarychromaticities' => { 90 => 0x13f, 333 => 'PrimaryChromaticities' },
	'printim' => { 90 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 140 => 0x1d, 287 => 0x28 },
	'privatertkinfo' => { 306 => 'privateRTKInfo' },
	'processingsoftware' => { 90 => 0xb },
	'processversion' => { 312 => 'ProcessVersion' },
	'producer' => { 222 => 'Producer', 325 => 'Producer' },
	'productid' => { 98 => 0x32 },
	'productioncode' => { 241 => 0x2 },
	'productorserviceconstraints' => { 327 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 90 => 0xc6f4 },
	'profilecopyright' => { 90 => 0xc6fe },
	'profileembedpolicy' => { 90 => 0xc6fd },
	'profilehuesatmapdata1' => { 90 => 0xc6fa },
	'profilehuesatmapdata2' => { 90 => 0xc6fb },
	'profilehuesatmapdims' => { 90 => 0xc6f9 },
	'profilelooktabledata' => { 90 => 0xc726 },
	'profilelooktabledims' => { 90 => 0xc725 },
	'profilename' => { 90 => 0xc6f8 },
	'profiletonecurve' => { 90 => 0xc6fc },
	'programiso' => { 232 => 0x3c },
	'programline' => { 242 => '1.1' },
	'programmode' => { 145 => 0x5 },
	'programshift' => { 169 => 0xd },
	'programversion' => { 97 => 0x46 },
	'prohibits' => { 310 => 'prohibits' },
	'projectname' => { 337 => 'projectName' },
	'projectref' => { 337 => 'projectRef' },
	'projectrefpath' => { 337 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 337 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 327 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 327 => 'PropertyReleaseStatus' },
	'province-state' => { 97 => 0x5f },
	'publicationdate' => { 328 => 'publicationDate' },
	'publicationname' => { 328 => 'publicationName' },
	'publisher' => { 313 => 'publisher' },
	'pulldown' => { 337 => 'pullDown' },
	'quality' => { 0 => 0x1, 25 => 0x3, 86 => 0x2, 87 => 0x3002, 94 => 0x1000, 104 => 0x9, 169 => 0x4, 189 => 0x3, 218 => 0x201, 228 => 0x300, 260 => 0x8, 265 => 0x2, 284 => 0x16, 287 => 0x56, 288 => 0x56, 289 => 0xb, 298 => [0x102,0xb047] },
	'qualitymode' => { 87 => 0x8 },
	'quantizationmethod' => { 99 => 0x78 },
	'quickadjust' => { 202 => 0x2a },
	'quickcontroldialinmeter' => { 64 => 0x703 },
	'quickshot' => { 283 => 0x213 },
	'rangefinder' => { 208 => '4.1' },
	'rasterizedcaption' => { 97 => 0x7d },
	'rating' => { 90 => 0x4746, 266 => 0xdf, 298 => 0x2002, 308 => 'rating', 314 => 'rating', 335 => 'Rating' },
	'ratingpercent' => { 90 => 0x4749, 135 => 'Rating' },
	'rawandjpgrecording' => { 62 => 0x8, 142 => 0x109, 242 => 0xd },
	'rawbrightnessadj' => { 82 => 0x38 },
	'rawcoloradj' => { 82 => 0x2e },
	'rawcropbottom' => { 266 => 0xd4 },
	'rawcropleft' => { 266 => 0xd1 },
	'rawcropright' => { 266 => 0xd3 },
	'rawcroptop' => { 266 => 0xd2 },
	'rawcustomsaturation' => { 82 => 0x30 },
	'rawcustomtone' => { 82 => 0x34 },
	'rawdatauniqueid' => { 90 => 0xc65d },
	'rawdepth' => { 144 => 0x10 },
	'rawdevautogradation' => { 220 => 0x119 },
	'rawdevcolorspace' => { 219 => 0x108, 220 => 0x109 },
	'rawdevcontrastvalue' => { 219 => 0x106, 220 => 0x105 },
	'rawdeveditstatus' => { 219 => 0x10b },
	'rawdevengine' => { 219 => 0x109, 220 => 0x10b },
	'rawdevexposurebiasvalue' => { 219 => 0x100, 220 => 0x100 },
	'rawdevgradation' => { 220 => 0x112 },
	'rawdevgraypoint' => { 219 => 0x103, 220 => 0x104 },
	'rawdevmemorycoloremphasis' => { 219 => 0x105, 220 => 0x108 },
	'rawdevnoisereduction' => { 219 => 0x10a, 220 => 0x10a },
	'rawdevpicturemode' => { 220 => 0x10c },
	'rawdevpm_bwfilter' => { 220 => 0x110 },
	'rawdevpmcontrast' => { 220 => 0x10e },
	'rawdevpmnoisefilter' => { 220 => 0x120 },
	'rawdevpmpicturetone' => { 220 => 0x111 },
	'rawdevpmsaturation' => { 220 => 0x10d },
	'rawdevpmsharpness' => { 220 => 0x10f },
	'rawdevsaturation3' => { 220 => 0x113 },
	'rawdevsaturationemphasis' => { 219 => 0x104, 220 => 0x107 },
	'rawdevsettings' => { 219 => 0x10c },
	'rawdevsharpnessvalue' => { 219 => 0x107, 220 => 0x106 },
	'rawdevversion' => { 219 => 0x0, 220 => 0x0 },
	'rawdevwbfineadjustment' => { 219 => 0x102, 220 => 0x103 },
	'rawdevwhitebalance' => { 220 => 0x101 },
	'rawdevwhitebalancevalue' => { 219 => 0x101, 220 => 0x102 },
	'rawfile' => { 90 => 0xfe4c },
	'rawfilename' => { 312 => 'RawFileName' },
	'rawimagecenter' => { 169 => 0x99 },
	'rawimagedigest' => { 90 => 0xc71c },
	'rawimagesize' => { 260 => 0x39 },
	'rawinfoversion' => { 221 => 0x0 },
	'rawjpgheight' => { 79 => 0x4 },
	'rawjpgquality' => { 42 => 0x6, 79 => 0x1 },
	'rawjpgsize' => { 42 => 0x7, 79 => 0x2 },
	'rawjpgwidth' => { 79 => 0x3 },
	'rawmeasuredrggb' => { 30 => 0x26a, 32 => 0x280, 34 => 0x194, 35 => 0x1ad },
	'rawrppused' => { 308 => 'rawrppused' },
	'reardisplay' => { 206 => '12.3' },
	'recognizedface1age' => { 227 => 0x20 },
	'recognizedface1name' => { 227 => 0x4 },
	'recognizedface1position' => { 227 => 0x18 },
	'recognizedface2age' => { 227 => 0x50 },
	'recognizedface2name' => { 227 => 0x34 },
	'recognizedface2position' => { 227 => 0x48 },
	'recognizedface3age' => { 227 => 0x80 },
	'recognizedface3name' => { 227 => 0x64 },
	'recognizedface3position' => { 227 => 0x78 },
	'recognizedfaceflags' => { 232 => 0x63 },
	'recommendedexposureindex' => { 90 => 0x8832 },
	'recorddisplay' => { 140 => 0x4d },
	'recordid' => { 77 => 0x1804 },
	'recordingmode' => { 86 => 0x1, 265 => 0x1 },
	'recordmode' => { 25 => 0x9, 87 => 0x3000 },
	'recordshutterrelease' => { 283 => 0x217 },
	'redbalance' => { 155 => 0x270, 218 => 0x1017, 236 => 0x11, 260 => 0x1c },
	'redcurvelimits' => { 82 => 0x18a },
	'redcurvepoints' => { 82 => 0x160 },
	'redeyecorrection' => { 203 => 0x0 },
	'redeyeinfo' => { 312 => 'RedEyeInfo' },
	'redeyereduction' => { 140 => 0x41, 289 => 0x28 },
	'redhue' => { 312 => 'RedHue' },
	'redsaturation' => { 312 => 'RedSaturation' },
	'reductionmatrix1' => { 90 => 0xc625 },
	'reductionmatrix2' => { 90 => 0xc626 },
	'reference1' => { 319 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 319 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 90 => 0x214, 333 => 'ReferenceBlackWhite' },
	'referencedate' => { 97 => 0x2f },
	'referencenumber' => { 97 => 0x32 },
	'references' => { 119 => 'References' },
	'referenceservice' => { 97 => 0x2d },
	'regionappliedtodimensions' => { 324 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 324 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 324 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 324 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 324 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 324 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 324 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 324 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 324 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 324 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 324 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 324 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 327 => 'RegionConstraints' },
	'regiondescription' => { 324 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 324 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 324 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 324 => 'Regions' },
	'regioninfodateregionsvalid' => { 132 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 132 => 'RegionInfo' },
	'regioninforegions' => { 132 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 324 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 324 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 132 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 132 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 132 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 132 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 132 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 324 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 324 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 321 => 'RegistryId' },
	'registryitemid' => { 321 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 321 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 117 => 'data' },
	'relatedaudiofilename' => { 117 => '1Name' },
	'relatedaudiofiletype' => { 117 => '0Type' },
	'relatedimagefileformat' => { 90 => 0x1000 },
	'relatedimageheight' => { 90 => 0x1002 },
	'relatedimagewidth' => { 90 => 0x1001 },
	'relatedsoundfile' => { 90 => 0xa004, 316 => 'RelatedSoundFile' },
	'relatedvideofile' => { 131 => 'data' },
	'relatedvideofilename' => { 131 => '1Name' },
	'relatedvideofiletype' => { 131 => '0Type' },
	'relation' => { 313 => 'relation' },
	'relativepeakaudiofilepath' => { 337 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 337 => 'relativeTimestamp' },
	'relativetimestampscale' => { 337 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 337 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 206 => '17.8', 209 => '33.8', 210 => '17.6' },
	'releasedate' => { 97 => 0x1e, 337 => 'releaseDate' },
	'releasemode' => { 87 => 0x3001, 298 => 0xb049 },
	'releasesetting' => { 77 => 0x1016 },
	'releasetime' => { 97 => 0x23 },
	'remoteonduration' => { 207 => '3.4', 208 => '17.2', 210 => '18.2', 211 => '4.3', 212 => '19.2' },
	'renditionclass' => { 338 => 'RenditionClass' },
	'renditionof' => { 338 => 'RenditionOf' },
	'renditionofalternatepaths' => { 338 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 338 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 338 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 338 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 338 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 338 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 338 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 338 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 338 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 338 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 338 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 338 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 338 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 338 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 338 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 338 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 338 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 338 => 'RenditionParams' },
	'repeatingflashcount' => { 159 => 0xd, 160 => 0xe, 161 => 0xe, 209 => '17.2', 210 => '24.2', 211 => '9.2', 212 => '25.2' },
	'repeatingflashoutput' => { 209 => '17.1', 210 => '24.1', 211 => '9.1', 212 => '25.1' },
	'repeatingflashrate' => { 159 => 0xc, 160 => 0xd, 161 => 0xd, 209 => '18.1', 210 => '25.1', 211 => '10.1', 212 => '26.1' },
	'requires' => { 310 => 'requires' },
	'resampleparams' => { 337 => 'resampleParams' },
	'resampleparamsquality' => { 337 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 283 => 0x21e },
	'resolution' => { 124 => 'Resolution' },
	'resolutionmode' => { 284 => 0x4 },
	'resolutionunit' => { 90 => 0x128, 100 => 0x2, 333 => 'ResolutionUnit' },
	'restrictions' => { 330 => 'restrictions' },
	'retouchhistory' => { 169 => 0x9e },
	'retouchinfo' => { 312 => 'RetouchInfo' },
	'reuse' => { 327 => 'Reuse' },
	'reuseallowed' => { 340 => 'ReuseAllowed' },
	'reuseprohibited' => { 330 => 'reuseProhibited' },
	'reverseindicators' => { 206 => '12.1', 208 => '4.3', 209 => '33.5', 210 => '5.1', 212 => '6.2' },
	'revision' => { 314 => 'revision' },
	'rgbcurvelimits' => { 82 => 0x238 },
	'rgbcurvepoints' => { 82 => 0x20e },
	'richtextcomment' => { 318 => 'RichTextComment' },
	'ricohdate' => { 275 => 0x6 },
	'ricohimageheight' => { 275 => 0x2 },
	'ricohimagewidth' => { 275 => 0x0 },
	'rightascension' => { 127 => 'RightAscension' },
	'rights' => { 313 => 'rights' },
	'rightsagent' => { 328 => 'rightsAgent', 330 => 'rightsAgent' },
	'rightsowner' => { 330 => 'rightsOwner' },
	'rollangle' => { 259 => 0x1 },
	'romoperationmode' => { 77 => 0x80d },
	'rotation' => { 22 => 0x17, 23 => 0x18, 76 => 0x3, 82 => 0x26e, 93 => 0x4, 127 => 'Rotation', 138 => [0x65,0x50], 139 => 0x46, 140 => 0x5a, 143 => 0x10, 187 => '590.1', 199 => 0x76a43207, 232 => 0x30, 242 => '17.2', 266 => 0xd8, 287 => 0x3f, 288 => 0x3f, 297 => 0x10 },
	'routedto' => { 317 => 'RoutedTo' },
	'routing' => { 271 => 'Routing' },
	'routingnotes' => { 317 => 'RoutingNotes' },
	'rowsperstrip' => { 90 => 0x116 },
	'rpp' => { 308 => 'rpp' },
	'safetyshift' => { 64 => 0x108 },
	'safetyshiftinavortv' => { 62 => 0x10, 63 => 0x10, 65 => 0xf, 66 => 0x10, 69 => 0x10 },
	'samplebits' => { 117 => 'SampleBits' },
	'samplerate' => { 117 => 'SampleRate' },
	'samplesperpixel' => { 90 => 0x115, 333 => 'SamplesPerPixel' },
	'samplestructure' => { 99 => 0x5a },
	'sanyoquality' => { 283 => 0x201 },
	'sanyothumbnail' => { 283 => 0x100 },
	'saturation' => { 7 => 0x6e, 9 => 0x76, 25 => 0xe, 36 => 0x1, 86 => 0xd, 87 => [0x3013,0x1f], 90 => [0xa409,0xfe55], 94 => 0x1003, 118 => 'Saturation', 137 => 0x1f, 138 => 0x32, 139 => 0x28, 140 => 0x1a, 145 => 0x1, 169 => [0x94,0xaa], 171 => 0x35, 232 => 0x40, 234 => 0x300d, 260 => 0x1f, 265 => 0xd, 272 => 0x27, 275 => 0x28, 284 => 0x10, 287 => 0x1e, 288 => 0x1b, 298 => 0x2005, 312 => 'Saturation', 316 => 'Saturation' },
	'saturationadj' => { 82 => 0x116, 198 => 0x1, 202 => 0x2e, 302 => 0x8016 },
	'saturationadjustmentaqua' => { 312 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 312 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 312 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 312 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 312 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 312 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 312 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 312 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 16 => 0xfe, 52 => 0x68, 53 => 0x68 },
	'saturationlandscape' => { 16 => 0xfc, 52 => 0x38, 53 => 0x38 },
	'saturationmonochrome' => { 52 => 0x80, 53 => 0x80 },
	'saturationneutral' => { 16 => 0xfd, 52 => 0x50, 53 => 0x50 },
	'saturationportrait' => { 16 => 0xfb, 52 => 0x20, 53 => 0x20 },
	'saturationsetting' => { 221 => 0x1010, 289 => 0x11, 299 => 0x9 },
	'saturationstandard' => { 16 => 0xfa, 52 => 0x8, 53 => 0x8 },
	'saturationunknown' => { 53 => 0x98 },
	'saturationuserdef1' => { 16 => 0x100, 52 => 0x98, 53 => 0xb0 },
	'saturationuserdef2' => { 16 => 0x101, 52 => 0xb0, 53 => 0xc8 },
	'saturationuserdef3' => { 16 => 0x102, 52 => 0xc8, 53 => 0xe0 },
	'saveid' => { 338 => 'SaveID' },
	'scaletype' => { 337 => 'scaleType' },
	'scanimageenhancer' => { 174 => 0x60 },
	'scanningdirection' => { 99 => 0x64 },
	'scene' => { 320 => 'Scene', 337 => 'scene' },
	'scenearea' => { 216 => 0x211, 218 => 0x1031 },
	'sceneassist' => { 169 => 0x9c },
	'scenecapturetype' => { 90 => 0xa406, 316 => 'SceneCaptureType' },
	'scenedetect' => { 216 => 0x210, 218 => 0x1030 },
	'scenedetectdata' => { 216 => 0x212, 218 => 0x1033 },
	'scenemode' => { 106 => 0xfa02, 142 => 0x100, 169 => 0x8f, 213 => 0x509, 218 => 0x403, 232 => 0x8001, 298 => 0xb023 },
	'scenemodeused' => { 108 => [0x6002,0xf002] },
	'sceneselect' => { 283 => 0x21f },
	'scenetype' => { 90 => 0xa301, 316 => 'SceneType' },
	'screentips' => { 206 => '12.7', 209 => '13.1', 210 => '4.4', 212 => '5.1' },
	'section' => { 328 => 'section' },
	'securityclassification' => { 90 => 0x9212 },
	'selectableafpoint' => { 64 => 0x509 },
	'selectafareaselectmode' => { 64 => 0x512 },
	'selftimer' => { 25 => 0x2, 232 => 0x2e, 283 => 0x214 },
	'selftimer2' => { 58 => 0x1d },
	'selftimerinterval' => { 210 => '19.2' },
	'selftimermode' => { 90 => 0x882b },
	'selftimershotcount' => { 208 => '18.2', 210 => '19.3', 212 => '20.2' },
	'selftimertime' => { 77 => 0x1806, 140 => 0x1f, 206 => '18.1', 207 => '3.3', 208 => '18.1', 209 => '7.2', 210 => '19.1', 211 => '3.3', 212 => '20.1' },
	'seminfo' => { 90 => 0x8546 },
	'sensingmethod' => { 90 => 0xa217, 316 => 'SensingMethod' },
	'sensitivityadjust' => { 260 => 0x40 },
	'sensitivitysteps' => { 242 => ['14.3','17.4'], 244 => 0x1 },
	'sensitivitytype' => { 90 => 0x8830 },
	'sensorareas' => { 281 => 0xa010 },
	'sensorbitdepth' => { 234 => 0x312d },
	'sensorbluelevel' => { 56 => 0x5 },
	'sensorcleaning' => { 70 => 0xd },
	'sensorfullheight' => { 101 => 0xf904 },
	'sensorfullwidth' => { 101 => 0xf903 },
	'sensorheight' => { 101 => 0xf901, 106 => 0xfa21, 144 => 0x8, 234 => 0x312c },
	'sensorpixelsize' => { 169 => 0x9a },
	'sensorredlevel' => { 56 => 0x4 },
	'sensorsize' => { 118 => 'SensorSize', 260 => 0x35 },
	'sensortemperature' => { 216 => 0x1500, 218 => 0x1007, 284 => [0x39,0x55] },
	'sensorwidth' => { 101 => 0xf900, 106 => 0xfa20, 144 => 0xa, 234 => 0x312b },
	'sequence' => { 272 => 0x7 },
	'sequencenumber' => { 58 => 0x9, 87 => 0x301c, 94 => 0x1101, 104 => 0x1d, 232 => 0x2b, 289 => [0x10c,0x30c], 298 => 0xb04a },
	'sequenceshotinterval' => { 283 => 0x224 },
	'sequentialshot' => { 283 => 0x20e },
	'serialnumber' => { 47 => 0xc, 77 => 0x180b, 90 => [0xa431,0xfde9], 101 => 0xfa04, 103 => 0xfa00, 105 => 0xc354, 106 => 0xfa19, 115 => 0x0, 118 => 'SerialNumber', 169 => [0xa0,0x1d], 214 => 0x101, 218 => [0x404,0x101a], 228 => 0x303, 234 => 0x3103, 260 => 0x229, 272 => 0x15, 276 => 0x5, 284 => 0x2, 309 => 'SerialNumber' },
	'serialnumberformat' => { 47 => 0x15, 77 => 0x183b },
	'seriesdatetime' => { 304 => 'SeriesDateTime' },
	'seriesdescription' => { 304 => 'SeriesDescription' },
	'seriesmodality' => { 304 => 'SeriesModality' },
	'seriesnumber' => { 304 => 'SeriesNumber' },
	'serviceidentifier' => { 98 => 0x1e },
	'setbuttoncrosskeysfunc' => { 67 => 0x0, 68 => 0x0 },
	'setbuttonwhenshooting' => { 62 => 0x1, 64 => 0x704, 70 => 0xc },
	'setfunctionwhenshooting' => { 65 => 0x0, 66 => 0x1, 69 => 0x1 },
	'shadingcompensation' => { 213 => 0x50c },
	'shadingcompensation2' => { 217 => 0x1012 },
	'shadow' => { 284 => 0xe },
	'shadowcompensation' => { 260 => 0x79 },
	'shadowprotection' => { 198 => 0x0 },
	'shadows' => { 90 => 0xfe52, 312 => 'Shadows' },
	'shadows2012' => { 312 => 'Shadows2012' },
	'shadowscale' => { 90 => 0xc633 },
	'shadowtint' => { 312 => 'ShadowTint' },
	'shakereduction' => { 261 => 0x1 },
	'sharpendetail' => { 312 => 'SharpenDetail' },
	'sharpenedgemasking' => { 312 => 'SharpenEdgeMasking' },
	'sharpening' => { 234 => 0x300b },
	'sharpeningadj' => { 202 => 0x2b },
	'sharpenradius' => { 312 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 7 => 0x72, 9 => 0x74, 25 => 0xf, 56 => 0x2, 86 => 0xb, 87 => [0x3011,0x21], 90 => [0xa40a,0xfe56], 94 => 0x1001, 104 => 0x6b, 113 => 0x37, 118 => 'Sharpness', 137 => 0x21, 138 => 0x30, 139 => 0x26, 140 => 0x18, 145 => 0x3, 169 => 0x6, 171 => 0x32, 218 => 0x100f, 232 => 0x41, 260 => 0x21, 265 => 0xb, 272 => 0x26, 275 => 0x22, 276 => 0x1003, 284 => 0x11, 287 => 0x1c, 288 => 0x19, 298 => 0x2006, 312 => 'Sharpness', 316 => 'Sharpness' },
	'sharpnessadj' => { 82 => 0x25a, 302 => 0x801a },
	'sharpnessfactor' => { 218 => 0x102a },
	'sharpnessfaithful' => { 16 => 0xf5, 52 => 0x64, 53 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 56 => 0x3 },
	'sharpnesslandscape' => { 16 => 0xf3, 52 => 0x34, 53 => 0x34 },
	'sharpnessmonochrome' => { 16 => 0xf6, 52 => 0x7c, 53 => 0x7c },
	'sharpnessneutral' => { 16 => 0xf4, 52 => 0x4c, 53 => 0x4c },
	'sharpnessovershoot' => { 302 => 0x801b },
	'sharpnessportrait' => { 16 => 0xf2, 52 => 0x1c, 53 => 0x1c },
	'sharpnesssetting' => { 213 => 0x506, 221 => 0x1013, 289 => 0x12, 299 => 0xa },
	'sharpnessstandard' => { 16 => 0xf1, 52 => 0x4, 53 => 0x4 },
	'sharpnessthreshold' => { 302 => 0x801d },
	'sharpnessundershoot' => { 302 => 0x801c },
	'sharpnessunknown' => { 53 => 0x94 },
	'sharpnessuserdef1' => { 16 => 0xf7, 52 => 0x94, 53 => 0xac },
	'sharpnessuserdef2' => { 16 => 0xf8, 52 => 0xac, 53 => 0xc4 },
	'sharpnessuserdef3' => { 16 => 0xf9, 52 => 0xc4, 53 => 0xdc },
	'shootinginfodisplay' => { 206 => '13.2', 209 => '10.2', 210 => '4.1', 212 => '5.3' },
	'shootinginfomonitorofftime' => { 209 => '9.1', 210 => '21.2', 212 => '22.2' },
	'shootingmode' => { 118 => 'ShootingMode', 169 => 0x89, 232 => 0x1f },
	'shootingmodesetting' => { 207 => '5.1' },
	'shortdescription' => { 314 => 'shortdescription' },
	'shortdocumentid' => { 97 => 0xba },
	'shortownername' => { 16 => 0xac },
	'shortreleasetimelag' => { 64 => 0x80d },
	'shotdate' => { 337 => 'shotDate' },
	'shotday' => { 337 => 'shotDay' },
	'shotlocation' => { 337 => 'shotLocation' },
	'shotname' => { 337 => 'shotName' },
	'shotnumber' => { 337 => 'shotNumber' },
	'shotsize' => { 337 => 'shotSize' },
	'shutter-aelock' => { 62 => 0x4, 64 => 0x701, 65 => 0x3, 66 => 0x4, 67 => 0x3, 68 => 0x3, 69 => 0x4, 70 => 0x2 },
	'shutteraelbutton' => { 63 => 0x4 },
	'shutterbuttonafonbutton' => { 64 => 0x701 },
	'shuttercount' => { 8 => 0x176, 42 => 0x1, 169 => 0xa7, 175 => [0x6a,0x157,0x24d], 176 => 0x286, 177 => 0x279, 178 => 0x284, 179 => 0x242, 180 => 0x280, 181 => 0x276, 182 => [0x27d,0x27f], 183 => 0x246, 184 => 0x2d6, 185 => 0x287, 186 => 0x320, 187 => 0x24a, 188 => 0x2d5, 260 => 0x5d },
	'shuttercurtainsync' => { 62 => 0xf, 63 => 0xf, 64 => 0x305, 65 => 0xe, 66 => 0xf, 67 => 0x8, 68 => 0x8, 69 => 0xf, 70 => 0x8 },
	'shuttermode' => { 104 => 0x1b },
	'shutterreleasebuttonae-l' => { 206 => '17.7', 208 => '16.1', 209 => '7.1', 210 => '17.5', 212 => '18.2' },
	'shutterreleasemethod' => { 77 => 0x1010 },
	'shutterreleasenocfcard' => { 62 => 0x2, 63 => 0x2, 70 => 0xf },
	'shutterreleasetiming' => { 77 => 0x1011 },
	'shutterspeedrange' => { 64 => 0x10c },
	'shutterspeedsetting' => { 140 => 0x6, 287 => 0x2f, 288 => 0x28, 289 => 0x0 },
	'shutterspeedvalue' => { 73 => 0x1, 90 => 0x9201, 218 => 0x1000, 316 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 326 => 'SidecarForExtension' },
	'similarityindex' => { 97 => 0xe4 },
	'singleframebracketing' => { 140 => 0x21 },
	'slaveflashmeteringsegments' => { 260 => 0x20b },
	'slowshutter' => { 58 => 0x8 },
	'slowsync' => { 94 => 0x1030 },
	'smartrange' => { 281 => 0xa012 },
	'smileshutter' => { 289 => 0x31 },
	'smileshuttermode' => { 289 => 0x27 },
	'smoothness' => { 90 => 0xfe57, 312 => 'Smoothness' },
	'softskineffect' => { 298 => 0x200f },
	'software' => { 90 => 0x131, 119 => 'Software', 224 => 'Software', 284 => 0x18, 333 => 'Software' },
	'softwareversion' => { 283 => 0x207 },
	'sonydatetime' => { 301 => 0x6 },
	'sonyimageheight' => { 301 => 0x1a },
	'sonyimagesize' => { 140 => 0x3b, 287 => 0x54, 288 => 0x54, 289 => 0x9 },
	'sonyimagewidth' => { 301 => 0x1c },
	'sonymodelid' => { 298 => 0xb001 },
	'sonyquality' => { 140 => 0x3c },
	'source' => { 97 => 0x73, 224 => 'Source', 313 => 'source', 314 => 'source', 326 => 'Source' },
	'sourcedirectoryindex' => { 248 => 0x0 },
	'sourcefileindex' => { 248 => 0x2 },
	'spatialfrequencyresponse' => { 316 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 316 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 316 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 316 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 316 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 337 => 'speakerPlacement' },
	'specialeffectlevel' => { 87 => 0x3030 },
	'specialeffectmode' => { 87 => 0x2076 },
	'specialeffectsetting' => { 87 => 0x3031 },
	'specialinstructions' => { 97 => 0x28 },
	'specialmode' => { 218 => 0x200, 283 => 0x200 },
	'spectralsensitivity' => { 90 => 0x8824, 316 => 'SpectralSensitivity' },
	'splittoningbalance' => { 312 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 312 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 312 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 312 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 312 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 137 => 0x2d },
	'spotfocuspointy' => { 137 => 0x2e },
	'spotmeteringmode' => { 25 => 0x27 },
	'spotmeterlinktoafpoint' => { 64 => 0x107 },
	'sractive' => { 242 => '17.1' },
	'srawquality' => { 25 => 0x2e },
	'srfocallength' => { 261 => 0x3 },
	'srhalfpresstime' => { 261 => 0x2 },
	'srresult' => { 261 => 0x0 },
	'standardoutputhighlightpoint' => { 83 => 0x14 },
	'standardoutputsensitivity' => { 90 => 0x8831 },
	'standardoutputshadowpoint' => { 83 => 0x15 },
	'standardrawcolortone' => { 83 => 0xd },
	'standardrawcontrast' => { 83 => 0xf },
	'standardrawhighlight' => { 83 => 0x75 },
	'standardrawhighlightpoint' => { 83 => 0x12 },
	'standardrawlinear' => { 83 => 0x10 },
	'standardrawsaturation' => { 83 => 0xe },
	'standardrawshadow' => { 83 => 0x7e },
	'standardrawshadowpoint' => { 83 => 0x13 },
	'standardrawsharpness' => { 83 => 0x11 },
	'standardunsharpmaskfineness' => { 83 => 0x94 },
	'standardunsharpmaskstrength' => { 83 => 0x92 },
	'standardunsharpmaskthreshold' => { 83 => 0x96 },
	'startingpage' => { 328 => 'startingPage' },
	'startmovieshooting' => { 64 => 0x70d },
	'starttimecode' => { 337 => 'startTimecode' },
	'starttimecodetimeformat' => { 337 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 337 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 337 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 123 => 'State', 232 => 0x6b, 326 => 'State' },
	'status' => { 307 => 'Status' },
	'storagemethod' => { 144 => 0x12 },
	'straightenangle' => { 199 => 0x2fc08431 },
	'stretchmode' => { 337 => 'stretchMode' },
	'studydatetime' => { 304 => 'StudyDateTime' },
	'studydescription' => { 304 => 'StudyDescription' },
	'studyid' => { 304 => 'StudyID' },
	'studyphysician' => { 304 => 'StudyPhysician' },
	'sub-location' => { 97 => 0x5c },
	'subfiledata' => { 126 => 'data' },
	'subfiledirectory' => { 126 => '1Directory' },
	'subfilemimetype' => { 126 => '2MIME' },
	'subfilename' => { 126 => '1Name' },
	'subfileresource' => { 126 => 'rsrc' },
	'subfiletype' => { 90 => 0xfe, 126 => '0Type' },
	'subject' => { 222 => 'Subject', 271 => 'Subject', 313 => 'subject', 325 => 'Subject', 338 => 'subject' },
	'subjectarea' => { 90 => 0x9214, 316 => 'SubjectArea' },
	'subjectcode' => { 320 => 'SubjectCode' },
	'subjectdistance' => { 90 => 0x9206, 104 => 0x3e, 316 => 'SubjectDistance' },
	'subjectdistancerange' => { 90 => 0xa40c, 316 => 'SubjectDistanceRange' },
	'subjectlocation' => { 90 => 0xa214, 316 => 'SubjectLocation' },
	'subjectprogram' => { 137 => 0x22 },
	'subjectreference' => { 97 => 0xc },
	'sublabels4' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 319 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 319 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 90 => 0x9290 },
	'subsectimedigitized' => { 90 => 0x9292 },
	'subsectimeoriginal' => { 90 => 0x9291 },
	'subsection1' => { 328 => 'subsection1' },
	'subsection2' => { 328 => 'subsection2' },
	'subsection3' => { 328 => 'subsection3' },
	'subsection4' => { 328 => 'subsection4' },
	'subversionfilename' => { 319 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 319 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 319 => 'SubVersions' },
	'superimposeddisplay' => { 62 => 0xa, 64 => 0x510, 65 => 0x9, 66 => 0xa, 69 => 0xa, 70 => 0xe },
	'supermacro' => { 47 => 0x1a },
	'supplementalcategories' => { 97 => 0x14, 326 => 'SupplementalCategories' },
	'supplementaltype' => { 99 => 0x37 },
	'svisosetting' => { 242 => 0x14 },
	'sweeppanoramadirection' => { 289 => 0x33 },
	'sweeppanoramasize' => { 289 => 0x32 },
	'switchtoregisteredafpoint' => { 63 => 0x12, 64 => 0x50a },
	'tagged' => { 266 => 0xdd, 308 => 'tagged' },
	'tagslist' => { 315 => 'TagsList' },
	'tagstructure' => { 319 => 'TagStructure' },
	'takenumber' => { 337 => 'takeNumber' },
	'tapename' => { 337 => 'tapeName' },
	'targetaperture' => { 58 => 0x4 },
	'targetcompressionratio' => { 75 => 0x1 },
	'targetdistancesetting' => { 77 => 0x1807 },
	'targetexposuretime' => { 58 => 0x5 },
	'targetimagetype' => { 77 => 0x100a },
	'teaser' => { 328 => 'teaser' },
	'teleconverter' => { 142 => 0x105, 298 => 0x105 },
	'tempo' => { 337 => 'tempo' },
	'termsandconditionstext' => { 327 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 327 => 'TermsAndConditionsURL' },
	'textencoding' => { 168 => 0x4 },
	'textlayername' => { 326 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 326 => 'TextLayers' },
	'textlayertext' => { 326 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 232 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 90 => 0x107 },
	'thumbnailfilename' => { 77 => 0x817 },
	'thumbnailformat' => { 335 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 106 => 0xfa55, 335 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 77 => 0x2008, 88 => 'ThumbnailImage', 92 => 0x3, 129 => 'data', 218 => 0x100, 335 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 129 => '1Name' },
	'thumbnailimagesize' => { 129 => 'ImageSize' },
	'thumbnailimagetype' => { 129 => '0Type' },
	'thumbnailimagevalidarea' => { 47 => 0x13 },
	'thumbnaillength' => { 90 => 0x202 },
	'thumbnailoffset' => { 90 => 0x201 },
	'thumbnails' => { 335 => 'Thumbnails' },
	'thumbnailwidth' => { 106 => 0xfa54, 335 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 328 => 'ticker' },
	'tilelength' => { 90 => 0x143 },
	'tilewidth' => { 90 => 0x142 },
	'time' => { 102 => 0x401, 260 => 0x7 },
	'timecreated' => { 97 => 0x3c, 104 => 0x14, 113 => 0x10, 267 => 'TimeCreated' },
	'timeperiod' => { 328 => 'timePeriod' },
	'timerfunctionbutton' => { 207 => '5.2', 208 => '12.1' },
	'timerlength' => { 64 => 0x80c },
	'timescaleparams' => { 337 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 337 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 337 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 337 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 98 => 0x50 },
	'timesignature' => { 337 => 'timeSignature' },
	'timesincepoweron' => { 232 => 0x29 },
	'timestamp' => { 8 => 0x45e, 16 => 0x11c, 224 => 'TimeStamp' },
	'timestamp1' => { 8 => 0x45a },
	'timezone' => { 59 => 0x1, 191 => 0x0 },
	'timezonecity' => { 59 => 0x2 },
	'timezonecode' => { 80 => 0x1 },
	'timezoneinfo' => { 80 => 0x2 },
	'timezoneoffset' => { 90 => 0x882a },
	'tint' => { 312 => 'Tint' },
	'title' => { 119 => 'Title', 222 => 'Title', 224 => 'Title', 232 => 0x65, 271 => 'Title', 313 => 'title', 325 => 'Title', 335 => 'Title' },
	'tonecomp' => { 169 => 0x81 },
	'tonecurve' => { 56 => 0x1, 260 => 0x402, 312 => 'ToneCurve' },
	'tonecurve1' => { 281 => 0xa040 },
	'tonecurve2' => { 281 => 0xa041 },
	'tonecurve3' => { 281 => 0xa042 },
	'tonecurve4' => { 281 => 0xa043 },
	'tonecurveactive' => { 82 => 0x110 },
	'tonecurveblue' => { 312 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 302 => 0x9003 },
	'tonecurvebluey' => { 302 => 0x9007 },
	'tonecurvebrightnessx' => { 302 => 0x9000 },
	'tonecurvebrightnessy' => { 302 => 0x9004 },
	'tonecurvefilename' => { 102 => 0x1391 },
	'tonecurvegreen' => { 312 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 302 => 0x9002 },
	'tonecurvegreeny' => { 302 => 0x9006 },
	'tonecurveinterpolation' => { 82 => 0x159 },
	'tonecurvemode' => { 82 => 0x113 },
	'tonecurvename' => { 312 => 'ToneCurveName' },
	'tonecurvename2012' => { 312 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 82 => 0x3c },
	'tonecurvepv2012' => { 312 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 312 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 312 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 312 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 312 => 'ToneCurveRed' },
	'tonecurveredx' => { 302 => 0x9001 },
	'tonecurveredy' => { 302 => 0x9005 },
	'tonecurves' => { 260 => 0x403 },
	'toningeffect' => { 42 => 0xf, 169 => 0xb3, 171 => 0x38 },
	'toningeffectfaithful' => { 52 => 0x74, 53 => 0x74 },
	'toningeffectlandscape' => { 52 => 0x44, 53 => 0x44 },
	'toningeffectmonochrome' => { 16 => 0x108, 52 => 0x8c, 53 => 0x8c },
	'toningeffectneutral' => { 52 => 0x5c, 53 => 0x5c },
	'toningeffectportrait' => { 52 => 0x2c, 53 => 0x2c },
	'toningeffectstandard' => { 52 => 0x14, 53 => 0x14 },
	'toningeffectunknown' => { 53 => 0xa4 },
	'toningeffectuserdef1' => { 52 => 0xa4, 53 => 0xbc },
	'toningeffectuserdef2' => { 52 => 0xbc, 53 => 0xd4 },
	'toningeffectuserdef3' => { 52 => 0xd4, 53 => 0xec },
	'toningsaturation' => { 171 => 0x39 },
	'totalzoom' => { 104 => 0x62 },
	'tracknumber' => { 337 => 'trackNumber' },
	'tracks' => { 337 => 'Tracks' },
	'tracksframerate' => { 337 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 337 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 337 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 337 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 337 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 337 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 337 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 337 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 337 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 337 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 337 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 337 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 337 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 337 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 337 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 337 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 337 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 126 => 'zmie' },
	'transferfunction' => { 90 => 0x12d, 333 => 'TransferFunction' },
	'transform' => { 232 => [0x8012,0x59] },
	'transmissionreference' => { 326 => 'TransmissionReference' },
	'trapped' => { 222 => 'Trapped', 325 => 'Trapped' },
	'travelday' => { 232 => 0x36 },
	'triggermode' => { 272 => 0x6 },
	'ttl_da_adown' => { 249 => 0x5 },
	'ttl_da_aup' => { 249 => 0x4 },
	'ttl_da_bdown' => { 249 => 0x7 },
	'ttl_da_bup' => { 249 => 0x6 },
	'tungstenawb' => { 239 => 0x1 },
	'tvexposuretimesetting' => { 242 => 0x12 },
	'type' => { 313 => 'type', 332 => 'type' },
	'uniquecameramodel' => { 90 => 0xc614 },
	'uniquedocumentid' => { 97 => 0xbb },
	'uniqueobjectname' => { 98 => 0x64 },
	'unknownblock' => { 217 => 0x1103 },
	'unknowncontrast' => { 83 => 0x45 },
	'unknownev' => { 102 => 0x1 },
	'unknownlinear' => { 83 => 0x46 },
	'unknownnumber' => { 77 => 0x180b, 116 => [0xa8,0xc4] },
	'unknownoutputhighlightpoint' => { 83 => 0x4a },
	'unknownoutputshadowpoint' => { 83 => 0x4b },
	'unknownrawhighlight' => { 83 => 0x7b },
	'unknownrawhighlightpoint' => { 83 => 0x48 },
	'unknownrawshadow' => { 83 => 0x84 },
	'unknownrawshadowpoint' => { 83 => 0x49 },
	'unknownsharpness' => { 83 => 0x47 },
	'unsharp1color' => { 204 => 0x13 },
	'unsharp1halowidth' => { 204 => 0x19 },
	'unsharp1intensity' => { 204 => 0x17 },
	'unsharp1threshold' => { 204 => 0x1b },
	'unsharp2color' => { 204 => 0x2e },
	'unsharp2halowidth' => { 204 => 0x34 },
	'unsharp2intensity' => { 204 => 0x32 },
	'unsharp2threshold' => { 204 => 0x36 },
	'unsharp3color' => { 204 => 0x49 },
	'unsharp3halowidth' => { 204 => 0x4f },
	'unsharp3intensity' => { 204 => 0x4d },
	'unsharp3threshold' => { 204 => 0x51 },
	'unsharp4color' => { 204 => 0x64 },
	'unsharp4halowidth' => { 204 => 0x6a },
	'unsharp4intensity' => { 204 => 0x68 },
	'unsharp4threshold' => { 204 => 0x6c },
	'unsharpcount' => { 204 => 0x0 },
	'unsharpmask' => { 83 => 0x90, 199 => 0x76a43200 },
	'urgency' => { 97 => 0xa, 326 => 'Urgency' },
	'url' => { 119 => 'URL', 224 => 'URL', 269 => 0x40b, 328 => 'url' },
	'usablemeteringmodes' => { 64 => 0x10a },
	'usableshootingmodes' => { 64 => 0x109 },
	'usage' => { 329 => 'usage' },
	'usagefee' => { 330 => 'usageFee' },
	'usageterms' => { 341 => 'UsageTerms' },
	'useguidelines' => { 310 => 'useGuidelines' },
	'usercomment' => { 77 => 0x805, 90 => 0x9286, 316 => 'UserComment' },
	'userdef1picturestyle' => { 16 => 0x10c, 52 => 0xd8, 53 => 0xf0 },
	'userdef2picturestyle' => { 16 => 0x10e, 52 => 0xda, 53 => 0xf2 },
	'userdef3picturestyle' => { 16 => 0x110, 52 => 0xdc, 53 => 0xf4 },
	'userfields' => { 307 => 'UserFields' },
	'userlabel' => { 272 => 0x2b },
	'userprofile' => { 228 => 0x302, 234 => 0x3038 },
	'usmlenselectronicmf' => { 63 => 0x7, 64 => 0x501 },
	'utmeasting' => { 130 => 'Easting' },
	'utmmapdatum' => { 130 => 'Datum' },
	'utmnorthing' => { 130 => 'Northing' },
	'utmzone' => { 130 => 'Zone' },
	'uv-irfiltercorrection' => { 228 => 0x325 },
	'validbits' => { 217 => 0x611, 218 => 0x102c },
	'validpixeldepth' => { 221 => 0x611 },
	'variousmodes' => { 104 => 0x26 },
	'variousmodes2' => { 104 => 0x3a },
	'variprogram' => { 169 => 0xab },
	'version' => { 94 => 0x0, 271 => 'Version', 312 => 'Version' },
	'versioncreatedate' => { 302 => 0xd100 },
	'versionid' => { 338 => 'VersionID' },
	'versionidentifier' => { 328 => 'versionIdentifier' },
	'versionmodifydate' => { 302 => 0xd101 },
	'versions' => { 338 => 'Versions' },
	'versionscomments' => { 338 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 338 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 338 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 338 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 338 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 338 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 338 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 338 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 338 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 338 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 338 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 206 => '3.2' },
	'vfdisplayillumination' => { 64 => 0x510 },
	'vibrance' => { 312 => 'Vibrance' },
	'vibrationreduction' => { 175 => [0x75,0x82,0x1ae], 183 => '586.1', 187 => '590.2', 190 => 0x4 },
	'videoalphamode' => { 337 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 337 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 337 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 337 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 50 => 0x74 },
	'videocolorspace' => { 337 => 'videoColorSpace' },
	'videocompressor' => { 337 => 'videoCompressor' },
	'videofieldorder' => { 337 => 'videoFieldOrder' },
	'videoframerate' => { 337 => 'videoFrameRate' },
	'videoframesize' => { 337 => 'videoFrameSize' },
	'videoframesizeh' => { 337 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 337 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 337 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 337 => 'videoModDate' },
	'videopixelaspectratio' => { 337 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 337 => 'videoPixelDepth' },
	'videoquality' => { 87 => 0x4003 },
	'viewfinderdisplay' => { 206 => '12.4' },
	'viewfinderwarning' => { 206 => '13.4', 210 => '3.5', 211 => '6.2', 212 => '4.4' },
	'viewfinderwarnings' => { 64 => 0x40a },
	'viewinfoduringexposure' => { 64 => 0x407 },
	'viewingmode' => { 289 => 0x2f, 299 => 0x18 },
	'viewingmode2' => { 289 => 0x85 },
	'vignetteamount' => { 312 => 'VignetteAmount' },
	'vignettecontrol' => { 169 => 0x2a, 199 => 0x76a43205 },
	'vignettecontrolintensity' => { 199 => 0xac6bd5c0 },
	'vignettemidpoint' => { 312 => 'VignetteMidpoint' },
	'vignettingcorrection' => { 298 => 0x2011 },
	'voicememo' => { 283 => 0x216 },
	'volume' => { 328 => 'volume' },
	'vr_0x66' => { 175 => 0x66 },
	'vrdoffset' => { 47 => 0xd0 },
	'wb_bluelevel3500k' => { 143 => 0x19a },
	'wb_bluelevel6500k' => { 143 => 0x18a },
	'wb_bluelevelcustom' => { 143 => 0x18e },
	'wb_bluelevelscloudy' => { 143 => 0x106 },
	'wb_bluelevelsdaylight' => { 143 => 0xea },
	'wb_bluelevelsflash' => { 143 => 0x122 },
	'wb_bluelevelsfluorescent' => { 143 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 143 => 0x254 },
	'wb_bluelevelsshade' => { 143 => 0x176 },
	'wb_bluelevelstungsten' => { 143 => 0xce },
	'wb_gbrglevels' => { 143 => 0xae, 146 => 0x4 },
	'wb_glevel' => { 217 => 0x11f },
	'wb_glevel3000k' => { 217 => 0x113 },
	'wb_glevel3300k' => { 217 => 0x114 },
	'wb_glevel3600k' => { 217 => 0x115 },
	'wb_glevel3900k' => { 217 => 0x116 },
	'wb_glevel4000k' => { 217 => 0x117 },
	'wb_glevel4300k' => { 217 => 0x118 },
	'wb_glevel4500k' => { 217 => 0x119 },
	'wb_glevel4800k' => { 217 => 0x11a },
	'wb_glevel5300k' => { 217 => 0x11b },
	'wb_glevel6000k' => { 217 => 0x11c },
	'wb_glevel6600k' => { 217 => 0x11d },
	'wb_glevel7500k' => { 217 => 0x11e },
	'wb_grbglevels' => { 154 => 0x0 },
	'wb_rbgglevels' => { 151 => 0x0 },
	'wb_rblevels' => { 169 => 0xc, 217 => 0x100 },
	'wb_rblevels3000k' => { 217 => 0x102 },
	'wb_rblevels3300k' => { 217 => 0x103 },
	'wb_rblevels3500k' => { 143 => 0x430 },
	'wb_rblevels3600k' => { 217 => 0x104 },
	'wb_rblevels3900k' => { 217 => 0x105 },
	'wb_rblevels4000k' => { 217 => 0x106 },
	'wb_rblevels4300k' => { 217 => 0x107 },
	'wb_rblevels4500k' => { 217 => 0x108 },
	'wb_rblevels4800k' => { 217 => 0x109 },
	'wb_rblevels5300k' => { 217 => 0x10a },
	'wb_rblevels6000k' => { 217 => 0x10b },
	'wb_rblevels6500k' => { 143 => 0x420 },
	'wb_rblevels6600k' => { 217 => 0x10c },
	'wb_rblevels7500k' => { 217 => 0x10d },
	'wb_rblevelsauto' => { 221 => 0x110 },
	'wb_rblevelscloudy' => { 143 => 0x3f0, 145 => 0x10, 221 => 0x121 },
	'wb_rblevelscoolwhitef' => { 143 => 0x308, 145 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 221 => 0x132 },
	'wb_rblevelscustom' => { 143 => 0x424 },
	'wb_rblevelscwb1' => { 217 => 0x10e },
	'wb_rblevelscwb2' => { 217 => 0x10f },
	'wb_rblevelscwb3' => { 217 => 0x110 },
	'wb_rblevelscwb4' => { 217 => 0x111 },
	'wb_rblevelsdaylight' => { 143 => [0x3ec,0x528], 145 => 0xc },
	'wb_rblevelsdaylightf' => { 145 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 221 => 0x130 },
	'wb_rblevelsdaywhitef' => { 145 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 221 => 0x131 },
	'wb_rblevelseveningsunlight' => { 221 => 0x124 },
	'wb_rblevelsfineweather' => { 221 => 0x122 },
	'wb_rblevelsflash' => { 143 => [0x3f4,0x304], 145 => 0x18 },
	'wb_rblevelsshade' => { 143 => 0x418, 145 => 0x20, 221 => 0x120 },
	'wb_rblevelstungsten' => { 143 => 0x3e8, 145 => 0x8, 221 => 0x123 },
	'wb_rblevelsunknown' => { 145 => 0x1c },
	'wb_rblevelsused' => { 221 => 0x100 },
	'wb_rblevelswhitef' => { 145 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 221 => 0x133 },
	'wb_redlevel3500k' => { 143 => 0x198 },
	'wb_redlevel6500k' => { 143 => 0x188 },
	'wb_redlevelcustom' => { 143 => 0x18c },
	'wb_redlevelscloudy' => { 143 => 0xf8 },
	'wb_redlevelsdaylight' => { 143 => 0xdc },
	'wb_redlevelsflash' => { 143 => 0x114 },
	'wb_redlevelsfluorescent' => { 143 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 143 => 0x1be },
	'wb_redlevelsshade' => { 143 => 0x168 },
	'wb_redlevelstungsten' => { 143 => 0xc0 },
	'wb_rgbglevels' => { 153 => 0x0 },
	'wb_rgblevels' => { 143 => [0x546,0x96], 229 => 0xd, 230 => 0x413, 234 => 0x3036 },
	'wb_rggblevels' => { 146 => 0x4, 152 => 0x0 },
	'wb_rggblevelsasshot' => { 28 => 0x0, 29 => 0x19, 30 => 0x22, 31 => 0x3f, 34 => 0x3f, 35 => 0x3f },
	'wb_rggblevelsauto' => { 26 => 0x0, 28 => 0x5, 29 => 0x1e, 30 => 0x18, 31 => 0x44, 34 => 0x44, 35 => 0x44, 281 => 0xa022 },
	'wb_rggblevelsblack' => { 281 => 0xa028 },
	'wb_rggblevelscloudy' => { 26 => 0xc, 28 => 0x1e, 29 => 0x2d, 30 => 0x31, 31 => 0x58, 34 => 0x71, 35 => 0x71, 260 => 0x20f },
	'wb_rggblevelscustom' => { 26 => 0x1c, 31 => 0x80 },
	'wb_rggblevelscustom1' => { 29 => 0x41 },
	'wb_rggblevelscustom2' => { 29 => 0x46 },
	'wb_rggblevelsdaylight' => { 26 => 0x4, 28 => 0x14, 29 => 0x23, 30 => 0x27, 31 => 0x4e, 34 => 0x67, 35 => 0x67, 260 => 0x20d },
	'wb_rggblevelsflash' => { 26 => 0x18, 28 => 0x32, 29 => 0x3c, 30 => 0x45, 31 => 0x6c, 34 => 0x85, 35 => 0x85, 260 => 0x214 },
	'wb_rggblevelsfluorescent' => { 26 => 0x14, 28 => 0x28, 29 => 0x37, 30 => 0x3b, 31 => 0x62, 34 => 0x7b, 35 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 260 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 260 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 260 => 0x213 },
	'wb_rggblevelsilluminator1' => { 281 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 281 => 0xa024 },
	'wb_rggblevelskelvin' => { 26 => 0x20, 28 => 0x2d, 30 => 0x40, 31 => 0x67, 34 => 0x80, 35 => 0x80 },
	'wb_rggblevelsmeasured' => { 28 => 0xa, 31 => 0x49, 34 => 0x49, 35 => 0x49 },
	'wb_rggblevelspc1' => { 30 => 0x90, 31 => 0x71 },
	'wb_rggblevelspc2' => { 30 => 0x95, 31 => 0x76 },
	'wb_rggblevelspc3' => { 30 => 0x9a, 31 => 0x7b },
	'wb_rggblevelsshade' => { 26 => 0x8, 28 => 0x19, 29 => 0x28, 30 => 0x2c, 31 => 0x53, 34 => 0x6c, 35 => 0x6c, 260 => 0x20e },
	'wb_rggblevelstungsten' => { 26 => 0x10, 28 => 0x23, 29 => 0x32, 30 => 0x36, 31 => 0x5d, 34 => 0x76, 35 => 0x76, 260 => 0x210 },
	'wb_rggblevelsuncorrected' => { 281 => 0xa021 },
	'wb_rggblevelsunknown' => { 28 => 0xf, 30 => 0x1d, 34 => 0x4e, 35 => 0x4e },
	'wb_rggblevelsunknown10' => { 28 => 0x5f, 30 => 0x72, 34 => 0x9e, 35 => 0x9e },
	'wb_rggblevelsunknown11' => { 28 => 0x64, 30 => 0x77, 34 => 0xa3, 35 => 0xa3 },
	'wb_rggblevelsunknown12' => { 28 => 0x69, 30 => 0x7c, 34 => 0xa8, 35 => 0xa8 },
	'wb_rggblevelsunknown13' => { 28 => 0x6e, 30 => 0x81, 34 => 0xad, 35 => 0xad },
	'wb_rggblevelsunknown14' => { 30 => 0x86, 34 => 0xb2, 35 => 0xb2 },
	'wb_rggblevelsunknown15' => { 30 => 0x8b, 34 => 0xb7, 35 => 0xb7 },
	'wb_rggblevelsunknown16' => { 30 => 0x9f, 35 => 0xbc },
	'wb_rggblevelsunknown17' => { 35 => 0xc1 },
	'wb_rggblevelsunknown18' => { 35 => 0xc6 },
	'wb_rggblevelsunknown19' => { 35 => 0xcb },
	'wb_rggblevelsunknown2' => { 28 => 0x37, 30 => 0x4a, 34 => 0x53, 35 => 0x53 },
	'wb_rggblevelsunknown20' => { 35 => 0xd0 },
	'wb_rggblevelsunknown3' => { 28 => 0x3c, 30 => 0x4f, 34 => 0x58, 35 => 0x58 },
	'wb_rggblevelsunknown4' => { 28 => 0x41, 30 => 0x54, 34 => 0x5d, 35 => 0x5d },
	'wb_rggblevelsunknown5' => { 28 => 0x46, 30 => 0x59, 34 => 0x62, 35 => 0x62 },
	'wb_rggblevelsunknown6' => { 28 => 0x4b, 30 => 0x5e, 34 => 0x8a, 35 => 0x8a },
	'wb_rggblevelsunknown7' => { 28 => 0x50, 30 => 0x63, 34 => 0x8f, 35 => 0x8f },
	'wb_rggblevelsunknown8' => { 28 => 0x55, 30 => 0x68, 34 => 0x94, 35 => 0x94 },
	'wb_rggblevelsunknown9' => { 28 => 0x5a, 30 => 0x6d, 34 => 0x99, 35 => 0x99 },
	'wbadjbluebalance' => { 205 => 0x8 },
	'wbadjcolortemp' => { 82 => 0x1a },
	'wbadjlighting' => { 205 => 0x15 },
	'wbadjlightingsubtype' => { 205 => 0x14 },
	'wbadjmode' => { 205 => 0x10 },
	'wbadjredbalance' => { 205 => 0x0 },
	'wbadjrggblevels' => { 82 => 0x6 },
	'wbadjtemperature' => { 205 => 0x18 },
	'wbadjtint' => { 205 => 0x25 },
	'wbbluelevel' => { 228 => 0x324, 232 => 0x8006, 236 => 0x26 },
	'wbbracketmode' => { 42 => 0x9 },
	'wbbracketshotnumber' => { 143 => 0x2b },
	'wbbracketvalueab' => { 42 => 0xc },
	'wbbracketvaluegm' => { 42 => 0xd },
	'wbfinetuneactive' => { 82 => 0x24 },
	'wbfinetunesaturation' => { 82 => 0x28 },
	'wbfinetunetone' => { 82 => 0x2c },
	'wbgreenlevel' => { 228 => 0x323, 232 => 0x8005, 236 => 0x25 },
	'wbmediaimagesizesetting' => { 64 => 0x708 },
	'wbmode' => { 145 => 0x4, 218 => 0x1015 },
	'wbredlevel' => { 228 => 0x322, 232 => 0x8004, 236 => 0x24 },
	'wbscale' => { 146 => 0x0 },
	'wbshiftab' => { 56 => 0xc, 232 => 0x46, 243 => 0x10 },
	'wbshiftab_gm' => { 298 => 0x2014 },
	'wbshiftgm' => { 56 => 0xd, 232 => 0x47, 243 => 0x11 },
	'webstatement' => { 341 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0xb5, 7 => 0x36, 8 => 0x5e, 9 => 0x36, 10 => 0x78, 11 => 0x6f, 12 => 0x6f, 13 => 0x73, 14 => 0x6f, 15 => 0x78, 16 => 0x54, 17 => 0x6f, 18 => 0xbc, 19 => 0x7b, 21 => 0x77, 56 => 0x8, 58 => 0x7, 86 => 0x7, 87 => [0x19,0x2012], 90 => [0xa403,0xfe4e], 94 => 0x1002, 102 => 0x3fc, 103 => 0xfa0d, 104 => 0x40, 137 => 0x3, 138 => 0xe, 139 => 0x4, 140 => 0xb, 142 => 0x115, 169 => 0x5, 189 => 0x7, 228 => 0x304, 232 => 0x3, 234 => 0x3033, 260 => 0x19, 265 => 0x7, 275 => 0x26, 284 => [0x3c,0x7,0x58], 298 => [0x115,0xb054], 312 => 'WhiteBalance', 316 => 'WhiteBalance' },
	'whitebalance2' => { 213 => 0x500 },
	'whitebalanceadj' => { 82 => 0x18, 199 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 239 => 0x0 },
	'whitebalancebias' => { 87 => 0x2011, 218 => 0x304, 232 => 0x23 },
	'whitebalanceblue' => { 56 => 0x7 },
	'whitebalancebracket' => { 213 => 0x502, 218 => 0x303 },
	'whitebalancebracketing' => { 140 => 0x22, 143 => 0x2c, 297 => 0x2c },
	'whitebalancecomp' => { 221 => 0x1001 },
	'whitebalancefinetune' => { 94 => 0x100a, 140 => 0x38, 142 => 0x112, 169 => 0xb, 287 => 0x6, 298 => 0x112 },
	'whitebalancemode' => { 260 => 0x1a },
	'whitebalancered' => { 56 => 0x6 },
	'whitebalanceset' => { 242 => 0xa },
	'whitebalancesetting' => { 140 => 0x23, 289 => 0x16, 299 => 0xd },
	'whitebalancetemperature' => { 213 => 0x501 },
	'whiteboard' => { 218 => 0x301 },
	'whitelevel' => { 90 => 0xc61d },
	'whitepoint' => { 90 => 0x13e, 260 => 0x201, 333 => 'WhitePoint' },
	'whites2012' => { 312 => 'Whites2012' },
	'widefocuszone' => { 137 => 0x2f },
	'widerange' => { 283 => 0x20f },
	'wordcount' => { 328 => 'wordCount' },
	'workcolorspace' => { 82 => 0x270 },
	'worktodo' => { 317 => 'WorkToDo' },
	'worldtimelocation' => { 232 => 0x3a, 260 => 0x22, 264 => '0.1' },
	'writer-editor' => { 97 => 0x7a },
	'x3filllight' => { 284 => 0x12 },
	'xmp' => { 81 => 0xffff00f6, 91 => 'XMP' },
	'xmptoolkit' => { 334 => 'xmptk' },
	'xpauthor' => { 90 => 0x9c9d },
	'xpcomment' => { 90 => 0x9c9c },
	'xpkeywords' => { 90 => 0x9c9e },
	'xposition' => { 90 => 0x11e },
	'xpsubject' => { 90 => 0x9c9f },
	'xptitle' => { 90 => 0x9c9b },
	'xresolution' => { 90 => 0x11a, 100 => 0x3, 270 => 0x0, 333 => 'XResolution' },
	'xyresolution' => { 93 => 0x3 },
	'ycbcrcoefficients' => { 90 => 0x211, 333 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 90 => 0x213, 333 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 90 => 0x212, 333 => 'YCbCrSubSampling' },
	'yearcreated' => { 104 => 0x10, 113 => 0xc },
	'yposition' => { 90 => 0x11f },
	'yresolution' => { 90 => 0x11b, 100 => 0x5, 270 => 0x4, 333 => 'YResolution' },
	'zonematching' => { 142 => 0x10a, 145 => [0x3a,0x4a], 298 => 0xb024 },
	'zonematchingmode' => { 140 => 0x14 },
	'zonematchingon' => { 139 => 0x75 },
	'zonematchingvalue' => { 287 => 0x1f },
	'zoomedpreviewlength' => { 218 => 0xf05 },
	'zoomedpreviewsize' => { 218 => 0xf06 },
	'zoomedpreviewstart' => { 218 => 0xf04 },
	'zoomsourcewidth' => { 25 => 0x24 },
	'zoomstepcount' => { 216 => 0x300, 218 => 0x100d },
	'zoomtargetwidth' => { 25 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'35mmfocallength' => 1,
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfounknown' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationiterations' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfoa100' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperturedimensions' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0104' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'framewidth' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'givenname' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'participants' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'readstatus' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyrictext' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userlastplayedtime' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8version' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grblevels' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtra' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2012, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
