<?php

/**
 * IMPORTANT WARNING: DO NOT MODIFY THIS FILE.
 */

/**
 * Google Fonts
 * This file in included in the core theme to ease management
 * and updates to the font families. Google add new fonts on
 * a regular basis and we will provide patches and updates
 * for this file periodically.
 *
 * Last update: 6/11/2011
 */

// Build an array of Google web fonts
function google_web_fonts_list() {
  return array(
    'Abel',
    'Abril Fatface',
    'Aclonica',
    'Actor',
    'Adamina',
    'Aldrich',
    'Alice',
    'Alike',
    'Allan',
    'Allerta',
    'Allerta Stencil',
    'Amaranth',
    'Andika',
    'Angkor',
    'Annie Use Your Telescope',
    'Anonymous Pro',
    'Antic',
    'Anton',
    'Arapey',
    'Architects Daughter',
    'Arimo',
    'Artifika',
    'Arvo',
    'Asset',
    'Astloch',
    'Atomic Age',
    'Aubrey',
    'Bangers',
    'Battambang',
    'Bayon',
    'Bentham',
    'Bevan',
    'Bigshot One',
    'Black Ops One',
    'Bokor',
    'Bowlby One',
    'Bowlby One SC',
    'Brawler',
    'Buda',
    'Butcherman Caps',
    'Cabin',
    'Cabin Sketch',
    'Calligraffitti',
    'Candal',
    'Cantarell',
    'Cardo',
    'Carme',
    'Carter One',
    'Caudex',
    'Cedarville Cursive',
    'Changa One',
    'Chenla',
    'Cherry Cream Soda',
    'Chewy',
    'Chivo',
    'Coda',
    'Coda Caption',
    'Comfortaa',
    'Coming Soon',
    'Content',
    'Contrail One',
    'Cookie',
    'Copse',
    'Corben',
    'Cousine',
    'Coustard',
    'Covered By Your Grace',
    'Crafty Girls',
    'Creepster Caps',
    'Crimson Text',
    'Crushed',
    'Cuprum',
    'Damion',
    'Dancing Script',
    'Dangrek',
    'Dawning of a New Day',
    'Days One',
    'Delius',
    'Delius Swash Caps',
    'Delius Unicase',
    'Didact Gothic',
    'Dorsa',
    'Droid Sans',
    'Droid Sans Mono',
    'Droid Serif',
    'EB Garamond',
    'Eater Caps',
    'Expletus Sans',
    'Fanwood Text',
    'Federant',
    'Federo',
    'Fjord One',
    'Fontdiner Swanky',
    'Forum',
    'Francois One',
    'Freehand',
    'Gentium Basic',
    'Gentium Book Basic',
    'Geo',
    'Geostar',
    'Geostar Fill',
    'GFS Didot',
    'GFS Neohellenic',
    'Give You Glory',
    'Gloria Hallelujah',
    'Goblin One',
    'Gochi Hand',
    'Goudy Bookletter 1911',
    'Gravitas One',
    'Gruppo',
    'Hammersmith One',
    'Hanuman',
    'Holtwood One SC',
    'Homemade Apple',
    'IM Fell DW Pica',
    'IM Fell DW Pica SC',
    'IM Fell Double Pica',
    'IM Fell Double Pica SC',
    'IM Fell English',
    'IM Fell English SC',
    'IM Fell French Canon',
    'IM Fell French Canon SC',
    'IM Fell Great Primer',
    'IM Fell Great Primer SC',
    'Inconsolata',
    'Indie Flower',
    'Irish Grover',
    'Istok Web',
    'Jockey One',
    'Josefin Sans',
    'Josefin Slab',
    'Judson',
    'Julee',
    'Jura',
    'Just Another Hand',
    'Just Me Again Down Here',
    'Kameron',
    'Kelly Slab',
    'Kenia',
    'Khmer',
    'Koulen',
    'Kranky',
    'Kreon',
    'Kristi',
    'La Belle Aurore',
    'Lancelot',
    'Lato',
    'League Script',
    'Leckerli One',
    'Lekton',
    'Limelight',
    'Linden Hill',
    'Lobster',
    'Lobster Two',
    'Lora',
    'Love Ya Like A Sister',
    'Loved by the King',
    'Luckiest Guy',
    'Maiden Orange',
    'Mako',
    'Marck Script',
    'Marvel',
    'Mate',
    'Mate SC',
    'Maven Pro',
    'Meddon',
    'MedievalSharp',
    'Megrim',
    'Merienda One',
    'Merriweather',
    'Metal',
    'Metrophobic',
    'Michroma',
    'Miltonian',
    'Miltonian Tattoo',
    'Modern Antiqua',
    'Molengo',
    'Monofett',
    'Monoton',
    'Montez',
    'Moul',
    'Moulpali',
    'Mountains of Christmas',
    'Muli',
    'Neucha',
    'Neuton',
    'News Cycle',
    'Nixie One',
    'Nobile',
    'Nosifer Caps',
    'Nothing You Could Do',
    'Nova Cut',
    'Nova Flat',
    'Nova Mono',
    'Nova Oval',
    'Nova Round',
    'Nova Script',
    'Nova Slim',
    'Nova Square',
    'Numans',
    'Nunito',
    'Odor Mean Chey',
    'Old Standard TT',
    'Open Sans',
    'Open Sans Condensed',
    'Orbitron',
    'Oswald',
    'Over the Rainbow',
    'Ovo',
    'PT Sans',
    'PT Sans Caption',
    'PT Sans Narrow',
    'PT Serif',
    'PT Serif Caption',
    'Pacifico',
    'Passero One',
    'Patrick Hand',
    'Paytone One',
    'Permanent Marker',
    'Petrona',
    'Philosopher',
    'Pinyon Script',
    'Play',
    'Playfair Display',
    'Podkova',
    'Poller One',
    'Poly',
    'Pompiere',
    'Prata',
    'Preahvihear',
    'Prociono',
    'Puritan',
    'Quattrocento',
    'Quattrocento Sans',
    'Questrial',
    'Quicksand',
    'Quicksand Light',
    'Quicksand Bold',
    'Radley',
    'Raleway',
    'Rammetto One',
    'Rancho',
    'Rationale',
    'Redressed',
    'Reenie Beanie',
    'Rochester',
    'Rock Salt',
    'Rokkitt',
    'Rosario',
    'Ruslan Display',
    'Salsa',
    'Sancreek',
    'Sansita One',
    'Satisfy',
    'Schoolbell',
    'Shadows Into Light',
    'Shanti',
    'Short Stack',
    'Siemreap',
    'Sigmar One',
    'Six Caps',
    'Slackey',
    'Smokum',
    'Smythe',
    'Sniglet',
    'Snippet',
    'Sorts Mill Goudy',
    'Special Elite',
    'Spinnaker',
    'Stardos Stencil',
    'Sue Ellen Francisco',
    'Sunshiney',
    'Supermercado One',
    'Suwannaphum',
    'Swanky and Moo Moo',
    'Syncopate',
    'Tangerine',
    'Taprom',
    'Tenor Sans',
    'Terminal Dosis',
    'Terminal Dosis Light',
    'The Girl Next Door',
    'Tienne',
    'Tinos',
    'Tulpen One',
    'Ubuntu',
    'Ubuntu Condensed',
    'Ubuntu Mono',
    'Ultra',
    'UnifrakturCook',
    'UnifrakturMaguntia',
    'Unkempt',
    'Unna',
    'VT323',
    'Varela',
    'Varela Round',
    'Vast Shadow',
    'Vibur',
    'Vidaloka',
    'Volkhov',
    'Vollkorn',
    'Voltaire',
    'Waiting for the Sunrise',
    'Wallpoet',
    'Walter Turncoat',
    'Wire One',
    'Yanone Kaffeesatz',
    'Yellowtail',
    'Yeseva One',
    'Zeyada',
  );
}

// Return a list of options
function google_web_fonts_list_options() {
  global $_google_web_font_families;
  if ($_google_web_font_families) {
    return $_google_web_font_families;
  }
  $_google_web_font_families = array();
  $font_families = google_web_fonts_list();
  foreach ($font_families as $ff) {
    $_google_web_font_families[$ff] = $ff;
  }
  return $_google_web_font_families;
}

// Return the style name
function google_web_fonts_get_style_name($key, $font_type, $font_value) {
  $font_value = trim($font_value);
  $font_value = strtolower($font_value);
  $font_value = str_replace(' ', '-', $font_value);
  return $key . (!empty($font_type) ? '-' . $font_type :  "") . "-" . $font_value;
}

// Process font families, this is not specific to Google fonts but makes sense including it here
function get_font_families($fonts, $theme_name) {
  $google_font_families = array();
  $font_type = '';
  $font_families = array();
  foreach ($fonts as $key => $value) {
    $font_type = theme_get_setting($value . '_type', $theme_name);
    $font_value = theme_get_setting($value . (!empty($font_type) ? '_' . $font_type : ''), $theme_name);
    if ($font_type == '') {
      $font_families[] = $font_value;
    }
    else {
      if ($font_type == 'gwf') {
        $gff = str_replace(' ', '+', $font_value);
        $google_font_families[] = $gff;
        $font_value = preg_replace('/[^\w\d_ -]/si', '', $font_value);
        $style_name = google_web_fonts_get_style_name($key, $font_type, $font_value);
        $font_families[] = $style_name;
        switch ($key) {
          case 'bf':
            drupal_add_css("body.$style_name, .$style_name .form-text {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'snf':
            drupal_add_css("body.$style_name #site-name {font-family : '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'ssf':
            drupal_add_css("body.$style_name #site-slogan {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'mmf':
            drupal_add_css(".$style_name #nav-wrapper {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'ptf':
            drupal_add_css("body.$style_name #page-title {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'ntf':
            drupal_add_css("body.$style_name .article-title {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'ctf':
            drupal_add_css("body.$style_name .comment-title {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
          case 'btf':
            drupal_add_css("body.$style_name .block-title {font-family: '" . $font_value . "'}", array('group' => CSS_DEFAULT, 'type' => 'inline'));
            break;
        }
      }
    }
  }
  if (!empty($google_font_families)) {
    $array = array_unique($google_font_families);
    $google_fonts = trim(implode('|', $array));
    drupal_add_css('//fonts.googleapis.com/css?family=' . $google_fonts, array(
      'group' => CSS_THEME,
      'type' => 'external',
      'weight' => -1,
      'preprocess' => FALSE,
      )
    );
  }
  return $font_families;
}
