C      $Id: x07f.fm4 7917 2007-10-01 02:53:41Z airwin $
C      Displays the plotter symbols for PLSYM
C
C      Copyright (C) 2004  Alan W. Irwin
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

      implicit none

      character*4 text

      integer i, j, k, l, base(17)
      data base /   0, 200, 500, 600, 700, 800, 900,
     &  2000,2100,2200,2300,2400,2500,2600,
     &  2700,2800,2900 /
      real*8 x, y
      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)
C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)

C      Full sized page for display

      call plinit()
      call plfontld(1)
      do l=1,17
        call pladv(0)

        call plcol0(2)

C        Set up viewport and window

        call plvpor(0.15d0, 0.95d0, 0.1d0, 0.9d0)
        call plwind(0.0d0, 1.0d0, 0.0d0, 1.0d0)

C        Draw the grid using plbox

        call plbox('bcg', 0.1d0, 0,'bcg', 0.1d0, 0)
        call plcol0(15)

C        Write the digits below the frame

        do  i=0,9
          write (text,'(i1)') i
          call plmtex('b', 1.5d0, (0.1d0*i+0.05d0),
     &                0.5d0, text)
        enddo
        k=0
        do i=0,9

C          Write the digits to the left of the frame

          if(base(l)+10*i.eq.0) then
            write (text,'(i1)') base(l)+10*i
          elseif(base(l)+10*i.lt.100) then
            write (text,'(i2)') base(l)+10*i
          elseif(base(l)+10*i.lt.1000) then
            write (text,'(i3)') base(l)+10*i
          else
            write (text,'(i4)') base(l)+10*i
	  endif
          call plmtex('lv', 1.0d0, (0.95d0-0.1d0*i),
     &      1.0d0, text)
          do j=0,9
            x=0.1d0*j+0.05d0
            y=0.95d0-0.1d0*i

C            Display the symbols

            call plsym(1,x,y,base(l)+k)
            k=k+1
          enddo
        enddo

        call plmtex('t', 1.5d0, 0.5d0, 0.5d0,
     &    'PLplot Example 7 - PLSYM symbols')
      enddo
      call plend
      end
