/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.ogg;

import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import net.sourceforge.jffmpeg.demux.ogg.AudioTrack;

public class OggDemux
implements Demultiplexer,
Positionable {
    public static final int MAX_OGG_PAGE_SIZE = 65307;
    private PullSourceStream in;
    private Seekable seek;
    private int TRACK_SERIAL = 1;
    private Track audioTrack = new AudioTrack(this, this.TRACK_SERIAL);
    private long currentTime;
    private long duration;
    byte[] buffer;
    private static final int[] crc_lookup = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
    private long lastPacketPosition = -1L;
    private long lastGranuleNumber = 0L;

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public void close() {
    }

    public synchronized void start() throws IOException {
    }

    public void stop() {
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return new Time(this.duration);
    }

    public Time getMediaTime() {
        return new Time(this.currentTime);
    }

    public String getName() {
        return "OGG Demultiplexer";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return new ContentDescriptor[]{new FileTypeDescriptor("audio.ogg")};
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return new Track[]{this.audioTrack};
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public Time setPosition(Time time, int n) {
        this.seekPacket((int)(time.getNanoseconds() / 22675L), 1);
        return this.getMediaTime();
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (dataSource instanceof PullDataSource) {
            this.in = ((PullDataSource)dataSource).getStreams()[0];
            if (this.in instanceof Seekable) {
                if (this.in.getContentLength() != -1L) {
                    this.seek = (Seekable)this.in;
                    this.seekPacket(-1L, 1);
                    this.duration = this.lastGranuleNumber * 22675L;
                    this.seekPacket(0L, 1);
                }
            }
            return;
        }
        throw new IncompatibleSourceException();
    }

    protected void readFrame(Buffer buffer, int n, long l) throws IOException {
        int n2;
        buffer.setEOM(false);
        if (this.currentTime == this.duration && this.seek != null && this.lastPacketPosition > 0L && this.seek.tell() >= this.lastPacketPosition) {
            buffer.setEOM(true);
            buffer.setLength(0);
            return;
        }
        this.buffer = (byte[])buffer.getData();
        if (this.buffer == null || this.buffer.length < 65307) {
            this.buffer = new byte[65307];
            buffer.setData((Object)this.buffer);
        }
        this.readBytes(0, 27);
        if (this.buffer[0] != 79 || this.buffer[1] != 103 || this.buffer[2] != 103 || this.buffer[3] != 83) {
            throw new IOException("Invalid Capture Pattern: " + new String(this.buffer, 0, 4));
        }
        int n3 = this.buffer[4] & 0xFF;
        int n4 = this.buffer[5] & 0xFF;
        long l2 = this.readLong(this.buffer, 6);
        int n5 = this.readInt(this.buffer, 14);
        int n6 = this.readInt(this.buffer, 18);
        int n7 = this.readInt(this.buffer, 22);
        int n8 = this.buffer[26] & 0xFF;
        this.readBytes(27, n8);
        int n9 = 0;
        for (n2 = 0; n2 < n8; ++n2) {
            n9 += this.buffer[27 + n2] & 0xFF;
        }
        this.readBytes(27 + n8, n9);
        n2 = 27 + n8 + n9;
        this.buffer[22] = 0;
        this.buffer[23] = 0;
        this.buffer[24] = 0;
        this.buffer[25] = 0;
        int n10 = 0;
        for (int i = 0; i < n2; ++i) {
            n10 = n10 << 8 ^ crc_lookup[(n10 >> 24 ^ this.buffer[i]) & 0xFF];
        }
        if (n7 != n10) {
            throw new IOException("Invalid CRC " + n10 + "/" + n7);
        }
        this.currentTime = l2 * l;
        buffer.setLength(n2);
        buffer.setTimeStamp(this.currentTime);
    }

    private void readBytes(int n, int n2) throws IOException {
        for (int i = 0; i < n2; i += this.in.read(this.buffer, i + n, n2 - i)) {
        }
    }

    private long readLong(byte[] byArray, int n) {
        long l = 0L;
        l = l << 8 | (long)(byArray[n + 7] & 0xFF);
        l = l << 8 | (long)(byArray[n + 6] & 0xFF);
        l = l << 8 | (long)(byArray[n + 5] & 0xFF);
        l = l << 8 | (long)(byArray[n + 4] & 0xFF);
        l = l << 8 | (long)(byArray[n + 3] & 0xFF);
        l = l << 8 | (long)(byArray[n + 2] & 0xFF);
        l = l << 8 | (long)(byArray[n + 1] & 0xFF);
        l = l << 8 | (long)(byArray[n + 0] & 0xFF);
        return l;
    }

    private int readInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n2 << 8 | byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    protected void seekPacket(long l, int n) {
        long l2;
        if (l == 0L) {
            this.seek.seek(0L);
            return;
        }
        if (l == -1L) {
            if (this.lastPacketPosition >= 0L) {
                this.seek.seek(this.lastPacketPosition);
                return;
            }
            l2 = this.seek.seek(this.in.getContentLength());
            Buffer buffer = new Buffer();
            for (long i = l2 - 4L; i >= 0L; --i) {
                this.seek.seek(i);
                try {
                    this.readFrame(buffer, n, 1L);
                    this.lastPacketPosition = i;
                    this.lastGranuleNumber = buffer.getTimeStamp();
                    this.seek.seek(i);
                    return;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        l2 = 0L;
        long l3 = this.lastPacketPosition;
        long l4 = 0L;
        long l5 = this.lastPacketPosition * (l - 1L) / this.lastGranuleNumber;
        Buffer buffer = new Buffer();
        for (long i = l5; i >= 0L; --i) {
            this.seek.seek(i);
            try {
                this.readFrame(buffer, n, 1L);
                this.seek.seek(i);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

