/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.recordset;

import flashgateway.io.ASObject;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.config.OpenAMFConfig;

public class ASRecordSet
extends ASObject {
    private static final Log log = LogFactory.getLog((Class)(class$org$openamf$recordset$ASRecordSet == null ? (class$org$openamf$recordset$ASRecordSet = ASRecordSet.class$("org.openamf.recordset.ASRecordSet")) : class$org$openamf$recordset$ASRecordSet));
    public static final String SERVICE_NAME = "OpenAMFPageableRecordSet";
    private static final String SI = "serverInfo";
    private static final String SI_ID = "id";
    private static final String SI_TOTAL_COUNT = "totalCount";
    private static final String SI_INITIAL_DATA = "initialData";
    private static final String SI_ROWS = "rows";
    private static final String SI_CURSOR = "cursor";
    private static final String SI_SERVICE_NAME = "serviceName";
    private static final String SI_COLUMN_NAMES = "columnNames";
    private static final String SI_VERSION = "version";
    private Map serverInfo = new HashMap();
    private List rows;
    private int initialRowCount;
    static /* synthetic */ Class class$org$openamf$recordset$ASRecordSet;

    public ASRecordSet() {
        super("RecordSet");
        this.put(SI, this.serverInfo);
        this.setId("RS" + String.valueOf(this.hashCode()));
        this.setInitialData(new ArrayList());
        this.setServiceName(SERVICE_NAME);
        this.setCursor(1);
        this.setVersion(1.0);
        this.rows = new ArrayList();
        this.initialRowCount = OpenAMFConfig.getInstance().getPageableRecordsetConfig().getInitialDataRowCount();
    }

    public String getId() {
        return (String)this.serverInfo.get(SI_ID);
    }

    public void setId(String id) {
        this.serverInfo.put(SI_ID, id);
    }

    public int getTotalCount() {
        Object value = this.serverInfo.get(SI_TOTAL_COUNT);
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public void setTotalCount(int totalCount) {
        this.serverInfo.put(SI_TOTAL_COUNT, new Integer(totalCount));
    }

    public List getInitialData() {
        return (List)this.serverInfo.get(SI_INITIAL_DATA);
    }

    public void setInitialData(List initialData) {
        this.serverInfo.put(SI_INITIAL_DATA, initialData);
    }

    public Map getRecords(int from, int count) {
        List page = this.rows.subList(from - 1, from - 1 + count);
        HashMap<String, Object> records = new HashMap<String, Object>();
        records.put("Page", page);
        records.put("Cursor", new Integer(from + 1));
        return records;
    }

    public int getCursor() {
        Object value = this.serverInfo.get(SI_CURSOR);
        if (value != null) {
            return (Integer)value;
        }
        return 0;
    }

    public void setCursor(int cursor) {
        this.serverInfo.put(SI_CURSOR, new Integer(cursor));
    }

    public String getServiceName() {
        return (String)this.serverInfo.get(SI_SERVICE_NAME);
    }

    public void setServiceName(String serviceName) {
        this.serverInfo.put(SI_SERVICE_NAME, serviceName);
    }

    public String[] getColumnNames() {
        return (String[])this.serverInfo.get(SI_COLUMN_NAMES);
    }

    public void setColumnNames(String[] columnNames) {
        this.serverInfo.put(SI_COLUMN_NAMES, columnNames);
    }

    public double getVersion() {
        Object value = this.serverInfo.get(SI_VERSION);
        if (value != null) {
            return (Double)value;
        }
        return 0.0;
    }

    public void setVersion(double version) {
        this.serverInfo.put(SI_VERSION, new Double(version));
    }

    public List rows() {
        return this.rows;
    }

    public void populate(ResultSet rs) throws IOException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columnNames = new String[columnCount];
            int rowIndex = 0;
            ArrayList initialData = new ArrayList();
            while (rs.next()) {
                ++rowIndex;
                ArrayList<Object> row = new ArrayList<Object>();
                int column = 0;
                while (column < columnCount) {
                    if (rowIndex == 1) {
                        columnNames[column] = rsmd.getColumnName(column + 1);
                    }
                    row.add(rs.getObject(column + 1));
                    ++column;
                }
                if (rowIndex == 1) {
                    this.setColumnNames(columnNames);
                }
                this.rows.add(row);
                if (rowIndex > this.initialRowCount) continue;
                initialData.add(row);
            }
            this.setTotalCount(rowIndex);
            this.setInitialData(initialData);
            this.setColumnNames(columnNames);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void populate(String[] columnNames, List rows) {
        this.rows = rows;
        List initialData = rows.subList(0, this.initialRowCount > rows.size() ? rows.size() : this.initialRowCount);
        this.setInitialData(initialData);
        this.setTotalCount(rows.size());
        this.setColumnNames(columnNames);
    }

    public void populate(List list, String[] ignoreProperties) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> names = new ArrayList<String>();
        Object firstBean = list.get(0);
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(firstBean);
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor descriptor = properties[i];
            if (!this.ignoreProperty(descriptor, ignoreProperties)) {
                names.add(descriptor.getDisplayName());
            }
            ++i;
        }
        String[] columnNames = new String[names.size()];
        columnNames = names.toArray(columnNames);
        this.setColumnNames(columnNames);
        int rowIndex = 0;
        ArrayList initialData = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++rowIndex;
            Object bean = iterator.next();
            ArrayList<Object> row = new ArrayList<Object>();
            int i2 = 0;
            while (i2 < properties.length) {
                PropertyDescriptor descriptor = properties[i2];
                if (!this.ignoreProperty(descriptor, ignoreProperties)) {
                    Object value = null;
                    Method readMethod = descriptor.getReadMethod();
                    if (readMethod != null) {
                        value = readMethod.invoke(bean, new Object[0]);
                    }
                    row.add(value);
                }
                ++i2;
            }
            this.rows.add(row);
            if (rowIndex > this.initialRowCount) continue;
            initialData.add(row);
        }
        this.setInitialData(initialData);
        this.setTotalCount(this.rows.size());
        log.debug((Object)this);
    }

    private boolean ignoreProperty(PropertyDescriptor descriptor, String[] ignoreProperties) {
        boolean ignore = false;
        if (descriptor.getName().equals("class")) {
            ignore = true;
        } else {
            int i = 0;
            while (i < ignoreProperties.length) {
                String ignoreProp = ignoreProperties[i];
                if (ignoreProp.equals(descriptor.getName())) {
                    log.debug((Object)("Ignoring " + descriptor.getName()));
                    ignore = true;
                    break;
                }
                ++i;
            }
        }
        return ignore;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        this.addInfo(info, SI_ID, this.getId());
        this.addInfo(info, SI_TOTAL_COUNT, this.getTotalCount());
        this.addInfo(info, SI_CURSOR, this.getCursor());
        this.addInfo(info, SI_SERVICE_NAME, this.getServiceName());
        this.addInfo(info, SI_VERSION, this.getVersion());
        StringBuffer names = new StringBuffer();
        String[] columnNames = this.getColumnNames();
        if (columnNames != null) {
            int i = 0;
            while (i < columnNames.length) {
                String name = columnNames[i];
                if (i > 0) {
                    names.append(", ");
                }
                names.append(name);
                ++i;
            }
        }
        this.addInfo(info, SI_COLUMN_NAMES, names);
        this.addInfo(info, SI_INITIAL_DATA, this.getInitialData().toString());
        return info.toString();
    }

    private void addInfo(StringBuffer info, String name, int value) {
        this.addInfo(info, name, new Integer(value));
    }

    private void addInfo(StringBuffer info, String name, double value) {
        this.addInfo(info, name, new Double(value));
    }

    private void addInfo(StringBuffer info, String name, Object value) {
        info.append(name);
        info.append(" = ");
        info.append(value);
        info.append('\n');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

