/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.invoker;

import java.util.StringTokenizer;
import javax.servlet.GenericServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.util.StringUtils;

class WebServiceBuildLogger
implements BuildListener {
    private GenericServlet servlet;
    private long startTime = System.currentTimeMillis();
    private static Log log = LogFactory.getLog((Class)(class$org$openamf$invoker$WebServiceInvoker == null ? (class$org$openamf$invoker$WebServiceInvoker = WebServiceBuildLogger.class$("org.openamf.invoker.WebServiceInvoker")) : class$org$openamf$invoker$WebServiceInvoker));
    static /* synthetic */ Class class$org$openamf$invoker$WebServiceInvoker;

    WebServiceBuildLogger() {
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
        log.debug((Object)"build started");
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            message.append(StringUtils.LINE_SEP);
            message.append("BUILD SUCCESSFUL");
        } else {
            message.append(StringUtils.LINE_SEP);
            message.append("BUILD FAILED");
            message.append(StringUtils.LINE_SEP);
            if (!(error instanceof BuildException)) {
                message.append(StringUtils.getStackTrace((Throwable)error));
            } else if (error instanceof BuildException) {
                message.append(error.toString()).append(StringUtils.LINE_SEP);
            } else {
                message.append(error.getMessage()).append(StringUtils.LINE_SEP);
            }
        }
        message.append(StringUtils.LINE_SEP);
        message.append("Total time: ");
        message.append((System.currentTimeMillis() - this.startTime) / 1000L);
        log.debug((Object)message.toString());
    }

    public void messageLogged(BuildEvent event) {
        StringBuffer message = new StringBuffer();
        if (event.getTask() != null) {
            String name = event.getTask().getTaskName();
            String label = "[" + name + "] ";
            int size = 10 - label.length();
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < size) {
                tmp.append(" ");
                ++i;
            }
            tmp.append(label);
            label = tmp.toString();
            StringTokenizer tok = new StringTokenizer(event.getMessage(), "\r\n", false);
            boolean first = true;
            while (tok.hasMoreTokens()) {
                if (!first) {
                    message.append(StringUtils.LINE_SEP);
                }
                first = false;
                message.append(label);
                message.append(tok.nextToken());
            }
        } else {
            message.append(event.getMessage());
        }
        log.debug((Object)message.toString());
    }

    public void targetStarted(BuildEvent arg0) {
    }

    public void targetFinished(BuildEvent arg0) {
    }

    public void taskStarted(BuildEvent arg0) {
    }

    public void taskFinished(BuildEvent arg0) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

