/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.UnaryExpr;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class AdditiveExpr
extends XSLExprBase {
    AdditiveExpr() {
        super.setExprType(1048632);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = AdditiveExpr.parseMultExpr(xSLParseString);
        while (xSLParseString.peekToken(100)) {
            AdditiveExpr additiveExpr = new AdditiveExpr();
            additiveExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            additiveExpr.operator = xSLParseString.getOperator();
            additiveExpr.leftExpr = xSLExprBase;
            additiveExpr.rightExpr = AdditiveExpr.parseMultExpr(xSLParseString);
            xSLExprBase = additiveExpr;
            if (!xSLParseString.isCachingExpr() || xSLExprBase.canCacheExpr()) continue;
            xSLExprBase.cacheSubExpr();
        }
        return xSLExprBase;
    }

    static XSLExprBase parseMultExpr(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = UnaryExpr.parse(xSLParseString);
        while (xSLParseString.peekToken(101)) {
            AdditiveExpr additiveExpr = new AdditiveExpr();
            additiveExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            additiveExpr.operator = xSLParseString.getOperator();
            additiveExpr.leftExpr = xSLExprBase;
            additiveExpr.rightExpr = UnaryExpr.parse(xSLParseString);
            xSLExprBase = additiveExpr;
            if (!xSLParseString.isCachingExpr() || xSLExprBase.canCacheExpr()) continue;
            xSLExprBase.cacheSubExpr();
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(this.operator);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN() || this.rightExpr.checkPosLastFN();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.peekExprValue();
        this.rightExpr.evaluate(xSLTContext);
        if (this.getXSLTVersion() == 20 && !this.isBackwardCompatibilityMode() || this.getXSLTVersion() == 10 && this.isForwardCompatibilityMode()) {
            XPathSequence.arithmetic20(oXMLSequence, xSLTContext.popExprValue(), this.operator);
        } else {
            XPathSequence.arithmetic(oXMLSequence, xSLTContext.popExprValue(), this.operator);
        }
    }
}

