/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class XMLNotation
extends XMLNode
implements Notation,
CXMLConstants,
Externalizable {
    int ntype;
    private static final int NOTATION_DTD = 0;
    private static final int NOTATION_QXNAME = 1;
    private static final int NOTATION_SYSID = 2;
    private static final int NOTATION_PUBID = 3;
    private static final int NOTATION_DATASZ = 4;

    private native String xdbGetPublicId(long var1, long var3);

    private native String xdbGetSystemId(long var1, long var3);

    public XMLNotation() {
        this.setNodeFlag(1);
    }

    XMLNotation(XMLDocument xMLDocument) {
        super(xMLDocument);
    }

    public XMLNotation(String string) {
        this.xdkSetQxName(QxNameHash.create("", string, "", string));
    }

    public short getNodeType() {
        return 12;
    }

    public String getNodeName() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getPublicId() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetPublicId();
            }
            case 2: {
                return this.xdbGetPublicId(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public String getSystemId() {
        switch (this.flags & 3) {
            case 1: {
                return this.xdkGetSystemId();
            }
            case 2: {
                return this.xdbGetSystemId(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public void setPublicId(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.xdkSetPublicId(string);
                break;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    public void setSystemId(String string) {
        switch (this.flags & 3) {
            case 1: {
                this.xdkSetSystemId(string);
                break;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        XMLNotation xMLNotation = (XMLNotation)xMLDocument.createNodeFromType((short)12);
        xMLNotation.xdkSetQxName(this.xdkGetQxName());
        xMLNotation.xdkSetSystemId(this.xdkGetSystemId());
        xMLNotation.xdkSetPublicId(this.xdkGetPublicId());
        xMLNotation.setNodeFlag(128, this.isNodeFlag(128));
        xMLNotation.ntype = this.ntype;
        return xMLNotation;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeChars("<!NOTATION ");
            xMLOutputStream.writeChars(this.getNodeName() + " ");
            if (this.getPublicId() != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.getPublicId());
                xMLOutputStream.writeChars(" ");
                if (this.getSystemId() != null) {
                    xMLOutputStream.writeQuotedString(this.getSystemId());
                }
            } else {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.getSystemId());
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectOutput(objectOutput);
        this.writeExternal(cXMLStream, cXMLContext);
        cXMLStream.flush();
    }

    void writeExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException {
        cXMLStream.writeByte(18);
        cXMLStream.writeUTF(this.getNodeName());
        cXMLStream.writeUTF(this.getSystemId());
        cXMLStream.writeUTF(this.getPublicId());
        cXMLStream.writeBoolean(this.isNodeFlag(128));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectInput(objectInput);
        this.readExternal(cXMLStream, cXMLContext);
    }

    public void readExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = cXMLStream.readByte();
        if (by != 18) {
            throw new IOException("Error in reading serialized stream corresponding to notation node");
        }
        String string = cXMLStream.readUTF();
        this.xdkSetQxName(QxNameHash.create("", string, "", string));
        this.xdkSetSystemId(cXMLStream.readUTF());
        this.xdkSetPublicId(cXMLStream.readUTF());
        this.setNodeFlag(128, cXMLStream.readBoolean());
    }

    DTD xdkGetDTD() {
        return (DTD)this.data[(int)this.nodeId + 0];
    }

    void xdkSetDTD(DTD dTD) {
        this.data[(int)this.nodeId + 0] = dTD;
    }

    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 1];
    }

    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 1] = qxName;
    }

    String xdkGetSystemId() {
        return (String)this.data[(int)this.nodeId + 2];
    }

    void xdkSetSystemId(String string) {
        this.data[(int)this.nodeId + 2] = string;
    }

    String xdkGetPublicId() {
        return (String)this.data[(int)this.nodeId + 3];
    }

    void xdkSetPublicId(String string) {
        this.data[(int)this.nodeId + 3] = string;
    }

    int xdkGetNodeArraySize() {
        return 4;
    }
}

