/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Arrays;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;

public class DefaultElementValueComparator
implements ElementValueComparator {
    private final ReadWriteCopyStrategy<Element> readWriteCopyStrategy;
    private final boolean doNoCopyForRead;

    public DefaultElementValueComparator(CacheConfiguration cacheConfiguration) {
        this.readWriteCopyStrategy = cacheConfiguration.getCopyStrategy();
        this.doNoCopyForRead = !cacheConfiguration.isCopyOnRead() || !cacheConfiguration.isCopyOnWrite();
    }

    public boolean equals(Element e1, Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 != null && e1.equals(e2)) {
            if (e1.getObjectValue() == null) {
                return e2.getObjectValue() == null;
            }
            return DefaultElementValueComparator.compareValues(this.copyForReadIfNeeded(e1).getObjectValue(), this.copyForReadIfNeeded(e2).getObjectValue());
        }
        return false;
    }

    private static boolean compareValues(Object objectValue1, Object objectValue2) {
        if (objectValue1 != null && objectValue2 != null && objectValue1.getClass().isArray() && objectValue2.getClass().isArray()) {
            return Arrays.deepEquals(new Object[]{objectValue1}, new Object[]{objectValue2});
        }
        if (objectValue1 == null) {
            return objectValue2 == null;
        }
        return objectValue1.equals(objectValue2);
    }

    private Element copyForReadIfNeeded(Element element) {
        if (this.readWriteCopyStrategy == null || this.doNoCopyForRead) {
            return element;
        }
        return this.readWriteCopyStrategy.copyForRead(element);
    }
}

