/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibConvolve3x3Or5x5OpImage;
import com.sun.media.jai.mlib.MlibConvolveOpImage;
import com.sun.media.jai.mlib.MlibSeparableConvolveOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibConvolveRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        boolean centered;
        ImageLayout layout = RIFUtil.getImageLayoutHint(hints);
        if (!MediaLibAccessor.isMediaLibCompatible(args, layout) || !MediaLibAccessor.hasSameNumBands(args, layout)) {
            return null;
        }
        BorderExtender extender = RIFUtil.getBorderExtenderHint(hints);
        RenderedImage source = args.getRenderedSource(0);
        KernelJAI unRotatedKernel = (KernelJAI)args.getObjectParameter(0);
        KernelJAI kJAI = unRotatedKernel.getRotatedKernel();
        int kWidth = kJAI.getWidth();
        int kHeight = kJAI.getHeight();
        if (kWidth < 2 || kHeight < 2) {
            return null;
        }
        boolean bl = centered = kWidth == kJAI.getXOrigin() * 2 + 1 && kHeight == kJAI.getYOrigin() * 2 + 1;
        if (kJAI.isSeparable() && kWidth >= 3 && kWidth <= 7 && kWidth == kHeight) {
            return new MlibSeparableConvolveOpImage(source, extender, hints, layout, kJAI);
        }
        if (kWidth == 3 && kHeight == 3 || kWidth == 5 && kHeight == 5) {
            return new MlibConvolve3x3Or5x5OpImage(source, extender, hints, layout, kJAI);
        }
        return new MlibConvolveOpImage(source, extender, hints, layout, kJAI);
    }
}

