/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.filters.ASCII85Decode;
import org.icepdf.core.pobjects.filters.ASCIIHexDecode;
import org.icepdf.core.pobjects.filters.CCITTFax;
import org.icepdf.core.pobjects.filters.FlateDecode;
import org.icepdf.core.pobjects.filters.LZWDecode;
import org.icepdf.core.pobjects.filters.RunLengthDecode;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.ImageCache;
import org.icepdf.core.util.Library;

public class Stream
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Stream.class.toString());
    private SeekableInputConstrainedWrapper streamInput;
    private ImageCache image = null;
    private final Object imageLock = new Object();
    private boolean isCCITTFaxDecodeWithoutEncodedByteAlign = false;
    private int CCITTFaxDecodeColumnWidthMismatch = 0;
    private Reference pObjectReference = null;
    private static boolean scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB_REVERSED = new int[]{-1, -16777216};
    private static final int[] GRAY_1_BIT_INDEX_TO_RGB = new int[]{-16777216, -1};
    private static final int[] GRAY_2_BIT_INDEX_TO_RGB = new int[]{-16777216, -11184811, -5592406, -1};
    private static final int[] GRAY_4_BIT_INDEX_TO_RGB = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    private static final int JPEG_ENC_UNKNOWN_PROBABLY_YCbCr = 0;
    private static final int JPEG_ENC_RGB = 1;
    private static final int JPEG_ENC_CMYK = 2;
    private static final int JPEG_ENC_YCbCr = 3;
    private static final int JPEG_ENC_YCCK = 4;
    private static final int JPEG_ENC_GRAY = 5;
    private static String[] JPEG_ENC_NAMES = new String[]{"JPEG_ENC_UNKNOWN_PROBABLY_YCbCr", "JPEG_ENC_RGB", "JPEG_ENC_CMYK", "JPEG_ENC_YCbCr", "JPEG_ENC_YCCK", "JPEG_ENC_GRAY"};

    public Stream(Library library, Hashtable hashtable, SeekableInputConstrainedWrapper seekableInputConstrainedWrapper) {
        super(library, hashtable);
        this.streamInput = seekableInputConstrainedWrapper;
    }

    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    boolean isImageSubtype() {
        Object object = this.library.getObject(this.entries, "Subtype");
        return object != null && object.equals("Image");
    }

    private boolean checkMemory(int n) {
        return this.library.memoryManager.checkMemory(n);
    }

    public InputStream getInputStreamForDecodedStreamBytes() {
        Vector vector;
        if (this.streamInput == null || this.streamInput.getLength() < 1L) {
            return null;
        }
        long l = this.streamInput.getLength();
        int n = (int)l;
        this.checkMemory(n);
        this.streamInput.prepareForCurrentUse();
        InputStream inputStream = this.streamInput;
        int n2 = Math.min(Math.max((int)l, 64), 16384);
        inputStream = new BufferedInputStream(inputStream, n2);
        if (this.library.securityManager != null) {
            inputStream = this.library.getSecurityManager().getEncryptionInputStream(this.getPObjectReference(), this.library.getSecurityManager().getDecryptionKey(), inputStream, true);
        }
        if ((vector = this.getFilterNames()) == null) {
            return inputStream;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            if (string.equals("FlateDecode") || string.equals("/Fl") || string.equals("Fl")) {
                inputStream = new FlateDecode(this.library, this.entries, inputStream);
                n *= 2;
                continue;
            }
            if (string.equals("LZWDecode") || string.equals("/LZW") || string.equals("LZW")) {
                inputStream = new LZWDecode(new BitStream(inputStream), this.library, this.entries);
                n *= 2;
                continue;
            }
            if (string.equals("ASCII85Decode") || string.equals("/A85") || string.equals("A85")) {
                inputStream = new ASCII85Decode(inputStream);
                n *= 2;
                continue;
            }
            if (string.equals("ASCIIHexDecode") || string.equals("/AHx") || string.equals("AHx")) {
                inputStream = new ASCIIHexDecode(inputStream);
                n /= 2;
                continue;
            }
            if (string.equals("RunLengthDecode") || string.equals("/RL") || string.equals("RL")) {
                inputStream = new RunLengthDecode(inputStream);
                n *= 2;
                continue;
            }
            if (string.equals("CCITTFaxDecode") || string.equals("/CCF") || string.equals("CCF") || string.equals("DCTDecode") || string.equals("/DCT") || string.equals("DCT")) continue;
            if (string.equals("JPXDecode")) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "UNSUPPORTED:" + string + " " + this.entries);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.log(Level.FINE, "Problem closing stream for unsupported JPXDecode");
                    }
                }
                return null;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("UNSUPPORTED:" + string + " " + this.entries);
        }
        this.checkMemory(n);
        return inputStream;
    }

    private byte[] getDecodedStreamBytes() {
        InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            int n2 = Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream conservativeSizingByteArrayOutputStream = new ConservativeSizingByteArrayOutputStream(n2, this.library.memoryManager);
            byte[] byArray = new byte[n2 > 1024 ? 4096 : 1024];
            while ((n = inputStream.read(byArray)) > 0) {
                conservativeSizingByteArrayOutputStream.write(byArray, 0, n);
            }
            conservativeSizingByteArrayOutputStream.flush();
            conservativeSizingByteArrayOutputStream.close();
            inputStream.close();
            byte[] byArray2 = conservativeSizingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", iOException);
            return null;
        }
    }

    private Object[] getDecodedStreamBytesAndSize(int n) {
        InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
        if (inputStream == null) {
            return null;
        }
        try {
            int n2;
            int n3 = n > 0 ? n : Math.max(1024, (int)this.streamInput.getLength());
            ConservativeSizingByteArrayOutputStream conservativeSizingByteArrayOutputStream = new ConservativeSizingByteArrayOutputStream(n3, this.library.memoryManager);
            byte[] byArray = new byte[n3 > 1024 ? 4096 : 1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                conservativeSizingByteArrayOutputStream.write(byArray, 0, n2);
            }
            conservativeSizingByteArrayOutputStream.flush();
            conservativeSizingByteArrayOutputStream.close();
            inputStream.close();
            n2 = conservativeSizingByteArrayOutputStream.size();
            boolean bl = conservativeSizingByteArrayOutputStream.trim();
            byte[] byArray2 = conservativeSizingByteArrayOutputStream.relinquishByteArray();
            Object[] objectArray = new Object[]{byArray2, n2};
            return objectArray;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem decoding stream bytes: ", iOException);
            return null;
        }
    }

    private boolean shouldUseCCITTFaxDecode() {
        Vector vector = this.getFilterNames();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            if (!string.equals("CCITTFaxDecode") && !string.equals("/CCF") && !string.equals("CCF")) continue;
            return true;
        }
        return false;
    }

    private boolean shouldUseDCTDecode() {
        Vector vector = this.getFilterNames();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            if (!string.equals("DCTDecode") && !string.equals("/DCT") && !string.equals("DCT")) continue;
            return true;
        }
        return false;
    }

    private Vector getFilterNames() {
        Vector vector = null;
        Object object = this.library.getObject(this.entries, "Filter");
        if (object instanceof Name) {
            vector = new Vector();
            vector.addElement(object);
        } else if (object instanceof Vector) {
            vector = (Vector)object;
        }
        return vector;
    }

    private byte[] decodeCCITTFaxDecodeOrDCTDecodeImage(int n, int n2, PColorSpace pColorSpace, int n3, Color color, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2) {
        byte[] byArray = null;
        if (this.shouldUseCCITTFaxDecode()) {
            boolean bl = this.nonDecodeCCITTMakeImage(color);
            if (!bl) {
                byArray = this.ccittfaxDecode(this.getInputStreamForDecodedStreamBytes());
            }
        } else if (this.shouldUseDCTDecode()) {
            this.dctDecode(n, n2, pColorSpace, n3, bufferedImage, bufferedImage2, nArray, nArray2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean bl) {
        if (this.streamInput != null && !bl) {
            try {
                this.streamInput.dispose();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error disposing stream.", iOException);
            }
            this.streamInput = null;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image != null) {
                this.image.dispose(bl, this.streamInput != null);
                if (!bl || !this.image.isCachedSomehow()) {
                    this.image = null;
                    this.isCCITTFaxDecodeWithoutEncodedByteAlign = false;
                    this.CCITTFaxDecodeColumnWidthMismatch = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dctDecode(int n, int n2, PColorSpace pColorSpace, int n3, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2) {
        Object object;
        Object object2;
        Object object3;
        InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 2048);
        bufferedInputStream.mark(2048);
        int n4 = 0;
        try {
            object3 = new byte[2048];
            int n5 = bufferedInputStream.read((byte[])object3);
            bufferedInputStream.reset();
            if (n5 > 0) {
                n4 = Stream.getJPEGEncoding(object3, n5);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Problem determining JPEG type: ", iOException);
        }
        object3 = null;
        if (object3 == null) {
            try {
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInputStream);
                int n6 = 65536 + (int)this.streamInput.getLength();
                this.checkMemory(n * n2 * 8 + n6);
                if (n4 == 1 && n3 == 8) {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    Stream.alterRasterRGB2PColorSpace((WritableRaster)object, pColorSpace);
                    object3 = Stream.makeRGBBufferedImage((WritableRaster)object);
                } else if (n4 == 2 && n3 == 8) {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    Stream.alterRasterCMYK2BGRA((WritableRaster)object, bufferedImage, bufferedImage2);
                    object3 = Stream.makeRGBABufferedImage((WritableRaster)object);
                } else if (n4 == 3 && n3 == 8) {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    Stream.alterRasterYCbCr2RGB((WritableRaster)object);
                    object3 = Stream.makeRGBBufferedImage((WritableRaster)object);
                } else if (n4 == 4 && n3 == 8) {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    Stream.alterRasterYCCK2BGRA((WritableRaster)object, bufferedImage, bufferedImage2);
                    object3 = Stream.makeRGBABufferedImage((WritableRaster)object);
                } else if (n4 == 5 && n3 == 8) {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    Object object4 = object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    if (!(pColorSpace instanceof DeviceGray)) {
                        Stream.alterRasterY2Gray((WritableRaster)object);
                    }
                    object3 = Stream.makeGrayBufferedImage((WritableRaster)object);
                } else {
                    object2 = jPEGImageDecoder.decodeAsRaster();
                    Object object5 = object = object2 instanceof WritableRaster ? (WritableRaster)object2 : ((Raster)object2).createCompatibleWritableRaster();
                    if (jPEGImageDecoder.getJPEGDecodeParam().getEncodedColorID() == 7) {
                        Stream.alterRasterYCbCrA2RGBA_new((WritableRaster)object, bufferedImage, bufferedImage2);
                        object3 = Stream.makeRGBABufferedImage((WritableRaster)object);
                    } else {
                        Stream.alterRasterYCbCr2RGB((WritableRaster)object);
                        object3 = Stream.makeRGBBufferedImage((WritableRaster)object);
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Problem loading JPEG image via JPEGImageDecoder: ", exception);
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error closing image stream.", iOException);
        }
        if (object3 == null) {
            try {
                Class<?> clazz;
                Object object6 = null;
                try {
                    inputStream = this.getInputStreamForDecodedStreamBytes();
                    clazz = Class.forName("com.sun.media.jai.codec.SeekableStream");
                    object2 = clazz.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
                    object = ((Method)object2).invoke(null, inputStream, Boolean.TRUE);
                    ParameterBlock parameterBlock = new ParameterBlock();
                    parameterBlock.add(object);
                    Class<?> clazz2 = Class.forName("javax.media.jai.JAI");
                    Method method = clazz2.getMethod("create", String.class, ParameterBlock.class);
                    object6 = method.invoke(null, "jpeg", parameterBlock);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(object6 == null || n4 == 2 && n3 == 8 || n4 == 4 && n3 == 8)) {
                    clazz = Class.forName("javax.media.jai.RenderedOp");
                    object2 = clazz.getMethod("getAsBufferedImage", new Class[0]);
                    object3 = (BufferedImage)((Method)object2).invoke(object6, new Object[0]);
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Problem loading JPEG image via JAI: ", exception);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Problem closing image stream. ", iOException);
            }
        }
        if (object3 == null) {
            try {
                Image image;
                byte[] byArray = this.getDecodedStreamBytes();
                if (byArray != null && (image = Toolkit.getDefaultToolkit().createImage(byArray)) != null) {
                    object3 = this.makeRGBABufferedImageFromImage(image);
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Problem loading JPEG image via Toolkit: ", exception);
            }
        }
        Object object7 = this.imageLock;
        synchronized (object7) {
            if (this.image == null) {
                this.image = new ImageCache(this.library);
            }
            this.image.setImage((BufferedImage)object3);
        }
    }

    private static void alterRasterCMYK2BGRA(WritableRaster writableRaster, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster2 = null;
        int n = 0;
        int n2 = 0;
        if (bufferedImage != null) {
            writableRaster2 = bufferedImage.getRaster();
            n = writableRaster2.getWidth();
            n2 = writableRaster2.getHeight();
        }
        WritableRaster writableRaster3 = null;
        int n3 = 0;
        int n4 = 0;
        if (bufferedImage2 != null) {
            writableRaster3 = bufferedImage2.getRaster();
            n3 = writableRaster3.getWidth();
            n4 = writableRaster3.getHeight();
        }
        int[] nArray = new int[4];
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                writableRaster.getPixel(j, i, nArray);
                int n7 = nArray[0];
                int n8 = nArray[1];
                int n9 = nArray[2];
                int n10 = nArray[3];
                int n11 = Math.max(n7, Math.max(n8, n9));
                n10 = (255 - n11) * n10 / 255;
                n7 += n10;
                n8 += n10;
                n9 += n10;
                n7 = Math.max(0, Math.min(255, n7));
                n8 = Math.max(0, Math.min(255, n8));
                n9 = Math.max(0, Math.min(255, n9));
                int n12 = 255 - n7;
                int n13 = 255 - n8;
                int n14 = 255 - n9;
                int n15 = 255;
                if (i < n2 && j < n && writableRaster2 != null) {
                    n15 = writableRaster2.getSample(j, i, 0) & 0xFF;
                } else if (i < n4 && j < n3 && writableRaster3 != null) {
                    n15 = bufferedImage2.getRGB(j, i) >>> 24 & 0xFF;
                }
                nArray[0] = n14;
                nArray[1] = n13;
                nArray[2] = n12;
                nArray[3] = n15;
                writableRaster.setPixel(j, i, nArray);
            }
        }
    }

    private static void alterRasterYCbCr2RGB(WritableRaster writableRaster) {
        int[] nArray = new int[3];
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3;
                int n4;
                writableRaster.getPixel(j, i, nArray);
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = nArray[2];
                int n8 = n7 - 128;
                int n9 = n6 - 128;
                int n10 = n5 + 1370705 * n8 / 1000000;
                int n11 = n5 - 337633 * n9 / 1000000 - 698001 * n8 / 1000000;
                int n12 = n5 + 1732446 * n9 / 1000000;
                byte by = (byte)(n10 < 0 ? 0 : (byte)(n4 = (byte)(n10 > 255 ? -1 : (byte)n10)));
                byte by2 = (byte)(n11 < 0 ? 0 : (byte)(n3 = (byte)(n11 > 255 ? -1 : (byte)n11)));
                int n13 = (byte)(n12 < 0 ? 0 : (byte)(n12 > 255 ? -1 : (byte)n12));
                nArray[0] = n4;
                nArray[1] = n3;
                nArray[2] = n13;
                writableRaster.setPixel(j, i, nArray);
            }
        }
    }

    private static void alterRasterYCCK2BGRA(WritableRaster writableRaster, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster2 = null;
        int n = 0;
        int n2 = 0;
        if (bufferedImage != null) {
            writableRaster2 = bufferedImage.getRaster();
            n = writableRaster2.getWidth();
            n2 = writableRaster2.getHeight();
        }
        WritableRaster writableRaster3 = null;
        int n3 = 0;
        int n4 = 0;
        if (bufferedImage2 != null) {
            writableRaster3 = bufferedImage2.getRaster();
            n3 = writableRaster3.getWidth();
            n4 = writableRaster3.getHeight();
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n7;
                int n8;
                writableRaster.getPixel(j, i, nArray);
                int n9 = nArray[0];
                int n10 = nArray[1];
                int n11 = nArray[2];
                int n12 = nArray[3];
                int n13 = n11 - 128;
                int n14 = n10 - 128;
                int n15 = (n9 -= n12) + 1370705 * n13 / 1000000;
                int n16 = n9 - 337633 * n14 / 1000000 - 698001 * n13 / 1000000;
                int n17 = n9 + 1732446 * n14 / 1000000;
                byte by = (byte)(n15 < 0 ? 0 : (byte)(n8 = (byte)(n15 > 255 ? -1 : (byte)n15)));
                byte by2 = (byte)(n16 < 0 ? 0 : (byte)(n7 = (byte)(n16 > 255 ? -1 : (byte)n16)));
                int n18 = (byte)(n17 < 0 ? 0 : (byte)(n17 > 255 ? -1 : (byte)n17));
                int n19 = 255;
                if (i < n2 && j < n && writableRaster2 != null) {
                    n19 = writableRaster2.getSample(j, i, 0) & 0xFF;
                } else if (i < n4 && j < n3 && writableRaster3 != null) {
                    n19 = bufferedImage2.getRGB(j, i) >>> 24 & 0xFF;
                }
                nArray2[0] = n18;
                nArray2[1] = n7;
                nArray2[2] = n8;
                nArray2[3] = n19;
                writableRaster.setPixel(j, i, nArray2);
            }
        }
    }

    private static void alterRasterYCbCrA2RGBA_new(WritableRaster writableRaster, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster2 = null;
        int n = 0;
        int n2 = 0;
        if (bufferedImage != null) {
            writableRaster2 = bufferedImage.getRaster();
            n = writableRaster2.getWidth();
            n2 = writableRaster2.getHeight();
        }
        WritableRaster writableRaster3 = null;
        int n3 = 0;
        int n4 = 0;
        if (bufferedImage2 != null) {
            writableRaster3 = bufferedImage2.getRaster();
            n3 = writableRaster3.getWidth();
            n4 = writableRaster3.getHeight();
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n7;
                int n8;
                writableRaster.getPixel(j, i, nArray);
                int n9 = nArray[0];
                int n10 = nArray[1];
                int n11 = nArray[2];
                int n12 = nArray[3];
                n9 = n12 - n9;
                int n13 = n11 - 128;
                int n14 = n10 - 128;
                int n15 = n9 + 1370705 * n13 / 1000000;
                int n16 = n9 - 337633 * n14 / 1000000 - 698001 * n13 / 1000000;
                int n17 = n9 + 1732446 * n14 / 1000000;
                byte by = (byte)(n15 < 0 ? 0 : (byte)(n8 = (byte)(n15 > 255 ? -1 : (byte)n15)));
                byte by2 = (byte)(n16 < 0 ? 0 : (byte)(n7 = (byte)(n16 > 255 ? -1 : (byte)n16)));
                int n18 = (byte)(n17 < 0 ? 0 : (byte)(n17 > 255 ? -1 : (byte)n17));
                int n19 = n12;
                if (i < n2 && j < n && writableRaster2 != null) {
                    n19 = writableRaster2.getSample(j, i, 0) & 0xFF;
                } else if (i < n4 && j < n3 && writableRaster3 != null) {
                    n19 = bufferedImage2.getRGB(j, i) >>> 24 & 0xFF;
                }
                nArray2[0] = n8;
                nArray2[1] = n7;
                nArray2[2] = n18;
                nArray2[3] = n19;
                writableRaster.setPixel(j, i, nArray2);
            }
        }
    }

    private static void alterRasterBGRA(WritableRaster writableRaster, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2) {
        WritableRaster writableRaster2 = null;
        int n = 0;
        int n2 = 0;
        if (bufferedImage != null) {
            writableRaster2 = bufferedImage.getRaster();
            n = writableRaster2.getWidth();
            n2 = writableRaster2.getHeight();
        }
        WritableRaster writableRaster3 = null;
        int n3 = 0;
        int n4 = 0;
        if (bufferedImage2 != null) {
            writableRaster3 = bufferedImage2.getRaster();
            n3 = writableRaster3.getWidth();
            n4 = writableRaster3.getHeight();
        }
        int n5 = 255;
        int n6 = 255;
        int n7 = 255;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (nArray != null && nArray2 != null) {
            n5 = nArray[0];
            n6 = nArray[1];
            n7 = nArray[2];
            n8 = nArray2[0];
            n9 = nArray2[1];
            n10 = nArray2[2];
        }
        if (writableRaster2 == null && writableRaster3 == null && (nArray == null || nArray2 == null)) {
            return;
        }
        int[] nArray3 = new int[4];
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        for (int i = 0; i < n12; ++i) {
            for (int j = 0; j < n11; ++j) {
                writableRaster.getPixel(j, i, nArray3);
                int n13 = nArray3[0];
                int n14 = nArray3[1];
                int n15 = nArray3[2];
                int n16 = 255;
                if (i < n2 && j < n && writableRaster2 != null) {
                    n16 = writableRaster2.getSample(j, i, 0) & 0xFF;
                } else if (i < n4 && j < n3 && writableRaster3 != null) {
                    n16 = bufferedImage2.getRGB(j, i) >>> 24 & 0xFF;
                } else if (n13 >= n7 && n13 <= n10 && n14 >= n6 && n14 <= n9 && n15 >= n5 && n15 <= n8) {
                    n16 = 0;
                }
                if (n16 == 255) continue;
                nArray3[3] = n16;
                writableRaster.setPixel(j, i, nArray3);
            }
        }
    }

    private static void alterRasterRGBA(WritableRaster writableRaster, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2) {
        WritableRaster writableRaster2 = null;
        int n = 0;
        int n2 = 0;
        if (bufferedImage != null) {
            writableRaster2 = bufferedImage.getRaster();
            n = writableRaster2.getWidth();
            n2 = writableRaster2.getHeight();
        }
        WritableRaster writableRaster3 = null;
        int n3 = 0;
        int n4 = 0;
        if (bufferedImage2 != null) {
            writableRaster3 = bufferedImage2.getRaster();
            n3 = writableRaster3.getWidth();
            n4 = writableRaster3.getHeight();
        }
        int n5 = 255;
        int n6 = 255;
        int n7 = 255;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (nArray != null && nArray2 != null) {
            n5 = nArray[0];
            n6 = nArray[1];
            n7 = nArray[2];
            n8 = nArray2[0];
            n9 = nArray2[1];
            n10 = nArray2[2];
        }
        if (writableRaster2 == null && writableRaster3 == null && (nArray == null || nArray2 == null)) {
            return;
        }
        int[] nArray3 = new int[4];
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        for (int i = 0; i < n12; ++i) {
            for (int j = 0; j < n11; ++j) {
                writableRaster.getPixel(j, i, nArray3);
                int n13 = nArray3[0];
                int n14 = nArray3[1];
                int n15 = nArray3[2];
                int n16 = 255;
                if (i < n2 && j < n && writableRaster2 != null) {
                    n16 = writableRaster2.getSample(j, i, 0) & 0xFF;
                } else if (i < n4 && j < n3 && writableRaster3 != null) {
                    n16 = bufferedImage2.getRGB(j, i) >>> 24 & 0xFF;
                } else if (n15 >= n7 && n15 <= n10 && n14 >= n6 && n14 <= n9 && n13 >= n5 && n13 <= n8) {
                    n16 = 0;
                }
                if (n16 == 255) continue;
                nArray3[3] = n16;
                writableRaster.setPixel(j, i, nArray3);
            }
        }
    }

    private static void alterRasterRGB2PColorSpace(WritableRaster writableRaster, PColorSpace pColorSpace) {
        if (pColorSpace instanceof DeviceRGB) {
            return;
        }
        float[] fArray = new float[3];
        int[] nArray = new int[3];
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                PColorSpace.reverseInPlace(nArray);
                pColorSpace.normaliseComponentsToFloats(nArray, fArray, 255.0f);
                Color color = pColorSpace.getColor(fArray);
                nArray[0] = color.getRed();
                nArray[1] = color.getGreen();
                nArray[2] = color.getBlue();
                writableRaster.setPixel(j, i, nArray);
            }
        }
    }

    private static void alterRasterY2Gray(WritableRaster writableRaster) {
        int[] nArray = new int[1];
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                int n3 = nArray[0];
                int n4 = (byte)(n3 < 0 ? 0 : (byte)(n3 > 255 ? -1 : (byte)n3));
                nArray[0] = 255 - n4;
                writableRaster.setPixel(j, i, nArray);
            }
        }
    }

    private static int getJPEGEncoding(byte[] byArray, int n) {
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = 0;
        int n6 = 0;
        while (!(n6 >= n || byArray[n6] != -1 || bl && bl2)) {
            byte by = byArray[n6 + 1];
            n6 += 2;
            if (by == -40) continue;
            int n7 = (byArray[n6] << 8 & 0xFF00) + (byArray[n6 + 1] & 0xFF);
            if (by == -18) {
                if (n7 >= 14) {
                    bl = true;
                    n3 = byArray[n6 + 13];
                }
            } else if (by == -64) {
                bl2 = true;
                n4 = byArray[n6 + 7] & 0xFF;
            } else if (by == -38) {
                bl3 = true;
                n5 = byArray[n6 + 2] & 0xFF;
            }
            n6 += n7;
        }
        if (bl && bl2) {
            if (n3 == 0) {
                if (n4 == 1) {
                    n2 = 5;
                }
                if (n4 == 3) {
                    n2 = 1;
                } else if (n4 == 4) {
                    n2 = 2;
                }
            } else if (n3 == 1) {
                n2 = 3;
            } else if (n3 == 2) {
                n2 = 4;
            }
        } else if (bl3 && n5 == 1) {
            n2 = 5;
        }
        return n2;
    }

    private static BufferedImage makeRGBABufferedImage(WritableRaster writableRaster) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 8;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, true, false, 1, writableRaster.getTransferType());
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private static BufferedImage makeRGBBufferedImage(WritableRaster writableRaster) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 8;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, writableRaster.getTransferType());
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private static BufferedImage makeGrayBufferedImage(WritableRaster writableRaster) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 8;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, writableRaster.getTransferType());
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private BufferedImage makeRGBABufferedImageFromImage(Image image) {
        BufferedImage bufferedImage = null;
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = 0;
        while (n < 0 || n2 < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = image.getWidth(null);
            n2 = image.getHeight(null);
            if (++n3 <= 20) continue;
        }
        if (n >= 0 && n2 >= 0) {
            this.checkMemory(n * n2 * 4);
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            image.flush();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nonDecodeCCITTMakeImage(Color color) {
        BufferedImage bufferedImage = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, color);
        if (bufferedImage != null) {
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image == null) {
                    this.image = new ImageCache(this.library);
                }
                this.image.setImage(bufferedImage);
            }
            return true;
        }
        return false;
    }

    private byte[] ccittfaxDecode(InputStream inputStream) {
        Hashtable hashtable = this.library.getDictionary(this.entries, "DecodeParms");
        float f = this.library.getFloat(hashtable, "K");
        boolean bl = this.getBlackIs1(this.library, hashtable);
        boolean bl2 = false;
        Object object = this.library.getObject(hashtable, "EncodedByteAlign");
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        int n = this.library.getInt(hashtable, "Columns");
        int n2 = this.library.getInt(this.entries, "Width");
        int n3 = this.library.getInt(this.entries, "Height");
        int n4 = n2 * n3 / 8;
        this.checkMemory(n4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
        if (f < 0.0f) {
            CCITTFax.Group4Decode(inputStream, byteArrayOutputStream, n, bl);
        }
        try {
            byteArrayOutputStream.close();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!bl2) {
            this.isCCITTFaxDecodeWithoutEncodedByteAlign = true;
        }
        if (n > n2) {
            this.CCITTFaxDecodeColumnWidthMismatch = n - n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes() {
        byte[] byArray = this.getDecodedStreamBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public BufferedImage getImage(Color color, Resources resources, boolean bl) {
        Object object;
        boolean bl2;
        PColorSpace pColorSpace = null;
        Object object2 = this.library.getObject(this.entries, "ColorSpace");
        if (resources != null) {
            pColorSpace = resources.getColorSpace(object2);
        }
        if (pColorSpace == null) {
            pColorSpace = new DeviceGray(this.library, null);
        }
        if (bl2 = this.isImageMask()) {
            bl = false;
        }
        int n = this.library.getInt(this.entries, "BitsPerComponent");
        if (bl2 && n == 0) {
            n = 1;
        }
        int n2 = this.library.getInt(this.entries, "Width");
        int n3 = this.library.getInt(this.entries, "Height");
        int n4 = pColorSpace.getNumComponents();
        Vector<Float> vector = (Vector<Float>)this.library.getObject(this.entries, "Decode");
        if (vector == null) {
            vector = new Vector<Float>();
            vector.addElement(new Float(0.0f));
            vector.addElement(new Float(1.0f));
        }
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        int n5 = -1;
        int n6 = -1;
        Object object3 = this.library.getObject(this.entries, "SMask");
        Object object4 = this.library.getObject(this.entries, "Mask");
        if (object3 instanceof Stream && ((Stream)(object = (Stream)object3)).isImageSubtype()) {
            bufferedImage = ((Stream)object).getImage(color, resources, false);
        }
        if (bufferedImage != null) {
            bl = false;
        }
        if (object4 != null && bufferedImage == null) {
            if (object4 instanceof Stream) {
                object = (Stream)object4;
                if (((Stream)object).isImageSubtype()) {
                    bufferedImage2 = ((Stream)object).getImage(color, resources, false);
                }
            } else if (object4 instanceof Vector) {
                object = (Vector)object4;
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    if (i * 2 < ((Vector)object).size()) {
                        nArray3[i] = ((Number)((Vector)object).get(i * 2)).intValue();
                    }
                    if (i * 2 + 1 >= ((Vector)object).size()) continue;
                    nArray4[i] = ((Number)((Vector)object).get(i * 2 + 1)).intValue();
                }
                if (pColorSpace instanceof Indexed) {
                    Indexed indexed = (Indexed)pColorSpace;
                    Color[] colorArray = indexed.accessColorTable();
                    if (colorArray != null && nArray3.length >= 1 && nArray4.length >= 1) {
                        n5 = nArray3[0];
                        n6 = nArray4[0];
                        if (n5 >= 0 && n5 < colorArray.length && n6 >= 0 && n6 < colorArray.length) {
                            Color color2 = colorArray[nArray3[0]];
                            Color color3 = colorArray[nArray4[0]];
                            nArray = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
                            nArray2 = new int[]{color3.getRed(), color3.getGreen(), color3.getBlue()};
                        }
                    }
                } else {
                    PColorSpace.reverseInPlace(nArray3);
                    PColorSpace.reverseInPlace(nArray4);
                    float[] fArray = new float[n4];
                    float[] fArray2 = new float[n4];
                    pColorSpace.normaliseComponentsToFloats(nArray3, fArray, (1 << n) - 1);
                    pColorSpace.normaliseComponentsToFloats(nArray4, fArray2, (1 << n) - 1);
                    Color color4 = pColorSpace.getColor(fArray);
                    Color color5 = pColorSpace.getColor(fArray2);
                    PColorSpace.reverseInPlace(fArray);
                    PColorSpace.reverseInPlace(fArray2);
                    nArray = new int[]{color4.getRed(), color4.getGreen(), color4.getBlue()};
                    nArray2 = new int[]{color5.getRed(), color5.getGreen(), color5.getBlue()};
                }
            }
        }
        if ((object = this.getImage(pColorSpace, color, n2, n3, n4, n, bl2, vector, bufferedImage, bufferedImage2, nArray, nArray2, n5, n6)) != null) {
            object = this.putIntoImageCache((BufferedImage)object, n2, n3, bl);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(PColorSpace pColorSpace, Color color, int n, int n2, int n3, int n4, boolean bl, Vector vector, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2, int n5, int n6) {
        BufferedImage bufferedImage3;
        byte[] byArray = null;
        if (this.image == null) {
            byArray = this.decodeCCITTFaxDecodeOrDCTDecodeImage(n, n2, pColorSpace, n4, color, bufferedImage, bufferedImage2, nArray, nArray2);
        }
        if (this.image != null) {
            this.checkMemory(n * n2 * Math.max(n3, 4));
            bufferedImage3 = null;
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image != null) {
                    bufferedImage3 = this.image.readImage();
                }
            }
            if (bufferedImage3 != null) {
                return bufferedImage3;
            }
        }
        if (byArray == null) {
            try {
                bufferedImage3 = this.makeImageWithRasterFromBytes(pColorSpace, color, n, n2, n3, n4, bl, vector, bufferedImage, bufferedImage2, nArray, nArray2, n5, n6);
                if (bufferedImage3 != null) {
                    return bufferedImage3;
                }
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error building image raster.", exception);
            }
        }
        bufferedImage3 = this.parseImage(n, n2, pColorSpace, bl, color, n4, vector, byArray, bufferedImage, bufferedImage2, nArray, nArray2);
        return bufferedImage3;
    }

    private BufferedImage makeImageWithRasterFromBytes(PColorSpace pColorSpace, Color color, int n, int n2, int n3, int n4, boolean bl, Vector vector, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2, int n5, int n6) {
        BufferedImage bufferedImage3 = null;
        if (pColorSpace instanceof DeviceGray) {
            if (bl && n4 == 1) {
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                byte[] byArray = (byte[])objectArray[0];
                int n7 = (Integer)objectArray[1];
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n7);
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n4, new Point(0, 0));
                boolean bl2 = 0.0f == ((Number)vector.elementAt(0)).floatValue();
                int n8 = 0xFFFFFF;
                int[] nArray3 = new int[]{bl2 ? color.getRGB() : n8, bl2 ? n8 : color.getRGB()};
                int n9 = bl2 ? 1 : 0;
                IndexColorModel indexColorModel = new IndexColorModel(n4, nArray3.length, nArray3, 0, true, n9, dataBufferByte.getDataType());
                bufferedImage3 = new BufferedImage(indexColorModel, writableRaster, false, null);
            } else if (n4 == 1 || n4 == 2 || n4 == 4) {
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                byte[] byArray = (byte[])objectArray[0];
                int n10 = (Integer)objectArray[1];
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n10);
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n4, new Point(0, 0));
                int[] nArray4 = null;
                if (n4 == 1) {
                    boolean bl3 = 0.0f == ((Number)vector.elementAt(0)).floatValue();
                    nArray4 = bl3 ? GRAY_1_BIT_INDEX_TO_RGB : GRAY_1_BIT_INDEX_TO_RGB_REVERSED;
                } else if (n4 == 2) {
                    nArray4 = GRAY_2_BIT_INDEX_TO_RGB;
                } else if (n4 == 4) {
                    nArray4 = GRAY_4_BIT_INDEX_TO_RGB;
                }
                IndexColorModel indexColorModel = new IndexColorModel(n4, nArray4.length, nArray4, 0, false, -1, dataBufferByte.getDataType());
                bufferedImage3 = new BufferedImage(indexColorModel, writableRaster, false, null);
            } else if (n4 == 8) {
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                byte[] byArray = (byte[])objectArray[0];
                int n11 = (Integer)objectArray[1];
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n11);
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBufferByte.getDataType(), n, n2, 1, n, new int[]{0});
                WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{n4}, false, false, 1, dataBufferByte.getDataType());
                bufferedImage3 = new BufferedImage(componentColorModel, writableRaster, false, null);
            }
        } else if (pColorSpace instanceof DeviceRGB) {
            if (n4 == 8) {
                int n12;
                int n13;
                Object object;
                boolean bl4;
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                Object object2 = (byte[])objectArray[0];
                int n14 = (Integer)objectArray[1];
                int n15 = n3;
                boolean bl5 = bl4 = bufferedImage != null || bufferedImage2 != null || nArray != null && nArray2 != null;
                if (bl4) {
                    this.checkMemory(n * n2 * 4);
                    object = new byte[n * n2 * 4];
                    int n16 = 0;
                    n13 = 0;
                    int n17 = n14 - 3;
                    while (n16 < n17) {
                        byte by = object2[n16++];
                        byte by2 = object2[n16++];
                        n12 = object2[n16++];
                        int n18 = -1;
                        object[n13++] = n12;
                        object[n13++] = by2;
                        object[n13++] = by;
                        object[n13++] = n18;
                    }
                    object2 = object;
                    n15 = 4;
                }
                object = new DataBufferByte((byte[])object2, n14);
                int[] nArray5 = new int[n15];
                for (n13 = 0; n13 < n15; ++n13) {
                    nArray5[n13] = n13;
                }
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(((DataBuffer)object).getDataType(), n, n2, n15, n15 * n, nArray5);
                WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, (DataBuffer)object, new Point(0, 0));
                if (bl4) {
                    Stream.alterRasterBGRA(writableRaster, bufferedImage, bufferedImage2, nArray, nArray2);
                }
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray6 = new int[n15];
                for (n12 = 0; n12 < n15; ++n12) {
                    nArray6[n12] = n4;
                }
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray6, bl4, false, bl4 ? 2 : 1, ((DataBuffer)object).getDataType());
                bufferedImage3 = new BufferedImage(componentColorModel, writableRaster, false, null);
            }
        } else if (!(pColorSpace instanceof DeviceCMYK) && pColorSpace instanceof Indexed) {
            if (n4 == 1 || n4 == 2 || n4 == 4) {
                Object object;
                int n19;
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                byte[] byArray = (byte[])objectArray[0];
                int n20 = (Integer)objectArray[1];
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n20);
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n4, new Point(0, 0));
                pColorSpace.init();
                Color[] colorArray = ((Indexed)pColorSpace).accessColorTable();
                int[] nArray7 = new int[colorArray == null ? 0 : colorArray.length];
                for (n19 = 0; n19 < nArray7.length; ++n19) {
                    nArray7[n19] = colorArray[n19].getRGB();
                }
                n19 = 1 << n4;
                if (nArray7.length > n19) {
                    object = new int[n19];
                    System.arraycopy(nArray7, 0, object, 0, n19);
                    nArray7 = object;
                }
                object = new IndexColorModel(n4, nArray7.length, nArray7, 0, false, -1, dataBufferByte.getDataType());
                bufferedImage3 = new BufferedImage((ColorModel)object, writableRaster, false, null);
            } else if (n4 == 8) {
                boolean bl6;
                int n21;
                Object[] objectArray = this.getDecodedStreamBytesAndSize(n * n2 * pColorSpace.getNumComponents() * n4 / 8);
                byte[] byArray = (byte[])objectArray[0];
                int n22 = (Integer)objectArray[1];
                pColorSpace.init();
                Color[] colorArray = ((Indexed)pColorSpace).accessColorTable();
                int n23 = colorArray == null ? 0 : colorArray.length;
                int[] nArray8 = new int[256];
                for (n21 = 0; n21 < n23; ++n21) {
                    nArray8[n21] = colorArray[n21].getRGB();
                }
                for (n21 = n23; n21 < nArray8.length; ++n21) {
                    nArray8[n21] = -16777216;
                }
                n21 = n5 >= 0 && n6 >= 0 ? 1 : 0;
                boolean bl7 = bl6 = bufferedImage != null || bufferedImage2 != null || nArray != null && nArray2 != null;
                if (n21 != 0) {
                    for (int i = n5; i <= n6; ++i) {
                        nArray8[i] = 0;
                    }
                    DataBufferByte dataBufferByte = new DataBufferByte(byArray, n22);
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBufferByte.getDataType(), n, n2, 1, n, new int[]{0});
                    WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
                    IndexColorModel indexColorModel = new IndexColorModel(n4, nArray8.length, nArray8, 0, true, -1, dataBufferByte.getDataType());
                    bufferedImage3 = new BufferedImage(indexColorModel, writableRaster, false, null);
                } else if (bl6) {
                    this.checkMemory(n * n2 * 4);
                    int[] nArray9 = new int[n * n2];
                    int n24 = n22;
                    for (int i = 0; i < n24; ++i) {
                        int n25 = byArray[i] & 0xFF;
                        nArray9[i] = nArray8[n25];
                    }
                    DataBufferInt dataBufferInt = new DataBufferInt(nArray9, nArray9.length);
                    int[] nArray10 = new int[]{0xFF0000, 65280, 255, -16777216};
                    WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray10, new Point(0, 0));
                    Stream.alterRasterRGBA(writableRaster, bufferedImage, bufferedImage2, nArray, nArray2);
                    ColorSpace colorSpace = ColorSpace.getInstance(1000);
                    DirectColorModel directColorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, dataBufferInt.getDataType());
                    bufferedImage3 = new BufferedImage(directColorModel, writableRaster, false, null);
                } else {
                    DataBufferByte dataBufferByte = new DataBufferByte(byArray, n22);
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(dataBufferByte.getDataType(), n, n2, 1, n, new int[]{0});
                    WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
                    IndexColorModel indexColorModel = new IndexColorModel(n4, nArray8.length, nArray8, 0, false, -1, dataBufferByte.getDataType());
                    bufferedImage3 = new BufferedImage(indexColorModel, writableRaster, false, null);
                }
            }
        }
        return bufferedImage3;
    }

    private BufferedImage parseImage(int n, int n2, PColorSpace pColorSpace, boolean bl, Color color, int n3, Vector vector, byte[] byArray, BufferedImage bufferedImage, BufferedImage bufferedImage2, int[] nArray, int[] nArray2) {
        int n4;
        int n5;
        int[] nArray3 = new int[n];
        int n6 = color.getRGB();
        int n7 = pColorSpace.getNumComponents();
        boolean bl2 = pColorSpace instanceof DeviceRGB;
        boolean bl3 = pColorSpace instanceof DeviceGray;
        int n8 = (1 << n3) - 1;
        int[] nArray4 = new int[n7];
        float[] fArray = new float[n7];
        int n9 = ((Number)vector.elementAt(0)).intValue();
        float[] fArray2 = null;
        if (vector != null) {
            fArray2 = new float[vector.size()];
            for (n5 = 0; n5 < fArray2.length; ++n5) {
                fArray2[n5] = ((Number)vector.elementAt(n5)).floatValue();
            }
        }
        n5 = n * n2 * 4;
        this.checkMemory(n5);
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        int n10 = n * n7 * n3;
        int n11 = n10 & 7;
        if (this.CCITTFaxDecodeColumnWidthMismatch > 0) {
            int n12 = (n + this.CCITTFaxDecodeColumnWidthMismatch) * n7 * n3;
            n4 = n10;
            n11 = n12 - n4;
        }
        BitStream bitStream = null;
        if (byArray != null) {
            bitStream = new BitStream(new ByteArrayInputStream(byArray));
        } else {
            InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
            if (inputStream == null) {
                return null;
            }
            bitStream = new BitStream(inputStream);
        }
        try {
            for (n4 = 0; n4 < n2; ++n4) {
                for (int i = 0; i < n; ++i) {
                    int n13;
                    if (bl) {
                        n13 = bitStream.getBits(n3);
                        nArray3[i] = n13 = n13 == n9 ? n6 : 0;
                        continue;
                    }
                    n13 = 255;
                    int n14 = 255;
                    int n15 = 255;
                    int n16 = 255;
                    if (n7 == 1) {
                        int n17 = bitStream.getBits(n3);
                        if (fArray2 != null && fArray2[0] > fArray2[1]) {
                            int n18 = n17 = n17 == n8 ? 0 : n8;
                        }
                        if (bl3) {
                            if (n3 == 1) {
                                n17 = GRAY_1_BIT_INDEX_TO_RGB[n17];
                            } else if (n3 == 2) {
                                n17 = GRAY_2_BIT_INDEX_TO_RGB[n17];
                            } else if (n3 == 4) {
                                n17 = GRAY_4_BIT_INDEX_TO_RGB[n17];
                            } else if (n3 == 8) {
                                n17 = n17 << 24 | n17 << 16 | n17 << 8 | n17;
                            }
                            nArray3[i] = n17;
                            continue;
                        }
                        nArray4[0] = n17;
                        pColorSpace.normaliseComponentsToFloats(nArray4, fArray, n8);
                        Color color2 = pColorSpace.getColor(fArray);
                        nArray3[i] = color2.getRGB();
                        continue;
                    }
                    if (n7 == 3) {
                        if (bl2) {
                            n13 = bitStream.getBits(n3);
                            n15 = bitStream.getBits(n3);
                            n14 = bitStream.getBits(n3);
                            nArray3[i] = n16 << 24 | n13 << 16 | n15 << 8 | n14;
                            continue;
                        }
                        for (int j = 0; j < n7; ++j) {
                            nArray4[j] = bitStream.getBits(n3);
                        }
                        PColorSpace.reverseInPlace(nArray4);
                        pColorSpace.normaliseComponentsToFloats(nArray4, fArray, n8);
                        Color color3 = pColorSpace.getColor(fArray);
                        nArray3[i] = color3.getRGB();
                        continue;
                    }
                    if (n7 == 4) {
                        for (int j = 0; j < n7; ++j) {
                            nArray4[j] = bitStream.getBits(n3);
                        }
                        PColorSpace.reverseInPlace(nArray4);
                        pColorSpace.normaliseComponentsToFloats(nArray4, fArray, n8);
                        Color color4 = pColorSpace.getColor(fArray);
                        nArray3[i] = color4.getRGB();
                        continue;
                    }
                    nArray3[i] = n16 << 24 | n13 << 16 | n15 << 8 | n14;
                }
                bufferedImage3.setRGB(0, n4, n, 1, nArray3, 0, 1);
                if (n11 <= 0 || this.isCCITTFaxDecodeWithoutEncodedByteAlign && this.CCITTFaxDecodeColumnWidthMismatch <= 0) continue;
                bitStream.getBits(n11);
            }
            bitStream.close();
            bitStream = null;
            if (bufferedImage != null || bufferedImage2 != null || nArray != null || nArray2 != null) {
                WritableRaster writableRaster = bufferedImage3.getRaster();
                Stream.alterRasterRGBA(writableRaster, bufferedImage, bufferedImage2, nArray, nArray2);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error parsing image.", iOException);
        }
        return bufferedImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage putIntoImageCache(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        boolean bl2;
        if (this.image == null) {
            this.image = new ImageCache(this.library);
        }
        boolean bl3 = false;
        if (bl && scaleImages && !this.image.isScaled() && (bl2 = this.checkMemory(Math.max(n, bufferedImage.getWidth()) * Math.max(n2, bufferedImage.getHeight()) * Math.max(4, bufferedImage.getColorModel().getPixelSize())))) {
            bufferedImage = ImageCache.scaleBufferedImage(bufferedImage, n, n2);
            bl3 = true;
        }
        Object object = this.imageLock;
        synchronized (object) {
            if (this.image == null) {
                this.image = new ImageCache(this.library);
            }
            if (bl3) {
                this.image.setIsScaled(true);
            }
            this.image.setImage(bufferedImage);
            bufferedImage = this.image.readImage();
        }
        return bufferedImage;
    }

    public boolean isImageMask() {
        Object object = this.library.getObject(this.entries, "ImageMask");
        return object != null ? object.toString().equals("true") : false;
    }

    public boolean getBlackIs1(Library library, Hashtable hashtable) {
        Boolean bl = this.getBlackIs1OrNull(library, hashtable);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public Boolean getBlackIs1OrNull(Library library, Hashtable hashtable) {
        Object object = library.getObject(hashtable, "BlackIs1");
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                String string = (String)object;
                if (string.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (string.equalsIgnoreCase("t")) {
                    return Boolean.TRUE;
                }
                if (string.equals("1")) {
                    return Boolean.TRUE;
                }
                if (string.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (string.equalsIgnoreCase("f")) {
                    return Boolean.FALSE;
                }
                if (string.equals("0")) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("STREAM= ");
        stringBuffer.append(this.entries);
        if (this.getPObjectReference() != null) {
            stringBuffer.append("  ");
            stringBuffer.append(this.getPObjectReference());
        }
        return stringBuffer.toString();
    }
}

