/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.syntax.Token;

public class BinaryExpression
extends Expression {
    private Expression leftExpression;
    private Expression rightExpression;
    private Token operation;

    public BinaryExpression(Expression leftExpression, Token operation, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.operation = operation;
        this.rightExpression = rightExpression;
    }

    public String toString() {
        return super.toString() + "[" + this.leftExpression + this.operation + this.rightExpression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        BinaryExpression ret = new BinaryExpression(transformer.transform(this.leftExpression), this.operation, transformer.transform(this.rightExpression));
        ret.setSourcePosition(this);
        return ret;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Token getOperation() {
        return this.operation;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public String getText() {
        if (this.operation.getType() == 30) {
            return this.leftExpression.getText() + "[" + this.rightExpression.getText() + "]";
        }
        return "(" + this.leftExpression.getText() + " " + this.operation.getText() + " " + this.rightExpression.getText() + ")";
    }
}

