/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.VarMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractVarMeta
extends MPPComponent
implements VarMeta {
    protected int m_unknown1;
    protected int m_itemCount;
    protected int m_unknown2;
    protected int m_unknown3;
    protected int m_dataSize;
    protected int[] m_offsets;
    protected Map<Integer, Map<Integer, Integer>> m_table = new TreeMap<Integer, Map<Integer, Integer>>();

    AbstractVarMeta() {
    }

    @Override
    public int getItemCount() {
        return this.m_itemCount;
    }

    @Override
    public int getDataSize() {
        return this.m_dataSize;
    }

    @Override
    public Integer[] getUniqueIdentifierArray() {
        Integer[] integerArray = new Integer[this.m_table.size()];
        int n = 0;
        Iterator<Integer> iterator = this.m_table.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2;
            integerArray[n] = n2 = iterator.next();
            ++n;
        }
        return integerArray;
    }

    @Override
    public Set<Integer> getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    @Override
    public Integer getOffset(Integer n, Integer n2) {
        Integer n3 = null;
        Map<Integer, Integer> map = this.m_table.get(n);
        if (map != null && n2 != null) {
            n3 = map.get(n2);
        }
        return n3;
    }

    @Override
    public int getOffset(int n) {
        return this.m_offsets[n];
    }

    @Override
    public Set<Integer> getTypes(Integer n) {
        Map<Integer, Integer> map = this.m_table.get(n);
        Set<Integer> set = map != null ? map.keySet() : new HashSet<Integer>();
        return set;
    }

    @Override
    public boolean containsKey(Integer n) {
        return this.m_table.containsKey(n);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(FieldMap fieldMap) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN: VarMeta");
        printWriter.println("   Item count: " + this.m_itemCount);
        printWriter.println("   Data size: " + this.m_dataSize);
        for (Integer n : this.m_table.keySet()) {
            printWriter.println("   Entries for Unique ID: " + n);
            Map<Integer, Integer> map = this.m_table.get(n);
            for (Integer n2 : map.keySet()) {
                Integer n3 = map.get(n2);
                FieldType fieldType = fieldMap == null ? null : fieldMap.getFieldTypeFromVarDataKey(n2);
                printWriter.println("      Type=" + (fieldType == null ? n2 : fieldType) + " Offset=" + n3);
            }
        }
        printWriter.println("END: VarMeta");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

