/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedCostData;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.TimephasedWorkData;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceAssignment
extends ProjectEntity
implements FieldContainer {
    private Object[] m_array = new Object[AssignmentField.MAX_VALUE];
    private boolean m_eventsEnabled = true;
    private TimephasedWorkData m_timephasedWork;
    private List<TimephasedCost> m_timephasedCost;
    private TimephasedWorkData m_timephasedActualWork;
    private List<TimephasedCost> m_timephasedActualCost;
    private TimephasedWorkData m_timephasedOvertimeWork;
    private TimephasedWorkData m_timephasedActualOvertimeWork;
    private List<FieldListener> m_listeners;
    private TimephasedWorkData[] m_timephasedBaselineWork = new TimephasedWorkData[11];
    private TimephasedCostData[] m_timephasedBaselineCost = new TimephasedCostData[11];
    private Task m_task;
    private ResourceAssignmentWorkgroupFields m_workgroup;
    public static final Double DEFAULT_UNITS = 100.0;
    private static final AssignmentField[] BASELINE_COSTS = new AssignmentField[]{AssignmentField.BASELINE1_COST, AssignmentField.BASELINE2_COST, AssignmentField.BASELINE3_COST, AssignmentField.BASELINE4_COST, AssignmentField.BASELINE5_COST, AssignmentField.BASELINE6_COST, AssignmentField.BASELINE7_COST, AssignmentField.BASELINE8_COST, AssignmentField.BASELINE9_COST, AssignmentField.BASELINE10_COST};
    private static final AssignmentField[] BASELINE_WORKS = new AssignmentField[]{AssignmentField.BASELINE1_WORK, AssignmentField.BASELINE2_WORK, AssignmentField.BASELINE3_WORK, AssignmentField.BASELINE4_WORK, AssignmentField.BASELINE5_WORK, AssignmentField.BASELINE6_WORK, AssignmentField.BASELINE7_WORK, AssignmentField.BASELINE8_WORK, AssignmentField.BASELINE9_WORK, AssignmentField.BASELINE10_WORK};
    private static final AssignmentField[] BASELINE_STARTS = new AssignmentField[]{AssignmentField.BASELINE1_START, AssignmentField.BASELINE2_START, AssignmentField.BASELINE3_START, AssignmentField.BASELINE4_START, AssignmentField.BASELINE5_START, AssignmentField.BASELINE6_START, AssignmentField.BASELINE7_START, AssignmentField.BASELINE8_START, AssignmentField.BASELINE9_START, AssignmentField.BASELINE10_START};
    private static final AssignmentField[] BASELINE_FINISHES = new AssignmentField[]{AssignmentField.BASELINE1_FINISH, AssignmentField.BASELINE2_FINISH, AssignmentField.BASELINE3_FINISH, AssignmentField.BASELINE4_FINISH, AssignmentField.BASELINE5_FINISH, AssignmentField.BASELINE6_FINISH, AssignmentField.BASELINE7_FINISH, AssignmentField.BASELINE8_FINISH, AssignmentField.BASELINE9_FINISH, AssignmentField.BASELINE10_FINISH};
    private static final AssignmentField[] BASELINE_BUDGET_COSTS = new AssignmentField[]{AssignmentField.BASELINE1_BUDGET_COST, AssignmentField.BASELINE2_BUDGET_COST, AssignmentField.BASELINE3_BUDGET_COST, AssignmentField.BASELINE4_BUDGET_COST, AssignmentField.BASELINE5_BUDGET_COST, AssignmentField.BASELINE6_BUDGET_COST, AssignmentField.BASELINE7_BUDGET_COST, AssignmentField.BASELINE8_BUDGET_COST, AssignmentField.BASELINE9_BUDGET_COST, AssignmentField.BASELINE10_BUDGET_COST};
    private static final AssignmentField[] BASELINE_BUDGET_WORKS = new AssignmentField[]{AssignmentField.BASELINE1_BUDGET_WORK, AssignmentField.BASELINE2_BUDGET_WORK, AssignmentField.BASELINE3_BUDGET_WORK, AssignmentField.BASELINE4_BUDGET_WORK, AssignmentField.BASELINE5_BUDGET_WORK, AssignmentField.BASELINE6_BUDGET_WORK, AssignmentField.BASELINE7_BUDGET_WORK, AssignmentField.BASELINE8_BUDGET_WORK, AssignmentField.BASELINE9_BUDGET_WORK, AssignmentField.BASELINE10_BUDGET_WORK};
    private static final AssignmentField[] CUSTOM_TEXT = new AssignmentField[]{AssignmentField.TEXT1, AssignmentField.TEXT2, AssignmentField.TEXT3, AssignmentField.TEXT4, AssignmentField.TEXT5, AssignmentField.TEXT6, AssignmentField.TEXT7, AssignmentField.TEXT8, AssignmentField.TEXT9, AssignmentField.TEXT10, AssignmentField.TEXT11, AssignmentField.TEXT12, AssignmentField.TEXT13, AssignmentField.TEXT14, AssignmentField.TEXT15, AssignmentField.TEXT16, AssignmentField.TEXT17, AssignmentField.TEXT18, AssignmentField.TEXT19, AssignmentField.TEXT20, AssignmentField.TEXT21, AssignmentField.TEXT22, AssignmentField.TEXT23, AssignmentField.TEXT24, AssignmentField.TEXT25, AssignmentField.TEXT26, AssignmentField.TEXT27, AssignmentField.TEXT28, AssignmentField.TEXT29, AssignmentField.TEXT30};
    private static final AssignmentField[] CUSTOM_START = new AssignmentField[]{AssignmentField.START1, AssignmentField.START2, AssignmentField.START3, AssignmentField.START4, AssignmentField.START5, AssignmentField.START6, AssignmentField.START7, AssignmentField.START8, AssignmentField.START9, AssignmentField.START10};
    private static final AssignmentField[] CUSTOM_FINISH = new AssignmentField[]{AssignmentField.FINISH1, AssignmentField.FINISH2, AssignmentField.FINISH3, AssignmentField.FINISH4, AssignmentField.FINISH5, AssignmentField.FINISH6, AssignmentField.FINISH7, AssignmentField.FINISH8, AssignmentField.FINISH9, AssignmentField.FINISH10};
    private static final AssignmentField[] CUSTOM_DATE = new AssignmentField[]{AssignmentField.DATE1, AssignmentField.DATE2, AssignmentField.DATE3, AssignmentField.DATE4, AssignmentField.DATE5, AssignmentField.DATE6, AssignmentField.DATE7, AssignmentField.DATE8, AssignmentField.DATE9, AssignmentField.DATE10};
    private static final AssignmentField[] CUSTOM_NUMBER = new AssignmentField[]{AssignmentField.NUMBER1, AssignmentField.NUMBER2, AssignmentField.NUMBER3, AssignmentField.NUMBER4, AssignmentField.NUMBER5, AssignmentField.NUMBER6, AssignmentField.NUMBER7, AssignmentField.NUMBER8, AssignmentField.NUMBER9, AssignmentField.NUMBER10, AssignmentField.NUMBER11, AssignmentField.NUMBER12, AssignmentField.NUMBER13, AssignmentField.NUMBER14, AssignmentField.NUMBER15, AssignmentField.NUMBER16, AssignmentField.NUMBER17, AssignmentField.NUMBER18, AssignmentField.NUMBER19, AssignmentField.NUMBER20};
    private static final AssignmentField[] CUSTOM_DURATION = new AssignmentField[]{AssignmentField.DURATION1, AssignmentField.DURATION2, AssignmentField.DURATION3, AssignmentField.DURATION4, AssignmentField.DURATION5, AssignmentField.DURATION6, AssignmentField.DURATION7, AssignmentField.DURATION8, AssignmentField.DURATION9, AssignmentField.DURATION10};
    private static final AssignmentField[] CUSTOM_COST = new AssignmentField[]{AssignmentField.COST1, AssignmentField.COST2, AssignmentField.COST3, AssignmentField.COST4, AssignmentField.COST5, AssignmentField.COST6, AssignmentField.COST7, AssignmentField.COST8, AssignmentField.COST9, AssignmentField.COST10};
    private static final AssignmentField[] CUSTOM_FLAG = new AssignmentField[]{AssignmentField.FLAG1, AssignmentField.FLAG2, AssignmentField.FLAG3, AssignmentField.FLAG4, AssignmentField.FLAG5, AssignmentField.FLAG6, AssignmentField.FLAG7, AssignmentField.FLAG8, AssignmentField.FLAG9, AssignmentField.FLAG10, AssignmentField.FLAG11, AssignmentField.FLAG12, AssignmentField.FLAG13, AssignmentField.FLAG14, AssignmentField.FLAG15, AssignmentField.FLAG16, AssignmentField.FLAG17, AssignmentField.FLAG18, AssignmentField.FLAG19, AssignmentField.FLAG20};
    private static final AssignmentField[] ENTERPRISE_COST = new AssignmentField[]{AssignmentField.ENTERPRISE_COST1, AssignmentField.ENTERPRISE_COST2, AssignmentField.ENTERPRISE_COST3, AssignmentField.ENTERPRISE_COST4, AssignmentField.ENTERPRISE_COST5, AssignmentField.ENTERPRISE_COST6, AssignmentField.ENTERPRISE_COST7, AssignmentField.ENTERPRISE_COST8, AssignmentField.ENTERPRISE_COST9, AssignmentField.ENTERPRISE_COST10};
    private static final AssignmentField[] ENTERPRISE_DATE = new AssignmentField[]{AssignmentField.ENTERPRISE_DATE1, AssignmentField.ENTERPRISE_DATE2, AssignmentField.ENTERPRISE_DATE3, AssignmentField.ENTERPRISE_DATE4, AssignmentField.ENTERPRISE_DATE5, AssignmentField.ENTERPRISE_DATE6, AssignmentField.ENTERPRISE_DATE7, AssignmentField.ENTERPRISE_DATE8, AssignmentField.ENTERPRISE_DATE9, AssignmentField.ENTERPRISE_DATE10, AssignmentField.ENTERPRISE_DATE11, AssignmentField.ENTERPRISE_DATE12, AssignmentField.ENTERPRISE_DATE13, AssignmentField.ENTERPRISE_DATE14, AssignmentField.ENTERPRISE_DATE15, AssignmentField.ENTERPRISE_DATE16, AssignmentField.ENTERPRISE_DATE17, AssignmentField.ENTERPRISE_DATE18, AssignmentField.ENTERPRISE_DATE19, AssignmentField.ENTERPRISE_DATE20, AssignmentField.ENTERPRISE_DATE21, AssignmentField.ENTERPRISE_DATE22, AssignmentField.ENTERPRISE_DATE23, AssignmentField.ENTERPRISE_DATE24, AssignmentField.ENTERPRISE_DATE25, AssignmentField.ENTERPRISE_DATE26, AssignmentField.ENTERPRISE_DATE27, AssignmentField.ENTERPRISE_DATE28, AssignmentField.ENTERPRISE_DATE29, AssignmentField.ENTERPRISE_DATE30};
    private static final AssignmentField[] ENTERPRISE_DURATION = new AssignmentField[]{AssignmentField.ENTERPRISE_DURATION1, AssignmentField.ENTERPRISE_DURATION2, AssignmentField.ENTERPRISE_DURATION3, AssignmentField.ENTERPRISE_DURATION4, AssignmentField.ENTERPRISE_DURATION5, AssignmentField.ENTERPRISE_DURATION6, AssignmentField.ENTERPRISE_DURATION7, AssignmentField.ENTERPRISE_DURATION8, AssignmentField.ENTERPRISE_DURATION9, AssignmentField.ENTERPRISE_DURATION10};
    private static final AssignmentField[] ENTERPRISE_FLAG = new AssignmentField[]{AssignmentField.ENTERPRISE_FLAG1, AssignmentField.ENTERPRISE_FLAG2, AssignmentField.ENTERPRISE_FLAG3, AssignmentField.ENTERPRISE_FLAG4, AssignmentField.ENTERPRISE_FLAG5, AssignmentField.ENTERPRISE_FLAG6, AssignmentField.ENTERPRISE_FLAG7, AssignmentField.ENTERPRISE_FLAG8, AssignmentField.ENTERPRISE_FLAG9, AssignmentField.ENTERPRISE_FLAG10, AssignmentField.ENTERPRISE_FLAG11, AssignmentField.ENTERPRISE_FLAG12, AssignmentField.ENTERPRISE_FLAG13, AssignmentField.ENTERPRISE_FLAG14, AssignmentField.ENTERPRISE_FLAG15, AssignmentField.ENTERPRISE_FLAG16, AssignmentField.ENTERPRISE_FLAG17, AssignmentField.ENTERPRISE_FLAG18, AssignmentField.ENTERPRISE_FLAG19, AssignmentField.ENTERPRISE_FLAG20};
    private static final AssignmentField[] ENTERPRISE_NUMBER = new AssignmentField[]{AssignmentField.ENTERPRISE_NUMBER1, AssignmentField.ENTERPRISE_NUMBER2, AssignmentField.ENTERPRISE_NUMBER3, AssignmentField.ENTERPRISE_NUMBER4, AssignmentField.ENTERPRISE_NUMBER5, AssignmentField.ENTERPRISE_NUMBER6, AssignmentField.ENTERPRISE_NUMBER7, AssignmentField.ENTERPRISE_NUMBER8, AssignmentField.ENTERPRISE_NUMBER9, AssignmentField.ENTERPRISE_NUMBER10, AssignmentField.ENTERPRISE_NUMBER11, AssignmentField.ENTERPRISE_NUMBER12, AssignmentField.ENTERPRISE_NUMBER13, AssignmentField.ENTERPRISE_NUMBER14, AssignmentField.ENTERPRISE_NUMBER15, AssignmentField.ENTERPRISE_NUMBER16, AssignmentField.ENTERPRISE_NUMBER17, AssignmentField.ENTERPRISE_NUMBER18, AssignmentField.ENTERPRISE_NUMBER19, AssignmentField.ENTERPRISE_NUMBER20, AssignmentField.ENTERPRISE_NUMBER21, AssignmentField.ENTERPRISE_NUMBER22, AssignmentField.ENTERPRISE_NUMBER23, AssignmentField.ENTERPRISE_NUMBER24, AssignmentField.ENTERPRISE_NUMBER25, AssignmentField.ENTERPRISE_NUMBER26, AssignmentField.ENTERPRISE_NUMBER27, AssignmentField.ENTERPRISE_NUMBER28, AssignmentField.ENTERPRISE_NUMBER29, AssignmentField.ENTERPRISE_NUMBER30, AssignmentField.ENTERPRISE_NUMBER31, AssignmentField.ENTERPRISE_NUMBER32, AssignmentField.ENTERPRISE_NUMBER33, AssignmentField.ENTERPRISE_NUMBER34, AssignmentField.ENTERPRISE_NUMBER35, AssignmentField.ENTERPRISE_NUMBER36, AssignmentField.ENTERPRISE_NUMBER37, AssignmentField.ENTERPRISE_NUMBER38, AssignmentField.ENTERPRISE_NUMBER39, AssignmentField.ENTERPRISE_NUMBER40};
    private static final AssignmentField[] ENTERPRISE_TEXT = new AssignmentField[]{AssignmentField.ENTERPRISE_TEXT1, AssignmentField.ENTERPRISE_TEXT2, AssignmentField.ENTERPRISE_TEXT3, AssignmentField.ENTERPRISE_TEXT4, AssignmentField.ENTERPRISE_TEXT5, AssignmentField.ENTERPRISE_TEXT6, AssignmentField.ENTERPRISE_TEXT7, AssignmentField.ENTERPRISE_TEXT8, AssignmentField.ENTERPRISE_TEXT9, AssignmentField.ENTERPRISE_TEXT10, AssignmentField.ENTERPRISE_TEXT11, AssignmentField.ENTERPRISE_TEXT12, AssignmentField.ENTERPRISE_TEXT13, AssignmentField.ENTERPRISE_TEXT14, AssignmentField.ENTERPRISE_TEXT15, AssignmentField.ENTERPRISE_TEXT16, AssignmentField.ENTERPRISE_TEXT17, AssignmentField.ENTERPRISE_TEXT18, AssignmentField.ENTERPRISE_TEXT19, AssignmentField.ENTERPRISE_TEXT20, AssignmentField.ENTERPRISE_TEXT21, AssignmentField.ENTERPRISE_TEXT22, AssignmentField.ENTERPRISE_TEXT23, AssignmentField.ENTERPRISE_TEXT24, AssignmentField.ENTERPRISE_TEXT25, AssignmentField.ENTERPRISE_TEXT26, AssignmentField.ENTERPRISE_TEXT27, AssignmentField.ENTERPRISE_TEXT28, AssignmentField.ENTERPRISE_TEXT29, AssignmentField.ENTERPRISE_TEXT30, AssignmentField.ENTERPRISE_TEXT31, AssignmentField.ENTERPRISE_TEXT32, AssignmentField.ENTERPRISE_TEXT33, AssignmentField.ENTERPRISE_TEXT34, AssignmentField.ENTERPRISE_TEXT35, AssignmentField.ENTERPRISE_TEXT36, AssignmentField.ENTERPRISE_TEXT37, AssignmentField.ENTERPRISE_TEXT38, AssignmentField.ENTERPRISE_TEXT39, AssignmentField.ENTERPRISE_TEXT40};

    public ResourceAssignment(ProjectFile projectFile) {
        super(projectFile);
        if (projectFile.getAutoAssignmentUniqueID()) {
            this.setUniqueID(projectFile.getAssignmentUniqueID());
        }
    }

    ResourceAssignment(ProjectFile projectFile, Task task) {
        super(projectFile);
        this.m_task = task;
    }

    public ResourceAssignmentWorkgroupFields addWorkgroupAssignment() throws MPXJException {
        if (this.m_workgroup != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_workgroup = new ResourceAssignmentWorkgroupFields();
        return this.m_workgroup;
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.UNIQUE_ID);
    }

    public void setUniqueID(Integer n) {
        this.set((FieldType)AssignmentField.UNIQUE_ID, n);
    }

    public Number getUnits() {
        return (Number)this.getCachedValue(AssignmentField.ASSIGNMENT_UNITS);
    }

    public void setUnits(Number number) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_UNITS, number);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(AssignmentField.WORK);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)AssignmentField.WORK, duration);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_START);
    }

    public void setBaselineStart(Date date) {
        this.set((FieldType)AssignmentField.BASELINE_START, date);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_START);
    }

    public void setActualStart(Date date) {
        this.set((FieldType)AssignmentField.ACTUAL_START, date);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(AssignmentField.BASELINE_FINISH);
    }

    public void setBaselineFinish(Date date) {
        this.set((FieldType)AssignmentField.BASELINE_FINISH, date);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(AssignmentField.ACTUAL_FINISH);
    }

    public void setActualFinish(Date date) {
        this.set((FieldType)AssignmentField.ACTUAL_FINISH, date);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_WORK);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)AssignmentField.BASELINE_WORK, duration);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_WORK);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)AssignmentField.ACTUAL_WORK, duration);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration duration) {
        this.set((FieldType)AssignmentField.OVERTIME_WORK, duration);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(AssignmentField.COST);
    }

    public void setCost(Number number) {
        this.set((FieldType)AssignmentField.COST, number);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_COST);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)AssignmentField.BASELINE_COST, number);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_COST);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)AssignmentField.ACTUAL_COST, number);
    }

    public Date getStart() {
        Date date = (Date)this.getCachedValue(AssignmentField.START);
        if (date == null) {
            date = this.getTask().getStart();
        }
        return date;
    }

    public void setStart(Date date) {
        this.set((FieldType)AssignmentField.START, date);
    }

    public Date getFinish() {
        Date date = (Date)this.getCachedValue(AssignmentField.FINISH);
        if (date == null) {
            date = this.getTask().getFinish();
        }
        return date;
    }

    public void setFinish(Date date) {
        this.set((FieldType)AssignmentField.FINISH, date);
    }

    public Duration getDelay() {
        return (Duration)this.getCachedValue(AssignmentField.ASSIGNMENT_DELAY);
    }

    public void setDelay(Duration duration) {
        this.set((FieldType)AssignmentField.ASSIGNMENT_DELAY, duration);
    }

    public Integer getResourceUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.RESOURCE_UNIQUE_ID);
    }

    public void setResourceUniqueID(Integer n) {
        this.set((FieldType)AssignmentField.RESOURCE_UNIQUE_ID, n);
    }

    public ResourceAssignmentWorkgroupFields getWorkgroupAssignment() {
        return this.m_workgroup;
    }

    public Task getTask() {
        if (this.m_task == null) {
            this.m_task = this.getParentFile().getTaskByUniqueID(this.getTaskUniqueID());
        }
        return this.m_task;
    }

    public Resource getResource() {
        return this.getParentFile().getResourceByUniqueID(this.getResourceUniqueID());
    }

    public WorkContour getWorkContour() {
        return (WorkContour)this.getCachedValue(AssignmentField.WORK_CONTOUR);
    }

    public void setWorkContour(WorkContour workContour) {
        this.set((FieldType)AssignmentField.WORK_CONTOUR, workContour);
    }

    public void remove() {
        this.getParentFile().removeResourceAssignment(this);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_WORK);
    }

    public void setRemainingWork(Duration duration) {
        this.set((FieldType)AssignmentField.REMAINING_WORK, duration);
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(AssignmentField.LEVELING_DELAY);
    }

    public void setLevelingDelay(Duration duration) {
        this.set((FieldType)AssignmentField.LEVELING_DELAY, duration);
    }

    public List<TimephasedWork> getTimephasedActualWork() {
        return this.m_timephasedActualWork == null ? null : this.m_timephasedActualWork.getData();
    }

    public void setTimephasedActualWork(TimephasedWorkData timephasedWorkData) {
        this.m_timephasedActualWork = timephasedWorkData;
    }

    public List<TimephasedWork> getTimephasedWork() {
        return this.m_timephasedWork == null ? null : this.m_timephasedWork.getData();
    }

    public void setTimephasedWork(TimephasedWorkData timephasedWorkData) {
        this.m_timephasedWork = timephasedWorkData;
    }

    public List<TimephasedWork> getTimephasedOvertimeWork() {
        if (this.m_timephasedOvertimeWork == null && this.m_timephasedWork != null && this.getOvertimeWork() != null) {
            double d = this.getRemainingOvertimeWork().getDuration() / (this.getRemainingWork().getDuration() - this.getRemainingOvertimeWork().getDuration());
            double d2 = this.getRemainingOvertimeWork().getDuration() / this.getRemainingWork().getDuration();
            this.m_timephasedOvertimeWork = new TimephasedWorkData(this.m_timephasedWork, d, d2);
        }
        return this.m_timephasedOvertimeWork == null ? null : this.m_timephasedOvertimeWork.getData();
    }

    public void setTimephasedActualOvertimeWork(TimephasedWorkData timephasedWorkData) {
        this.m_timephasedActualOvertimeWork = timephasedWorkData;
    }

    public List<TimephasedWork> getTimephasedActualOvertimeWork() {
        return this.m_timephasedActualOvertimeWork == null ? null : this.m_timephasedActualOvertimeWork.getData();
    }

    public List<TimephasedCost> getTimephasedCost() {
        if (this.m_timephasedCost == null && this.m_timephasedWork != null && this.m_timephasedWork.hasData()) {
            this.m_timephasedCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedWork(), this.getTimephasedOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedWork(), this.getTimephasedOvertimeWork());
        }
        return this.m_timephasedCost;
    }

    public List<TimephasedCost> getTimephasedActualCost() {
        if (this.m_timephasedActualCost == null && this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData()) {
            this.m_timephasedActualCost = this.hasMultipleCostRates() ? this.getTimephasedCostMultipleRates(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork()) : this.getTimephasedCostSingleRate(this.getTimephasedActualWork(), this.getTimephasedActualOvertimeWork());
        }
        return this.m_timephasedActualCost;
    }

    private List<TimephasedCost> getTimephasedCostSingleRate(List<TimephasedWork> list, List<TimephasedWork> list2) {
        LinkedList<TimephasedCost> linkedList = new LinkedList<TimephasedCost>();
        Iterator<TimephasedWork> iterator = list2.iterator();
        for (TimephasedWork timephasedWork : list) {
            Duration duration;
            Duration duration2;
            Duration duration3;
            CostRateTableEntry costRateTableEntry = this.getCostRateTableEntry(timephasedWork.getStart());
            double d = costRateTableEntry.getStandardRate().getAmount();
            TimeUnit timeUnit = costRateTableEntry.getStandardRate().getUnits();
            double d2 = costRateTableEntry.getOvertimeRate().getAmount();
            TimeUnit timeUnit2 = costRateTableEntry.getOvertimeRate().getUnits();
            TimephasedWork timephasedWork2 = iterator.hasNext() ? iterator.next() : null;
            Duration duration4 = (Duration)timephasedWork.getAmountPerDay();
            if (duration4.getUnits() != timeUnit) {
                duration4 = duration4.convertUnits(timeUnit, this.getParentFile().getProjectHeader());
            }
            if ((duration3 = (Duration)timephasedWork.getTotalAmount()).getUnits() != timeUnit) {
                duration3 = duration3.convertUnits(timeUnit, this.getParentFile().getProjectHeader());
            }
            if (timephasedWork2 == null || ((Duration)timephasedWork2.getTotalAmount()).getDuration() == 0.0) {
                duration2 = Duration.getInstance(0, duration4.getUnits());
                duration = Duration.getInstance(0, duration4.getUnits());
            } else {
                duration2 = (Duration)timephasedWork2.getAmountPerDay();
                if (duration2.getUnits() != timeUnit2) {
                    duration2 = duration2.convertUnits(timeUnit2, this.getParentFile().getProjectHeader());
                }
                if ((duration = (Duration)timephasedWork2.getTotalAmount()).getUnits() != timeUnit2) {
                    duration = duration.convertUnits(timeUnit2, this.getParentFile().getProjectHeader());
                }
            }
            double d3 = duration4.getDuration() * d + duration2.getDuration() * d2;
            double d4 = duration3.getDuration() * d + duration.getDuration() * d2;
            TimephasedCost timephasedCost = new TimephasedCost();
            timephasedCost.setStart(timephasedWork.getStart());
            timephasedCost.setFinish(timephasedWork.getFinish());
            timephasedCost.setModified(timephasedWork.getModified());
            timephasedCost.setAmountPerDay(d3);
            timephasedCost.setTotalAmount(d4);
            linkedList.add(timephasedCost);
        }
        return linkedList;
    }

    private List<TimephasedCost> getTimephasedCostMultipleRates(List<TimephasedWork> list, List<TimephasedWork> list2) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        LinkedList<TimephasedWork> linkedList2 = new LinkedList<TimephasedWork>();
        CostRateTable costRateTable = this.getCostRateTable();
        ProjectCalendar projectCalendar = this.getCalendar();
        Iterator<TimephasedWork> iterator = list2.iterator();
        for (TimephasedWork timephasedWork : list) {
            int n;
            TimephasedWork timephasedWork2 = iterator.hasNext() ? iterator.next() : null;
            int n2 = this.getCostRateTableEntryIndex(timephasedWork.getStart());
            if (n2 == (n = this.getCostRateTableEntryIndex(timephasedWork.getFinish()))) {
                linkedList.add(timephasedWork);
                if (timephasedWork2 == null) continue;
                linkedList2.add(timephasedWork2);
                continue;
            }
            linkedList.addAll(this.splitWork(costRateTable, projectCalendar, timephasedWork, n2));
            if (timephasedWork2 == null) continue;
            linkedList2.addAll(this.splitWork(costRateTable, projectCalendar, timephasedWork2, n2));
        }
        return this.getTimephasedCostSingleRate(linkedList, linkedList2);
    }

    private List<TimephasedWork> splitWork(CostRateTable costRateTable, ProjectCalendar projectCalendar, TimephasedWork timephasedWork, int n) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        timephasedWork.setTotalAmount(Duration.getInstance(0, ((Duration)timephasedWork.getAmountPerDay()).getUnits()));
        while (true) {
            CostRateTableEntry costRateTableEntry;
            Date date;
            if ((date = (costRateTableEntry = (CostRateTableEntry)costRateTable.get(n)).getEndDate()).getTime() >= timephasedWork.getFinish().getTime()) break;
            Date date2 = projectCalendar.getPreviousWorkFinish(date);
            TimephasedWork timephasedWork2 = new TimephasedWork(timephasedWork);
            timephasedWork2.setFinish(date2);
            linkedList.add(timephasedWork2);
            Date date3 = projectCalendar.getNextWorkStart(date);
            timephasedWork.setStart(date3);
            ++n;
        }
        linkedList.add(timephasedWork);
        return linkedList;
    }

    private boolean hasMultipleCostRates() {
        boolean bl = false;
        CostRateTable costRateTable = this.getCostRateTable();
        if (costRateTable != null && costRateTable.size() > 1) {
            CostRateTableEntry costRateTableEntry;
            CostRateTableEntry costRateTableEntry2 = costRateTable.getEntryByDate(this.getStart());
            bl = costRateTableEntry2 != (costRateTableEntry = costRateTable.getEntryByDate(this.getFinish()));
        }
        return bl;
    }

    private CostRateTableEntry getCostRateTableEntry(Date date) {
        CostRateTableEntry costRateTableEntry;
        CostRateTable costRateTable = this.getCostRateTable();
        if (costRateTable == null) {
            Resource resource = this.getResource();
            costRateTableEntry = new CostRateTableEntry(resource.getStandardRate(), TimeUnit.HOURS, resource.getOvertimeRate(), TimeUnit.HOURS, resource.getCostPerUse(), null);
        } else {
            costRateTableEntry = costRateTable.size() == 1 ? (CostRateTableEntry)costRateTable.get(0) : costRateTable.getEntryByDate(date);
        }
        return costRateTableEntry;
    }

    private int getCostRateTableEntryIndex(Date date) {
        int n = -1;
        CostRateTable costRateTable = this.getCostRateTable();
        if (costRateTable != null) {
            n = costRateTable.size() == 1 ? 0 : costRateTable.getIndexByDate(date);
        }
        return n;
    }

    public boolean getHasTimephasedData() {
        return this.m_timephasedWork != null && this.m_timephasedWork.hasData() || this.m_timephasedActualWork != null && this.m_timephasedActualWork.hasData();
    }

    public void setTimephasedBaselineWork(int n, TimephasedWorkData timephasedWorkData) {
        this.m_timephasedBaselineWork[n] = timephasedWorkData;
    }

    public void setTimephasedBaselineCost(int n, TimephasedCostData timephasedCostData) {
        this.m_timephasedBaselineCost[n] = timephasedCostData;
    }

    public List<TimephasedWork> getTimephasedBaselineWork(int n) {
        return this.m_timephasedBaselineWork[n] == null ? null : this.m_timephasedBaselineWork[n].getData();
    }

    public List<TimephasedCost> getTimephasedBaselineCost(int n) {
        return this.m_timephasedBaselineCost[n] == null ? null : this.m_timephasedBaselineCost[n].getData();
    }

    public ProjectCalendar getCalendar() {
        ProjectCalendar projectCalendar = null;
        Resource resource = this.getResource();
        if (resource != null) {
            projectCalendar = resource.getResourceCalendar();
        }
        Task task = this.getTask();
        if (projectCalendar == null || task.getIgnoreResourceCalendar()) {
            projectCalendar = task.getCalendar();
        }
        if (projectCalendar == null) {
            projectCalendar = this.getParentFile().getCalendar();
        }
        return projectCalendar;
    }

    public TimeUnit getVariableRateUnits() {
        return (TimeUnit)this.getCachedValue(AssignmentField.VARIABLE_RATE_UNITS);
    }

    public void setVariableRateUnits(TimeUnit timeUnit) {
        this.set((FieldType)AssignmentField.VARIABLE_RATE_UNITS, timeUnit);
    }

    public void setTaskUniqueID(Integer n) {
        this.set((FieldType)AssignmentField.TASK_UNIQUE_ID, n);
    }

    public Integer getTaskUniqueID() {
        return (Integer)this.getCachedValue(AssignmentField.TASK_UNIQUE_ID);
    }

    public Number getBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BUDGET_COST);
    }

    public void setBudgetCost(Number number) {
        this.set((FieldType)AssignmentField.BUDGET_COST, number);
    }

    public Duration getBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration duration) {
        this.set((FieldType)AssignmentField.BUDGET_WORK, duration);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.getCachedValue(AssignmentField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number number) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_COST, number);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.getCachedValue(AssignmentField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration duration) {
        this.set((FieldType)AssignmentField.BASELINE_BUDGET_WORK, duration);
    }

    public void setBaselineCost(int n, Number number) {
        this.set((FieldType)this.selectField(BASELINE_COSTS, n), number);
    }

    public void setBaselineWork(int n, Duration duration) {
        this.set((FieldType)this.selectField(BASELINE_WORKS, n), duration);
    }

    public Duration getBaselineWork(int n) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_WORKS, n));
    }

    public Number getBaselineCost(int n) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_COSTS, n));
    }

    public void setBaselineStart(int n, Date date) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, n), date);
    }

    public Date getBaselineStart(int n) {
        return (Date)this.getCachedValue(this.selectField(BASELINE_STARTS, n));
    }

    public void setBaselineFinish(int n, Date date) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, n), date);
    }

    public Date getBaselineFinish(int n) {
        return (Date)this.getCachedValue(this.selectField(BASELINE_FINISHES, n));
    }

    public void setBaselineBudgetCost(int n, Number number) {
        this.set((FieldType)this.selectField(BASELINE_BUDGET_COSTS, n), number);
    }

    public void setBaselineBudgetWork(int n, Duration duration) {
        this.set((FieldType)this.selectField(BASELINE_BUDGET_WORKS, n), duration);
    }

    public Duration getBaselineBudgetWork(int n) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_BUDGET_WORKS, n));
    }

    public Number getBaselineBudgetCost(int n) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_BUDGET_COSTS, n));
    }

    public void setText(int n, String string) {
        this.set((FieldType)this.selectField(CUSTOM_TEXT, n), string);
    }

    public String getText(int n) {
        return (String)this.getCachedValue(this.selectField(CUSTOM_TEXT, n));
    }

    public void setStart(int n, Date date) {
        this.set((FieldType)this.selectField(CUSTOM_START, n), date);
    }

    public Date getStart(int n) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_START, n));
    }

    public void setFinish(int n, Date date) {
        this.set((FieldType)this.selectField(CUSTOM_FINISH, n), date);
    }

    public Date getFinish(int n) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_FINISH, n));
    }

    public void setDate(int n, Date date) {
        this.set((FieldType)this.selectField(CUSTOM_DATE, n), date);
    }

    public Date getDate(int n) {
        return (Date)this.getCachedValue(this.selectField(CUSTOM_DATE, n));
    }

    public void setNumber(int n, Number number) {
        this.set((FieldType)this.selectField(CUSTOM_NUMBER, n), number);
    }

    public Number getNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_NUMBER, n));
    }

    public void setDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(CUSTOM_DURATION, n), duration);
    }

    public Duration getDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(CUSTOM_DURATION, n));
    }

    public void setCost(int n, Number number) {
        this.set((FieldType)this.selectField(CUSTOM_COST, n), number);
    }

    public Number getCost(int n) {
        return (Number)this.getCachedValue(this.selectField(CUSTOM_COST, n));
    }

    public void setFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(CUSTOM_FLAG, n), bl);
    }

    public boolean getFlag(int n) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(CUSTOM_FLAG, n)));
    }

    public void setEnterpriseCost(int n, Number number) {
        this.set((FieldType)this.selectField(ENTERPRISE_COST, n), number);
    }

    public Number getEnterpriseCost(int n) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_COST, n));
    }

    public void setEnterpriseDate(int n, Date date) {
        this.set((FieldType)this.selectField(ENTERPRISE_DATE, n), date);
    }

    public Date getEnterpriseDate(int n) {
        return (Date)this.getCachedValue(this.selectField(ENTERPRISE_DATE, n));
    }

    public void setEnterpriseDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(ENTERPRISE_DURATION, n), duration);
    }

    public Duration getEnterpriseDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(ENTERPRISE_DURATION, n));
    }

    public void setEnterpriseFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(ENTERPRISE_FLAG, n), bl);
    }

    public boolean getEnterpriseFlag(int n) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(ENTERPRISE_FLAG, n)));
    }

    public void setEnterpriseNumber(int n, Number number) {
        this.set((FieldType)this.selectField(ENTERPRISE_NUMBER, n), number);
    }

    public Number getEnterpriseNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_NUMBER, n));
    }

    public void setEnterpriseText(int n, String string) {
        this.set((FieldType)this.selectField(ENTERPRISE_TEXT, n), string);
    }

    public String getEnterpriseText(int n) {
        return (String)this.getCachedValue(this.selectField(ENTERPRISE_TEXT, n));
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(AssignmentField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)AssignmentField.REGULAR_WORK, duration);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_WORK, duration);
    }

    public Number getOvertimeCost() {
        Number number = (Number)this.getCachedValue(AssignmentField.OVERTIME_COST);
        if (number == null) {
            Number number2 = this.getActualOvertimeCost();
            Number number3 = this.getRemainingOvertimeCost();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() + number3.doubleValue());
                this.set((FieldType)AssignmentField.OVERTIME_COST, number);
            }
        }
        return number;
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)AssignmentField.OVERTIME_COST, number);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_COST);
    }

    public void setRemainingCost(Number number) {
        this.set((FieldType)AssignmentField.REMAINING_COST, number);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number number) {
        this.set((FieldType)AssignmentField.ACTUAL_OVERTIME_COST, number);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(AssignmentField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number number) {
        this.set((FieldType)AssignmentField.REMAINING_OVERTIME_COST, number);
    }

    public void setBCWP(Number number) {
        this.set((FieldType)AssignmentField.BCWP, number);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(AssignmentField.BCWP);
    }

    public void setBCWS(Number number) {
        this.set((FieldType)AssignmentField.BCWS, number);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(AssignmentField.BCWS);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(AssignmentField.ACWP);
    }

    public void setACWP(Number number) {
        this.set((FieldType)AssignmentField.ACWP, number);
    }

    public void setSV(Number number) {
        this.set((FieldType)AssignmentField.SV, number);
    }

    public Number getSV() {
        Number number = (Number)this.getCachedValue(AssignmentField.SV);
        if (number == null) {
            Number number2 = this.getBCWP();
            Number number3 = this.getBCWS();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)AssignmentField.SV, number);
            }
        }
        return number;
    }

    public void setCV(Number number) {
        this.set((FieldType)AssignmentField.CV, number);
    }

    public Number getCV() {
        Number number = (Number)this.getCachedValue(AssignmentField.CV);
        if (number == null) {
            number = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)AssignmentField.CV, number);
        }
        return number;
    }

    public void setCostVariance(Number number) {
        this.set((FieldType)AssignmentField.COST_VARIANCE, number);
    }

    public Number getCostVariance() {
        Number number = (Number)this.getCachedValue(AssignmentField.COST_VARIANCE);
        if (number == null) {
            Number number2 = this.getCost();
            Number number3 = this.getBaselineCost();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)AssignmentField.COST_VARIANCE, number);
            }
        }
        return number;
    }

    public void setPercentageWorkComplete(Number number) {
        this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, number);
    }

    public Number getPercentageWorkComplete() {
        Number number = (Number)this.getCachedValue(AssignmentField.PERCENT_WORK_COMPLETE);
        if (number == null) {
            Duration duration = this.getActualWork();
            Duration duration2 = this.getWork();
            if (duration != null && duration2 != null && duration2.getDuration() != 0.0) {
                number = duration.getDuration() * 100.0 / duration2.convertUnits(duration.getUnits(), this.getParentFile().getProjectHeader()).getDuration();
                this.set((FieldType)AssignmentField.PERCENT_WORK_COMPLETE, number);
            }
        }
        return number;
    }

    public void setNotes(String string) {
        this.set((FieldType)AssignmentField.NOTES, string);
    }

    public String getNotes() {
        String string = (String)this.getCachedValue(AssignmentField.NOTES);
        return string == null ? "" : string;
    }

    public void setConfirmed(boolean bl) {
        this.set((FieldType)AssignmentField.CONFIRMED, bl);
    }

    public boolean getConfirmed() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.CONFIRMED));
    }

    public void setUpdateNeeded(boolean bl) {
        this.set((FieldType)AssignmentField.UPDATE_NEEDED, bl);
    }

    public boolean getUpdateNeeded() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.UPDATE_NEEDED));
    }

    public void setLinkedFields(boolean bl) {
        this.set((FieldType)AssignmentField.LINKED_FIELDS, bl);
    }

    public boolean getLinkedFields() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.LINKED_FIELDS));
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String string) {
        this.set((FieldType)AssignmentField.HYPERLINK, string);
    }

    public void setHyperlinkAddress(String string) {
        this.set((FieldType)AssignmentField.HYPERLINK_ADDRESS, string);
    }

    public void setHyperlinkSubAddress(String string) {
        this.set((FieldType)AssignmentField.HYPERLINK_SUBADDRESS, string);
    }

    public void setWorkVariance(Duration duration) {
        this.set((FieldType)AssignmentField.WORK_VARIANCE, duration);
    }

    public Duration getWorkVariance() {
        Duration duration = (Duration)this.getCachedValue(AssignmentField.WORK_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getWork();
            Duration duration3 = this.getBaselineWork();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration2.getUnits());
                this.set((FieldType)AssignmentField.WORK_VARIANCE, duration);
            }
        }
        return duration;
    }

    public void setStartVariance(Duration duration) {
        this.set((FieldType)AssignmentField.START_VARIANCE, duration);
    }

    public Duration getStartVariance() {
        Duration duration = (Duration)this.getCachedValue(AssignmentField.START_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            duration = DateUtility.getVariance(this.getTask(), this.getBaselineStart(), this.getStart(), timeUnit);
            this.set((FieldType)AssignmentField.START_VARIANCE, duration);
        }
        return duration;
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)AssignmentField.FINISH_VARIANCE, duration);
    }

    public Duration getFinishVariance() {
        Duration duration = (Duration)this.getCachedValue(AssignmentField.FINISH_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            duration = DateUtility.getVariance(this.getTask(), this.getBaselineFinish(), this.getFinish(), timeUnit);
            this.set((FieldType)AssignmentField.FINISH_VARIANCE, duration);
        }
        return duration;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(AssignmentField.CREATED);
    }

    public void setCreateDate(Date date) {
        this.set((FieldType)AssignmentField.CREATED, date);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(AssignmentField.GUID);
    }

    public void setGUID(UUID uUID) {
        this.set((FieldType)AssignmentField.GUID, uUID);
    }

    public void setResponsePending(boolean bl) {
        this.set((FieldType)AssignmentField.RESPONSE_PENDING, bl);
    }

    public boolean getResponsePending() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.RESPONSE_PENDING));
    }

    public void setTeamStatusPending(boolean bl) {
        this.set((FieldType)AssignmentField.TEAM_STATUS_PENDING, bl);
    }

    public boolean getTeamStatusPending() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(AssignmentField.TEAM_STATUS_PENDING));
    }

    public void setVAC(Number number) {
        this.set((FieldType)AssignmentField.VAC, number);
    }

    public Number getVAC() {
        return (Number)this.getCachedValue(AssignmentField.VAC);
    }

    public void setCostRateTableIndex(int n) {
        this.set((FieldType)AssignmentField.COST_RATE_TABLE, n);
    }

    public int getCostRateTableIndex() {
        Integer n = (Integer)this.getCachedValue(AssignmentField.COST_RATE_TABLE);
        return n == null ? 0 : n;
    }

    public CostRateTable getCostRateTable() {
        return this.getResource() == null ? null : this.getResource().getCostRateTable(this.getCostRateTableIndex());
    }

    public String getHyperlinkScreenTip() {
        return (String)this.getCachedValue(AssignmentField.HYPERLINK_SCREEN_TIP);
    }

    public void setHyperlinkScreenTip(String string) {
        this.set((FieldType)AssignmentField.HYPERLINK_SCREEN_TIP, string);
    }

    private AssignmentField selectField(AssignmentField[] assignmentFieldArray, int n) {
        if (n < 1 || n > assignmentFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return assignmentFieldArray[n - 1];
    }

    public String toString() {
        return "[Resource Assignment task=" + this.getTask().getName() + " resource=" + (this.getResource() == null ? "Unassigned" : this.getResource().getName()) + " start=" + this.getStart() + " finish=" + this.getFinish() + " duration=" + this.getWork() + " workContour=" + this.getWorkContour() + "]";
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((AssignmentField)fieldType, this.m_array[n], object);
            }
            this.m_array[n] = object;
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    private void fireFieldChangeEvent(AssignmentField assignmentField, Object object, Object object2) {
        switch (assignmentField) {
            case START: 
            case BASELINE_START: {
                this.m_array[AssignmentField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[AssignmentField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[AssignmentField.CV.getValue()] = null;
                this.m_array[AssignmentField.SV.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[AssignmentField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[AssignmentField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case ACTUAL_OVERTIME_COST: 
            case REMAINING_OVERTIME_COST: {
                this.m_array[AssignmentField.OVERTIME_COST.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener fieldListener : this.m_listeners) {
                fieldListener.fieldChange(this, assignmentField, object, object2);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        Object object = null;
        if (fieldType != null) {
            int n = fieldType.getValue();
            object = this.m_array[n];
        }
        return object;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

