/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

/*
 * NameDataSet.java
 *
 * Created on April 24, 2007, 11:37 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.pim;

import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;

/**
 *
 * @author Michal Skvor
 */
public class NameDataSet implements DataSet {
    
    public static final String FAMILY   = "family";
    public static final String GIVEN    = "given";
    public static final String OTHER    = "other";
    public static final String PREFIX   = "prefix";
    public static final String SUFFIX   = "suffix";

    private Vector supportedFields = new Vector();
    
    private int contactIndex;
    
   /** Creates a new instance of NameDataSet */
    public NameDataSet( int contactIndex ) {
        this.contactIndex = contactIndex;
        
         try {
            ContactList contacts = (ContactList) PIM.getInstance().openPIMList( PIM.CONTACT_LIST, PIM.READ_ONLY );
            contacts.createContact();
            int[] fields = contacts.getSupportedArrayElements( Contact.NAME );
            for( int i = 0; i < fields.length; i++ ) {
                switch( fields[i] ) {
                    case Contact.NAME_FAMILY:
                        supportedFields.addElement( FAMILY );
                        break;
                    case Contact.NAME_GIVEN:
                        supportedFields.addElement( GIVEN );
                        break;
                    case Contact.NAME_OTHER:
                        supportedFields.addElement( OTHER );
                        break;
                    case Contact.NAME_PREFIX:
                        supportedFields.addElement( PREFIX );
                        break;
                    case Contact.NAME_SUFFIX:
                        supportedFields.addElement( SUFFIX );
                        break;
                }
                System.err.println(" - - " + contacts.getArrayElementLabel( Contact.NAME, fields[i] ));
            }
         } catch( PIMException e ) {
             e.printStackTrace();
         }
    }

    public Class getType(String dataItemName) throws DataBindingException {
        return Object.class;
    }

    public Object getValue(String dataItemName) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        
        if( FAMILY.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_FAMILY );
        } else if( GIVEN.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_GIVEN );
        } else if( OTHER.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_OTHER );
        } else if( PREFIX.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_PREFIX );
        } else if( SUFFIX.equals( dataItemName )) {
            return Query.getContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_SUFFIX );
        }
        throw new DataBindingException( "Invalid data item name: " + dataItemName );
    }

    public void setValue(String dataItemName, Object value) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        if(!( value instanceof String ))
            throw new DataBindingException( "Unsupported value type." );           
        setAsString( dataItemName, (String) value );
    }

    public void setAsString(String dataItemName, String value) throws DataBindingException {
        if( !supportedFields.contains( dataItemName )) 
            throw new DataBindingException( "Unsupported item name: " + dataItemName );
        
        if( FAMILY.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_FAMILY, value );
        } else if( GIVEN.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_GIVEN, value );
        } else if( OTHER.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_OTHER, value );
        } else if( PREFIX.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_PREFIX, value );
        } else if( SUFFIX.equals( dataItemName )) {
            Query.setContactArrayValue( contactIndex, Contact.ATTR_NONE, Contact.NAME, Contact.NAME_SUFFIX, value );
        }
        throw new DataBindingException( "Invalid data item name: " + dataItemName );
    }

    public boolean isReadOnly(String dataItemName) throws DataBindingException {
        return false;
    }    
}
