/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasText(String str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static List<String> tokenize(String str, String delimiters) {
        return StringUtils.tokenize(str, delimiters, true, true);
    }

    private static List<String> tokenize(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String join(List<String> strings, String separator) {
        int size = strings.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(strings.size() * strings.get(0).length());
        int index = 0;
        int lastIndex = size - 1;
        for (String string : strings) {
            sb.append(string);
            if (separator != null && index < lastIndex) {
                sb.append(separator);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String toLowerCamelCase(String str) {
        char[] cs = str.toCharArray();
        cs[0] = Character.toLowerCase(cs[0]);
        return String.valueOf(cs);
    }

    public static int indexOfAnyDelimiter(String str, int fromIndex, String delimiters) {
        if (!StringUtils.hasLength(str)) {
            return -1;
        }
        return StringUtils.indexOfAnyDelimiter(str, fromIndex, str.length(), delimiters);
    }

    public static int indexOfAnyDelimiter(String str, int fromIndex, int toIndex, String delimiters) {
        if (!StringUtils.hasLength(str) || !StringUtils.hasLength(delimiters)) {
            return -1;
        }
        if (toIndex <= 0 || fromIndex >= str.length()) {
            return -1;
        }
        fromIndex = Math.max(fromIndex, 0);
        toIndex = Math.min(toIndex, str.length());
        char[] charArray = str.toCharArray();
        char[] delims = delimiters.toCharArray();
        for (int i = fromIndex; i < toIndex; ++i) {
            for (char d : delims) {
                if (d != charArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfAnyDelimiter(String str, int fromIndex, String delimiters) {
        if (!StringUtils.hasLength(str)) {
            return -1;
        }
        return StringUtils.lastIndexOfAnyDelimiter(str, fromIndex, str.length(), delimiters);
    }

    public static int lastIndexOfAnyDelimiter(String str, int fromIndex, int toIndex, String delimiters) {
        if (!StringUtils.hasLength(str) || !StringUtils.hasLength(delimiters)) {
            return -1;
        }
        if (toIndex < 0 || fromIndex >= str.length()) {
            return -1;
        }
        fromIndex = Math.max(fromIndex, 0);
        toIndex = Math.min(toIndex, str.length());
        char[] charArray = str.toCharArray();
        char[] delims = delimiters.toCharArray();
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            for (char d : delims) {
                if (d != charArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean occurs(String str, String subString, int fromIndex) {
        return str.indexOf(subString, fromIndex) != -1;
    }
}

