/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.session.StandardManager;

public final class SessionSerializer {
    public static final void doSerialization(Request req, ClassLoader cl, StandardManager sessionM) {
        Hashtable sessions = sessionM.getSessions();
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(b);
            o.writeObject(sessions);
            o.flush();
            ByteArrayInputStream bIn = new ByteArrayInputStream(b.toByteArray());
            ACLObjectInputStream oOut = new ACLObjectInputStream(cl, bIn);
            sessions = (Hashtable)oOut.readObject();
            sessionM.setSessions(sessions);
            if (req.getSession(false) != null) {
                HttpSession newSession = (HttpSession)sessions.get(req.getRequestedSessionId());
                req.setSession(newSession);
            }
        }
        catch (Exception e) {
            System.out.println("SessionSerializer: " + e);
        }
    }

    private static final class ACLObjectInputStream
    extends ObjectInputStream {
        ClassLoader loader;

        ACLObjectInputStream(ClassLoader loader, InputStream bIn) throws IOException {
            super(bIn);
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return this.loader.loadClass(v.getName());
        }
    }
}

