/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.ElementScanningTask;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.ToolTipManagerEx;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener,
PropertyChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private InstanceContent selectedNodes = new InstanceContent();
    private Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private ClassMemberFilters filters;
    private Action[] actions;
    private static final Rectangle ZERO = new Rectangle(0, 0, 1, 1);
    private long lastShowWaitNodeTime = -1L;
    private static final Logger PERF_LOG = Logger.getLogger(ClassMemberPanelUI.class.getName() + ".perf");

    public ClassMemberPanelUI() {
        this.initComponents();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String string = Utilities.keyToString((KeyStroke)keyStroke);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)string));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        JComponent jComponent = this.filters.getComponent();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(jComponent);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        this.add((Component)this.filtersPanel, "South");
        this.manager.setRootContext(ElementNode.getWaitNode());
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return bl;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.elementView.requestFocus();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
                ClassMemberPanelUI.this.lastShowWaitNodeTime = System.currentTimeMillis();
            }
        });
    }

    public void selectElementNode(ElementHandle<Element> elementHandle) {
        ElementNode elementNode = this.getRootNode();
        if (elementNode == null) {
            return;
        }
        ElementNode elementNode2 = elementNode.getNodeForElement(elementHandle);
        try {
            this.manager.setSelectedNodes(new Node[]{elementNode2 == null ? this.getRootNode() : elementNode2});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
    }

    public void refresh(final ElementNode.Description description) {
        final ElementNode elementNode = this.getRootNode();
        if (elementNode != null && elementNode.getDescritption().fileObject.equals(description.fileObject)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    elementNode.updateRecursively(description);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(description));
                    boolean bl = ClassMemberPanelUI.this.getScrollOnExpand();
                    ClassMemberPanelUI.this.setScrollOnExpand(false);
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(false);
                    ClassMemberPanelUI.this.elementView.expandAll();
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(true);
                    ClassMemberPanelUI.this.setScrollOnExpand(bl);
                    if (PERF_LOG.isLoggable(Level.FINE)) {
                        long l = System.currentTimeMillis();
                        long l2 = ClassMemberPanelUI.this.lastShowWaitNodeTime;
                        if (l2 != -1L) {
                            ClassMemberPanelUI.this.lastShowWaitNodeTime = -1L;
                            PERF_LOG.log(Level.FINE, String.format("ClassMemberPanelUI refresh took: %d ms", l - l2), new Object[]{description.getFileObject().getName(), l - l2});
                        }
                    }
                }
            });
        }
    }

    public void sort() {
        ElementNode elementNode = this.getRootNode();
        if (null != elementNode) {
            elementNode.refreshRecursively();
        }
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node node) {
        this.elementView.expandNode(node);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        ElementNode elementNode = this.getRootNode();
        if (elementNode != null) {
            return elementNode.getDescritption().fileObject;
        }
        return null;
    }

    @Override
    public void filterStateChanged(ChangeEvent changeEvent) {
        ElementNode elementNode = this.getRootNode();
        if (elementNode != null) {
            elementNode.refreshRecursively();
        }
    }

    boolean getScrollOnExpand() {
        return null == this.elementView ? true : this.elementView.getScrollOnExpand();
    }

    void setScrollOnExpand(boolean bl) {
        if (null != this.elementView) {
            this.elementView.setScrollOnExpand(bl);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node node = this.manager.getRootContext();
        if (node instanceof ElementNode) {
            return (ElementNode)node;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        return new MyBeanTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected ElementJavadoc getJavaDocFor(ElementNode elementNode) {
        ElementNode elementNode2 = this.getRootNode();
        if (elementNode2 == null) {
            return null;
        }
        ElementHandle<? extends Element> elementHandle = elementNode.getDescritption().elementHandle;
        JavaSource javaSource = JavaSource.forFileObject((FileObject)elementNode2.getDescritption().fileObject);
        if (javaSource == null) {
            return null;
        }
        JavaDocCalculator javaDocCalculator = new JavaDocCalculator(elementHandle);
        CompilationInfo[] compilationInfoArray = new CompilationInfo[1];
        try {
            javaSource.runUserActionTask((Task)javaDocCalculator, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        return javaDocCalculator.doc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            for (Node node : (Node[])propertyChangeEvent.getOldValue()) {
                this.selectedNodes.remove((Object)node);
            }
            for (Node node : (Node[])propertyChangeEvent.getNewValue()) {
                this.selectedNodes.add((Object)node);
            }
        }
    }

    private class MyBeanTreeView
    extends BeanTreeView
    implements ToolTipManagerEx.ToolTipProvider {
        private final ToolTipManagerEx toolTipManager = new ToolTipManagerEx(this);
        private boolean inHierarchy;
        private boolean doExpandAll;

        public MyBeanTreeView() {
            this.setUseSubstringInQuickSearch(true);
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean bl) {
            this.tree.setScrollsOnExpand(bl);
        }

        @Override
        public JComponent getComponent() {
            return this.tree;
        }

        @Override
        public String getToolTipText(Point point) {
            ElementJavadoc elementJavadoc = this.getDocumentation(point);
            return null == elementJavadoc ? null : elementJavadoc.getText();
        }

        private ElementJavadoc getDocumentation(Point point) {
            TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
            if (null == treePath) {
                return null;
            }
            Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
            if (node instanceof ElementNode) {
                return ClassMemberPanelUI.this.getJavaDocFor((ElementNode)node);
            }
            return null;
        }

        @Override
        public Rectangle getToolTipSourceBounds(Point point) {
            ElementNode elementNode = ClassMemberPanelUI.this.getRootNode();
            if (elementNode == null) {
                return null;
            }
            TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
            return null == treePath ? null : this.tree.getPathBounds(treePath);
        }

        @Override
        public Point getToolTipLocation(Point point, Dimension dimension) {
            Point point2 = this.getLocationOnScreen();
            Rectangle rectangle = this.getGraphicsConfiguration().getBounds();
            Dimension dimension2 = this.getSize();
            Point point3 = new Point();
            Rectangle rectangle2 = this.getToolTipSourceBounds(point);
            if (rectangle2 == null) {
                rectangle2 = new Rectangle();
            }
            Point point4 = this.getViewport().getViewPosition();
            point2.x -= point4.x;
            point2.y -= point4.y;
            point3.x = point2.x + dimension2.width;
            point3.y = point2.y + rectangle2.y + rectangle2.height;
            if (point3.x + dimension.width <= rectangle.x + rectangle.width && point3.y + dimension.height <= rectangle.y + rectangle.height) {
                return point3;
            }
            point3.x = point2.x + dimension2.width;
            point3.y = point2.y + rectangle2.y - dimension.height;
            if (point3.x + dimension.width <= rectangle.x + rectangle.width && point3.y >= rectangle.y) {
                return point3;
            }
            point3.x = point2.x - dimension.width;
            point3.y = point2.y + rectangle2.y;
            if (point3.x >= rectangle.x && point3.y + dimension.height <= rectangle.y + rectangle.height) {
                return point3;
            }
            point3.x = point2.x - dimension.width;
            point3.y = point2.y + rectangle2.y + rectangle2.height - dimension.height;
            if (point3.x >= rectangle.x && point3.y >= rectangle.y) {
                return point3;
            }
            point3.x = point2.x + rectangle2.x;
            point3.y = rectangle.y + rectangle.height - (point2.y + rectangle2.y + rectangle2.height) > point2.y + rectangle2.y - rectangle.y ? point2.y + rectangle2.y + rectangle2.height : point2.y + rectangle2.y - dimension.height;
            return point3;
        }

        @Override
        public void invokeUserAction(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != mouseEvent) {
                        ElementJavadoc elementJavadoc = MyBeanTreeView.this.getDocumentation(mouseEvent.getPoint());
                        JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                        if (null != javadocTopComponent) {
                            javadocTopComponent.open();
                            javadocTopComponent.setJavadoc(elementJavadoc);
                            javadocTopComponent.requestActive();
                        }
                    }
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.inHierarchy = true;
            if (this.doExpandAll) {
                super.expandAll();
                this.doExpandAll = false;
            }
        }

        public void removeNotify() {
            super.removeNotify();
            this.inHierarchy = false;
            this.toolTipManager.hideTipWindow();
        }

        public void expandAll() {
            super.expandAll();
            if (!this.inHierarchy) {
                this.doExpandAll = true;
            }
        }
    }

    private static class JavaDocCalculator
    implements Task<CompilationController> {
        private ElementHandle<? extends Element> handle;
        private ElementJavadoc doc;

        public JavaDocCalculator(ElementHandle<? extends Element> elementHandle) {
            this.handle = elementHandle;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.UP_TO_DATE);
            Element element = this.handle.resolve((CompilationInfo)compilationController);
            this.doc = ElementJavadoc.create((CompilationInfo)compilationController, (Element)element);
        }
    }
}

