/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.util.Set;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.DefaultErrorReporter;
import org.mozilla.nb.javascript.ErrorReporter;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private int languageVersion = 0;
    private boolean generateDebugInfo = true;
    private boolean useDynamicScope = false;
    private boolean reservedKeywordAsIdentifier = false;
    private boolean allowMemberExprAsFunctionName = false;
    private boolean xmlAvailable = true;
    private int optimizationLevel = 0;
    private boolean generatingSource = true;
    private boolean strictMode = false;
    private boolean warningAsError = false;
    private boolean generateObserverCount = false;
    Set<String> activationNames;

    public void initFromContext(Context context) {
        this.setErrorReporter(context.getErrorReporter());
        this.languageVersion = context.getLanguageVersion();
        this.useDynamicScope = context.compileFunctionsWithDynamicScopeFlag;
        this.generateDebugInfo = !context.isGeneratingDebugChanged() || context.isGeneratingDebug();
        this.reservedKeywordAsIdentifier = context.hasFeature(3);
        this.allowMemberExprAsFunctionName = context.hasFeature(2);
        this.strictMode = context.hasFeature(11);
        this.warningAsError = context.hasFeature(12);
        this.xmlAvailable = context.hasFeature(6);
        this.optimizationLevel = context.getOptimizationLevel();
        this.generatingSource = context.isGeneratingSource();
        this.activationNames = context.activationNames;
        this.generateObserverCount = context.generateObserverCount;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final int getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(int n) {
        if (n == 180) {
            n = 170;
        }
        Context.checkLanguageVersion(n);
        this.languageVersion = n;
    }

    public final boolean isGenerateDebugInfo() {
        return this.generateDebugInfo;
    }

    public void setGenerateDebugInfo(boolean bl) {
        this.generateDebugInfo = bl;
    }

    public void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    public final boolean isUseDynamicScope() {
        return this.useDynamicScope;
    }

    public final boolean isReservedKeywordAsIdentifier() {
        return this.reservedKeywordAsIdentifier;
    }

    public void setReservedKeywordAsIdentifier(boolean bl) {
        this.reservedKeywordAsIdentifier = bl;
    }

    public final boolean isAllowMemberExprAsFunctionName() {
        return this.allowMemberExprAsFunctionName;
    }

    public void setAllowMemberExprAsFunctionName(boolean bl) {
        this.allowMemberExprAsFunctionName = bl;
    }

    public final boolean isXmlAvailable() {
        return this.xmlAvailable;
    }

    public void setXmlAvailable(boolean bl) {
        this.xmlAvailable = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int n) {
        Context.checkOptimizationLevel(n);
        this.optimizationLevel = n;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final boolean isStrictMode() {
        return this.strictMode;
    }

    public final boolean reportWarningAsError() {
        return this.warningAsError;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public boolean isGenerateObserverCount() {
        return this.generateObserverCount;
    }

    public void setGenerateObserverCount(boolean bl) {
        this.generateObserverCount = bl;
    }
}

