/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.netbeans.modules.hudson.spi.PasswordAuthorizer;
import org.openide.util.Lookup;

public class ServletConnectionAuthenticator
implements ConnectionAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ServletConnectionAuthenticator.class.getName());

    @Override
    public void prepareRequest(URLConnection conn, URL home) {
    }

    @Override
    public URLConnection forbidden(URLConnection conn, URL home) {
        for (PasswordAuthorizer aa : Lookup.getDefault().lookupAll(PasswordAuthorizer.class)) {
            String[] auth = aa.authorize(home);
            if (auth == null) continue;
            LOGGER.log(Level.FINE, "Got authorization for {0} on {1} from {2}", new Object[]{auth[0], home, aa});
            for (String realmURI : new String[]{"j_acegi_security_check", "j_security_check"}) {
                try {
                    LOGGER.log(Level.FINER, "Posting authentication to {0}", realmURI);
                    new ConnectionBuilder().url(new URL(home, realmURI)).postData(("j_username=" + URLEncoder.encode(auth[0], "UTF-8") + "&j_password=" + URLEncoder.encode(auth[1], "UTF-8")).getBytes("UTF-8")).homeURL(home).authentication(false).connection();
                    LOGGER.log(Level.FINER, "Posted authentication to {0} worked", realmURI);
                    return conn.getURL().openConnection();
                }
                catch (IOException x) {
                    LOGGER.log(Level.FINE, null, x);
                }
            }
        }
        return null;
    }
}

