/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Comparator;

public class CharSequenceUtils {
    public static final Comparator<CharSequence> ComparatorIgnoreCase = new CharSequenceComparatorIgnoreCase();

    public static int indexOf(CharSequence text, CharSequence seq) {
        return CharSequenceUtils.indexOf(text, seq, 0);
    }

    public static int indexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int textLength = text.length();
        int seqLength = seq.length();
        if (fromIndex >= textLength) {
            return seqLength == 0 ? textLength : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        char first = seq.charAt(0);
        int max = textLength - seqLength;
        for (int i = fromIndex; i <= max; ++i) {
            if (text.charAt(i) != first) {
                while (++i <= max && text.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + seqLength - 1;
            int k = 1;
            while (j < end && text.charAt(j) == seq.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence text, CharSequence seq) {
        return CharSequenceUtils.lastIndexOf(text, seq, text.length());
    }

    public static int lastIndexOf(CharSequence text, CharSequence seq, int fromIndex) {
        int start;
        int textLength = text.length();
        int seqLength = seq.length();
        int rightIndex = textLength - seqLength;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (seqLength == 0) {
            return fromIndex;
        }
        int strLastIndex = seqLength - 1;
        char strLastChar = seq.charAt(strLastIndex);
        int min = seqLength - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && text.charAt(i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (seqLength - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (text.charAt(j--) == seq.charAt(k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(CharSequence text, int ch) {
        return CharSequenceUtils.lastIndexOf(text, ch, text.length() - 1);
    }

    public static int lastIndexOf(CharSequence text, int ch, int fromIndex) {
        if (fromIndex > text.length() - 1) {
            fromIndex = text.length() - 1;
        }
        while (fromIndex >= 0) {
            if (text.charAt(fromIndex) == ch) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public static boolean startsWith(CharSequence text, CharSequence prefix) {
        int p_length = prefix.length();
        if (p_length > text.length()) {
            return false;
        }
        for (int x = 0; x < p_length; ++x) {
            if (text.charAt(x) == prefix.charAt(x)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(CharSequence text, CharSequence prefix) {
        int p_length = prefix.length();
        if (p_length > text.length()) {
            return false;
        }
        for (int x = 0; x < p_length; ++x) {
            char c2;
            char c1 = text.charAt(x);
            if (c1 == (c2 = prefix.charAt(x)) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence text, CharSequence suffix) {
        int text_length;
        int s_length = suffix.length();
        if (s_length > (text_length = text.length())) {
            return false;
        }
        for (int x = 0; x < s_length; ++x) {
            if (text.charAt(text_length - s_length + x) == suffix.charAt(x)) continue;
            return false;
        }
        return true;
    }

    public static String toString(CharSequence prefix, char separator, CharSequence postfix) {
        int i;
        int prefLength = prefix.length();
        int postLength = postfix.length();
        char[] chars = new char[prefLength + 1 + postLength];
        int indx = 0;
        if (prefix instanceof String) {
            ((String)prefix).getChars(0, prefLength, chars, indx);
            indx = prefLength;
        } else {
            for (i = 0; i < prefLength; ++i) {
                chars[indx++] = prefix.charAt(i);
            }
        }
        chars[indx++] = separator;
        if (postfix instanceof String) {
            ((String)postfix).getChars(0, postLength, chars, indx);
        } else {
            for (i = 0; i < postLength; ++i) {
                chars[indx++] = postfix.charAt(i);
            }
        }
        return new String(chars);
    }

    private static class CharSequenceComparatorIgnoreCase
    implements Comparator<CharSequence> {
        private CharSequenceComparatorIgnoreCase() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int n1 = o1.length();
            int n2 = o2.length();
            int i1 = 0;
            for (int i2 = 0; i1 < n1 && i2 < n2; ++i1, ++i2) {
                char c2;
                char c1 = o1.charAt(i1);
                if (c1 == (c2 = o2.charAt(i2)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

