/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecutor;
import org.netbeans.modules.db.api.sql.execute.StatementExecutionInfo;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.util.NbBundle;

public class LogFileLogger
implements SQLExecuteLogger {
    private static Logger LOGGER = Logger.getLogger(LogFileLogger.class.getName());
    private int errorCount;

    @Override
    public void log(StatementExecutionInfo info) {
        if (info.hasExceptions()) {
            this.logException(info);
        }
    }

    @Override
    public void finish(long executionTime) {
        LOGGER.log(Level.INFO, NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinished", (Object)String.valueOf(this.millisecondsToSeconds(executionTime)), (Object)String.valueOf(this.errorCount)));
    }

    @Override
    public void cancel() {
        LOGGER.log(Level.INFO, NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
    }

    private void logException(StatementExecutionInfo info) {
        ++this.errorCount;
        for (Throwable e : info.getExceptions()) {
            if (e instanceof SQLException) {
                this.logSQLException((SQLException)e, info);
                continue;
            }
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLExecutor.class, (String)"MSG_SQLExecutionException", (Object)info.getSQL()), e);
        }
    }

    private void logSQLException(SQLException e, StatementExecutionInfo info) {
        while (e != null) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLExecutor.class, (String)"MSG_SQLExecutionException", (Object)info.getSQL()), e);
            e = e.getNextException();
        }
    }

    private String millisecondsToSeconds(long ms) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumFractionDigits(3);
        return fmt.format((double)ms / 1000.0);
    }
}

