/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.deprecated.pre61settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;

public final class KitchenSink {
    private static final Logger LOG = Logger.getLogger(KitchenSink.class.getName());
    public static final String JAVATYPE_KEY_PREFIX = "nbeditor-javaType-for-legacy-setting_";

    public static Object getValueFromPrefs(String settingName, Preferences prefs, MimePath mimePath) {
        Object value = null;
        if (prefs != null && null != prefs.get(settingName, null)) {
            Class type = null;
            String javaType = prefs.get(JAVATYPE_KEY_PREFIX + settingName, null);
            if (javaType != null) {
                type = KitchenSink.typeFromString(javaType);
            }
            if (type != null) {
                if (type.equals(SettingsConversions.class)) {
                    value = SettingsConversions.callFactory((Preferences)prefs, (MimePath)mimePath, (String)settingName, null);
                } else if (type.equals(Boolean.class)) {
                    value = prefs.getBoolean(settingName, false);
                } else if (type.equals(Integer.class)) {
                    value = prefs.getInt(settingName, 0);
                } else if (type.equals(Long.class)) {
                    value = prefs.getLong(settingName, 0L);
                } else if (type.equals(Float.class)) {
                    value = Float.valueOf(prefs.getFloat(settingName, 0.0f));
                } else if (type.equals(Double.class)) {
                    value = prefs.getDouble(settingName, 0.0);
                } else if (type.equals(Insets.class)) {
                    value = SettingsConversions.parseInsets((String)prefs.get(settingName, null));
                } else if (type.equals(Dimension.class)) {
                    value = SettingsConversions.parseDimension((String)prefs.get(settingName, null));
                } else if (type.equals(Color.class)) {
                    value = SettingsConversions.parseColor((String)prefs.get(settingName, null));
                } else if (type.equals(String.class)) {
                    value = prefs.get(settingName, null);
                } else {
                    LOG.log(Level.WARNING, "Can't load setting '" + settingName + "' with value '" + prefs.get(settingName, null) + "' through org.netbeans.editor.Settings! Unsupported value conversion to " + type, new Throwable("Stacktrace"));
                }
            } else {
                LOG.warning("Can't determine type of '" + settingName + "' editor setting. If you supplied this setting" + " through the editor implementation of java.util.prefs.Preferences you should use the 'javaType'" + " attribute and specify the class representing values of this setting. There seem to be legacy" + " clients accessing your setting through the old org.netbeans.editor.Settings.");
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean setValueToPreferences(String settingName, Object value, Preferences prefs, MimePath mimePath) {
        if (value == null) {
            prefs.remove(settingName);
            return true;
        }
        if (value instanceof Boolean) {
            prefs.putBoolean(settingName, (Boolean)value);
            return true;
        }
        if (value instanceof Integer) {
            prefs.putInt(settingName, (Integer)value);
            return true;
        }
        if (value instanceof Long) {
            prefs.putLong(settingName, (Long)value);
            return true;
        }
        if (value instanceof Float) {
            prefs.putFloat(settingName, ((Float)value).floatValue());
            return true;
        }
        if (value instanceof Double) {
            prefs.putDouble(settingName, (Double)value);
            return true;
        }
        if (value instanceof Insets) {
            prefs.put(settingName, SettingsConversions.insetsToString((Insets)((Insets)value)));
            prefs.put(JAVATYPE_KEY_PREFIX + settingName, Insets.class.getName());
            return true;
        }
        if (value instanceof Dimension) {
            prefs.put(settingName, SettingsConversions.dimensionToString((Dimension)((Dimension)value)));
            prefs.put(JAVATYPE_KEY_PREFIX + settingName, Dimension.class.getName());
            return true;
        }
        if (value instanceof Color) {
            prefs.put(settingName, SettingsConversions.color2String((Color)((Color)value)));
            prefs.put(JAVATYPE_KEY_PREFIX + settingName, Color.class.getName());
            return true;
        }
        if (value instanceof String) {
            prefs.put(settingName, (String)value);
            return true;
        }
        LOG.log(Level.FINE, "Can't save setting '" + settingName + "' with value '" + value + "' through org.netbeans.editor.Settings; unsupported value conversion!", new Throwable("Stacktrace"));
        return false;
    }

    private static Class typeFromString(String javaType) {
        if ("methodvalue".equals(javaType)) {
            return SettingsConversions.class;
        }
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            return classLoader == null ? null : classLoader.loadClass(javaType);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.log(Level.WARNING, null, cnfe);
            return null;
        }
    }

    public static final Object getIndentEngineValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("indentEngine")) : "The getIndentEngineValue factory called for '" + settingName + "'";
        BaseOptions bo = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)mimePath).lookup(BaseOptions.class));
        return bo != null ? bo.getIndentEngine() : null;
    }
}

