/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.PaintElement;
import com.sun.perseus.model.Stop;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TransformTraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;

public abstract class GradientElement
extends PaintElement {
    PaintDef computedPaint;
    float[] lastColorMapFractions;
    int[] lastColorMapRGBA;
    Transform transform = new Transform(null);

    public GradientElement(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.isObjectBBox = true;
    }

    public void setTransform(Transform newTransform) {
        if (GradientElement.equal(newTransform, this.transform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.onPaintChange();
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setIsObjectBBox(boolean newIsObjectBBox) {
        if (newIsObjectBBox == this.isObjectBBox) {
            return;
        }
        this.isObjectBBox = newIsObjectBBox;
        this.onPaintChange();
    }

    boolean supportsTrait(String traitName) {
        if ("gradientTransform" == traitName || "gradientUnits" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("gradientTransform" == name) {
            return GradientElement.toStringTrait(this.transform);
        }
        if ("gradientUnits" == name) {
            if (this.isObjectBBox) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        return super.getTraitImpl(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("gradientTransform" == name) {
            this.setTransform(this.parseTransformTrait(name, value));
            return;
        } else if ("gradientUnits".equals(name)) {
            if ("objectBoundingBox".equals(value)) {
                this.setIsObjectBBox(true);
                return;
            } else {
                if (!"userSpaceOnUse".equals(value)) throw this.illegalTraitValue(name, value);
                this.setIsObjectBBox(false);
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        if ("gradientTransform".equals(name)) {
            return this.toSVGMatrixTrait(this.transform);
        }
        return super.getMatrixTraitImpl(name);
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        if ("gradientTransform".equals(name)) {
            this.setTransform(matrix);
        } else {
            super.setMatrixTraitImpl(name, matrix);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("gradientTransform" == name) {
            Transform transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            return GradientElement.toStringTrait(transform);
        }
        return super.toStringTrait(name, value);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("gradientTransform" == traitName) {
            return new TransformTraitAnim(this, traitName);
        }
        if ("gradientUnits" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("gradientTransform".equals(name)) {
            if (this.transform == null) {
                this.modifyingNode();
                this.transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.transform.equals(value)) {
                this.modifyingNode();
                this.transform.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.modifiedNode();
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null) {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("gradientUnits".equals(traitName)) {
            if (!"userSpaceOnUse".equals(value) && !"objectBoundingBox".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("gradientTransform" == traitName) {
            Transform txf = this.parseTransformTrait(traitName, value);
            return new float[][]{{txf.getComponent(0)}, {txf.getComponent(1)}, {txf.getComponent(2)}, {txf.getComponent(3)}, {txf.getComponent(4)}, {txf.getComponent(5)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    final void buildGradientColorMap() {
        int[] tmpRgba;
        int n = 0;
        Stop[] stop = new Stop[5];
        for (ElementNode c = (ElementNode)this.getFirstElementChild(); c != null; c = (ElementNode)c.getNextElementSibling()) {
            if (c.getLocalName() != "stop" || c.getNamespaceURI() != "http://www.w3.org/2000/svg") continue;
            stop[n] = (Stop)c;
            if (++n <= stop.length - 1) continue;
            Stop[] tmpStop = new Stop[stop.length + 5];
            System.arraycopy(stop, 0, tmpStop, 0, stop.length);
            stop = tmpStop;
        }
        if (n == 0) {
            this.lastColorMapFractions = new float[]{0.0f, 1.0f};
            this.lastColorMapRGBA = new int[]{0, 0};
            return;
        }
        if (n == 1) {
            RGB color = stop[0].getStopColor();
            int a = (int)(stop[0].getStopOpacity() * 255.0f);
            this.lastColorMapFractions = new float[]{0.0f, 1.0f};
            this.lastColorMapRGBA = new int[]{a << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue(), a << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue()};
            return;
        }
        float[] fractions = new float[n];
        int[] rgba = new int[n];
        RGB col = null;
        for (int i = 0; i < n; ++i) {
            fractions[i] = stop[i].getOffset();
            if (i > 0 && fractions[i] <= fractions[i - 1]) {
                fractions[i] = fractions[i - 1];
            }
            col = stop[i].getStopColor();
            rgba[i] = (int)(stop[i].getStopOpacity() * 255.0f) << 24 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue();
        }
        if (fractions[0] != 0.0f) {
            float[] tmpFractions = new float[fractions.length + 1];
            tmpRgba = new int[rgba.length + 1];
            tmpFractions[0] = 0.0f;
            tmpRgba[0] = rgba[0];
            System.arraycopy(fractions, 0, tmpFractions, 1, fractions.length);
            System.arraycopy(rgba, 0, tmpRgba, 1, rgba.length);
            fractions = tmpFractions;
            rgba = tmpRgba;
        }
        if (fractions[fractions.length - 1] != 1.0f) {
            float[] tmpFractions = new float[fractions.length + 1];
            tmpRgba = new int[rgba.length + 1];
            tmpFractions[tmpFractions.length - 1] = 1.0f;
            tmpRgba[tmpRgba.length - 1] = rgba[rgba.length - 1];
            System.arraycopy(fractions, 0, tmpFractions, 0, fractions.length);
            System.arraycopy(rgba, 0, tmpRgba, 0, rgba.length);
            fractions = tmpFractions;
            rgba = tmpRgba;
        }
        this.lastColorMapFractions = fractions;
        this.lastColorMapRGBA = rgba;
    }

    protected void onPaintChange() {
        this.computedPaint = null;
        this.lastColorMapFractions = null;
        this.lastColorMapRGBA = null;
        if (this.loaded) {
            this.notifyPaintChange();
        }
    }
}

