/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.GraphicsNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;

public abstract class CompositeGraphicsNode
extends ElementNode
implements GraphicsNode,
PaintTarget,
SVGLocatableElement {
    protected static final int FONT_STYLE_MASK = 0x60000000;
    protected static final int FONT_WEIGHT_MASK = 0x1E000000;
    protected static final int TEXT_ANCHOR_MASK = 0x1800000;
    protected static final int STROKE_OPACITY_MASK = 8355840;
    protected static final int FILL_OPACITY_MASK = 32640;
    protected static final int FILL_RULE_MASK = 64;
    protected static final int STROKE_LINE_CAP_MASK = 48;
    protected static final int STROKE_LINE_JOIN_MASK = 12;
    protected static final int VISIBILITY_MASK = 2;
    protected static final int DISPLAY_MASK = 1;
    protected static final int OPACITY_MASK = 255;
    protected static final int FONT_STYLE_NORMAL_IMPL = 0;
    protected static final int FONT_STYLE_ITALIC_IMPL = 0x40000000;
    protected static final int FONT_STYLE_OBLIQUE_IMPL = 0x60000000;
    protected static final int FONT_WEIGHT_100_IMPL = 0;
    protected static final int FONT_WEIGHT_200_IMPL = 0x2000000;
    protected static final int FONT_WEIGHT_300_IMPL = 0x4000000;
    protected static final int FONT_WEIGHT_400_IMPL = 0x6000000;
    protected static final int FONT_WEIGHT_500_IMPL = 0x8000000;
    protected static final int FONT_WEIGHT_600_IMPL = 0xA000000;
    protected static final int FONT_WEIGHT_700_IMPL = 0xC000000;
    protected static final int FONT_WEIGHT_800_IMPL = 0xE000000;
    protected static final int FONT_WEIGHT_900_IMPL = 0x10000000;
    protected static final int FONT_WEIGHT_LIGHTER_IMPL = 0x12000000;
    protected static final int FONT_WEIGHT_BOLDER_IMPL = 0x14000000;
    protected static final int TEXT_ANCHOR_MIDDLE_IMPL = 0;
    protected static final int TEXT_ANCHOR_START_IMPL = 0x800000;
    protected static final int TEXT_ANCHOR_END_IMPL = 0x1000000;
    protected static final int CAP_BUTT_IMPL = 0;
    protected static final int CAP_ROUND_IMPL = 16;
    protected static final int CAP_SQUARE_IMPL = 32;
    protected static final int JOIN_MITER_IMPL = 0;
    protected static final int JOIN_ROUND_IMPL = 4;
    protected static final int JOIN_BEVEL_IMPL = 8;
    protected RGB color = INITIAL_COLOR;
    protected PaintServer fill = INITIAL_FILL;
    protected PaintServer stroke = INITIAL_STROKE;
    protected float strokeWidth = 1.0f;
    protected float strokeMiterLimit = 4.0f;
    protected float[] strokeDashArray = INITIAL_STROKE_DASH_ARRAY;
    protected float strokeDashOffset = 0.0f;
    protected int pack = 115631171;
    protected static final int INITIAL_FONT_STYLE_IMPL = 0;
    protected static final int INITIAL_FONT_WEIGHT_IMPL = 0x6000000;
    protected static final int INITIAL_TEXT_ANCHOR_IMPL = 0x800000;
    protected static final int INITIAL_STROKE_OPACITY_IMPL = 0x640000;
    protected static final int INITIAL_FILL_OPACITY_IMPL = 25600;
    protected static final int INITIAL_FILL_RULE_IMPL = 64;
    protected static final int INITIAL_STROKE_LINE_CAP_IMPL = 0;
    protected static final int INITIAL_STROKE_LINE_JOIN_IMPL = 0;
    protected static final int INITIAL_VISIBILITY_IMPL = 2;
    protected static final int INITIAL_DISPLAY_IMPL = 1;
    protected static final int INITIAL_PACK = 115631171;
    protected int pack2 = 200;
    protected static final int INITIAL_OPACITY_IMPL = 200;
    protected static final int INITIAL_PACK2 = 200;
    public static final int COLOR_RELATIVE_MARKER = 23;
    protected int markers = 2046975;
    protected Transform txf = null;
    protected Transform inverseTxf = null;

    public CompositeGraphicsNode(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.canRenderState &= 0xFFFFFFFE;
    }

    protected boolean contributeBBox() {
        return (this.pack & 1) != 0;
    }

    public SVGRect getBBox() {
        return null;
    }

    public SVGRect getScreenBBox() {
        return null;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 1: {
                return this.fill;
            }
            case 2: {
                return this.stroke;
            }
            case 4: {
                return this.color;
            }
            case 256: {
                return this.strokeDashArray;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 16: {
                return this.strokeWidth;
            }
            case 128: {
                return this.strokeMiterLimit;
            }
            case 512: {
                return this.strokeDashOffset;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected int getPackedPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 8: {
                return this.pack & 0x40;
            }
            case 32: {
                return this.pack & 0xC;
            }
            case 64: {
                return this.pack & 0x30;
            }
            case 1024: {
                return this.pack & 1;
            }
            case 2048: {
                return this.pack & 2;
            }
            case 4096: {
                return this.pack & 0x7F80;
            }
            case 8192: {
                return this.pack & 0x7F8000;
            }
            case 16384: {
                return this.pack2 & 0xFF;
            }
        }
        return super.getPackedPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 1: {
                this.setComputedFill((PaintServer)propertyValue);
                break;
            }
            case 2: {
                this.setComputedStroke((PaintServer)propertyValue);
                break;
            }
            case 4: {
                this.setComputedColor((RGB)propertyValue);
                break;
            }
            case 256: {
                this.setComputedStrokeDashArray((float[])propertyValue);
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 16: {
                this.setComputedStrokeWidth(propertyValue);
                break;
            }
            case 128: {
                this.setComputedStrokeMiterLimit(propertyValue);
                break;
            }
            case 512: {
                this.setComputedStrokeDashOffset(propertyValue);
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setPackedPropertyState(int propertyIndex, int propertyValue) {
        block0 : switch (propertyIndex) {
            case 8: {
                if (propertyValue == 0) {
                    this.setComputedFillRule(0);
                    break;
                }
                this.setComputedFillRule(1);
                break;
            }
            case 32: {
                switch (propertyValue) {
                    case 0: {
                        this.setComputedStrokeLineJoin(0);
                        break block0;
                    }
                    case 4: {
                        this.setComputedStrokeLineJoin(1);
                        break block0;
                    }
                }
                this.setComputedStrokeLineJoin(2);
                break;
            }
            case 64: {
                switch (propertyValue) {
                    case 0: {
                        this.setComputedStrokeLineCap(0);
                        break block0;
                    }
                    case 16: {
                        this.setComputedStrokeLineCap(1);
                        break block0;
                    }
                }
                this.setComputedStrokeLineCap(2);
                break;
            }
            case 1024: {
                if (propertyValue != 0) {
                    this.setComputedDisplay(true);
                    break;
                }
                this.setComputedDisplay(false);
                break;
            }
            case 2048: {
                if (propertyValue != 0) {
                    this.setComputedVisibility(true);
                    break;
                }
                this.setComputedVisibility(false);
                break;
            }
            case 4096: {
                this.setComputedFillOpacity((float)(propertyValue >> 7) / 200.0f);
                break;
            }
            case 8192: {
                this.setComputedStrokeOpacity((float)(propertyValue >> 15) / 200.0f);
                break;
            }
            case 16384: {
                this.setComputedOpacity((float)propertyValue / 200.0f);
                break;
            }
            default: {
                super.setPackedPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 1: {
                return this.fill == propertyValue;
            }
            case 2: {
                return this.stroke == propertyValue;
            }
            case 4: {
                return this.color == propertyValue;
            }
            case 256: {
                return this.strokeDashArray == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 16: {
                return this.strokeWidth == propertyValue;
            }
            case 128: {
                return this.strokeMiterLimit == propertyValue;
            }
            case 512: {
                return this.strokeDashOffset == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isPackedPropertyState(int propertyIndex, int propertyValue) {
        switch (propertyIndex) {
            case 8: {
                return propertyValue == (this.pack & 0x40);
            }
            case 32: {
                return propertyValue == (this.pack & 0xC);
            }
            case 64: {
                return propertyValue == (this.pack & 0x30);
            }
            case 1024: {
                return propertyValue == (this.pack & 1);
            }
            case 2048: {
                return propertyValue == (this.pack & 2);
            }
            case 4096: {
                return propertyValue == (this.pack & 0x7F80);
            }
            case 8192: {
                return propertyValue == (this.pack & 0x7F8000);
            }
            case 16384: {
                return propertyValue == (this.pack2 & 0xFF);
            }
        }
        return super.isPackedPropertyState(propertyIndex, propertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(1, p.getPropertyState(1));
        this.recomputePropertyState(2, p.getPropertyState(2));
        this.recomputePropertyState(4, p.getPropertyState(4));
        this.recomputePackedPropertyState(8, p.getPackedPropertyState(8));
        this.recomputeFloatPropertyState(16, p.getFloatPropertyState(16));
        this.recomputePackedPropertyState(32, p.getPackedPropertyState(32));
        this.recomputePackedPropertyState(64, p.getPackedPropertyState(64));
        this.recomputeFloatPropertyState(128, p.getFloatPropertyState(128));
        this.recomputePropertyState(256, p.getPropertyState(256));
        this.recomputeFloatPropertyState(512, p.getFloatPropertyState(512));
        this.recomputePackedPropertyState(1024, p.getPackedPropertyState(1024));
        this.recomputePackedPropertyState(2048, p.getPackedPropertyState(2048));
        this.recomputePackedPropertyState(4096, p.getPackedPropertyState(4096));
        this.recomputePackedPropertyState(8192, p.getPackedPropertyState(8192));
        this.recomputePackedPropertyState(16384, p.getPackedPropertyState(16384));
    }

    protected void recomputePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (!this.isInherited(propertyIndex) || this.isPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setPropertyState(propertyIndex, parentPropertyValue);
        this.propagatePropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputeFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (!this.isInherited(propertyIndex) || this.isFloatPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setFloatPropertyState(propertyIndex, parentPropertyValue);
        this.propagateFloatPropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (!this.isInherited(propertyIndex) || this.isPackedPropertyState(propertyIndex, parentPropertyValue)) {
            return;
        }
        this.setPackedPropertyState(propertyIndex, parentPropertyValue);
        this.propagatePackedPropertyState(propertyIndex, parentPropertyValue);
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputePropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedFloatPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputeFloatPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPackedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.appendTransform(parentTransform, this.txf);
        this.computeCanRenderTransformBit(this.txf);
        this.inverseTxf = null;
        this.recomputeTransformState(this.txf, this.getFirstChildNode());
    }

    public Transform getTransformState() {
        return this.txf;
    }

    Transform getInverseTransformState() {
        if ((this.canRenderState & 0x10) == 0) {
            if (this.inverseTxf == null) {
                if (this.parent != null && this.txf == this.parent.getTransformState()) {
                    this.inverseTxf = this.parent.getInverseTransformState();
                } else {
                    this.inverseTxf = new Transform(null);
                    try {
                        this.inverseTxf = (Transform)this.txf.inverse(this.inverseTxf);
                    }
                    catch (Exception e) {
                        throw new Error();
                    }
                }
            }
        } else {
            this.inverseTxf = null;
        }
        return this.inverseTxf;
    }

    public final boolean isInherited(int propertyIndex) {
        return this.isMarkerSet(propertyIndex);
    }

    public void setInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            Object inheritedValue = this.getInheritedPropertyState(propertyIndex);
            this.setPropertyState(propertyIndex, inheritedValue);
            this.propagatePropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    public void setFloatInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            float inheritedValue = this.getInheritedFloatPropertyState(propertyIndex);
            this.setFloatPropertyState(propertyIndex, inheritedValue);
            this.propagateFloatPropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    public void setPackedInherited(int propertyIndex, boolean inherit) {
        if (this.isInherited(propertyIndex) == inherit) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(propertyIndex, inherit);
        if (inherit) {
            int inheritedValue = this.getInheritedPackedPropertyState(propertyIndex);
            this.setPackedPropertyState(propertyIndex, inheritedValue);
            this.propagatePackedPropertyState(propertyIndex, inheritedValue);
        }
        this.modifiedNode();
    }

    protected void setInheritedQuiet(int propertyIndex, boolean inherit) {
        if (inherit) {
            this.setMarker(propertyIndex);
        } else {
            this.clearMarker(propertyIndex);
        }
    }

    public boolean isColorRelative(int propertyIndex) {
        return this.isMarkerSet(propertyIndex << 23);
    }

    public boolean isColorRelativeProperty(int propertyIndex) {
        switch (propertyIndex) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setColorRelative(int propertyIndex, boolean isColorRelative) {
        if (isColorRelative && !this.isColorRelativeProperty(propertyIndex)) {
            throw new IllegalArgumentException();
        }
        if (this.isColorRelative(propertyIndex) == isColorRelative) {
            return;
        }
        this.modifyingNode();
        this.setColorRelativeQuiet(propertyIndex, isColorRelative);
        if (isColorRelative) {
            this.setPropertyState(propertyIndex, this.color);
            this.propagatePropertyState(propertyIndex, this.color);
        }
        this.modifiedNode();
    }

    void setMarker(int marker) {
        this.markers |= marker;
    }

    void clearMarker(int marker) {
        this.markers &= ~marker;
    }

    final boolean isMarkerSet(int marker) {
        return (this.markers & marker) != 0;
    }

    protected void setColorRelativeQuiet(int propertyIndex, boolean isColorRelative) {
        if (isColorRelative) {
            this.setMarker(propertyIndex << 23);
        } else {
            this.clearMarker(propertyIndex << 23);
        }
    }

    public void setFill(PaintServer newFill) {
        if (!this.isInherited(1) && CompositeGraphicsNode.equal(newFill, this.fill)) {
            return;
        }
        this.modifyingNode();
        if (this.fill != null) {
            this.fill.dispose();
        }
        this.setComputedFill(newFill);
        this.setInheritedQuiet(1, false);
        this.setColorRelativeQuiet(1, false);
        this.propagatePropertyState(1, this.fill);
        this.modifiedNode();
    }

    void setComputedFill(PaintServer newFill) {
        this.fill = newFill;
    }

    public PaintServer getFill() {
        return this.fill;
    }

    public void setFillOpacity(float newFillOpacity) {
        if (!this.isInherited(4096) && newFillOpacity == this.getFillOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newFillOpacity > 1.0f) {
            newFillOpacity = 1.0f;
        } else if (newFillOpacity < 0.0f) {
            newFillOpacity = 0.0f;
        }
        this.setInheritedQuiet(4096, false);
        this.setComputedFillOpacity(newFillOpacity);
        this.propagatePackedPropertyState(4096, this.pack & 0x7F80);
        this.modifiedNode();
    }

    void setComputedFillOpacity(float newFillOpacity) {
        this.pack &= 0xFFFF807F;
        this.pack |= (int)(newFillOpacity * 200.0f) << 7 & 0x7F80;
    }

    public float getFillOpacity() {
        return (float)((this.pack & 0x7F80) >> 7) / 200.0f;
    }

    public void setStroke(PaintServer newStroke) {
        if (!this.isInherited(2) && CompositeGraphicsNode.equal(newStroke, this.stroke)) {
            return;
        }
        this.modifyingNode();
        if (newStroke != this.stroke && this.stroke != null) {
            this.stroke.dispose();
        }
        this.setInheritedQuiet(2, false);
        this.setColorRelativeQuiet(2, false);
        this.setComputedStroke(newStroke);
        this.propagatePropertyState(2, this.stroke);
        this.modifiedNode();
    }

    void setComputedStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    public PaintServer getStroke() {
        return this.stroke;
    }

    public void setStrokeOpacity(float newStrokeOpacity) {
        if (!this.isInherited(8192) && newStrokeOpacity == this.getStrokeOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newStrokeOpacity > 1.0f) {
            newStrokeOpacity = 1.0f;
        } else if (newStrokeOpacity < 0.0f) {
            newStrokeOpacity = 0.0f;
        }
        this.setInheritedQuiet(8192, false);
        this.setComputedStrokeOpacity(newStrokeOpacity);
        this.propagatePackedPropertyState(8192, this.pack & 0x7F8000);
        this.modifiedNode();
    }

    void setComputedStrokeOpacity(float newStrokeOpacity) {
        this.pack &= 0xFF807FFF;
        this.pack |= (int)(newStrokeOpacity * 200.0f) << 15 & 0x7F8000;
    }

    public float getStrokeOpacity() {
        return (float)((this.pack & 0x7F8000) >> 15) / 200.0f;
    }

    public void setColor(RGB newColor) {
        if (!this.isInherited(4) && CompositeGraphicsNode.equal(newColor, this.color)) {
            return;
        }
        this.modifyingNode();
        this.setComputedColor(newColor);
        this.setInheritedQuiet(4, false);
        this.propagatePropertyState(4, this.color);
        this.modifiedNode();
    }

    void setComputedColor(RGB newColor) {
        this.color = newColor;
        if (this.isColorRelative(1)) {
            this.setComputedFill(newColor);
            this.propagatePropertyState(1, this.fill);
        }
        if (this.isColorRelative(2)) {
            this.setComputedStroke(newColor);
            this.propagatePropertyState(2, this.stroke);
        }
    }

    public RGB getColor() {
        return this.color;
    }

    public void setFillRule(int newFillRule) {
        if (!this.isInherited(8) && newFillRule == this.getFillRule()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(8, false);
        this.setComputedFillRule(newFillRule);
        this.propagatePackedPropertyState(8, this.pack & 0x40);
        this.modifiedNode();
    }

    final void setComputedFillRule(int newFillRule) {
        this.pack = newFillRule == 1 ? (this.pack |= 0x40) : (this.pack &= 0xFFFFFFBF);
    }

    public int getFillRule() {
        if ((this.pack & 0x40) == 64) {
            return 1;
        }
        return 0;
    }

    public void setStrokeDashArray(float[] newStrokeDashArray) {
        if (!this.isInherited(256) && CompositeGraphicsNode.equal(newStrokeDashArray, this.strokeDashArray)) {
            return;
        }
        this.modifyingNode();
        this.setComputedStrokeDashArray(newStrokeDashArray);
        this.setInheritedQuiet(256, false);
        this.propagatePropertyState(256, newStrokeDashArray);
        this.modifiedNode();
    }

    void setComputedStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
    }

    public float[] getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public void setStrokeLineCap(int newStrokeLineCap) {
        if (!this.isInherited(64) && newStrokeLineCap == this.getStrokeLineCap()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(64, false);
        this.setComputedStrokeLineCap(newStrokeLineCap);
        this.propagatePackedPropertyState(64, this.pack & 0x30);
        this.modifiedNode();
    }

    void setComputedStrokeLineCap(int newStrokeLineCap) {
        this.pack &= 0xFFFFFFCF;
        switch (newStrokeLineCap) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 0x10;
                break;
            }
            default: {
                this.pack |= 0x20;
            }
        }
    }

    public int getStrokeLineCap() {
        switch (this.pack & 0x30) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeLineJoin(int newStrokeLineJoin) {
        if (!this.isInherited(32) && newStrokeLineJoin == this.getStrokeLineJoin()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(32, false);
        this.setComputedStrokeLineJoin(newStrokeLineJoin);
        this.propagatePackedPropertyState(32, this.pack & 0xC);
        this.modifiedNode();
    }

    void setComputedStrokeLineJoin(int newStrokeLineJoin) {
        this.pack &= 0xFFFFFFF3;
        switch (newStrokeLineJoin) {
            case 0: {
                this.pack |= 0;
                break;
            }
            case 1: {
                this.pack |= 4;
                break;
            }
            default: {
                this.pack |= 8;
            }
        }
    }

    public int getStrokeLineJoin() {
        switch (this.pack & 0xC) {
            case 0: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return 2;
    }

    public void setStrokeWidth(float newStrokeWidth) {
        if (newStrokeWidth < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (!this.isInherited(16) && newStrokeWidth == this.strokeWidth) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(16, false);
        this.setComputedStrokeWidth(newStrokeWidth);
        this.propagateFloatPropertyState(16, newStrokeWidth);
        this.modifiedNode();
    }

    void setComputedStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeMiterLimit(float newStrokeMiterLimit) {
        if (newStrokeMiterLimit < 1.0f) {
            throw new IllegalArgumentException();
        }
        if (!this.isInherited(128) && newStrokeMiterLimit == this.strokeMiterLimit) {
            return;
        }
        this.modifyingNode();
        this.setComputedStrokeMiterLimit(newStrokeMiterLimit);
        this.setInheritedQuiet(128, false);
        this.propagateFloatPropertyState(128, this.strokeMiterLimit);
        this.modifiedNode();
    }

    void setComputedStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
    }

    public float getStrokeMiterLimit() {
        return this.strokeMiterLimit;
    }

    public void setStrokeDashOffset(float newStrokeDashOffset) {
        if (!this.isInherited(512) && newStrokeDashOffset == this.strokeDashOffset) {
            return;
        }
        this.modifyingNode();
        this.setComputedStrokeDashOffset(newStrokeDashOffset);
        this.setInheritedQuiet(512, false);
        this.propagateFloatPropertyState(512, this.strokeDashOffset);
        this.modifiedNode();
    }

    void setComputedStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
    }

    public float getStrokeDashOffset() {
        return this.strokeDashOffset;
    }

    public void setVisibility(boolean newVisibility) {
        if (!this.isInherited(2048) && newVisibility == this.getVisibility()) {
            return;
        }
        this.modifyingNode();
        this.setComputedVisibility(newVisibility);
        this.setInheritedQuiet(2048, false);
        this.propagatePackedPropertyState(2048, this.pack & 2);
        this.modifiedNode();
    }

    void setComputedVisibility(boolean newVisibility) {
        this.pack = newVisibility ? (this.pack |= 2) : (this.pack &= 0xFFFFFFFD);
    }

    public boolean getVisibility() {
        return (this.pack & 2) == 2;
    }

    public void setDisplay(boolean newDisplay) {
        if (!this.isInherited(1024) && newDisplay == this.getDisplay()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(1024, false);
        this.setComputedDisplay(newDisplay);
        this.propagatePackedPropertyState(1024, this.pack & 1);
        this.modifiedNode();
    }

    void setComputedDisplay(boolean newDisplay) {
        this.pack = newDisplay ? (this.pack |= 1) : (this.pack &= 0xFFFFFFFE);
        this.computeCanRenderDisplayBit(newDisplay);
    }

    public boolean getDisplay() {
        return (this.pack & 1) == 1;
    }

    public void setOpacity(float newOpacity) {
        if (!this.isInherited(16384) && newOpacity == this.getOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newOpacity > 1.0f) {
            newOpacity = 1.0f;
        } else if (newOpacity < 0.0f) {
            newOpacity = 0.0f;
        }
        this.setInheritedQuiet(16384, false);
        this.setComputedOpacity(newOpacity);
        this.propagatePackedPropertyState(16384, this.pack2 & 0xFF);
        this.modifiedNode();
    }

    void setComputedOpacity(float newOpacity) {
        this.pack2 &= 0xFFFFFF00;
        this.pack2 |= (int)(newOpacity * 200.0f) & 0xFF;
    }

    public float getOpacity() {
        return (float)(this.pack2 & 0xFF) / 200.0f;
    }

    boolean supportsTrait(String traitName) {
        if ("stroke-width" == traitName || "stroke-miterlimit" == traitName || "stroke-dashoffset" == traitName || "fill-rule" == traitName || "stroke-linejoin" == traitName || "stroke-linecap" == traitName || "display" == traitName || "visibility" == traitName || "color" == traitName || "fill" == traitName || "stroke" == traitName || "fill-opacity" == traitName || "stroke-opacity" == traitName || "stroke-dasharray" == traitName || "opacity" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("stroke-width" == name && this.isInherited(16) || "stroke-miterlimit" == name && this.isInherited(128) || "stroke-dashoffset" == name && this.isInherited(512) || "fill-rule" == name && this.isInherited(8) || "stroke-linejoin" == name && this.isInherited(32) || "stroke-linecap" == name && this.isInherited(64) || "display" == name && this.isInherited(1024) || "visibility" == name && this.isInherited(2048) || "color" == name && this.isInherited(4) || "fill" == name && this.isInherited(1) || "stroke" == name && this.isInherited(2) || "fill-opacity" == name && this.isInherited(4096) || "stroke-opacity" == name && this.isInherited(8192) || "opacity" == name && this.isInherited(16384) || "stroke-dasharray" == name && this.isInherited(256)) {
            return "inherit";
        }
        if ("fill" == name && this.isColorRelative(1) || "stroke" == name && this.isColorRelative(2)) {
            return "currentColor";
        }
        if ("display" == name) {
            if (this.getDisplay()) {
                return "inline";
            }
            return "none";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    String fillRuleToStringTrait(int fillRule) {
        if (fillRule == 64) {
            return "nonzero";
        }
        return "evenodd";
    }

    String strokeLineJoinToStringTrait(int strokeLineJoin) {
        switch (strokeLineJoin) {
            case 0: {
                return "miter";
            }
            case 4: {
                return "round";
            }
        }
        return "bevel";
    }

    String strokeLineCapToStringTrait(int strokeLineCap) {
        switch (strokeLineCap) {
            case 0: {
                return "butt";
            }
            case 16: {
                return "round";
            }
        }
        return "square";
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("stroke-width" == name) {
            return Float.toString(this.getStrokeWidth());
        }
        if ("stroke-miterlimit" == name) {
            return Float.toString(this.getStrokeMiterLimit());
        }
        if ("stroke-dashoffset" == name) {
            return Float.toString(this.getStrokeDashOffset());
        }
        if ("fill-rule" == name) {
            return this.fillRuleToStringTrait(this.pack & 0x40);
        }
        if ("stroke-linejoin" == name) {
            return this.strokeLineJoinToStringTrait(this.pack & 0xC);
        }
        if ("stroke-linecap" == name) {
            return this.strokeLineCapToStringTrait(this.pack & 0x30);
        }
        if ("display" == name) {
            if (this.getDisplay()) {
                return "inline";
            }
            return "none";
        }
        if ("visibility" == name) {
            if (this.getVisibility()) {
                return "visible";
            }
            return "hidden";
        }
        if ("color" == name) {
            return this.getColor().toString();
        }
        if ("fill" == name) {
            return this.toString(this.getFill());
        }
        if ("stroke" == name) {
            return this.toString(this.getStroke());
        }
        if ("fill-opacity" == name) {
            return Float.toString(this.getFillOpacity());
        }
        if ("stroke-opacity" == name) {
            return Float.toString(this.getStrokeOpacity());
        }
        if ("stroke-dasharray" == name) {
            return this.toStringTrait(this.getStrokeDashArray());
        }
        if ("opacity" == name) {
            return Float.toString(this.getOpacity());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("stroke-width" == name) {
            return this.getStrokeWidth();
        }
        if ("stroke-miterlimit" == name) {
            return this.getStrokeMiterLimit();
        }
        if ("stroke-dashoffset" == name) {
            return this.getStrokeDashOffset();
        }
        if ("fill-opacity" == name) {
            return this.getFillOpacity();
        }
        if ("stroke-opacity" == name) {
            return this.getStrokeOpacity();
        }
        if ("opacity" == name) {
            return this.getOpacity();
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("fill".equals(name)) {
            return this.toSVGRGBColor("fill", this.getFill());
        }
        if ("stroke".equals(name)) {
            return this.toSVGRGBColor("stroke", this.getStroke());
        }
        if ("color".equals(name)) {
            return this.toSVGRGBColor("color", this.getColor());
        }
        return super.getRGBColorTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("stroke-width" == traitName || "stroke-miterlimit" == traitName || "stroke-dashoffset" == traitName || "fill-opacity" == traitName || "stroke-opacity" == traitName || "opacity" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("color" == traitName || "fill" == traitName || "stroke" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        if ("stroke-dasharray" == traitName) {
            return new FloatTraitAnim(this, traitName, "string");
        }
        if ("display" == traitName || "fill-rule" == traitName || "stroke-linecap" == traitName || "stroke-linejoin" == traitName || "visibility" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("stroke-width" == name) {
            this.checkPositive(name, value[0][0]);
            this.setStrokeWidth(value[0][0]);
        } else if ("stroke-miterlimit".equals(name)) {
            if (value[0][0] < 1.0f) {
                throw this.illegalTraitValue(name, Float.toString(value[0][0]));
            }
            this.setStrokeMiterLimit(value[0][0]);
        } else if ("stroke-dashoffset".equals(name)) {
            this.setStrokeDashOffset(value[0][0]);
        } else if ("color" == name) {
            this.setColor(this.toRGB(name, value));
        } else if ("fill" == name) {
            this.setFill(this.toRGB(name, value));
        } else if ("stroke" == name) {
            this.setStroke(this.toRGB(name, value));
        } else if ("fill-opacity" == name) {
            this.setFillOpacity(value[0][0]);
        } else if ("stroke-opacity" == name) {
            this.setStrokeOpacity(value[0][0]);
        } else if ("stroke-dasharray".equals(name)) {
            this.setStrokeDashArray(value[0]);
        } else if ("opacity" == name) {
            this.setOpacity(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null && namespaceURI != "#!null/ns@!") {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("stroke-width" == traitName || "stroke-miterlimit" == traitName || "stroke-dashoffset" == traitName || "color" == traitName || "fill" == traitName || "stroke" == traitName || "fill-opacity" == traitName || "stroke-opacity" == traitName || "stroke-dasharray".equals(traitName) || "opacity" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        if ("fill-rule" == traitName) {
            if ("inherit".equals(value)) {
                return this.fillRuleToStringTrait(this.getInheritedPackedPropertyState(8));
            }
            if (!"nonzero".equals(value) && !"evenodd".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("stroke-linejoin" == traitName) {
            if ("inherit".equals(value)) {
                return this.strokeLineJoinToStringTrait(this.getInheritedPackedPropertyState(32));
            }
            if (!("miter".equals(value) || "round".equals(value) || "bevel".equals(value))) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("stroke-linecap" == traitName) {
            if ("inherit".equals(value)) {
                return this.strokeLineCapToStringTrait(this.getInheritedPackedPropertyState(64));
            }
            if (!("butt".equals(value) || "round".equals(value) || "square".equals(value))) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("display" == traitName) {
            if ("inherit".equals(value)) {
                if (this.getInheritedPackedPropertyState(1024) != 0) {
                    return "inline";
                }
                return "none";
            }
            if (!"inline".equals(value) && !"none".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("visibility" == traitName) {
            if ("inherit".equals(value)) {
                if (this.getInheritedPackedPropertyState(2048) != 0) {
                    return "visible";
                }
                return "hidden";
            }
            if (!"visible".equals(value) && !"hidden".equals(value)) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("stroke-width" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        if ("stroke-miterlimit".equals(traitName)) {
            float miter = this.parseFloatTrait(traitName, value);
            if (miter < 1.0f) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{miter}};
        }
        if ("stroke-dashoffset".equals(traitName)) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("fill-rule" == traitName || "stroke-linejoin" == traitName || "stroke-linecap" == traitName || "display" == traitName || "visibility" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        if ("color" == traitName) {
            RGB color = GraphicsProperties.INITIAL_COLOR;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(4) : this.parseColorTrait("color", value);
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("fill" == traitName) {
            RGB color = GraphicsProperties.INITIAL_FILL;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(1) : ("currentColor".equals(value) ? this.color : this.parseColorTrait("fill", value));
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("stroke" == traitName) {
            RGB color = GraphicsProperties.INITIAL_STROKE;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(2) : ("currentColor".equals(value) ? this.getColor() : this.parseColorTrait("stroke", value));
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("fill-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                if (this.parent != null) {
                    v = (float)(this.getInheritedPackedPropertyState(4096) >> 7) / 200.0f;
                }
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        if ("stroke-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                v = (float)(this.getInheritedPackedPropertyState(8192) >> 15) / 200.0f;
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        if ("stroke-dasharray".equals(traitName)) {
            float[] da = this.parsePositiveFloatArrayTrait(traitName, value);
            if (da == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{da};
        }
        if ("opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                v = (float)this.getInheritedPackedPropertyState(16384) / 200.0f;
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("stroke-width" == name) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(16, true);
                return;
            } else {
                this.setStrokeWidth(this.parsePositiveFloatTrait(name, value));
            }
            return;
        } else if ("stroke-miterlimit".equals(name)) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(128, true);
                return;
            } else {
                float miter = this.parseFloatTrait(name, value);
                if (miter < 1.0f) {
                    throw this.illegalTraitValue(name, value);
                }
                this.setStrokeMiterLimit(miter);
            }
            return;
        } else if ("stroke-dashoffset".equals(name)) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(512, true);
                return;
            } else {
                this.setStrokeDashOffset(this.parseFloatTrait(name, value));
            }
            return;
        } else if ("fill-rule" == name) {
            if ("nonzero".equals(value)) {
                this.setFillRule(1);
                return;
            } else if ("evenodd".equals(value)) {
                this.setFillRule(0);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(8, true);
            }
            return;
        } else if ("stroke-linejoin" == name) {
            if ("miter".equals(value)) {
                this.setStrokeLineJoin(0);
                return;
            } else if ("round".equals(value)) {
                this.setStrokeLineJoin(1);
                return;
            } else if ("bevel".equals(value)) {
                this.setStrokeLineJoin(2);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(32, true);
            }
            return;
        } else if ("stroke-linecap" == name) {
            if ("butt".equals(value)) {
                this.setStrokeLineCap(0);
                return;
            } else if ("round".equals(value)) {
                this.setStrokeLineCap(1);
                return;
            } else if ("square".equals(value)) {
                this.setStrokeLineCap(2);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(64, true);
            }
            return;
        } else if ("display" == name) {
            if ("none".equals(value)) {
                this.setDisplay(false);
                return;
            } else if ("inherit".equals(value)) {
                if (this.isInherited(1024)) return;
                this.setPackedInherited(1024, true);
                return;
            } else {
                if (!"block".equals(value) && !"compact".equals(value) && !"inline-table".equals(value) && !"inline".equals(value) && !"list-item".equals(value) && !"marker".equals(value) && !"run-in".equals(value) && !"table".equals(value) && !"table-row-group".equals(value) && !"table-header-group".equals(value) && !"table-footer-group".equals(value) && !"table-row".equals(value) && !"table-column-group".equals(value) && !"table-column".equals(value) && !"table-cell".equals(value) && !"table-caption".equals(value)) throw this.illegalTraitValue(name, value);
                this.setDisplay(true);
            }
            return;
        } else if ("visibility" == name) {
            if ("inherit".equals(value)) {
                this.setPackedInherited(2048, true);
                return;
            } else if ("hidden".equals(value) || "collapse".equals(value)) {
                this.setVisibility(false);
                return;
            } else {
                if (!"visible".equals(value)) throw this.illegalTraitValue(name, value);
                this.setVisibility(true);
            }
            return;
        } else if ("color" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(4, true);
                return;
            } else {
                if ("none".equals(value)) {
                    throw this.illegalTraitValue(name, value);
                }
                RGB color = this.parseColorTrait("color", value);
                this.setColor(color);
            }
            return;
        } else if ("fill" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(1, true);
                this.setColorRelative(1, false);
                return;
            } else if ("none".equals(value)) {
                this.setFill(null);
                return;
            } else if ("currentColor".equals(value)) {
                this.setColorRelative(1, true);
                this.setInherited(1, false);
                return;
            } else {
                PaintServer fill = this.parsePaintTrait("fill", this, value);
                if (fill == null) return;
                this.setFill(fill);
            }
            return;
        } else if ("stroke" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(2, true);
                this.setColorRelative(2, false);
                return;
            } else if ("none".equals(value)) {
                this.setStroke(null);
                return;
            } else if ("currentColor".equals(value)) {
                this.setColorRelative(2, true);
                this.setInherited(2, false);
                return;
            } else {
                PaintServer stroke = this.parsePaintTrait("stroke", this, value);
                if (stroke == null) return;
                this.setStroke(stroke);
            }
            return;
        } else if ("fill-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setPackedInherited(4096, true);
                return;
            } else {
                this.setFillOpacity(this.parseFloatTrait(name, value));
            }
            return;
        } else if ("stroke-opacity".equals(name)) {
            if ("inherit".equals(value)) {
                this.setPackedInherited(8192, true);
                return;
            } else {
                this.setStrokeOpacity(this.parseFloatTrait(name, value));
            }
            return;
        } else if ("stroke-dasharray".equals(name)) {
            if ("inherit".equals(value)) {
                this.setInherited(256, true);
                return;
            } else if ("none".equals(value)) {
                this.setStrokeDashArray(null);
                return;
            } else {
                this.setStrokeDashArray(this.parsePositiveFloatArrayTrait(name, value));
            }
            return;
        } else if ("opacity".equals(name)) {
            if ("inherit".equals(value)) {
                this.setPackedInherited(16384, true);
                return;
            } else {
                this.setOpacity(this.parseFloatTrait(name, value));
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("stroke-width" == name || "stroke-miterlimit" == name || "stroke-dashoffset" == name || "fill-opacity" == name || "stroke-opacity" == name || "opacity" == name) {
            return Float.toString(value[0][0]);
        }
        if ("color" == name || "fill" == name || "stroke" == name) {
            return this.toRGBString(name, value);
        }
        if ("stroke-dasharray" == name) {
            return this.toStringTrait(value[0]);
        }
        return super.toStringTrait(name, value);
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("stroke-width" == name) {
            this.checkPositive(name, value);
            this.setStrokeWidth(value);
        } else if ("stroke-miterlimit" == name) {
            if (value < 1.0f) {
                throw this.illegalTraitValue(name, Float.toString(value));
            }
            this.setStrokeMiterLimit(value);
        } else if ("stroke-dashoffset" == name) {
            this.setStrokeDashOffset(value);
        } else if ("fill-opacity" == name) {
            this.setFillOpacity(value);
        } else if ("stroke-opacity" == name) {
            this.setStrokeOpacity(value);
        } else if ("opacity" == name) {
            this.setOpacity(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("fill".equals(name)) {
                this.setFill((RGB)color);
            } else if ("stroke".equals(name)) {
                this.setStroke((RGB)color);
            } else if ("color".equals(name)) {
                this.setColor((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
        if (paintType == "fill") {
            this.setFill(paintServer);
        } else if (paintType == "stroke") {
            this.setStroke(paintServer);
        } else {
            throw new Error();
        }
    }
}

