/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.modules.java.hints.perf.SizeEqualsZero;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class Tiny {
    static final String SC_IGNORE_SUBSTRING = "ignore.substring";
    static final boolean SC_IGNORE_SUBSTRING_DEFAULT = true;
    private static final String CONF_SC_CHECKBOX_LABEL = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_LBL_SizeEqualsZero");
    private static final String CONF_SC_CHECKBOX_TP = NbBundle.getMessage(SizeEqualsZero.class, (String)"CONF_TP_SizeEqualsZero");
    private static final Set<Tree.Kind> KEEP_PARENTHESIS = EnumSet.of(Tree.Kind.MEMBER_SELECT);

    public static ErrorDescription stringConstructor(HintContext hintContext) {
        Object object;
        Object object2;
        Object object3;
        TreePath treePath = hintContext.getVariables().get("$original");
        if (hintContext.getPreferences().getBoolean(SC_IGNORE_SUBSTRING, true) && (MatcherUtilities.matches(hintContext, treePath, "$str1.substring($s)", true) || MatcherUtilities.matches(hintContext, treePath, "$str2.substring($s, $e)", true))) {
            Object object4 = object3 = hintContext.getVariables().get("$str1") != null ? hintContext.getVariables().get("$str1") : hintContext.getVariables().get("$str2");
            assert (object3 != null);
            object2 = hintContext.getInfo().getTrees().getTypeMirror((TreePath)object3);
            if (object2 != null && object2.getKind() == TypeKind.DECLARED && (object = (TypeElement)((DeclaredType)object2).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
        }
        object3 = NbBundle.getMessage(Tiny.class, (String)"FIX_StringConstructor");
        object2 = JavaFix.rewriteFix(hintContext, (String)object3, hintContext.getPath(), "$original", new String[0]);
        object = NbBundle.getMessage(Tiny.class, (String)"ERR_StringConstructor");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), (String)object, new Fix[]{object2});
    }

    public static ErrorDescription stringEqualsEmpty(HintContext hintContext) {
        Fix fix;
        String string;
        if (hintContext.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_6) >= 0) {
            string = NbBundle.getMessage(Tiny.class, (String)"FIX_StringEqualsEmpty16");
            fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$string.isEmpty()", new String[0]);
        } else {
            boolean bl = hintContext.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            String string2 = NbBundle.getMessage(Tiny.class, (String)(bl ? "FIX_StringEqualsEmptyNeg" : "FIX_StringEqualsEmpty"));
            fix = JavaFix.rewriteFix(hintContext, string2, bl ? hintContext.getPath().getParentPath() : hintContext.getPath(), bl ? "$string.length() != 0" : "$string.length() == 0", new String[0]);
        }
        string = NbBundle.getMessage(Tiny.class, (String)"ERR_StringEqualsEmpty");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string, fix);
    }

    public static ErrorDescription lengthOneStringIndexOf(HintContext hintContext) {
        TreePath treePath = hintContext.getVariables().get("$toSearch");
        if (treePath.getLeaf().getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        LiteralTree literalTree = (LiteralTree)treePath.getLeaf();
        String string = (String)literalTree.getValue();
        if (string.length() != 1) {
            return null;
        }
        String string2 = NbBundle.getMessage(Tiny.class, (String)"FIX_LengthOneStringIndexOf");
        Fix fix = JavaFix.rewriteFix(hintContext, string2, treePath, "'" + (string.equals("'") ? "\\" : "") + string + "'", new String[0]);
        int n = (int)hintContext.getInfo().getTrees().getSourcePositions().getStartPosition(hintContext.getInfo().getCompilationUnit(), treePath.getLeaf());
        int n2 = (int)hintContext.getInfo().getTrees().getSourcePositions().getEndPosition(hintContext.getInfo().getCompilationUnit(), treePath.getLeaf());
        String string3 = hintContext.getInfo().getText().substring(n, n2);
        String string4 = NbBundle.getMessage(Tiny.class, (String)"ERR_LengthOneStringIndexOf", (Object)string3);
        return ErrorDescriptionFactory.forTree(hintContext, treePath, string4, fix);
    }

    public static ErrorDescription getClassInsteadOfDotClass(HintContext hintContext) {
        TreePath treePath = hintContext.getVariables().get("$O");
        if (treePath.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            treePath = new TreePath(treePath, ((ParameterizedTypeTree)treePath.getLeaf()).getType());
        }
        hintContext.getVariables().put("$OO", treePath);
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_GetClassInsteadOfDotClass");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$OO.class", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_GetClassInsteadOfDotClass");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string2, fix);
    }

    public static ErrorDescription constantIntern(HintContext hintContext) {
        String string;
        TreePath treePath = hintContext.getVariables().get("$str");
        TreePath treePath2 = treePath.getLeaf().getKind() == Tree.Kind.PARENTHESIZED ? new TreePath(treePath, ((ParenthesizedTree)treePath.getLeaf()).getExpression()) : treePath;
        if (!Utilities.isConstantString(hintContext.getInfo(), treePath2)) {
            return null;
        }
        String string2 = NbBundle.getMessage(Tiny.class, (String)"FIX_ConstantIntern");
        if (treePath2 != treePath && KEEP_PARENTHESIS.contains((Object)hintContext.getPath().getParentPath().getLeaf().getKind())) {
            string = "$str";
        } else {
            string = "$constant";
            hintContext.getVariables().put("$constant", treePath2);
        }
        Fix fix = JavaFix.rewriteFix(hintContext, string2, hintContext.getPath(), string, new String[0]);
        String string3 = NbBundle.getMessage(Tiny.class, (String)"ERR_ConstantIntern");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string3, fix);
    }

    public static ErrorDescription enumSet(HintContext hintContext) {
        return Tiny.enumHint(hintContext, "java.util.Set", null, "ERR_Tiny_enumSet");
    }

    public static ErrorDescription enumMap(HintContext hintContext) {
        return Tiny.enumHint(hintContext, "java.util.Map", "java.util.EnumMap", "ERR_Tiny_enumMap");
    }

    private static ErrorDescription enumHint(HintContext hintContext, String string, String string2, String string3) {
        Object object;
        Element element = hintContext.getInfo().getTrees().getElement(hintContext.getVariables().get("$param"));
        if (element == null || element.getKind() != ElementKind.ENUM) {
            return null;
        }
        Element element2 = hintContext.getInfo().getTrees().getElement(hintContext.getVariables().get("$coll"));
        if (element2 == null || element2.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = hintContext.getInfo().getElements().getTypeElement(string);
        if (typeElement == null) {
            return null;
        }
        Types types = hintContext.getInfo().getTypes();
        if (!types.isSubtype(types.erasure(element2.asType()), types.erasure(typeElement.asType()))) {
            return null;
        }
        if (string2 != null) {
            object = hintContext.getInfo().getElements().getTypeElement(string2);
            if (object == null) {
                return null;
            }
            if (types.isSubtype(types.erasure(element2.asType()), types.erasure(object.asType()))) {
                return null;
            }
        }
        object = NbBundle.getMessage(Tiny.class, (String)string3);
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), (String)object, new Fix[0]);
    }

    public static final class StringConstructorCustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public StringConstructorCustomizerProviderImpl() {
            super(CONF_SC_CHECKBOX_LABEL, CONF_SC_CHECKBOX_TP, Tiny.SC_IGNORE_SUBSTRING, true);
        }
    }
}

