/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.beanutils;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodUtils {
    private static Log log = LogFactory.getLog(class$com$sun$org$apache$commons$beanutils$MethodUtils == null ? (class$com$sun$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("com.sun.org.apache.commons.beanutils.MethodUtils")) : class$com$sun$org$apache$commons$beanutils$MethodUtils);
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    static /* synthetic */ Class class$com$sun$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (args == null) {
            args = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = emptyObjectArray;
        }
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        if (log.isTraceEnabled()) {
            log.trace("Matching name=" + methodName + " on " + clazz);
        }
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("Found straight match: " + method);
                log.trace("isPublic:" + Modifier.isPublic(method.getModifiers()));
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException se) {
                if (!loggedAccessibleWarning) {
                    log.warn("Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                    loggedAccessibleWarning = true;
                }
                log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", se);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Method[] methods = clazz.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Class<?>[] methodsParams;
                int methodParamSize;
                if (!methods[i].getName().equals(methodName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found matching name:");
                    log.trace(methods[i]);
                }
                if ((methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (log.isTraceEnabled()) {
                        log.trace("Param=" + parameterTypes[n].getName());
                        log.trace("Method=" + methodsParams[n].getName());
                    }
                    if (MethodUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue;
                    if (log.isTraceEnabled()) {
                        log.trace(methodsParams[n] + " is not assignable from " + parameterTypes[n]);
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                Method method = MethodUtils.getAccessibleMethod(methods[i]);
                if (method != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(method + " accessible version of " + methods[i]);
                    }
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        if (!loggedAccessibleWarning) {
                            log.warn("Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                            loggedAccessibleWarning = true;
                        }
                        log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", se);
                    }
                    return method;
                }
                log.trace("Couldn't find accessible method.");
            }
            log.trace("No match found.");
            return null;
        }
    }

    protected static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            if (Boolean.TYPE.equals(parameterType)) {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(parameterization);
            }
            if (Float.TYPE.equals(parameterType)) {
                return (class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(parameterization);
            }
            if (Long.TYPE.equals(parameterType)) {
                return (class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(parameterization);
            }
            if (Integer.TYPE.equals(parameterType)) {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(parameterization);
            }
            if (Double.TYPE.equals(parameterType)) {
                return (class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(parameterization);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

